/*
 * Decompiled with CFR 0.152.
 */
package com.sun.management.viper.console;

import com.sun.management.viper.console.VConsoleActionListener;
import com.sun.management.viper.console.VConsoleEvent;
import com.sun.management.viper.console.VConsoleProperties;
import com.sun.management.viper.console.VConsoleTreeModel;
import com.sun.management.viper.console.VScopeNode;
import com.sun.management.viper.console.gui.VDisplayModel;
import com.sun.management.viper.console.gui.VTable;
import com.sun.management.viper.util.ResourceManager;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.Vector;
import javax.swing.JComponent;
import javax.swing.event.TableModelEvent;
import javax.swing.event.TableModelListener;
import javax.swing.event.TreeSelectionEvent;
import javax.swing.event.TreeSelectionListener;
import javax.swing.table.TableModel;

public class VConsoleTableModel
extends VConsoleTreeModel
implements TableModel,
VConsoleActionListener,
PropertyChangeListener {
    protected VScopeNode selectedNode = null;
    protected VScopeNode internalRoot = null;
    protected String[] colHeaders = null;
    protected String[] defaultHeaders = null;
    protected int[] colWidths = null;
    protected int[] defaultWidths = null;
    protected int[] visibleCols = null;
    protected int[] defVisibleCols = null;
    protected final int nameWidth = 135;
    protected final int descWidth = 300;
    protected Vector tableListeners = null;
    protected Vector treeListeners = null;
    protected VConsoleProperties properties = null;
    protected Vector consoleListeners = null;
    protected int stdColWidth;
    protected int defaultColWidth = this.stdColWidth = 100;
    protected JComponent resultDisplay = null;
    protected String iconStyle = null;
    protected boolean detailsMode = false;
    protected boolean listMode = false;
    protected String stdColName = null;
    protected boolean notifyTableListeners = true;
    protected boolean suppressTableRebuild = false;

    public VConsoleTableModel(VScopeNode vScopeNode) {
        super(vScopeNode);
        this.defaultHeaders = new String[2];
        this.defaultHeaders[0] = this.stdColName = ResourceManager.getString("Name");
        this.defaultHeaders[1] = ResourceManager.getString("Description");
        this.defaultWidths = new int[2];
        this.defaultWidths[0] = 135;
        this.defaultWidths[1] = 300;
        this.colHeaders = this.defaultHeaders;
        this.colWidths = this.defaultWidths;
        this.defVisibleCols = new int[2];
        this.defVisibleCols[0] = 0;
        this.defVisibleCols[1] = 1;
        this.visibleCols = this.defVisibleCols;
    }

    public void addConsoleActionListener(VConsoleActionListener vConsoleActionListener) {
        if (vConsoleActionListener == null) {
            return;
        }
        if (this.consoleListeners == null) {
            this.consoleListeners = new Vector();
        }
        if (!this.consoleListeners.contains(vConsoleActionListener)) {
            this.consoleListeners.addElement(vConsoleActionListener);
        }
    }

    public void addTableModelListener(TableModelListener tableModelListener) {
        if (tableModelListener == null) {
            return;
        }
        if (this.tableListeners == null) {
            this.tableListeners = new Vector();
        }
        this.tableListeners.addElement(tableModelListener);
    }

    public void addTreeSelectionListener(TreeSelectionListener treeSelectionListener) {
        if (treeSelectionListener == null) {
            return;
        }
        if (this.treeListeners == null) {
            this.treeListeners = new Vector();
        }
        this.treeListeners.addElement(treeSelectionListener);
    }

    public void consoleAction(VConsoleEvent vConsoleEvent) {
        if (vConsoleEvent == null) {
            return;
        }
        String string = vConsoleEvent.getID();
        if (string == null) {
            return;
        }
        if (string.equals("vconsole.upscopelevel")) {
            VScopeNode vScopeNode;
            if (this.selectedNode != null && (vScopeNode = (VScopeNode)this.selectedNode.getParent()) != null) {
                vConsoleEvent.setID("vconsole.scopeselected");
                vConsoleEvent.setPayload(vScopeNode);
                this.notifyListeners(vConsoleEvent);
            }
        } else if (string.equals("vconsole.scopeselected")) {
            Object object = vConsoleEvent.getPayload();
            if (this.properties != null) {
                this.properties.setProperty("vconsole.sortedcolumn", "null");
                VConsoleEvent vConsoleEvent2 = new VConsoleEvent(this, "vconsole.sortup", null);
                this.notifyListeners(vConsoleEvent2);
                this.notifyTableListeners = false;
                this.properties.setProperty("vconsole.defaultcolumnheader", this.stdColName);
                this.properties.setPropertyObject("vconsole.defaultcolumnwidth", new Integer(this.stdColWidth));
                this.notifyTableListeners = true;
                try {
                    VDisplayModel vDisplayModel = (VDisplayModel)this.properties.getPropertyObject("vconsole.displaymodel");
                    vDisplayModel.setSelectionMode(2);
                }
                catch (Throwable throwable) {}
                this.properties.setProperty("vconsole.deselectallenabled", "false");
                this.properties.setProperty("vconsole.selectallenabled", "true");
                this.properties.setProperty("vconsole.printenabled", "false");
                this.properties.setProperty("vconsole.cutenabled", "false");
                this.properties.setProperty("vconsole.copyenabled", "false");
                this.properties.setProperty("vconsole.pasteenabled", "false");
                this.properties.setProperty("vconsole.renameenabled", "false");
                this.properties.setProperty("vconsole.deleteenabled", "false");
                this.properties.setProperty("vconsole.duplicateenabled", "false");
                this.properties.setProperty("vconsole.filteredstate", "false");
            }
            if (object instanceof VScopeNode) {
                this.selectionChanged((VScopeNode)object);
            } else {
                this.selectionChanged(null);
            }
        } else if (string.equals("vconsole.updatescope")) {
            Object object = vConsoleEvent.getPayload();
            if (object instanceof VScopeNode) {
                VScopeNode vScopeNode = (VScopeNode)object;
                this.reload(vScopeNode);
                if (this.selectedNode == vScopeNode) {
                    this.selectionChanged(vScopeNode);
                }
            }
        } else if (string.equals("vconsole.filter")) {
            if (this.selectedNode != null) {
                this.reload(this.selectedNode);
                this.suppressTableRebuild = true;
                this.selectionChanged(this.selectedNode);
            }
        } else if (string.equals("vconsole.selectall")) {
            try {
                VDisplayModel vDisplayModel = (VDisplayModel)this.properties.getPropertyObject("vconsole.displaymodel");
                vDisplayModel.selectAll();
            }
            catch (Throwable throwable) {}
        } else if (string.equals("vconsole.deselectall")) {
            try {
                VDisplayModel vDisplayModel = (VDisplayModel)this.properties.getPropertyObject("vconsole.displaymodel");
                vDisplayModel.clearSelection();
            }
            catch (Throwable throwable) {}
        } else if (string.equals("vconsole.repaint")) {
            this.notifyTableListeners(new TableModelEvent(this, -1));
        }
    }

    public void correlateViewAction(VConsoleEvent vConsoleEvent) {
        if (vConsoleEvent == null) {
            return;
        }
        String string = vConsoleEvent.getID();
        if (string == null) {
            return;
        }
        if (string.equals("vconsole.scopechildopened")) {
            Object object = vConsoleEvent.getPayload();
            if (object == null) {
                return;
            }
            if (object instanceof VScopeNode) {
                VScopeNode vScopeNode = (VScopeNode)object;
                if (vScopeNode.getParent() == this.selectedNode) {
                    vConsoleEvent.setID("vconsole.scopeselected");
                }
            } else {
                return;
            }
        }
        this.notifyListeners(vConsoleEvent);
        if (string.equals("vconsole.scopechildselected")) {
            vConsoleEvent.setID("vconsole.sechelpselection");
            this.notifyListeners(vConsoleEvent);
        }
    }

    public Class getColumnClass(int n) {
        if (this.iconStyle != null) {
            if (this.iconStyle.equals("details")) {
                Object object = this.getValueAt(0, n);
                if (object == null) {
                    return null;
                }
                return object.getClass();
            }
            if (this.selectedNode != null) {
                return this.selectedNode.getClass();
            }
        }
        return null;
    }

    public int getColumnCount() {
        int n = 0;
        if (this.iconStyle != null) {
            if (this.iconStyle.equals("details")) {
                n = this.visibleCols.length;
            } else if (this.iconStyle.equals("list")) {
                n = 1;
            } else {
                int n2 = 400;
                if (this.resultDisplay != null) {
                    n2 = this.resultDisplay.getSize().width;
                    n = n2 / this.defaultColWidth;
                }
                if (n == 0) {
                    n = 1;
                }
            }
        }
        return n;
    }

    public String getColumnName(int n) {
        if (this.iconStyle == null) {
            return "Error";
        }
        if (this.detailsMode) {
            try {
                int n2 = this.visibleCols[n];
                return this.colHeaders[n2];
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
        }
        return "";
    }

    public int getColumnWidth(int n) {
        if (this.iconStyle == null) {
            return -1;
        }
        if (this.detailsMode) {
            try {
                int n2 = this.visibleCols[n];
                return this.colWidths[n2];
            }
            catch (Exception exception) {
            }
        }
        return this.defaultColWidth;
    }

    public int getRowCount() {
        if (this.iconStyle == null) {
            return 0;
        }
        if (this.listMode || this.detailsMode) {
            return this.getTrueRowCount();
        }
        int n = this.getTrueRowCount();
        int n2 = this.getColumnCount();
        if (n2 == 0) {
            return 0;
        }
        if (n % n2 > 0) {
            return n / n2 + 1;
        }
        return n / n2;
    }

    public VScopeNode getSelectedNavigationNode() {
        return this.selectedNode;
    }

    protected int getTrueRowCount() {
        if (this.selectedNode == null) {
            return 0;
        }
        return super.getTrueChildCount(this.selectedNode);
    }

    public Object getValueAt(int n, int n2) {
        if (this.iconStyle == null || this.selectedNode == null) {
            return null;
        }
        try {
            if (this.detailsMode || this.listMode) {
                VScopeNode vScopeNode = (VScopeNode)super.getTrueChild(this.selectedNode, n);
                if (n2 == 0 || vScopeNode == null) {
                    return vScopeNode;
                }
                int n3 = this.visibleCols[n2];
                String string = this.colHeaders[n3];
                if (n3 == 1 && string.equals(this.defaultHeaders[1])) {
                    return vScopeNode.getDescription();
                }
                return vScopeNode.getColumnValues().get(string);
            }
            int n4 = n * this.getColumnCount() + n2;
            return (VScopeNode)super.getTrueChild(this.selectedNode, n4);
        }
        catch (Throwable throwable) {
            return null;
        }
    }

    public boolean isCellEditable(int n, int n2) {
        return false;
    }

    protected void notifyListeners(VConsoleEvent vConsoleEvent) {
        if (this.consoleListeners == null) {
            return;
        }
        int n = 0;
        while (n < this.consoleListeners.size()) {
            Object e = this.consoleListeners.elementAt(n);
            ((VConsoleActionListener)e).consoleAction(vConsoleEvent);
            ++n;
        }
    }

    protected void notifyTableListeners(TableModelEvent tableModelEvent) {
        if (this.tableListeners == null) {
            return;
        }
        int n = 0;
        while (n < this.tableListeners.size()) {
            Object e = this.tableListeners.elementAt(n);
            TableModelListener tableModelListener = (TableModelListener)e;
            if (this.suppressTableRebuild && e instanceof VTable) {
                ((VTable)e).suppressRebuild();
            }
            tableModelListener.tableChanged(tableModelEvent);
            ++n;
        }
        this.suppressTableRebuild = false;
    }

    protected void notifyTreeListeners(TreeSelectionEvent treeSelectionEvent) {
        if (this.treeListeners == null) {
            return;
        }
        int n = 0;
        while (n < this.treeListeners.size()) {
            Object e = this.treeListeners.elementAt(n);
            ((TreeSelectionListener)e).valueChanged(treeSelectionEvent);
            ++n;
        }
    }

    public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
        if (propertyChangeEvent == null) {
            return;
        }
        try {
            String string = propertyChangeEvent.getPropertyName();
            if (string.equals("vconsole.iconstyle")) {
                this.iconStyle = (String)propertyChangeEvent.getNewValue();
                this.detailsMode = this.iconStyle.equals("details");
                this.listMode = this.iconStyle.equals("list");
            } else if (string.equals("vconsole.defaultcolumnheader")) {
                this.setDefaultColumnName((String)propertyChangeEvent.getNewValue());
                if (!this.notifyTableListeners) {
                    return;
                }
                this.notifyTableListeners(new TableModelEvent(this, -1));
            } else if (string.equals("vconsole.defaultcolumnwidth")) {
                Integer n = (Integer)propertyChangeEvent.getNewValue();
                this.setDefaultColumnWidth(n);
                if (!this.notifyTableListeners) {
                    return;
                }
                this.notifyTableListeners(new TableModelEvent(this, -1));
            }
        }
        catch (Throwable throwable) {}
    }

    public void removeTableModelListener(TableModelListener tableModelListener) {
        if (this.tableListeners != null && this.tableListeners.contains(tableModelListener)) {
            this.tableListeners.removeElement(tableModelListener);
        }
    }

    public void removeTreeSelectionListener(TreeSelectionListener treeSelectionListener) {
        if (this.treeListeners != null && this.treeListeners.contains(treeSelectionListener)) {
            this.treeListeners.removeElement(treeSelectionListener);
        }
    }

    protected void selectionChanged(VScopeNode vScopeNode) {
        this.selectedNode = vScopeNode;
        this.internalRoot = null;
        String[][] stringArray = null;
        if (this.properties == null) {
            return;
        }
        this.properties.setProperty("vconsole.upscopeenabled", "false");
        this.properties.setProperty("vconsole.propertiesenabled", "false");
        if (this.selectedNode != null) {
            this.internalRoot = this.selectedNode.getInternalRoot();
            stringArray = this.internalRoot != null ? this.internalRoot.getColumnHeaders() : this.selectedNode.getColumnHeaders();
            if (this.selectedNode.getLevel() > 0) {
                this.properties.setProperty("vconsole.upscopeenabled", "true");
            }
            if (this.selectedNode.getPropsPane() != null) {
                this.properties.setProperty("vconsole.propertiesenabled", "true");
            }
        }
        if (this.detailsMode) {
            if (stringArray == null) {
                this.colHeaders = this.defaultHeaders;
                this.colWidths = this.defaultWidths;
                this.visibleCols = this.defVisibleCols;
            } else {
                int n;
                this.colHeaders = new String[stringArray.length + 1];
                this.colWidths = new int[stringArray.length + 1];
                this.colHeaders[0] = this.defaultHeaders[0];
                this.colWidths[0] = this.defaultWidths[0];
                int n2 = 1;
                int n3 = 0;
                while (n3 < stringArray.length) {
                    this.colHeaders[n3 + 1] = stringArray[n3][0];
                    n = 0;
                    try {
                        String string = stringArray[n3][1];
                        if (string != null) {
                            n = Integer.parseInt(string);
                        }
                    }
                    catch (Throwable throwable) {
                        n = -1;
                    }
                    this.colWidths[n3 + 1] = n;
                    if (this.colWidths[n3 + 1] >= 0) {
                        ++n2;
                    }
                    ++n3;
                }
                this.visibleCols = new int[n2];
                n2 = 0;
                n = 0;
                while (n < this.colWidths.length) {
                    if (this.colWidths[n] >= 0) {
                        this.visibleCols[n2++] = n;
                    }
                    ++n;
                }
            }
        } else {
            int n = this.getColumnCount();
            this.colHeaders = new String[n];
            this.colWidths = new int[n];
            this.visibleCols = new int[n];
            int n4 = 0;
            while (n4 < n) {
                this.colHeaders[n4] = "";
                this.colWidths[n4] = 100;
                this.visibleCols[n4] = n4;
                ++n4;
            }
        }
        this.notifyTableListeners(new TableModelEvent(this, -1));
        this.notifyTreeListeners(new TreeSelectionEvent((Object)new VConsoleEvent(this, "vconsole.scopeselected", this.selectedNode), null, null, null, null));
    }

    protected void setDefaultColumnName(String string) {
        if (string != null) {
            this.defaultHeaders[0] = string;
            this.colHeaders[0] = string;
        }
    }

    protected void setDefaultColumnWidth(int n) {
        if (n <= 0) {
            return;
        }
        this.defaultColWidth = n;
        if (this.colWidths[0] != n) {
            this.colWidths[0] = n;
        }
    }

    public void setProperties(VConsoleProperties vConsoleProperties) {
        this.properties = vConsoleProperties;
        if (vConsoleProperties != null) {
            this.iconStyle = vConsoleProperties.getProperty("vconsole.iconstyle");
            this.detailsMode = this.iconStyle.equals("details");
            this.listMode = this.iconStyle.equals("list");
            vConsoleProperties.addPropertyChangeListener(this);
        }
    }

    public void setResultDisplay(JComponent jComponent) {
        this.resultDisplay = jComponent;
    }

    public void setValueAt(Object object, int n, int n2) {
    }

    public void tableWasResized() {
        this.selectionChanged(this.selectedNode);
    }
}

