/*
 * Decompiled with CFR 0.152.
 */
package com.ibutton.oc.terminal.jib;

import com.ibutton.Access;
import com.ibutton.cib.CibCommunicationException;
import com.ibutton.iButtonFactory;
import com.ibutton.jib.JibButton;
import com.ibutton.jib.JibCommandInterpreterException;
import com.ibutton.oc.terminal.jib.iButtonDriverException;
import java.util.Enumeration;

public class iButtonDriver {
    private static final String PORT_TYPE_SERIAL = "PORT_TYPE_SERIAL";
    private static final String PORT_TYPE_LEGACY_SERIAL = "PORT_TYPE_LEGACY_SERIAL";
    private static final String PORT_TYPE_LEGACY_PARALLEL = "PORT_TYPE_LEGACY_PARALLEL";
    private boolean buttonPresent = false;
    private Access jibAccess;
    private JibButton Button;
    private int portT = 3;
    private String portN;
    private int ParPortNumber = 0;
    private int[] adapterId;
    private int[] iButtonId;
    private byte[] buttonATR;

    public iButtonDriver(String string, String string2) throws iButtonDriverException {
        if (string2.equalsIgnoreCase("iBUTTON_PORT_TYPE_SERIAL")) {
            this.portT = 0;
        } else if (string2.equalsIgnoreCase("iBUTTON_PORT_TYPE_LEGACY_PARALLEL")) {
            this.portT = 3;
        } else if (string2.equalsIgnoreCase("iBUTTON_PORT_TYPE_LEGACY_SERIAL")) {
            this.portT = 2;
        } else if (string2.equalsIgnoreCase("iBUTTON_PORT_TYPE_LEGACY_SERIAL_9600")) {
            this.portT = 4;
        } else if (string2.equalsIgnoreCase("iBUTTON_PORT_TYPE_LEGACY_SERIAL_19200")) {
            this.portT = 5;
        } else if (string2.equalsIgnoreCase("iBUTTON_PORT_TYPE_LEGACY_SERIAL_57600")) {
            this.portT = 6;
        } else if (string2.equalsIgnoreCase("iBUTTON_PORT_TYPE_LEGACY_SERIAL_115200")) {
            this.portT = 7;
        } else if (string2.equalsIgnoreCase("iBUTTON_PORT_TYPE_SERIAL_9600")) {
            this.portT = 8;
        } else if (string2.equalsIgnoreCase("iBUTTON_PORT_TYPE_SERIAL_19200")) {
            this.portT = 9;
        } else if (string2.equalsIgnoreCase("iBUTTON_PORT_TYPE_SERIAL_57600")) {
            this.portT = 10;
        } else if (string2.equalsIgnoreCase("iBUTTON_PORT_TYPE_SERIAL_115200")) {
            this.portT = 11;
        }
        this.portN = string;
    }

    protected synchronized void driverClose() throws iButtonDriverException {
        try {
            this.jibAccess.iBKeyClose();
            this.jibAccess.releasePort();
        }
        catch (Exception exception) {}
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected synchronized boolean driverIsCardPresent() throws iButtonDriverException {
        boolean bl = this.buttonPresent;
        if (bl) {
            boolean bl2;
            if (!this.jibAccess.iBKeyOpen()) {
                this.buttonPresent = false;
                return false;
            }
            try {
                if (this.jibAccess.iBStrongAccess()) {
                    boolean bl3 = true;
                    Object var4_4 = null;
                    this.jibAccess.iBKeyClose();
                    return bl3;
                }
                this.buttonPresent = false;
                bl2 = false;
            }
            catch (Throwable throwable) {
                Object var4_6 = null;
                this.jibAccess.iBKeyClose();
                throw throwable;
            }
            Object var4_5 = null;
            this.jibAccess.iBKeyClose();
            return bl2;
        }
        this.Button = this.initiButton();
        if (this.Button != null) {
            this.buttonPresent = true;
        }
        if (this.Button != null) return true;
        return false;
    }

    protected synchronized boolean driverIsCardPresent(JibButton jibButton) {
        return jibButton.select();
    }

    protected synchronized void driverOpen() throws iButtonDriverException {
        if (this.initPort() == -1) {
            if (this.portT == 3) {
                System.out.println("Unable to find Parallel Port Adapter");
            } else {
                System.out.println("Unable to open port " + this.portN);
            }
            throw new iButtonDriverException("Unable to open port " + this.portN);
        }
        this.initAdapterId();
    }

    public synchronized byte[] driverReset(JibButton jibButton, int n) throws iButtonDriverException {
        boolean bl = this.buttonPresent;
        if (jibButton != null) {
            this.buttonPresent = true;
            byte[] byArray = jibButton.getATR();
            return byArray;
        }
        this.buttonPresent = false;
        if (bl) {
            throw new iButtonDriverException("The iButton in the Interface Device was removed during the reset");
        }
        throw new iButtonDriverException("No iButton is in the Interface Device");
    }

    protected byte[] driverSendAPDU(JibButton jibButton, byte[] byArray, int n) throws iButtonDriverException {
        byte[] byArray2;
        try {
            byArray2 = jibButton.sendAPDU(byArray, 64);
        }
        catch (JibCommandInterpreterException jibCommandInterpreterException) {
            System.out.println("caught JibCommandInterpreterException:calling keyclose");
            this.jibAccess.iBKeyClose();
            System.out.println("A");
            throw new iButtonDriverException(jibCommandInterpreterException.getMessage());
        }
        catch (CibCommunicationException cibCommunicationException) {
            System.out.println("caught CibCommandInterpreterException:calling keyclose");
            this.jibAccess.iBKeyClose();
            throw new iButtonDriverException(cibCommunicationException.getMessage());
        }
        catch (RuntimeException runtimeException) {
            this.jibAccess.iBKeyClose();
            throw runtimeException;
        }
        return byArray2;
    }

    protected Access getAccess() {
        return this.jibAccess;
    }

    public int[] getAdapterId() {
        return this.adapterId;
    }

    public String getDescription() {
        return "Dalsemi iButton adapter Driver v1.10";
    }

    public String getName() {
        return this.toString();
    }

    public int[] getiButtonId() {
        return this.iButtonId;
    }

    public synchronized Enumeration getiButtons() throws iButtonDriverException {
        if (!this.jibAccess.iBDOWCheck()) {
            return null;
        }
        boolean bl = false;
        boolean bl2 = true;
        if (this.ParPortNumber == 0) {
            this.ParPortNumber = 1;
        }
        if (!this.jibAccess.iBSetup(this.ParPortNumber)) {
            return null;
        }
        iButtonFactory iButtonFactory2 = new iButtonFactory(this.jibAccess);
        return iButtonFactory2.getButtons(22, "JiB");
    }

    private void initAdapterId() {
        int[] nArray = new int[8];
        boolean bl = true;
        if (this.ParPortNumber == 0) {
            this.ParPortNumber = 1;
        }
        if (this.jibAccess.iBSetup(this.ParPortNumber) && this.jibAccess.iBKeyOpen()) {
            block6: {
                try {
                    if (!this.jibAccess.iBFirst()) break block6;
                    do {
                        if (((nArray = this.jibAccess.iBROMData())[0] & 0x7F) == 1 || (nArray[0] & 0x7F) == 17 || (nArray[0] & 0x7F) == 9) {
                            bl = false;
                        }
                        if (!this.jibAccess.iBNext()) break;
                    } while (bl);
                }
                catch (Throwable throwable) {
                    Object var4_4 = null;
                    this.jibAccess.iBKeyClose();
                    throw throwable;
                }
            }
            Object var4_3 = null;
            this.jibAccess.iBKeyClose();
        }
        this.adapterId = bl ? null : nArray;
    }

    private int initPort() throws iButtonDriverException {
        block14: {
            block13: {
                this.jibAccess = new Access();
                if (this.portT != 3) break block13;
                String string = System.getProperty("os.name");
                if (string.indexOf("Solaris") > -1) {
                    return -1;
                }
                if (string.toLowerCase().indexOf("java") > -1) {
                    return -1;
                }
                int n = 0;
                while (n < 3) {
                    this.portN = new String("");
                    if (!this.jibAccess.SetAdapterType(this.portT, this.portN)) {
                        throw new iButtonDriverException("A problem occurred while trying to initialize the driver.Unable to create Adapter for" + this.portN);
                    }
                    this.jibAccess.iBDOWCheck();
                    this.jibAccess.iBSetup(n + 1);
                    if (this.jibAccess.iBKeyOpen()) {
                        Object var4_3;
                        block12: {
                            try {
                                if (!this.jibAccess.iBFirst()) break block12;
                                this.ParPortNumber = n + 1;
                                var4_3 = null;
                                this.jibAccess.iBKeyClose();
                            }
                            catch (Throwable throwable) {
                                var4_3 = null;
                                this.jibAccess.iBKeyClose();
                                throw throwable;
                            }
                            {
                                break;
                            }
                        }
                        var4_3 = null;
                        this.jibAccess.iBKeyClose();
                    }
                    ++n;
                }
                if (this.ParPortNumber == 0) {
                    return 0;
                }
                break block14;
            }
            try {
                if (!this.jibAccess.SetAdapterType(this.portT, this.portN)) {
                    throw new iButtonDriverException("A problem occurred while trying to initialize the driver.Unable to create Adapter for" + this.portN);
                }
                this.jibAccess.iBDOWCheck();
                if (!this.jibAccess.iBSetup(1)) {
                    throw new iButtonDriverException("A problem occurred while trying to initialize the driver.Unable to create Adapter for " + this.portN);
                }
            }
            catch (Exception exception) {
                System.out.println("failed serial setadaptertype");
                return -1;
            }
        }
        return 1;
    }

    private synchronized JibButton initiButton() throws iButtonDriverException {
        if (!this.jibAccess.iBDOWCheck()) {
            return null;
        }
        boolean bl = false;
        boolean bl2 = true;
        if (this.ParPortNumber == 0) {
            this.ParPortNumber = 1;
        }
        if (!this.jibAccess.iBSetup(this.ParPortNumber)) {
            return null;
        }
        JibButton jibButton = null;
        iButtonFactory iButtonFactory2 = new iButtonFactory(this.jibAccess);
        Enumeration enumeration = iButtonFactory2.getButtons(22, "JiB");
        boolean bl3 = false;
        while (enumeration.hasMoreElements()) {
            enumeration.nextElement();
        }
        Enumeration enumeration2 = iButtonFactory2.getButtons(22, "JiB");
        if (enumeration2.hasMoreElements()) {
            jibButton = (JibButton)enumeration2.nextElement();
            bl = jibButton.select();
            if (!bl) {
                return null;
            }
            this.iButtonId = this.jibAccess.iBROMData();
            return jibButton;
        }
        return bl ? jibButton : null;
    }

    public String toString() {
        return "iButtonDriver_" + this.portN;
    }
}

