/*
 * Decompiled with CFR 0.152.
 */
package com.ibutton.jib;

import com.ibutton.Access;
import com.ibutton.cib.CibCommunicationException;
import com.ibutton.cib.CibMessage;
import com.ibutton.iButton;
import com.ibutton.jib.CommandAPDU;
import com.ibutton.jib.JibCommandInterpreterException;
import com.ibutton.jib.JibCommandPacket;
import com.ibutton.jib.JibMasterPIN;
import com.ibutton.jib.JibReturnPacket;
import com.ibutton.jib.ResponseAPDU;

public class JibButton
extends iButton {
    JibMasterPIN commonPIN;
    JibReturnPacket lastReturn;
    boolean doDebug = false;

    public JibButton(Access access, int[] nArray) {
        super(access, nArray);
    }

    private JibReturnPacket dispatchCommand(JibCommandPacket jibCommandPacket) {
        int n = 0;
        CibMessage cibMessage = null;
        do {
            try {
                this.sendMessage(jibCommandPacket.getRawData(), jibCommandPacket.getExecTime());
                cibMessage = this.receiveMessage();
                n = 2;
            }
            catch (CibCommunicationException cibCommunicationException) {
                block12: {
                    block11: {
                        Object var7_8;
                        if (n == 1) {
                            throw cibCommunicationException;
                        }
                        Access access = this.getAccess();
                        if (access == null) break block11;
                        access.iBKeyOpen();
                        try {
                            access.iBOverdriveOff();
                            if (!access.iBStrongAccess()) {
                                throw cibCommunicationException;
                            }
                            var7_8 = null;
                            access.iBKeyClose();
                        }
                        catch (Throwable throwable) {
                            var7_8 = null;
                            access.iBKeyClose();
                            throw throwable;
                        }
                        break block12;
                    }
                    throw cibCommunicationException;
                }
                if (!this.doDebug) continue;
                System.out.println("HAD TO RETRY !!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!");
            }
        } while (n++ < 2);
        Access access = this.getAccess();
        access.iBKeyOpen();
        try {
            access.setAdapterSpeed(9600);
        }
        finally {
            Object var6_10 = null;
            access.iBKeyClose();
        }
        return new JibReturnPacket(cibMessage.getRawData());
    }

    public ResponseAPDU getAIDbyNumber(int n) {
        byte[] byArray = new byte[]{(byte)(n & 0xFF)};
        CommandAPDU commandAPDU = new CommandAPDU(-48, -107, 1, 14, byArray);
        ResponseAPDU responseAPDU = this.sendAPDU(commandAPDU, 64);
        return responseAPDU;
    }

    public byte[] getATR() {
        byte[] byArray = new byte[]{-48, -107, 1, 11};
        byte[] byArray2 = this.sendAPDU(byArray, 64);
        return byArray2;
    }

    public ResponseAPDU getAppletGCMode() {
        CommandAPDU commandAPDU = new CommandAPDU(-48, -107, 1, 3);
        ResponseAPDU responseAPDU = this.sendAPDU(commandAPDU, 64);
        return responseAPDU;
    }

    public ResponseAPDU getCommandPINMode() {
        CommandAPDU commandAPDU = new CommandAPDU(-48, -107, 1, 4);
        ResponseAPDU responseAPDU = this.sendAPDU(commandAPDU, 64);
        return responseAPDU;
    }

    public ResponseAPDU getCommitBufferSize() {
        CommandAPDU commandAPDU = new CommandAPDU(-48, -107, 1, 10);
        ResponseAPDU responseAPDU = this.sendAPDU(commandAPDU, 64);
        return responseAPDU;
    }

    public ResponseAPDU getEphemeralGCMode() {
        CommandAPDU commandAPDU = new CommandAPDU(-48, -107, 1, 2);
        ResponseAPDU responseAPDU = this.sendAPDU(commandAPDU, 64);
        return responseAPDU;
    }

    public ResponseAPDU getExceptionMode() {
        CommandAPDU commandAPDU = new CommandAPDU(-48, -107, 1, 7);
        ResponseAPDU responseAPDU = this.sendAPDU(commandAPDU, 64);
        return responseAPDU;
    }

    private JibReturnPacket getLastReturn() {
        return this.lastReturn;
    }

    public ResponseAPDU getLoadPINMode() {
        CommandAPDU commandAPDU = new CommandAPDU(-48, -107, 1, 5);
        ResponseAPDU responseAPDU = this.sendAPDU(commandAPDU, 64);
        return responseAPDU;
    }

    protected ResponseAPDU getPORCount() {
        CommandAPDU commandAPDU = new CommandAPDU(-48, -107, 2, 0);
        ResponseAPDU responseAPDU = this.sendAPDU(commandAPDU, 64);
        return responseAPDU;
    }

    public ResponseAPDU getRandomBytes(int n) {
        byte[] byArray = new byte[]{(byte)(n & 0xFF)};
        CommandAPDU commandAPDU = new CommandAPDU(-48, -107, 1, 13, byArray);
        ResponseAPDU responseAPDU = this.sendAPDU(commandAPDU, 64);
        return responseAPDU;
    }

    public ResponseAPDU getRealTimeClock() {
        CommandAPDU commandAPDU = new CommandAPDU(-48, -107, 1, 12);
        ResponseAPDU responseAPDU = this.sendAPDU(commandAPDU, 64);
        return responseAPDU;
    }

    public ResponseAPDU getRestoreMode() {
        CommandAPDU commandAPDU = new CommandAPDU(-48, -107, 1, 6);
        ResponseAPDU responseAPDU = this.sendAPDU(commandAPDU, 64);
        return responseAPDU;
    }

    public ResponseAPDU masterErase() {
        CommandAPDU commandAPDU;
        Object object;
        if (this.commonPIN != null) {
            byte[] byArray = new byte[this.commonPIN.getPINLength() + 1];
            object = this.commonPIN.getPIN();
            byArray[0] = (byte)(this.commonPIN.getPINLength() & 0xFF);
            int n = 0;
            while (n < byArray[0]) {
                byArray[n + 1] = (byte)(object[n] & 0xFF);
                ++n;
            }
            commandAPDU = new CommandAPDU(-48, -107, 0, 0, byArray);
        } else {
            commandAPDU = new CommandAPDU(-48, -107, 0, 0);
        }
        object = this.sendAPDU(commandAPDU, 64);
        return object;
    }

    public ResponseAPDU readFirmwareVersionID() {
        CommandAPDU commandAPDU = new CommandAPDU(-48, -107, 1, 0);
        ResponseAPDU responseAPDU = this.sendAPDU(commandAPDU, 64);
        return responseAPDU;
    }

    public ResponseAPDU readFreeRAM() {
        CommandAPDU commandAPDU = new CommandAPDU(-48, -107, 1, 1);
        ResponseAPDU responseAPDU = this.sendAPDU(commandAPDU, 64);
        return responseAPDU;
    }

    private CibMessage receiveMessage() {
        CibMessage cibMessage = new CibMessage(this.getAccess());
        int n = cibMessage.receive(2048);
        return cibMessage;
    }

    public ResponseAPDU sendAPDU(CommandAPDU commandAPDU, int n) {
        JibReturnPacket jibReturnPacket;
        JibCommandPacket jibCommandPacket = new JibCommandPacket(137);
        jibCommandPacket.appendData(commandAPDU.getAPDUBytes());
        jibCommandPacket.setExecTime(n);
        this.lastReturn = jibReturnPacket = this.dispatchCommand(jibCommandPacket);
        if (jibReturnPacket.getCSB() == 0) {
            return new ResponseAPDU(jibReturnPacket.getReturnBytes());
        }
        throw new JibCommandInterpreterException(jibReturnPacket.getCSB());
    }

    public byte[] sendAPDU(byte[] byArray, int n) {
        JibReturnPacket jibReturnPacket;
        JibCommandPacket jibCommandPacket = new JibCommandPacket(137);
        jibCommandPacket.appendData(byArray);
        jibCommandPacket.setExecTime(n);
        this.lastReturn = jibReturnPacket = this.dispatchCommand(jibCommandPacket);
        if (jibReturnPacket.getCSB() == 0) {
            return jibReturnPacket.getReturnBytes();
        }
        throw new JibCommandInterpreterException(jibReturnPacket.getCSB());
    }

    private void sendMessage(int[] nArray, int n) {
        this.sendMessage(nArray, nArray.length, n);
    }

    private void sendMessage(int[] nArray, int n, int n2) {
        CibMessage cibMessage = new CibMessage(this.getAccess(), nArray, n, n2);
        cibMessage.send();
    }

    public ResponseAPDU setAppletGCMode(int n) {
        CommandAPDU commandAPDU;
        Object object;
        if (this.commonPIN != null) {
            byte[] byArray = new byte[this.commonPIN.getPINLength() + 2];
            object = this.commonPIN.getPIN();
            byArray[0] = (byte)(this.commonPIN.getPINLength() & 0xFF);
            int n2 = 0;
            while (n2 < byArray[0]) {
                byArray[n2 + 1] = (byte)(object[n2] & 0xFF);
                ++n2;
            }
            byArray[byArray.length - 1] = (byte)(n & 0xFF);
            commandAPDU = new CommandAPDU(-48, -107, 0, 3, byArray);
        } else {
            byte[] byArray = new byte[]{0, (byte)(n & 0xFF)};
            commandAPDU = new CommandAPDU(-48, -107, 0, 3);
        }
        object = this.sendAPDU(commandAPDU, 64);
        return object;
    }

    public ResponseAPDU setCommandPINMode(int n) {
        CommandAPDU commandAPDU;
        Object object;
        if (this.commonPIN != null) {
            byte[] byArray = new byte[this.commonPIN.getPINLength() + 2];
            object = this.commonPIN.getPIN();
            byArray[0] = (byte)(this.commonPIN.getPINLength() & 0xFF);
            int n2 = 0;
            while (n2 < byArray[0]) {
                byArray[n2 + 1] = (byte)(object[n2] & 0xFF);
                ++n2;
            }
            byArray[byArray.length - 1] = (byte)(n & 0xFF);
            commandAPDU = new CommandAPDU(-48, -107, 0, 3, byArray);
        } else {
            byte[] byArray = new byte[]{0, (byte)(n & 0xFF)};
            commandAPDU = new CommandAPDU(-48, -107, 0, 3);
        }
        object = this.sendAPDU(commandAPDU, 64);
        return object;
    }

    public ResponseAPDU setCommitBufferSize(short s) {
        CommandAPDU commandAPDU;
        Object object;
        if (this.commonPIN != null) {
            byte[] byArray = new byte[this.commonPIN.getPINLength() + 3];
            object = this.commonPIN.getPIN();
            byArray[0] = (byte)(this.commonPIN.getPINLength() & 0xFF);
            int n = 0;
            while (n < byArray[0]) {
                byArray[n + 1] = (byte)(object[n] & 0xFF);
                ++n;
            }
            byArray[byArray.length - 2] = (byte)(s & 0xFF);
            byArray[byArray.length - 1] = (byte)(s >>> 16 & 0xFF);
            commandAPDU = new CommandAPDU(-48, -107, 0, 3, byArray);
        } else {
            byte[] byArray = new byte[]{0, (byte)(s & 0xFF), (byte)(s >>> 8 & 0xFF)};
            commandAPDU = new CommandAPDU(-48, -107, 0, 3);
        }
        object = this.sendAPDU(commandAPDU, 64);
        return object;
    }

    public ResponseAPDU setEphemeralGCMode(int n) {
        CommandAPDU commandAPDU;
        Object object;
        if (this.commonPIN != null) {
            byte[] byArray = new byte[this.commonPIN.getPINLength() + 2];
            object = this.commonPIN.getPIN();
            byArray[0] = (byte)(this.commonPIN.getPINLength() & 0xFF);
            int n2 = 0;
            while (n2 < byArray[0]) {
                byArray[n2 + 1] = (byte)(object[n2] & 0xFF);
                ++n2;
            }
            byArray[byArray.length - 1] = (byte)n;
            commandAPDU = new CommandAPDU(-48, -107, 0, 2, byArray);
        } else {
            byte[] byArray = new byte[]{0, (byte)n};
            commandAPDU = new CommandAPDU(-48, -107, 0, 2);
        }
        object = this.sendAPDU(commandAPDU, 64);
        return object;
    }

    public ResponseAPDU setExceptionMode(int n) {
        CommandAPDU commandAPDU;
        Object object;
        if (this.commonPIN != null) {
            byte[] byArray = new byte[this.commonPIN.getPINLength() + 2];
            object = this.commonPIN.getPIN();
            byArray[0] = (byte)(this.commonPIN.getPINLength() & 0xFF);
            int n2 = 0;
            while (n2 < byArray[0]) {
                byArray[n2 + 1] = (byte)(object[n2] & 0xFF);
                ++n2;
            }
            byArray[byArray.length - 1] = (byte)(n & 0xFF);
            commandAPDU = new CommandAPDU(-48, -107, 0, 3, byArray);
        } else {
            byte[] byArray = new byte[]{0, (byte)(n & 0xFF)};
            commandAPDU = new CommandAPDU(-48, -107, 0, 3);
        }
        object = this.sendAPDU(commandAPDU, 64);
        return object;
    }

    public ResponseAPDU setLoadPINMode(int n) {
        CommandAPDU commandAPDU;
        Object object;
        if (this.commonPIN != null) {
            byte[] byArray = new byte[this.commonPIN.getPINLength() + 2];
            object = this.commonPIN.getPIN();
            byArray[0] = (byte)(this.commonPIN.getPINLength() & 0xFF);
            int n2 = 0;
            while (n2 < byArray[0]) {
                byArray[n2 + 1] = (byte)(object[n2] & 0xFF);
                ++n2;
            }
            byArray[byArray.length - 1] = (byte)(n & 0xFF);
            commandAPDU = new CommandAPDU(-48, -107, 0, 3, byArray);
        } else {
            byte[] byArray = new byte[]{0, (byte)(n & 0xFF)};
            commandAPDU = new CommandAPDU(-48, -107, 0, 3);
        }
        object = this.sendAPDU(commandAPDU, 64);
        return object;
    }

    public ResponseAPDU setMasterPIN(JibMasterPIN jibMasterPIN) {
        byte[] byArray;
        if (this.commonPIN == null) {
            byArray = new byte[jibMasterPIN.getPINLength() + 2];
            byArray[0] = 0;
            byArray[1] = (byte)(jibMasterPIN.getPINLength() & 0xFF);
            System.arraycopy(jibMasterPIN, 0, byArray, 2, jibMasterPIN.getPINLength());
        } else {
            byArray = new byte[this.commonPIN.getPINLength() + jibMasterPIN.getPINLength() + 2];
            byArray[0] = (byte)(this.commonPIN.getPINLength() & 0xFF);
            if (this.commonPIN.getPINLength() > 0) {
                System.arraycopy(this.commonPIN, 0, byArray, 1, this.commonPIN.getPINLength());
                byArray[this.commonPIN.getPINLength()] = (byte)(jibMasterPIN.getPINLength() & 0xFF);
            } else {
                byArray[1] = (byte)(jibMasterPIN.getPINLength() & 0xFF);
            }
            if (jibMasterPIN.getPINLength() > 0) {
                int n = this.commonPIN.getPINLength() + 2;
                int n2 = jibMasterPIN.getPINLength();
                int[] nArray = jibMasterPIN.getPIN();
                int n3 = 0;
                while (n3 < jibMasterPIN.getPINLength()) {
                    byArray[n++] = (byte)(nArray[n3] & 0xFF);
                    ++n3;
                }
            }
        }
        CommandAPDU commandAPDU = new CommandAPDU(-48, -107, 0, 1, byArray);
        ResponseAPDU responseAPDU = this.sendAPDU(commandAPDU, 64);
        return responseAPDU;
    }

    public void setPIN(JibMasterPIN jibMasterPIN) {
        if (jibMasterPIN != null) {
            this.commonPIN = jibMasterPIN;
        } else {
            this.commonPIN.setPIN(null);
        }
    }

    public ResponseAPDU setRestoreMode(int n) {
        CommandAPDU commandAPDU;
        Object object;
        if (this.commonPIN != null) {
            byte[] byArray = new byte[this.commonPIN.getPINLength() + 2];
            object = this.commonPIN.getPIN();
            byArray[0] = (byte)(this.commonPIN.getPINLength() & 0xFF);
            int n2 = 0;
            while (n2 < byArray[0]) {
                byArray[n2 + 1] = (byte)(object[n2] & 0xFF);
                ++n2;
            }
            byArray[byArray.length - 1] = (byte)(n & 0xFF);
            commandAPDU = new CommandAPDU(-48, -107, 0, 3, byArray);
        } else {
            byte[] byArray = new byte[]{0, (byte)(n & 0xFF)};
            commandAPDU = new CommandAPDU(-48, -107, 0, 3);
        }
        object = this.sendAPDU(commandAPDU, 64);
        return object;
    }
}

