/*
 * Decompiled with CFR 0.152.
 */
package com.ibutton.cib;

import com.ibutton.cib.CibCommandInterpreterException;
import com.ibutton.cib.CibCommandPacket;
import com.ibutton.cib.CibCommandTypeException;
import com.ibutton.cib.CibGroup;
import com.ibutton.cib.CibReturnPacket;
import com.ibutton.cib.CibScriptInterpreterException;

public class CibObject {
    public static final int OPEN_OBJ = 0;
    public static final int LOCKED_OBJ = 1;
    public static final int PRIVATIZE_OBJ = 2;
    public static final int DESTRUCTIBLE_OBJ = 4;
    public static final int CIB_CREATED_OBJ = 128;
    public static final int OUTPUT_OBJ = 0;
    public static final int WORKING_REG_OBJ = 1;
    public static final int ROM_DATA_OBJ = 2;
    public static final int RANDOM_FILL_OBJ = 3;
    public static final int MODULUS_OBJ = 32;
    public static final int EXPONENT_OBJ = 33;
    public static final int MONEY_REGISTER_OBJ = 34;
    public static final int COUNTER_OBJ = 35;
    public static final int SCRIPT_OBJ = 36;
    public static final int CLOCK_OFFSET_OBJ = 37;
    public static final int SALT_OBJ = 38;
    public static final int CONFIG_DATA_OBJ = 39;
    public static final int INPUT_OBJ = 40;
    public static final int DESTRUCTOR_OBJ = 41;
    public static final int MIN_SCRIPT_ERR = 192;
    int maxLength = 0;
    int type = 0;
    int length = 0;
    char[] data;
    int attribute = 0;
    int id;
    private CibGroup group;
    private CibReturnPacket lastReturn;

    public CibObject(CibGroup cibGroup, int n) {
        this.group = cibGroup;
        this.id = n;
    }

    public CibObject(CibGroup cibGroup, int n, int n2, int n3, char[] cArray) {
        this.group = cibGroup;
        this.id = n;
        this.type = n2;
        this.attribute = n3;
        this.setData(cArray);
    }

    public int getAttributes() {
        return this.attribute;
    }

    public char[] getDataChars() {
        return this.data;
    }

    public int[] getDataInts() {
        int[] nArray = new int[this.data.length];
        int n = 0;
        while (n < this.data.length) {
            nArray[n] = this.data[n];
            ++n;
        }
        return nArray;
    }

    public CibReturnPacket getLastReturn() {
        return this.lastReturn;
    }

    public int getMaxLength() {
        return this.maxLength;
    }

    public int getObjectID() {
        return this.id;
    }

    public int getType() {
        return this.type;
    }

    public void invokeScript(int n) throws CibCommandInterpreterException, CibScriptInterpreterException {
        CibReturnPacket cibReturnPacket;
        CibCommandPacket cibCommandPacket = new CibCommandPacket(11, this.group.id);
        cibCommandPacket.setExecTime(n);
        int n2 = this.group.groupPIN.getPINLength();
        cibCommandPacket.appendData(n2);
        if (n2 > 0) {
            cibCommandPacket.appendData(this.group.groupPIN.getPIN());
        }
        cibCommandPacket.appendData(this.id);
        this.lastReturn = cibReturnPacket = this.group.button.dispatchCommand(cibCommandPacket);
        if (cibReturnPacket.getCSB() != 0) {
            if (cibReturnPacket.getCSB() < 192) {
                throw new CibCommandInterpreterException(cibReturnPacket.getCSB());
            }
            throw new CibScriptInterpreterException(cibReturnPacket.getCSB());
        }
    }

    public void read() throws CibCommandInterpreterException {
        CibReturnPacket cibReturnPacket;
        CibCommandPacket cibCommandPacket = new CibCommandPacket(12, this.group.id);
        int n = this.group.groupPIN.getPINLength();
        cibCommandPacket.appendData(n);
        if (n > 0) {
            cibCommandPacket.appendData(this.group.groupPIN.getPIN());
        }
        cibCommandPacket.appendData(this.id);
        this.lastReturn = cibReturnPacket = this.group.button.dispatchCommand(cibCommandPacket);
        if (cibReturnPacket.getCSB() != 0) {
            throw new CibCommandInterpreterException(cibReturnPacket.getCSB());
        }
        this.maxLength = cibReturnPacket.getReturnInteger(0);
        this.attribute = cibReturnPacket.getReturnInteger(1);
        this.type = cibReturnPacket.getReturnInteger(2);
        this.length = cibReturnPacket.getReturnInteger(3);
        this.data = cibReturnPacket.getReturnChars(4, this.length);
    }

    public int readTrueTimeClock() throws CibCommandInterpreterException {
        CibReturnPacket cibReturnPacket;
        CibCommandPacket cibCommandPacket = new CibCommandPacket(19, this.group.id);
        int n = this.group.groupPIN.getPINLength();
        cibCommandPacket.appendData(n);
        if (n > 0) {
            cibCommandPacket.appendData(this.group.groupPIN.getPIN());
        }
        cibCommandPacket.appendData(this.id);
        this.lastReturn = cibReturnPacket = this.group.button.dispatchCommand(cibCommandPacket);
        if (cibReturnPacket.getCSB() == 0) {
            return cibReturnPacket.getReturnInteger(3) << 24 | cibReturnPacket.getReturnInteger(2) << 16 | cibReturnPacket.getReturnInteger(1) << 8 | cibReturnPacket.getReturnInteger(0);
        }
        throw new CibCommandInterpreterException(cibReturnPacket.getCSB());
    }

    public void setAttribute(int n) throws CibCommandTypeException, CibCommandInterpreterException {
        CibReturnPacket cibReturnPacket;
        CibCommandPacket cibCommandPacket;
        if (n == 1) {
            cibCommandPacket = new CibCommandPacket(6, this.group.id);
        } else if (n == 2) {
            cibCommandPacket = new CibCommandPacket(7, this.group.id);
        } else if (n == 4) {
            cibCommandPacket = new CibCommandPacket(8, this.group.id);
        } else {
            throw new CibCommandTypeException("Illegal command for setting attribute");
        }
        int n2 = this.group.groupPIN.getPINLength();
        cibCommandPacket.appendData(n2);
        if (n2 > 0) {
            cibCommandPacket.appendData(this.group.groupPIN.getPIN());
        }
        cibCommandPacket.appendData(this.id);
        this.lastReturn = cibReturnPacket = this.group.button.dispatchCommand(cibCommandPacket);
        if (cibReturnPacket.getCSB() != 0) {
            throw new CibCommandInterpreterException(cibReturnPacket.getCSB());
        }
    }

    public void setData(String string) {
        this.data = new char[string.length()];
        string.getChars(0, string.length(), this.data, 0);
    }

    public void setData(char[] cArray) {
        this.data = new char[cArray.length];
        System.arraycopy(cArray, 0, this.data, 0, cArray.length);
    }

    public void setData(int[] nArray) {
        this.data = new char[nArray.length];
        int n = 0;
        while (n < nArray.length) {
            this.data[n] = (char)nArray[n];
            ++n;
        }
    }

    public void write() throws CibCommandInterpreterException {
        CibReturnPacket cibReturnPacket;
        CibCommandPacket cibCommandPacket = new CibCommandPacket(13, this.group.id);
        int n = this.group.groupPIN.getPINLength();
        cibCommandPacket.appendData(n);
        if (n > 0) {
            cibCommandPacket.appendData(this.group.groupPIN.getPIN());
        }
        cibCommandPacket.appendData(this.id);
        cibCommandPacket.appendData(this.data.length);
        cibCommandPacket.appendData(this.data);
        this.lastReturn = cibReturnPacket = this.group.button.dispatchCommand(cibCommandPacket);
        if (cibReturnPacket.getCSB() != 0) {
            throw new CibCommandInterpreterException(cibReturnPacket.getCSB());
        }
    }
}

