/*
 * Decompiled with CFR 0.152.
 */
package com.ibutton.cib;

import com.ibutton.Access;
import com.ibutton.cib.CibCommunicationException;

public class CibMessage {
    public static int[] CRCtable = new int[256];
    private boolean doDebug = false;
    private static final int CE_RESET = 0;
    private static final int CE_MSGINcomP = 1;
    private static final int CE_BADSEQ = 2;
    private static final int CE_BUFOVERRUN = 3;
    private static final int CE_BADCKSUM = 4;
    private static final int CE_HDRSIZE = 5;
    private static final int CE_DATASIZE = 6;
    private static final int CE_BADCRC = 7;
    private static final int CE_DURATION = 8;
    private static final int CE_FIFONOTEMPTY = 9;
    private static final int CE_STANDBY = 10;
    private static final int CE_RESPONSERDY = 11;
    private static final int CE_RESPINcomP = 12;
    private static final int CE_NOHEADER = 13;
    private static final int CE_MESSAGEOK = 15;
    private static final int CE_FIRSTBIRTH = 29;
    private static final int CE_CIREEXEC = 30;
    private static final int CE_CMDINcomP = 31;
    private static final int OW_MICRORUN = 135;
    private static final int OW_MICROINTERRUPT = 119;
    private static final int OW_MICRORESET = 221;
    private static final int OW_STATUSREAD = 225;
    private static final int OW_STATUSWRITE = 210;
    private static final int OW_IPRREAD = 170;
    private static final int OW_IPRWRITE = 15;
    private static final int OW_FIFOREAD = 34;
    private static final int OW_FIFOWRITE = 45;
    private static final int RS_MICRORUN = 23923;
    private static final int RS_MICROINTERRUPT = 27971;
    private static final int RS_MICRORESET = 37564;
    private static final int RS_STATUSWRITE = 20863;
    private static final int RS_FIFOREAD = 25164;
    private static final int RS_FIFOWRITE = 40371;
    public static final int CE_BPOR = 64;
    private static final int SEGSIZE = 128;
    private static final int HEADERSIZE = 8;
    private static final int FIFO_LEN = 8;
    private int minRun = 96;
    int[] message;
    int[] streamBuffer;
    int[] scratchPad;
    int scratchPadLen = 0;
    Access access;
    int execTime;
    int FIFOFree;
    int FIFOUsed;
    int OWMS;
    int CPST;
    private boolean lastSegment = false;
    private boolean powerOn = false;
    boolean DriverLoaded = false;
    private int[] fillArray;
    int receiveByteCount;

    static {
        int n = 0;
        while (n < 256) {
            int n2 = 0;
            int n3 = n;
            int n4 = 0;
            while (n4 < 8) {
                boolean bl = ((n2 ^ n3) & 1) == 1;
                n2 >>= 1;
                if (bl) {
                    n2 ^= 0xA001;
                }
                n3 >>= 1;
                ++n4;
            }
            CibMessage.CRCtable[n] = n2;
            ++n;
        }
    }

    public CibMessage(Access access) {
        this.access = access;
        this.fillArray = new int[2048];
        this.streamBuffer = new int[this.fillArray.length + 4];
        int n = 0;
        while (n < 2048) {
            this.fillArray[n] = 255;
            ++n;
        }
    }

    public CibMessage(Access access, int[] nArray, int n, int n2) {
        this.message = new int[nArray.length];
        System.arraycopy(nArray, 0, this.message, 0, nArray.length);
        this.access = access;
        this.execTime = n2;
        this.streamBuffer = new int[nArray.length + 4];
    }

    private int CRC16(int n, int n2) {
        return CRCtable[(n2 ^ n) & 0xFF] ^ n2 >> 8;
    }

    private int CRC16Buf(int[] nArray) {
        return this.CRC16Buf(nArray, 0, nArray.length, 0);
    }

    private int CRC16Buf(int[] nArray, int n, int n2, int n3) {
        int n4 = 0;
        while (n4 < n2) {
            n3 = CRCtable[(n3 ^ nArray[n + n4]) & 0xFF] ^ n3 >> 8;
            ++n4;
        }
        return n3;
    }

    private int LSB(int n) {
        return n & 0xFF;
    }

    private int MSB(int n) {
        return n >> 8 & 0xFF;
    }

    private int ReleaseSequence(int n) {
        int[] nArray = new int[]{this.LSB(n), this.MSB(n)};
        this.access.iBDataBlock(nArray, 0, 2);
        if (n == 23923 || n == 27971) {
            this.powerOn = true;
            this.access.SetAdapter5VTime(14);
            this.access.Adapter5VPrime();
        }
        this.access.iBDataBit(1);
        int n2 = 1;
        return n2;
    }

    private boolean checkCRC(int n) {
        int[] nArray = new int[2];
        nArray[1] = 255;
        nArray[0] = 255;
        this.access.iBDataBlock(nArray, 0, 2);
        if (nArray[0] != (this.LSB(n) ^ 0xFF)) {
            return false;
        }
        return nArray[1] == (this.MSB(n) ^ 0xFF);
    }

    private boolean checkCRC(int[] nArray, int n, int n2) {
        if (nArray[n] != (this.LSB(n2) ^ 0xFF)) {
            return false;
        }
        return nArray[n + 1] == (this.MSB(n2) ^ 0xFF);
    }

    public int[] getRawData() {
        int[] nArray = new int[this.receiveByteCount];
        System.arraycopy(this.scratchPad, 0, nArray, 0, this.receiveByteCount);
        return nArray;
    }

    private void getStatus() {
        int[] nArray = new int[5];
        CibCommunicationException cibCommunicationException = new CibCommunicationException(4, 48);
        int n = 0;
        while (n < 3) {
            int n2;
            int n3 = 0;
            this.streamBuffer[n3++] = 225;
            int n4 = 0;
            while (n4 < 4) {
                this.streamBuffer[n3++] = 255;
                ++n4;
            }
            this.streamBuffer[n3++] = 255;
            this.streamBuffer[n3++] = 255;
            if (this.doDebug) {
                System.out.println("Before Stream");
                n2 = 0;
                while (n2 < 10) {
                    System.out.print(String.valueOf(Integer.toHexString(this.streamBuffer[n2])) + " ");
                    ++n2;
                }
                System.out.println("");
            }
            if (!this.access.iBStream(this.streamBuffer, n3)) {
                cibCommunicationException = new CibCommunicationException(4, 48);
            } else {
                if (this.doDebug) {
                    System.out.println("After Stream");
                    n2 = 0;
                    while (n2 < 10) {
                        System.out.print(String.valueOf(Integer.toHexString(this.streamBuffer[n2])) + " ");
                        ++n2;
                    }
                    System.out.println("");
                }
                this.streamBuffer[1] = this.streamBuffer[1] & 0xFE;
                this.FIFOFree = this.streamBuffer[1];
                this.FIFOUsed = this.streamBuffer[2];
                this.OWMS = this.streamBuffer[3];
                this.CPST = this.streamBuffer[4];
                int n5 = this.CRC16(225, 0);
                n5 = this.CRC16(this.FIFOFree, n5);
                n5 = this.CRC16(this.FIFOUsed, n5);
                n5 = this.CRC16(this.OWMS, n5);
                n5 = this.CRC16(this.CPST, n5);
                if (!this.checkCRC(this.streamBuffer, n3 - 2, n5)) {
                    cibCommunicationException = new CibCommunicationException(7, 48);
                } else {
                    return;
                }
            }
            ++n;
        }
        if (this.doDebug) {
            System.out.println("getStatus error: " + cibCommunicationException.toString());
        }
        throw cibCommunicationException;
    }

    public int receive(int n) {
        this.scratchPad = new int[n];
        int n2 = 0;
        int n3 = 0;
        pInteger pInteger2 = new pInteger(0);
        pInteger pInteger3 = new pInteger(0);
        pInteger pInteger4 = new pInteger(0);
        pInteger pInteger5 = new pInteger(0);
        pInteger pInteger6 = new pInteger(0);
        pInteger pInteger7 = new pInteger(0);
        int n4 = 0;
        int n5 = 0;
        boolean bl = false;
        CibCommunicationException cibCommunicationException = null;
        if (this.doDebug) {
            System.out.println("In receive");
        }
        int n6 = 0;
        while (n6 < 3) {
            int n7 = 255;
            try {
                while (true) {
                    this.getStatus();
                    if ((this.OWMS & 0x40) == 64) {
                        if (this.doDebug) {
                            System.out.println("POR IN RECEIVE!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!");
                        }
                        throw new CibCommunicationException(3, 0);
                    }
                    if ((this.CPST & 1) == 1) {
                        this.sendStatus(n3);
                        this.sendRun();
                        this.timeDelay(n3 + 6);
                        this.access.Adapter5VCancel();
                        this.access.iBDataBit(1);
                        this.access.Adapter5VCancel();
                        continue;
                    }
                    if ((this.OWMS & 0x20) == 32) {
                        n3 = (this.OWMS & 0x1F) >> 1;
                        if (n3 == 0) {
                            ++n3;
                        }
                        n3 = 1;
                        this.sendStatus(n3);
                        this.sendRun();
                        this.timeDelay(n3);
                        this.access.Adapter5VCancel();
                        continue;
                    }
                    if (this.FIFOUsed == 0) {
                        if (n2 > 7) {
                            throw new CibCommunicationException(9, 0);
                        }
                        if (this.doDebug) {
                            System.out.println("ER_NOHEADER");
                        }
                        ++n2;
                        this.sendStatus(6);
                        this.sendRun();
                        this.timeDelay(8);
                        this.access.Adapter5VCancel();
                        continue;
                    }
                    if (this.FIFOUsed != 8) {
                        if (this.doDebug) {
                            System.out.println("ER_BADHEADER");
                        }
                        throw new CibCommunicationException(10, 0);
                    }
                    this.receiveHeader(pInteger2, pInteger3, pInteger4, pInteger7, pInteger6);
                    if ((pInteger2.getValue() & 0x7F) == 0 && !bl) {
                        n4 = 0;
                        n7 = 0;
                        pInteger5.setValue(0);
                        n5 = 0;
                    } else if (bl) {
                        pInteger2.setValue(0);
                        pInteger5.setValue(0);
                        n7 = 0;
                    } else if (++n7 != (pInteger2.getValue() & 0x7F)) {
                        if (this.doDebug) {
                            System.out.println("ER_SEQUENCE");
                        }
                        throw new CibCommunicationException(12, 0);
                    }
                    if (n4 + pInteger7.getValue() > n) {
                        if (this.doDebug) {
                            System.out.println("ER_OVERRUN");
                        }
                        throw new CibCommunicationException(13, 0);
                    }
                    pInteger5.setValue(pInteger5.getValue() + pInteger6.getValue());
                    this.receiveData(n5, pInteger7.getValue(), pInteger3.getValue(), pInteger6, bl);
                    pInteger5.setValue(pInteger5.getValue() + pInteger6.getValue());
                    if (!bl) {
                        n4 += pInteger7.getValue();
                        n5 += pInteger7.getValue();
                    } else {
                        n4 += pInteger7.getValue() - 3;
                        n5 += pInteger7.getValue() - 3;
                    }
                    if (pInteger4.getValue() != pInteger5.getValue()) {
                        if (this.doDebug) {
                            System.out.println("ER_CHECKSUM");
                        }
                        throw new CibCommunicationException(8, 0);
                    }
                    pInteger5.setValue(pInteger5.getValue() + this.LSB(pInteger4.getValue()));
                    pInteger5.setValue(pInteger5.getValue() + this.MSB(pInteger4.getValue()));
                    if (this.lastSegment && this.OWMS != 14) {
                        this.access.iBOverdriveOff();
                        this.access.iBKeyClose();
                        this.receiveByteCount = n4;
                        return n4;
                    }
                    if (this.OWMS == 14) {
                        bl = true;
                    }
                    this.sendStatus(2);
                    this.sendRun();
                    this.timeDelay(2);
                    this.access.Adapter5VCancel();
                }
            }
            catch (CibCommunicationException cibCommunicationException2) {
                cibCommunicationException = cibCommunicationException2;
                ++n6;
            }
        }
        this.access.iBOverdriveOff();
        this.access.iBKeyClose();
        System.out.println("Leaving Receive");
        if (cibCommunicationException != null) {
            throw cibCommunicationException;
        }
        return 0;
    }

    private void receiveData(int n, int n2, int n3, pInteger pInteger2, boolean bl) {
        int n4 = n;
        CibCommunicationException cibCommunicationException = new CibCommunicationException(4, 144);
        int n5 = 0;
        while (n5 < 3) {
            try {
                int n6;
                n = n4;
                int n7 = this.CRC16(n2, 0);
                int n8 = 0;
                if (!bl) {
                    int n9;
                    if (this.streamBuffer.length < n2 + 4) {
                        this.streamBuffer = new int[n2 + 4];
                    }
                    System.arraycopy(this.fillArray, 0, this.scratchPad, n, n2);
                    int n10 = 0;
                    this.streamBuffer[n10] = 170;
                    int n11 = this.CRC16(this.streamBuffer[n10++], 0);
                    this.streamBuffer[n10] = n2 & 0xFF;
                    n11 = this.CRC16(this.streamBuffer[n10++], n11);
                    int n12 = 0;
                    while (n12 < n2) {
                        this.streamBuffer[n10++] = this.scratchPad[n + n12];
                        ++n12;
                    }
                    this.streamBuffer[n10++] = 255;
                    this.streamBuffer[n10++] = 255;
                    if (this.access.iBStream(this.streamBuffer, n10)) {
                        n9 = 0;
                        while (n9 < n2) {
                            this.scratchPad[n + n9] = this.streamBuffer[n9 + 2] & 0xFF;
                            ++n9;
                        }
                    } else {
                        throw new CibCommunicationException(4, 144);
                    }
                    n11 = this.CRC16Buf(this.scratchPad, n, n2, n11);
                    n7 = this.CRC16Buf(this.scratchPad, n, n2, n7);
                    n9 = 0;
                    while (n9 < n2) {
                        n8 += this.scratchPad[n + n9];
                        ++n9;
                    }
                    if (!this.checkCRC(this.streamBuffer, n10 - 2, n11)) {
                        throw new CibCommunicationException(7, 144);
                    }
                    if (n3 != n7) {
                        throw new CibCommunicationException(11, 144);
                    }
                    pInteger2.setValue(n8);
                    return;
                }
                int[] nArray = new int[n2 * 2];
                if (this.streamBuffer.length < nArray.length + 4) {
                    this.streamBuffer = new int[nArray.length + 4];
                }
                System.arraycopy(this.fillArray, 0, nArray, 0, n2);
                int n13 = 0;
                this.streamBuffer[n13] = 170;
                int n14 = this.CRC16(this.streamBuffer[n13++], 0);
                this.streamBuffer[n13] = n2 & 0xFF;
                n14 = this.CRC16(this.streamBuffer[n13++], n14);
                int n15 = 0;
                while (n15 < n2) {
                    this.streamBuffer[n13++] = nArray[n15];
                    ++n15;
                }
                this.streamBuffer[n13++] = 255;
                this.streamBuffer[n13++] = 255;
                if (this.access.iBStream(this.streamBuffer, n13)) {
                    n6 = 0;
                    while (n6 < n2) {
                        nArray[n6] = this.streamBuffer[n6 + 2];
                        ++n6;
                    }
                } else {
                    throw new CibCommunicationException(4, 144);
                }
                n14 = this.CRC16Buf(nArray, 0, n2, n14);
                n7 = this.CRC16Buf(nArray, 0, n2, n7);
                n6 = 0;
                while (n6 < n2) {
                    n8 += nArray[n6];
                    ++n6;
                }
                if (!this.checkCRC(this.streamBuffer, n13 - 2, n14)) {
                    throw new CibCommunicationException(7, 144);
                }
                if (n3 != n7) {
                    throw new CibCommunicationException(11, 144);
                }
                System.arraycopy(nArray, 3, this.scratchPad, n, n2 - 3);
                pInteger2.setValue(n8);
                return;
            }
            catch (CibCommunicationException cibCommunicationException2) {
                cibCommunicationException = cibCommunicationException2;
                ++n5;
            }
        }
        cibCommunicationException.setErrorGroup(144);
        throw cibCommunicationException;
    }

    private void receiveHeader(pInteger pInteger2, pInteger pInteger3, pInteger pInteger4, pInteger pInteger5, pInteger pInteger6) {
        FIFOORDWR fIFOORDWR = new FIFOORDWR();
        CibCommunicationException cibCommunicationException = new CibCommunicationException(4, 128);
        int n = 0;
        while (n < 3) {
            block12: {
                try {
                    int n2;
                    fIFOORDWR.command = 34;
                    fIFOORDWR.length = 8;
                    int n3 = 0;
                    while (n3 < 8) {
                        fIFOORDWR.FIFOBuffer[n3] = 255;
                        ++n3;
                    }
                    int[] nArray = fIFOORDWR.getRawData();
                    int n4 = 0;
                    int n5 = 0;
                    while (n5 < nArray.length) {
                        this.streamBuffer[n4++] = nArray[n5];
                        ++n5;
                    }
                    this.streamBuffer[n4++] = 255;
                    this.streamBuffer[n4++] = 255;
                    if (this.access.iBStream(this.streamBuffer, n4)) {
                        n2 = 0;
                        while (n2 < nArray.length) {
                            nArray[n2] = this.streamBuffer[n2];
                            ++n2;
                        }
                    } else {
                        throw new CibCommunicationException(4, 128);
                    }
                    fIFOORDWR.setData(nArray);
                    int n6 = this.CRC16Buf(fIFOORDWR.getRawData());
                    pInteger6.setValue(0);
                    n2 = 0;
                    while (n2 < 6) {
                        pInteger6.setValue(pInteger6.getValue() + fIFOORDWR.FIFOBuffer[n2]);
                        ++n2;
                    }
                    pInteger2.setValue(fIFOORDWR.FIFOBuffer[0]);
                    if ((pInteger2.getValue() & 0x80) == 128) {
                        this.lastSegment = true;
                    }
                    pInteger5.setValue(fIFOORDWR.FIFOBuffer[1]);
                    int n7 = fIFOORDWR.FIFOBuffer[3] << 8 | fIFOORDWR.FIFOBuffer[2];
                    pInteger3.setValue(fIFOORDWR.FIFOBuffer[5] << 8 | fIFOORDWR.FIFOBuffer[4]);
                    pInteger4.setValue(fIFOORDWR.FIFOBuffer[7] << 8 | fIFOORDWR.FIFOBuffer[6]);
                    if (!this.checkCRC(this.streamBuffer, n4 - 2, n6)) {
                        throw new CibCommunicationException(7, 128);
                    }
                    int n8 = this.ReleaseSequence(25164);
                    if (n8 != 1) {
                        cibCommunicationException = new CibCommunicationException(n8, 128);
                        break block12;
                    }
                    return;
                }
                catch (CibCommunicationException cibCommunicationException2) {
                    cibCommunicationException = cibCommunicationException2;
                }
            }
            ++n;
        }
        cibCommunicationException.setErrorGroup(128);
        throw cibCommunicationException;
    }

    public void send() {
        int n = 127;
        pInteger pInteger2 = new pInteger(0);
        pInteger pInteger3 = new pInteger(0);
        CibCommunicationException cibCommunicationException = null;
        if (this.doDebug) {
            System.out.println("In Send");
        }
        int n2 = this.execTime / 250;
        if (!this.DriverLoaded) {
            if (this.access.iBDOWCheck()) {
                this.DriverLoaded = true;
            } else {
                return;
            }
        }
        this.access.iBKeyOpen();
        this.access.setAdapterSpeedOptimum();
        this.access.iBOverdriveOn();
        int[] nArray = this.access.iBROMData();
        nArray[7] = nArray[7];
        int n3 = 0;
        while (n3 < 3) {
            try {
                while (true) {
                    this.getStatus();
                    if ((this.OWMS & 0x40) == 64) {
                        if (this.doDebug) {
                            System.out.println("POR of DEVICE !!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!");
                        }
                        throw new CibCommunicationException(3, 0);
                    }
                    if ((this.CPST & 1) == 1) {
                        this.sendStatus(n2);
                        this.sendRun();
                        this.timeDelay(n2 + 6);
                        this.access.Adapter5VCancel();
                        this.access.iBDataBit(1);
                        this.access.Adapter5VCancel();
                        continue;
                    }
                    if ((this.OWMS & 0x7F) == 0 && this.FIFOUsed == 0) {
                        this.OWMS = 63;
                    }
                    if ((this.OWMS & 0x20) == 32 || (this.OWMS & 0x1F) == 29 || this.OWMS == 31) {
                        if (n2 == 0) {
                            n2 += 2;
                        }
                        if (n2 < 8) {
                            n2 *= 2;
                        }
                        if ((this.OWMS & 0x1F) == 29) {
                            n2 = 12;
                            this.sendStatus(n2);
                        } else {
                            this.sendStatus(n2);
                        }
                        this.sendRun();
                        this.timeDelay(n2);
                        this.timeDelay(1);
                        this.access.Adapter5VCancel();
                        continue;
                    }
                    if (this.FIFOFree < 8) {
                        throw new CibCommunicationException(2, 0);
                    }
                    if (n != 127 && (this.OWMS & 0x1F) > 1 && (this.OWMS & 0x1F) < 8) {
                        throw new CibCommunicationException(this.OWMS & 0x1F, 160);
                    }
                    if (this.lastSegment) {
                        return;
                    }
                    ++n;
                    pInteger2.setValue((n &= 0x7F) == 1 ? pInteger2.getValue() + pInteger3.getValue() : 0);
                    pInteger3.setValue(pInteger2.getValue());
                    this.sendSegment(n, pInteger3);
                    if (this.lastSegment) {
                        n2 = this.execTime / 250;
                        this.sendStatus(n2);
                    } else {
                        n2 = 0;
                    }
                    this.sendInterrupt();
                    this.timeDelay(n2);
                    this.access.Adapter5VCancel();
                    this.access.iBDataBit(1);
                    this.access.Adapter5VCancel();
                    cibCommunicationException = null;
                }
            }
            catch (CibCommunicationException cibCommunicationException2) {
                cibCommunicationException = cibCommunicationException2;
                try {
                    this.sendReset();
                    this.sendStatus(1);
                    this.sendRun();
                    this.timeDelay(1);
                    this.access.Adapter5VCancel();
                    n = 127;
                    this.lastSegment = false;
                }
                catch (CibCommunicationException cibCommunicationException3) {}
                ++n3;
            }
        }
        if (this.doDebug) {
            System.out.println("Leaving Send");
        }
        if (cibCommunicationException != null) {
            this.access.iBOverdriveOff();
            this.access.iBKeyClose();
            throw cibCommunicationException;
        }
    }

    private void sendData(int n, int n2, pInteger pInteger2) {
        CibCommunicationException cibCommunicationException = new CibCommunicationException(4, 16);
        int n3 = 0;
        while (n3 < 3) {
            if (this.streamBuffer.length < n2) {
                this.streamBuffer = new int[n2 + 4];
            }
            int n4 = 0;
            this.streamBuffer[n4] = 15;
            int n5 = this.CRC16(this.streamBuffer[n4++], 0);
            this.streamBuffer[n4] = (byte)(n2 & 0xFF);
            n5 = this.CRC16(this.streamBuffer[n4++], n5);
            int n6 = 0;
            while (n6 < n2) {
                this.streamBuffer[n4++] = this.message[n + n6];
                ++n6;
            }
            this.streamBuffer[n4++] = 255;
            this.streamBuffer[n4++] = 255;
            if (!this.access.iBStream(this.streamBuffer, n4)) {
                cibCommunicationException = new CibCommunicationException(4, 16);
            } else {
                int n7 = 0;
                while (n7 < n2) {
                    this.message[n + n7] = this.streamBuffer[n7 + 2] & 0xFF;
                    ++n7;
                }
                n5 = this.CRC16Buf(this.message, n, n2, n5);
                n7 = 0;
                while (n7 < n2) {
                    pInteger2.setValue(pInteger2.getValue() + this.message[n + n7]);
                    ++n7;
                }
                if (!this.checkCRC(this.streamBuffer, n4 - 2, n5)) {
                    cibCommunicationException = new CibCommunicationException(7, 16);
                } else {
                    return;
                }
            }
            ++n3;
        }
        throw cibCommunicationException;
    }

    private void sendHeader(int n, int n2, int n3, int n4, pInteger pInteger2) {
        FIFOORDWR fIFOORDWR = new FIFOORDWR();
        CibCommunicationException cibCommunicationException = new CibCommunicationException(4, 32);
        int n5 = this.CRC16(n3, 0);
        n5 = this.CRC16Buf(this.message, n2, n3, n5);
        int n6 = 0;
        while (n6 < 3) {
            if (!this.access.iBFastAccess()) {
                cibCommunicationException = new CibCommunicationException(4, 32);
            } else {
                if (this.lastSegment) {
                    n |= 0x80;
                }
                fIFOORDWR.command = 45;
                fIFOORDWR.length = 8;
                fIFOORDWR.FIFOBuffer[0] = n;
                fIFOORDWR.FIFOBuffer[1] = n3;
                fIFOORDWR.FIFOBuffer[2] = this.LSB(n4);
                fIFOORDWR.FIFOBuffer[3] = this.MSB(n4);
                fIFOORDWR.FIFOBuffer[4] = this.LSB(n5);
                fIFOORDWR.FIFOBuffer[5] = this.MSB(n5);
                int n7 = 0;
                while (n7 < 6) {
                    pInteger2.setValue(pInteger2.getValue() + fIFOORDWR.FIFOBuffer[n7]);
                    ++n7;
                }
                fIFOORDWR.FIFOBuffer[6] = this.LSB(pInteger2.getValue());
                fIFOORDWR.FIFOBuffer[7] = this.MSB(pInteger2.getValue());
                this.access.iBDataBlock(fIFOORDWR.getRawData(), 0, 10);
                int n8 = this.CRC16Buf(fIFOORDWR.getRawData());
                n5 = pInteger2.getValue();
                pInteger2.setValue(pInteger2.getValue() + this.LSB(n5));
                pInteger2.setValue(pInteger2.getValue() + this.MSB(n5));
                if (!this.checkCRC(n8)) {
                    cibCommunicationException = new CibCommunicationException(7, 32);
                } else {
                    int n9 = this.ReleaseSequence(40371);
                    if (n9 != 1) {
                        cibCommunicationException = new CibCommunicationException(n9, 32);
                    } else {
                        return;
                    }
                }
            }
            ++n6;
        }
        throw cibCommunicationException;
    }

    private void sendInterrupt() {
        CibCommunicationException cibCommunicationException = new CibCommunicationException(4, 112);
        int n = 0;
        while (n < 3) {
            if (!this.access.iBFastAccess()) {
                cibCommunicationException = new CibCommunicationException(4, 112);
            } else {
                this.access.iBDataByte(119);
                int n2 = this.ReleaseSequence(27971);
                if (n2 != 1) {
                    cibCommunicationException = new CibCommunicationException(n2, 112);
                } else {
                    return;
                }
            }
            ++n;
        }
        throw cibCommunicationException;
    }

    private void sendReset() {
        CibCommunicationException cibCommunicationException = new CibCommunicationException(4, 96);
        int n = 0;
        while (n < 3) {
            if (!this.access.iBFastAccess()) {
                cibCommunicationException = new CibCommunicationException(4, 96);
            } else {
                this.access.iBDataByte(221);
                int n2 = this.ReleaseSequence(37564);
                if (n2 != 1) {
                    cibCommunicationException = new CibCommunicationException(n2, 96);
                } else {
                    return;
                }
            }
            ++n;
        }
        throw cibCommunicationException;
    }

    private void sendRun() {
        CibCommunicationException cibCommunicationException = new CibCommunicationException(4, 80);
        int n = 0;
        while (n < 3) {
            if (!this.access.iBFastAccess()) {
                cibCommunicationException = new CibCommunicationException(4, 80);
            } else {
                this.access.iBDataByte(135);
                int n2 = this.ReleaseSequence(23923);
                if (n2 != 1) {
                    cibCommunicationException = new CibCommunicationException(n2, 80);
                } else {
                    return;
                }
            }
            ++n;
        }
        throw cibCommunicationException;
    }

    private void sendSegment(int n, pInteger pInteger2) {
        int n2;
        CibCommunicationException cibCommunicationException = new CibCommunicationException(4, 16);
        int n3 = n * 128;
        int n4 = this.message.length - n3;
        if (n4 > 128) {
            n2 = 128;
        } else {
            n2 = n4;
            this.lastSegment = true;
        }
        int n5 = n3;
        this.sendData(n5, n2, pInteger2);
        this.sendHeader(n, n5, n2, n4, pInteger2);
    }

    private void sendStatus(int n) {
        int n2 = 0;
        CibCommunicationException cibCommunicationException = new CibCommunicationException(4, 64);
        int n3 = 0;
        while (n3 < 3) {
            if (!this.access.iBFastAccess()) {
                cibCommunicationException = new CibCommunicationException(4, 64);
            } else {
                n2 = this.CRC16(this.access.iBDataByte(210), n2);
                n2 = this.CRC16(this.access.iBDataByte(n), n2);
                if (!this.checkCRC(n2)) {
                    cibCommunicationException = new CibCommunicationException(7, 64);
                } else {
                    int n4 = this.ReleaseSequence(20863);
                    if (n4 != 1) {
                        cibCommunicationException = new CibCommunicationException(n4, 64);
                    } else {
                        return;
                    }
                }
            }
            ++n3;
        }
        throw cibCommunicationException;
    }

    private void timeDelay(int n) {
        try {
            Thread.currentThread();
            Thread.sleep(n * 250 + this.minRun + 10);
        }
        catch (InterruptedException interruptedException) {}
    }

    private class pInteger {
        int value;

        public pInteger(int n) {
            this.setValue(n);
        }

        public int getValue() {
            return this.value;
        }

        public void setValue(int n) {
            this.value = n;
        }
    }

    private class FIFOORDWR {
        int command;
        int length;
        int[] FIFOBuffer = new int[8];

        FIFOORDWR() {
        }

        public int[] getRawData() {
            int[] nArray = new int[10];
            nArray[0] = this.command;
            nArray[1] = this.length;
            System.arraycopy(this.FIFOBuffer, 0, nArray, 2, 8);
            return nArray;
        }

        public void setData(int[] nArray) {
            this.command = nArray[0];
            this.length = nArray[1];
            int n = 0;
            while (n < 8) {
                this.FIFOBuffer[n] = nArray[n + 2];
                ++n;
            }
        }
    }
}

