/*
 * Decompiled with CFR 0.152.
 */
package com.ibutton.cib;

import com.ibutton.cib.CibCommandTypeException;

public class CibCommandPacket {
    public static final int SET_comMON_PIN = 1;
    public static final int MASTER_ERASE = 2;
    public static final int CREATE_TRANSACTION_GROUP = 3;
    public static final int SET_GROUP_PIN = 4;
    public static final int CREATE_OBJECT = 5;
    public static final int LOCK_OBJECT = 6;
    public static final int PRIVATIZE_OBJECT = 7;
    public static final int DESTRUCTIBLE_OBJECT = 8;
    public static final int LOCK_CIB = 9;
    public static final int LOCK_GROUP = 10;
    public static final int INVOKE_SCRIPT = 11;
    public static final int READ_OBJECT = 12;
    public static final int WRITE_OBJECT = 13;
    public static final int READ_GROUP_NAME = 14;
    public static final int DELETE_GROUP = 15;
    public static final int GET_GROUP_ID = 16;
    public static final int READ_CONFIG_INFO = 17;
    public static final int READ_REAL_TIME_CLOCK = 18;
    public static final int READ_TRUE_TIME_CLOCK = 19;
    public static final int CHECK_GROUP_CRC = 20;
    public static final int GET_RANDOM_DATA = 21;
    public static final int GET_VER_STRING = 22;
    public static final int READ_FREE_RAM = 23;
    public static final int CHANGE_GROUP_NAME = 24;
    public static final int DISABLE_KS_GEN = 25;
    public static final int GEN_RSA_KS = 26;
    public static final int GEN_RSA_MOD_AND_EXP = 27;
    public static final int GEN_RSA_KS_NO_PRIVATE = 28;
    public static final int GEN_PRIME = 29;
    public static final int GEN_RANDOM_EXP = 30;
    public static final int TEST_RNG = 31;
    public static final int GET_STATUS_BYTE = 32;
    public static final int INITIALIZE_JIB = 136;
    public static final int SEND_APDU = 137;
    private int commandType;
    private int groupID = 0;
    private int[] data = null;
    int execTimeMS = 0;

    public CibCommandPacket(int n) {
        if (n < 1 || n > 137) {
            throw new CibCommandTypeException();
        }
        this.commandType = n;
    }

    public CibCommandPacket(int n, int n2) {
        if (n < 1 || n > 137) {
            throw new CibCommandTypeException();
        }
        this.commandType = n;
        this.groupID = n2;
    }

    public void appendData(int n) {
        if (this.data != null) {
            int[] nArray = this.data;
            this.data = new int[nArray.length + 1];
            System.arraycopy(nArray, 0, this.data, 0, nArray.length);
            this.data[this.data.length - 1] = (byte)n;
        } else {
            this.data = new int[1];
            this.data[0] = n;
        }
    }

    public void appendData(String string) {
        if (this.data != null) {
            int[] nArray = this.data;
            this.data = new int[nArray.length + string.length()];
            System.arraycopy(nArray, 0, this.data, 0, nArray.length);
            int n = 0;
            while (n < string.length()) {
                this.data[nArray.length + n] = string.charAt(n);
                ++n;
            }
        } else {
            this.data = new int[string.length()];
            int n = 0;
            while (n < string.length()) {
                this.data[n] = string.charAt(n);
                ++n;
            }
        }
    }

    public void appendData(char[] cArray) {
        if (this.data != null) {
            int[] nArray = this.data;
            this.data = new int[nArray.length + cArray.length];
            System.arraycopy(nArray, 0, this.data, 0, nArray.length);
            int n = 0;
            while (n < cArray.length) {
                this.data[nArray.length + n] = cArray[n];
                ++n;
            }
        } else {
            this.data = new int[cArray.length];
            int n = 0;
            while (n < cArray.length) {
                this.data[n] = cArray[n];
                ++n;
            }
        }
    }

    public void appendData(int[] nArray) {
        if (this.data != null) {
            int[] nArray2 = this.data;
            this.data = new int[nArray2.length + nArray.length];
            System.arraycopy(nArray2, 0, this.data, 0, nArray2.length);
            System.arraycopy(nArray, 0, this.data, nArray2.length, nArray.length);
        } else {
            this.data = new int[nArray.length];
            System.arraycopy(nArray, 0, this.data, 0, nArray.length);
        }
    }

    public int getExecTime() {
        return this.execTimeMS;
    }

    public int[] getRawData() {
        if (this.data == null) {
            this.data = new int[0];
        }
        int[] nArray = new int[this.data.length + 3];
        System.arraycopy(this.data, 0, nArray, 3, this.data.length);
        nArray[0] = this.data.length + 2;
        nArray[1] = this.commandType;
        nArray[2] = this.groupID;
        return nArray;
    }

    public void setExecTime(int n) {
        this.execTimeMS = n;
    }
}

