/*
 * Decompiled with CFR 0.152.
 */
package com.ibutton;

import com.ibutton.PortAdapter;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Enumeration;
import javax.comm.CommPort;
import javax.comm.CommPortIdentifier;
import javax.comm.CommPortOwnershipListener;
import javax.comm.SerialPort;

public class SerialAdapter
implements PortAdapter,
CommPortOwnershipListener {
    private static final int DS2480_VERSION_1 = 4;
    private static final int DS2480_VERSION_2 = 8;
    private static final int DS2480_VERSION_3 = 12;
    private static final int DOW_RESPONSE_BUS_SHORTED = 0;
    private static final int DOW_RESPONSE_PRESENCE_PULSE = 1;
    private static final int DOW_RESPONSE_ALARM_PRESENCE_PULSE = 2;
    private static final int DOW_RESPONSE_NO_PRESENCE_PULSE = 3;
    private static final int SPEED_STD = 0;
    private static final int SPEED_OD = 8;
    private static final int SPEED_FLEX = 4;
    private static final int SPEED_PULSE = 12;
    private static final int DATA_MODE = 153;
    private static final int comMAND_MODE = 152;
    private static final int SPEED_9600 = 0;
    private static final int SPEED_19200 = 2;
    private static final int SPEED_57600 = 4;
    private static final int SPEED_115200 = 6;
    private static final int PARMSEL_5VPULSE = 48;
    private static final int PARMSEL_BAUDRATE = 112;
    private static final int CMD_comM = 129;
    private static final int CMD_CONFIG = 1;
    private static final int comMAND_CODE_SWITCH_TO_DATA_MODE = 225;
    private static final int comMAND_CODE_SWITCH_TO_comMAND_MODE_V1 = 243;
    private static final int comMAND_CODE_SWITCH_TO_comMAND_MODE_V1V2 = 227;
    private static final int comMAND_CODE_TERMINATE_PULSE = 241;
    private static final int comMAND_MASK_RESET = 193;
    private static final int IBUTTON_comMAND_SEARCH_ROM = 240;
    private static final int IBUTTON_comMAND_MATCH_ROM = 85;
    private static final int PRIME5V_TRUE = 3;
    private static final int PRIME5V_FALSE = 0;
    public static final int PARMSET_infinite = 14;
    private static final int BITPOL_ONE = 16;
    private static final int BITPOL_ZERO = 0;
    private static final int BITPOL_5V = 0;
    private static final int BITPOL_12V = 16;
    private static final int FUNCTSEL_BIT = 0;
    private static final int FUNCTSEL_SEARCHON = 48;
    private static final int FUNCTSEL_SEARCHOFF = 32;
    private static final int FUNCTSEL_RESET = 64;
    private static final int FUNCTSEL_CHMOD = 96;
    private static final int INITIAL_RECEIVE_BLOCK_THRESHOLD = 100000;
    private static final int INITIAL_RECEIVE_BLOCK_TIMEOUT = 30;
    private static final int INITIAL_RAW_BLOCK_THRESHOLD = 1;
    public static boolean doDebugMessages = false;
    public static int ReceiveBlockThreshold = 100000;
    public static int ReceiveBlockTimeout = 30;
    public static int RawBlockThreshold = 1;
    public String adapter = null;
    public int adapterType;
    private SerialPort serport = null;
    private CommPort commport = null;
    private int portNumber = 0;
    private CommPortIdentifier portID;
    private boolean ownPort = false;
    private boolean waitOwnedEvent = false;
    private boolean waitUnOwnedEvent = false;
    private String currentThreadName;
    private boolean keyOpen = false;
    private InputStream ins = null;
    private OutputStream outs = null;
    private int[] RomDta = new int[8];
    private int l0 = 0;
    private boolean FailNext = true;
    private int ds2480mode;
    private int currentSpeed = 9600;
    private boolean bitPrime = false;
    private int ds2480version;
    private int speedmask = 0;
    private String failstring = new String("FailReason Currently not implemented");

    public SerialAdapter() {
        this.currentThreadName = new String("none");
        int n = 0;
        while (n < 8) {
            this.RomDta[n] = 0;
            ++n;
        }
        Object var2_2 = null;
        Object var3_3 = null;
        this.ds2480mode = 152;
    }

    public boolean Adapter5VActivate(int n) {
        int n2 = 1;
        if (doDebugMessages) {
            System.out.println("DEBUG: SerialAdapter-Adapter5VActivate");
        }
        if (!this.keyOpen || !this.currentThreadName.equals(Thread.currentThread().getName())) {
            return false;
        }
        this.flush();
        this.ToggleCommandMode();
        n2 = n2 | 0x81 | 0xC;
        try {
            this.bitPrime = false;
            this.writeCom(n2 |= 3);
        }
        catch (Exception exception) {
            System.out.println("EXCEPTION: SerialAdapter-Adapter5VActivate: " + exception);
            this.DS2480Recovery();
            return false;
        }
        return true;
    }

    public boolean Adapter5VCancel() {
        int n;
        int n2 = 241;
        if (doDebugMessages) {
            System.out.println("DEBUG: SerialAdapter-Adapter5VCancel");
        }
        if (!this.keyOpen || !this.currentThreadName.equals(Thread.currentThread().getName())) {
            return false;
        }
        this.flush();
        this.ToggleCommandMode();
        try {
            this.writeCom(n2);
            n = this.readCom();
            if (n == -1) {
                System.out.println("EXCEPTION: SerialAdapter-Adapter5VCancel, no return byte on pulse cancel");
                this.DS2480Recovery();
                return false;
            }
        }
        catch (Exception exception) {
            System.out.println("EXCEPTION: SerialAdapter-Adapter5VCancel: " + exception);
            this.DS2480Recovery();
            return false;
        }
        return n >= 0;
    }

    public boolean Adapter5VPrime() {
        if (doDebugMessages) {
            System.out.println("DEBUG: SerialAdapter-Adapter5VPrime");
        }
        if (!this.keyOpen || !this.currentThreadName.equals(Thread.currentThread().getName())) {
            return false;
        }
        this.bitPrime = true;
        return true;
    }

    private boolean DS2480CheckBaud() {
        int n = 0;
        int n2 = 0;
        try {
            this.ds2480mode = 152;
            this.flush();
            this.writeCom(227);
            this.writeCom(15);
            n = this.readCom();
            if (n > -1) {
                switch (this.currentSpeed) {
                    case 9600: {
                        n2 = 0;
                        break;
                    }
                    case 19200: {
                        n2 = 2;
                        break;
                    }
                    case 57600: {
                        n2 = 4;
                        break;
                    }
                    case 115200: {
                        n2 = 6;
                        break;
                    }
                }
                if (doDebugMessages) {
                    System.out.println("DEBUG: SerialAdapter-DS2480CheckBaud " + (n2 == (n & 0xE)));
                }
                if (n2 == (n & 0xE)) {
                    return true;
                }
            }
        }
        catch (Exception exception) {
            System.out.println("EXCEPTION: SerialAdapter-DS2480CheckBaud: " + exception);
            return false;
        }
        return false;
    }

    private int[] DS2480Pad(int[] nArray, int n, int n2) {
        int n3 = 0;
        int n4 = n;
        while (n4 < n + n2) {
            if (nArray[n4] == 227 || this.ds2480version == 4 && nArray[n4] == 243) {
                ++n3;
            }
            ++n3;
            ++n4;
        }
        int[] nArray2 = new int[n3];
        int n5 = 0;
        n4 = n;
        while (n4 < n + n2) {
            if (nArray[n4] == 227 || this.ds2480version == 4 && nArray[n4] == 243) {
                nArray2[n5] = nArray[n4];
                ++n5;
            }
            nArray2[n5] = nArray[n4];
            ++n5;
            ++n4;
        }
        return nArray2;
    }

    private boolean DS2480Recovery() {
        if (doDebugMessages) {
            System.out.println("DEBUG: SerialAdapter-DS2480Recovery");
        }
        if (this.DS2480CheckBaud()) {
            return true;
        }
        this.currentSpeed = 9600;
        this.speedmask = 0;
        this.ds2480mode = 152;
        try {
            this.serport.setSerialPortParams(this.currentSpeed, 8, 1, 0);
            this.serport.setDTR(true);
            this.serport.setRTS(true);
        }
        catch (Exception exception) {
            System.out.println("EXCEPTION: SerialAdapter-DS2480Recovery: " + exception);
        }
        try {
            this.flush();
            this.writeCom(193);
            this.writeCom(227);
            this.writeCom(193);
            Thread.sleep(100L);
            this.flush();
            if (this.DS2480CheckBaud()) {
                return true;
            }
        }
        catch (Exception exception) {
            System.out.println("EXCEPTION: SerialAdapter-DS2480Recovery: " + exception);
            return false;
        }
        if (doDebugMessages) {
            System.out.println("DEBUG: SerialAdapter-DS2480Recovery, POR the part");
        }
        try {
            this.serport.setDTR(false);
            this.serport.setRTS(false);
            Thread.sleep(360L);
            this.serport.setSerialPortParams(9600, 8, 1, 0);
            this.serport.setDTR(true);
            this.serport.setRTS(true);
        }
        catch (Exception exception) {
            System.out.println("EXCEPTION: SerialAdapter-DS2480Recovery: " + exception);
        }
        try {
            Thread.sleep(100L);
            this.flush();
            this.writeCom(193);
            Thread.sleep(100L);
            this.flush();
        }
        catch (Exception exception) {
            System.out.println("EXCEPTION: SerialAdapter-DS2480Recovery: " + exception);
            return false;
        }
        return this.DS2480CheckBaud();
    }

    public boolean DS2480SetParm(int n, int n2) {
        int n3 = 1;
        int n4 = 1;
        if (doDebugMessages) {
            System.out.println("DEBUG: SerialAdapter-DS2480SetParm");
        }
        this.flush();
        this.ToggleCommandMode();
        n3 = n3 | 1 | n | n2;
        try {
            this.writeCom(n3);
            n4 = this.readCom();
        }
        catch (Exception exception) {
            System.out.println("EXCEPTION: SerialAdapter-DS2480SetParm: " + exception);
            this.DS2480Recovery();
            return false;
        }
        return (n3 & 0x7E) == (n4 & 0x7E);
    }

    private int NOT(int n) {
        int n2 = ~n;
        return n2 & 0xFF;
    }

    public boolean SetAdapter5VTime(int n) {
        if (doDebugMessages) {
            System.out.println("DEBUG: SerialAdapter-SetAdapter5VTime");
        }
        if (!this.keyOpen || !this.currentThreadName.equals(Thread.currentThread().getName())) {
            return false;
        }
        return this.DS2480SetParm(48, 14);
    }

    public boolean SetAdapterSpeed(int n) {
        return this.setAdapterSpeed(n);
    }

    private boolean ToggleCommandMode() {
        if (this.ds2480mode == 152) {
            return false;
        }
        try {
            this.writeCom(227);
        }
        catch (Exception exception) {
            System.out.println("EXCEPTION: SerialAdapter-ToggleCommandMode: " + exception);
            this.DS2480Recovery();
            return false;
        }
        this.ds2480mode = 152;
        return true;
    }

    private boolean ToggleDataMode() {
        if (this.ds2480mode == 153) {
            return false;
        }
        try {
            this.writeCom(225);
        }
        catch (Exception exception) {
            System.out.println("EXCEPTION: SerialAdapter-ToggleDataMode: " + exception);
            this.DS2480Recovery();
            return false;
        }
        this.ds2480mode = 153;
        return true;
    }

    private boolean acquirePort() {
        String string;
        Enumeration enumeration = CommPortIdentifier.getPortIdentifiers();
        boolean bl = true;
        if (doDebugMessages) {
            System.out.println("DEBUG: SerialAdapter-acquirePort by thread " + Thread.currentThread());
        }
        this.currentThreadName = new String("none");
        if (this.adapter == null || this.adapter.length() == 0) {
            StringBuffer stringBuffer = new StringBuffer();
            stringBuffer.append("com");
            stringBuffer.append((char)(this.portNumber + 48));
            string = new String(stringBuffer.toString());
        } else {
            string = new String(this.adapter);
        }
        if (doDebugMessages) {
            System.out.println("DEBUG: SerialAdapter-acquirePort, search for port " + string);
        }
        if (this.serport != null && this.serport.getName().equals(string)) {
            if (doDebugMessages) {
                System.out.println("DEBUG: SerialAdapter-acquirePort, we already own this port return success");
            }
            bl = false;
        }
        if (bl) {
            while (enumeration.hasMoreElements()) {
                this.portID = (CommPortIdentifier)enumeration.nextElement();
                if (this.portID.isCurrentlyOwned() && this.portID.getName().equals(string) && this.portID.getCurrentOwner().equals("Dallas Semiconductor Access System " + this.portID.getName()) && this.serport == null) {
                    System.out.println("EXCEPTION: SerialAdapter-acquirePort: port owned by us ");
                    System.out.println("   but we don't have a handle, duplicate SerialAdapter");
                    return false;
                }
                if (!this.portID.getName().equals(string) || this.portID.isCurrentlyOwned()) continue;
                this.portID.addPortOwnershipListener((CommPortOwnershipListener)this);
                try {
                    this.currentThreadName = Thread.currentThread().getName();
                    this.waitOwnedEvent = true;
                    this.commport = this.portID.open("Dallas Semiconductor Access System " + this.portID.getName(), 200);
                    this.serport = (SerialPort)this.commport;
                    break;
                }
                catch (Exception exception) {
                    System.out.println("EXCEPTION: SerialAdapter-acquirePort: " + exception.toString());
                    return false;
                }
            }
        }
        if (this.serport == null) {
            return false;
        }
        int n = 0;
        while (this.waitOwnedEvent) {
            try {
                Thread.sleep(10L);
            }
            catch (Exception exception) {
                System.out.println("EXCEPTION: SerialAdapter-acquirePort: " + exception.toString());
                return false;
            }
            if (n++ <= 30) continue;
            System.out.println("EXCEPTION: SerialAdapter-acquirePort, timeout waiting for port owned");
            return false;
        }
        this.ownPort = true;
        try {
            this.serport.setDTR(true);
            this.serport.setRTS(true);
            this.serport.setFlowControlMode(0);
            this.outs = this.serport.getOutputStream();
            this.ins = this.serport.getInputStream();
            this.serport.enableReceiveThreshold(ReceiveBlockThreshold);
            this.serport.enableReceiveTimeout(ReceiveBlockTimeout);
        }
        catch (Exception exception) {
            System.out.println("EXCEPTION: SerialAdapter-acquirePort, port configuration: " + exception.toString());
            return false;
        }
        if (this.ins == null || this.outs == null) {
            return false;
        }
        try {
            this.serport.setSerialPortParams(9600, 8, 1, 0);
            this.serport.setDTR(true);
            this.serport.setRTS(true);
        }
        catch (Exception exception) {
            System.out.println("EXCEPTION: SerialAdapter-acquirePort, baud/power setup: " + exception);
            return false;
        }
        return true;
    }

    private boolean blockSearch(int[] nArray) {
        int[] nArray2 = new int[39];
        int[] nArray3 = new int[24];
        if (doDebugMessages) {
            System.out.println("DEBUG: SerialAdapter-blockSearch");
        }
        this.flush();
        boolean bl = false;
        if (this.speedmask == 8 && this.currentSpeed <= 57600 || this.currentSpeed == 9600) {
            if (doDebugMessages) {
                System.out.println("DEBUG: SerialAdapter-blockSearch, no streaming of resets in search");
            }
            int n = 0;
            int n2 = 0;
            if (!bl) {
                if (!this.iBReset()) {
                    return false;
                }
                this.ToggleDataMode();
            } else {
                this.ToggleCommandMode();
                nArray2[n++] = 0xC1 | this.speedmask;
                nArray2[n++] = 225;
                ++n2;
            }
            nArray2[n++] = 240;
            ++n2;
            nArray2[n++] = 227;
            nArray2[n++] = 0xB1 | this.speedmask;
            nArray2[n++] = 225;
            int[] nArray4 = this.DS2480Pad(nArray, 0, nArray.length);
            int n3 = 0;
            while (n3 < nArray4.length) {
                nArray2[n++] = nArray4[n3];
                ++n3;
            }
            nArray2[n++] = 227;
            nArray2[n++] = 0xA1 | this.speedmask;
            nArray2[n++] = 225;
            nArray3 = this.rawBlock(nArray2, 0, n, n2 += 16);
            if (bl && (nArray3[0] & 3) != 1) {
                return false;
            }
            n = 0;
            while (n < 16) {
                nArray[n] = nArray3[n + (n2 - 16)];
                ++n;
            }
        } else {
            if (doDebugMessages) {
                System.out.println("DEBUG: SerialAdapter-blockSearch, slow search");
            }
            if (!this.iBReset()) {
                return false;
            }
            this.ToggleDataMode();
            nArray3[0] = this.iBDataByte(240);
            int[] nArray5 = new int[]{227};
            this.rawBlock(nArray5, 0, 1, 0);
            nArray5[0] = 0xB1 | this.speedmask;
            this.rawBlock(nArray5, 0, 1, 0);
            nArray5[0] = 225;
            this.rawBlock(nArray5, 0, 1, 0);
            int n = 0;
            while (n < 16) {
                nArray3[n + 1] = this.iBDataByte(nArray[n]);
                ++n;
            }
            nArray5[0] = 227;
            this.rawBlock(nArray5, 0, 1, 0);
            nArray5[0] = 0xA1 | this.speedmask;
            this.rawBlock(nArray5, 0, 1, 0);
            nArray5[0] = 225;
            this.rawBlock(nArray5, 0, 1, 0);
            int n4 = 0;
            while (n4 < 16) {
                nArray[n4] = nArray3[n4 + 1] & 0xFF;
                ++n4;
            }
        }
        this.ds2480mode = 153;
        return true;
    }

    public void finalize() {
        if (this.ownPort) {
            this.releasePort();
        }
    }

    private void flush() {
        if (doDebugMessages) {
            System.out.println("DEBUG: SerialAdapter-flush");
        }
        try {
            this.outs.flush();
            if (this.ins.available() > 0) {
                byte[] byArray = new byte[this.ins.available()];
                this.ins.read(byArray);
            }
        }
        catch (Exception exception) {
            System.out.println("EXCEPTION: SerialAdapter-flush: " + exception);
        }
    }

    public boolean iBAccess() {
        if (doDebugMessages) {
            System.out.println("DEBUG: SerialAdapter-iBAccess");
        }
        if (!this.keyOpen || !this.currentThreadName.equals(Thread.currentThread().getName())) {
            return false;
        }
        try {
            if (this.speedmask == 8 || this.currentSpeed <= 57600) {
                if (doDebugMessages) {
                    System.out.println("DEBUG: SerialAdapter-iBAccess, doing fast Access");
                }
                int[] nArray = this.DS2480Pad(this.RomDta, 0, 8);
                int[] nArray2 = new int[3 + nArray.length];
                this.ToggleCommandMode();
                nArray2[0] = 0xC1 | this.speedmask;
                nArray2[1] = 225;
                nArray2[2] = 85;
                int n = 0;
                while (n < nArray.length) {
                    nArray2[n + 3] = nArray[n];
                    ++n;
                }
                this.rawBlock(nArray2, 0, nArray2.length, nArray2.length - (1 + (nArray.length - this.RomDta.length)));
                this.ds2480mode = 153;
                if ((nArray2[0] & 3) != 1) {
                    return false;
                }
            } else {
                if (doDebugMessages) {
                    System.out.println("DEBUG: SerialAdapter-iBAccess, doing slow Access");
                }
                int[] nArray = new int[9];
                if (!this.iBReset()) {
                    return false;
                }
                nArray[0] = 85;
                int n = 0;
                while (n < 8) {
                    nArray[n + 1] = this.RomDta[n];
                    ++n;
                }
                this.iBDataBlock(nArray, 0, nArray.length);
            }
        }
        catch (Exception exception) {
            System.out.println("EXCEPTION: SerialAdapter-iBAccess: " + exception);
            this.DS2480Recovery();
            return false;
        }
        return true;
    }

    public boolean iBDOWCheck() {
        if (doDebugMessages) {
            System.out.println("DEBUG: SerialAdapter-iBDOWCheck");
        }
        return true;
    }

    public boolean iBDataBit(int n) {
        if (doDebugMessages) {
            System.out.println("DEBUG: SerialAdapter-iBDataBit");
        }
        if (!this.keyOpen || !this.currentThreadName.equals(Thread.currentThread().getName())) {
            return false;
        }
        this.flush();
        try {
            if (n != 0) {
                n = 16;
            }
            this.ToggleCommandMode();
            int n2 = 0x81 | this.speedmask | n;
            if (this.bitPrime) {
                this.bitPrime = false;
                this.writeCom(n2 |= 3);
            } else {
                this.writeCom(n2);
            }
            int n3 = this.readCom();
            if (n3 == -1) {
                this.DS2480Recovery();
                return false;
            }
            return (n3 & 3) == 3;
        }
        catch (Exception exception) {
            System.out.println("EXCEPTION: SerialAdapter-iBDataBit: " + exception);
            this.DS2480Recovery();
            return false;
        }
    }

    public boolean iBDataBlock(int[] nArray, int n, int n2) {
        int n3 = n + n2;
        if (doDebugMessages) {
            System.out.println("DEBUG: SerialAdapter-iBDataBlock");
        }
        if (!this.keyOpen || !this.currentThreadName.equals(Thread.currentThread().getName())) {
            return false;
        }
        if (n < 0 || n > n3 || n3 < 0 || n > nArray.length || n3 > nArray.length) {
            return false;
        }
        this.flush();
        this.ToggleDataMode();
        boolean bl = false;
        int[] nArray2 = this.DS2480Pad(nArray, n, n2);
        if (this.speedmask == 8 || this.currentSpeed == 9600 || this.ds2480version == 8 && this.currentSpeed <= 19200) {
            try {
                nArray2 = this.rawBlock(nArray2, 0, nArray2.length, n2);
            }
            catch (Exception exception) {
                System.out.println("EXCEPTION: SerialAdapter-iBDataBlock, rawblock: " + exception);
                this.DS2480Recovery();
                return false;
            }
            int n4 = n;
            while (n4 < n3) {
                nArray[n4] = nArray2[n4 - n] & 0xFF;
                ++n4;
            }
        } else {
            int n5 = n;
            while (n5 < n3) {
                nArray[n5] = this.iBDataByte(nArray[n5]);
                ++n5;
            }
        }
        return true;
    }

    public int iBDataByte(int n) {
        int n2 = -1;
        boolean bl = false;
        if (doDebugMessages) {
            System.out.println("DEBUG: SerialAdapter-iBDataByte");
        }
        if (!this.keyOpen || !this.currentThreadName.equals(Thread.currentThread().getName())) {
            return -1;
        }
        this.flush();
        this.ToggleDataMode();
        if (n == 243 && this.ds2480version == 4 || n == 227) {
            bl = true;
        }
        try {
            if (bl) {
                this.writeCom(n);
            }
            this.writeCom(n);
            n2 = this.readCom();
        }
        catch (Exception exception) {
            System.out.println("EXCEPTION: SerialAdapter-iBDataByte: " + exception);
            this.DS2480Recovery();
            return -1;
        }
        return n2 & 0xFF;
    }

    public String iBFailReason() {
        return this.failstring;
    }

    public boolean iBFastAccess() {
        if (doDebugMessages) {
            System.out.println("DEBUG: SerialAdapter-iBFastAccess");
        }
        if (!this.keyOpen || !this.currentThreadName.equals(Thread.currentThread().getName())) {
            return false;
        }
        return this.iBStrongAccess();
    }

    public boolean iBFirst() {
        if (doDebugMessages) {
            System.out.println("DEBUG: SerialAdapter-iBFirst");
        }
        if (!this.keyOpen || !this.currentThreadName.equals(Thread.currentThread().getName())) {
            return false;
        }
        int n = 0;
        while (n < 8) {
            this.RomDta[n] = 0;
            ++n;
        }
        this.FailNext = false;
        this.l0 = 0;
        return this.iBNext();
    }

    public boolean iBGndTest() {
        if (doDebugMessages) {
            System.out.println("DEBUG: SerialAdapter-iBGndTest");
        }
        if (!this.keyOpen || this.currentThreadName != Thread.currentThread().getName()) {
            return false;
        }
        this.iBReset();
        return this.iBDataBit(1) ^ true;
    }

    public boolean iBKeyClose() {
        if (doDebugMessages) {
            System.out.println("DEBUG: SerialAdapter-iBKeyClose by thread " + Thread.currentThread());
        }
        if (this.ownPort && !this.keyOpen) {
            this.releasePort();
            return true;
        }
        if (!this.currentThreadName.equals(Thread.currentThread().getName())) {
            System.out.println("Don't have permission to call keyclose");
            return false;
        }
        this.currentThreadName = new String("none");
        this.keyOpen = false;
        return true;
    }

    public synchronized boolean iBKeyOpen() {
        if (doDebugMessages) {
            System.out.println("DEBUG: SerialAdapter-iBKeyOpen by thread " + Thread.currentThread());
        }
        if (this.keyOpen && this.currentThreadName.equals(Thread.currentThread().getName())) {
            return true;
        }
        if (!this.keyOpen) {
            if (!this.ownPort && !this.acquirePort()) {
                return false;
            }
            if (this.ownPort) {
                this.currentThreadName = Thread.currentThread().getName();
                this.keyOpen = true;
                if (!this.DS2480Recovery()) {
                    this.iBKeyClose();
                    return false;
                }
                return true;
            }
        }
        return false;
    }

    public boolean iBNext() {
        if (doDebugMessages) {
            System.out.println("DEBUG: SerialAdapter-iBNext");
        }
        if (!this.keyOpen || !this.currentThreadName.equals(Thread.currentThread().getName())) {
            return false;
        }
        try {
            if (this.FailNext) {
                this.FailNext = false;
                this.l0 = 0;
            } else {
                int n = this.search();
                if (n != 0) {
                    if (n == 2) {
                        this.FailNext = true;
                    }
                    return true;
                }
            }
            return false;
        }
        catch (Exception exception) {
            System.out.println("EXCEPTION: SerialAdapter-iBNext: " + exception);
            this.DS2480Recovery();
            return false;
        }
    }

    public boolean iBOverdriveOff() {
        if (doDebugMessages) {
            System.out.println("DEBUG: SerialAdapter-iBOverdriveOff");
        }
        if (!this.keyOpen || !this.currentThreadName.equals(Thread.currentThread().getName())) {
            return false;
        }
        this.speedmask = 0;
        return true;
    }

    public boolean iBOverdriveOn() {
        if (doDebugMessages) {
            System.out.println("DEBUG: iBOverdriveOn");
        }
        if (!this.keyOpen || !this.currentThreadName.equals(Thread.currentThread().getName())) {
            return false;
        }
        if (!this.iBReset()) {
            return false;
        }
        try {
            this.iBDataByte(60);
        }
        catch (Exception exception) {
            System.out.println("EXCEPTION: SerialAdapter-iBOverdriveOn: " + exception);
            this.DS2480Recovery();
            return false;
        }
        this.speedmask = 8;
        return true;
    }

    public int[] iBROMData() {
        if (doDebugMessages) {
            System.out.println("DEBUG: SerialAdapter-iBROMData");
        }
        int[] nArray = new int[8];
        System.arraycopy(this.RomDta, 0, nArray, 0, 8);
        return nArray;
    }

    public boolean iBROMData(int[] nArray) {
        if (doDebugMessages) {
            System.out.println("DEBUG: SerialAdapter-iBROMData");
        }
        System.arraycopy(nArray, 0, this.RomDta, 0, 8);
        return true;
    }

    public boolean iBReset() {
        int n;
        if (doDebugMessages) {
            System.out.println("DEBUG: SerialAdapter-iBReset");
        }
        if (!this.keyOpen || !this.currentThreadName.equals(Thread.currentThread().getName())) {
            return false;
        }
        this.flush();
        this.ToggleCommandMode();
        int n2 = 0xC1 | this.speedmask;
        try {
            this.writeCom(n2);
            n = this.readCom();
            if (n == -1) {
                return false;
            }
        }
        catch (Exception exception) {
            System.out.println("EXCEPTION: SerialAdapter-iBReset: " + exception);
            this.DS2480Recovery();
            return false;
        }
        int n3 = n & 3;
        this.ds2480version = n & 0x1C;
        if (this.ds2480version != 4 && this.ds2480version != 8 && this.ds2480version != 12) {
            return false;
        }
        return n3 == 1 || n3 == 2;
    }

    public boolean iBSetup(int n) {
        boolean bl = false;
        this.portNumber = n;
        if (this.keyOpen && this.currentThreadName == Thread.currentThread().getName()) {
            return this.DS2480Recovery();
        }
        if (!this.iBKeyOpen()) {
            return false;
        }
        bl = this.DS2480Recovery();
        this.iBKeyClose();
        return bl;
    }

    public boolean iBStream(int[] nArray, int n) {
        if (doDebugMessages) {
            System.out.println("DEBUG: SerialAdapter-iBStream");
        }
        if (!this.keyOpen || !this.currentThreadName.equals(Thread.currentThread().getName())) {
            return false;
        }
        try {
            if (!this.iBAccess()) {
                return false;
            }
            return this.iBDataBlock(nArray, 0, n);
        }
        catch (Exception exception) {
            System.out.println("EXCEPTION: SerialAdapter-iBStream: " + exception);
            this.DS2480Recovery();
            return false;
        }
    }

    public boolean iBStrongAccess() {
        if (doDebugMessages) {
            System.out.println("DEBUG: SerialAdapter-iBStrongAccess");
        }
        if (!this.keyOpen || !this.currentThreadName.equals(Thread.currentThread().getName())) {
            return false;
        }
        if (!this.iBReset()) {
            return false;
        }
        this.iBDataByte(240);
        int[] nArray = new int[24];
        int n = 0;
        while (n < 24) {
            nArray[n] = 255;
            ++n;
        }
        int n2 = 0;
        int n3 = 2;
        int n4 = 128;
        int n5 = 0;
        while (n5 < 8) {
            int n6 = 0;
            while (n6 < 8) {
                int n7 = this.RomDta[n5];
                if ((n7 >>> n6 & 1) != 1) {
                    nArray[n2] = nArray[n2] & this.NOT(128 >>> 7 - n3);
                }
                if ((n3 += 3) >= 8) {
                    ++n2;
                }
                n3 %= 8;
                ++n6;
            }
            ++n5;
        }
        if (!this.iBDataBlock(nArray, 0, 24)) {
            System.out.println("EXCEPTION: SerialAdapter-iBStrongAccess");
            this.DS2480Recovery();
            return false;
        }
        return (nArray[15] & 0xC0) != 192;
    }

    public String iBVersion() {
        return new String("Serial Adapter 0.28Beta for DS2480");
    }

    public void ownershipChange(int n) {
        switch (n) {
            case 1: {
                if (doDebugMessages) {
                    System.out.println("DEBUG: SerialAdapter-Ownership Change -  PORT_OWNED by thread " + Thread.currentThread());
                }
                this.waitOwnedEvent = false;
                break;
            }
            case 2: {
                if (doDebugMessages) {
                    System.out.println("DEBUG: SerialAdapter-Ownership Change -  PORT_UNOWNED by thread " + Thread.currentThread());
                }
                this.waitUnOwnedEvent = false;
                break;
            }
            case 3: {
                if (doDebugMessages) {
                    System.out.println("DEBUG: SerialAdapter-Ownership Change -  PORT_OWNERSHIP_REQUESTED by thread " + Thread.currentThread());
                }
                if (!this.ownPort || this.keyOpen) break;
                this.releasePort();
                break;
            }
        }
    }

    private int[] rawBlock(int[] nArray, int n, int n2, int n3) {
        int[] nArray2 = new int[n2];
        int[] nArray3 = new int[n3];
        if (doDebugMessages) {
            System.out.println("DEBUG: SerialAdapter-rawBlock");
        }
        int n4 = n;
        while (n4 < n + n2) {
            nArray2[n4 - n] = nArray[n4] & 0xFF;
            ++n4;
        }
        this.writeCom(nArray2);
        this.readCom(nArray3, 0, n3);
        return nArray3;
    }

    private int readCom() {
        try {
            int n = this.readbyte();
            if (n < 0 && doDebugMessages) {
                System.out.println("DEBUG: SerialAdapter-readCom(), timeout reading from com");
            }
            if (doDebugMessages) {
                System.out.print("R(" + Integer.toHexString(n) + ")");
            }
            return n;
        }
        catch (Exception exception) {
            System.out.println("EXCEPTION: SerialAdapter-readCom(): " + exception);
            return -1;
        }
    }

    private int readCom(int[] nArray, int n, int n2) {
        try {
            int n3 = 0;
            while (n3 < n2) {
                int n4 = this.readbyte();
                if (n4 < 0) {
                    if (doDebugMessages) {
                        System.out.println("DEBUG: SerialAdapter-readCom([],,), timeout reading from com");
                    }
                    return -1;
                }
                nArray[n + n3] = n4;
                if (doDebugMessages) {
                    System.out.print("R{" + Integer.toHexString(n4) + "}");
                }
                ++n3;
            }
            return n2;
        }
        catch (Exception exception) {
            System.out.println("EXCEPTION: SerialAdapter-readCom([],,): " + exception);
            return -1;
        }
    }

    private int readbyte() throws IOException {
        long l = System.currentTimeMillis();
        int n;
        while ((n = this.ins.read()) < 0) {
            int n2 = (int)(System.currentTimeMillis() - l);
            if (n2 >= ReceiveBlockTimeout) {
                return -1;
            }
            try {
                Thread.sleep(10L);
            }
            catch (InterruptedException interruptedException) {
                return -1;
            }
        }
        return n;
    }

    public boolean releasePort() {
        if (doDebugMessages) {
            System.out.println("DEBUG: SerialAdapter-releasePort by thread " + Thread.currentThread());
        }
        if (this.serport != null) {
            this.ownPort = false;
            this.currentThreadName = Thread.currentThread().getName();
            this.waitUnOwnedEvent = true;
            this.portID.removePortOwnershipListener((CommPortOwnershipListener)this);
            this.serport.close();
            this.portID = null;
            this.serport = null;
            System.gc();
            boolean bl = false;
            this.serport = null;
            this.commport = null;
            this.ins = null;
            this.outs = null;
        }
        return true;
    }

    private int search() {
        int n;
        int n2;
        int n3;
        int n4 = 0;
        int n5 = 0;
        int n6 = this.l0;
        if (doDebugMessages) {
            System.out.println("DEBUG: SerialAdapter-search");
        }
        int[] nArray = new int[16];
        n4 = 0;
        while (n4 < 16) {
            nArray[n4] = 0;
            ++n4;
        }
        if (this.l0 != 0) {
            n4 = 0;
            while (n4++ < 64) {
                if (n4 >= n6) {
                    n3 = n4 == n6 ? 1 : 0;
                } else {
                    n2 = this.RomDta[(n4 - 1) / 8];
                    n3 = n2 >>> (n4 - 1) % 8 & 1;
                }
                nArray[(n4 - 1) / 4] = nArray[(n4 - 1) / 4] | (n3 <<= (n4 - 1) % 4 * 2 + 1);
            }
        }
        if (!this.blockSearch(nArray)) {
            return 0;
        }
        if ((nArray[15] & 0xC0) == 192) {
            n5 = 3;
        }
        n4 = 0;
        while (n4 < 8) {
            this.RomDta[n4] = 0;
            ++n4;
        }
        n4 = 0;
        while (n4++ < 64) {
            n2 = nArray[(n4 - 1) / 4];
            n = n3 = n2 >>> (n4 - 1) % 4 * 2 + 1 & 1;
            this.RomDta[(n4 - 1) / 8] = this.RomDta[(n4 - 1) / 8] | n << (n4 - 1) % 8;
        }
        n4 = 64;
        n2 = 0;
        n = 0;
        while (n4 > 0) {
            if ((nArray[(n4 - 1) / 4] & 1 << (n4 - 1) % 4 * 2) != 0) {
                n2 = 1;
            }
            if ((nArray[(n4 - 1) / 4] & 1 << (n4 - 1) % 4 * 2 + 1) == 0) {
                n = 1;
            }
            if (n2 != 0 && n != 0) {
                this.l0 = n4;
                n4 = 1;
            }
            n = 0;
            n2 = 0;
            --n4;
        }
        if (n5 == 3) {
            return 0;
        }
        if (n6 == this.l0) {
            return 2;
        }
        return 1;
    }

    public boolean setAdapterSpeed(int n) {
        if (doDebugMessages) {
            System.out.println("DEBUG: SerialAdapter-SetAdapterSpeed");
        }
        if (!this.keyOpen || !this.currentThreadName.equals(Thread.currentThread().getName())) {
            return false;
        }
        try {
            int n2;
            this.flush();
            this.ToggleCommandMode();
            switch (n) {
                case 9600: {
                    n2 = 0;
                    break;
                }
                case 19200: {
                    n2 = 2;
                    break;
                }
                case 57600: {
                    n2 = 4;
                    break;
                }
                case 115200: {
                    n2 = 6;
                    break;
                }
                default: {
                    n2 = 0;
                    n = 9600;
                }
            }
            int n3 = n2 | 1 | 0x70;
            this.writeCom(n3);
            Thread.sleep(100L);
            this.serport.setSerialPortParams(n, 8, 1, 0);
            this.serport.setDTR(true);
            this.serport.setRTS(true);
            Thread.sleep(50L);
            this.flush();
            this.currentSpeed = n;
            boolean bl = this.DS2480CheckBaud();
            if (!bl) {
                this.DS2480Recovery();
            }
            return bl;
        }
        catch (Exception exception) {
            System.out.println("EXCEPTION: SerialAdapter-SetAdapterSpeed: " + exception);
            this.DS2480Recovery();
            return false;
        }
    }

    public void setAdapterSpeedOptimum() {
        switch (this.adapterType) {
            case 8: {
                this.setAdapterSpeed(9600);
                break;
            }
            case 9: {
                this.setAdapterSpeed(19200);
                break;
            }
            case 10: {
                this.setAdapterSpeed(57600);
                break;
            }
            case 11: {
                this.setAdapterSpeed(115200);
                break;
            }
        }
    }

    public void setPortDeviceName(int n, String string) {
        this.adapterType = n;
        this.adapter = new String(string);
    }

    private boolean writeCom(int n) {
        if (doDebugMessages) {
            System.out.print("W(" + Integer.toHexString(n) + ")");
        }
        try {
            this.outs.write(n);
            this.outs.flush();
            return true;
        }
        catch (Exception exception) {
            System.out.println("EXCEPTION: SerialAdapter-writeCom(): " + exception);
            return false;
        }
    }

    private boolean writeCom(int[] nArray) {
        try {
            byte[] byArray = new byte[nArray.length];
            int n = 0;
            while (n < nArray.length) {
                byArray[n] = (byte)nArray[n];
                if (doDebugMessages) {
                    System.out.print("W{" + Integer.toHexString(nArray[n]) + "}");
                }
                ++n;
            }
            this.outs.write(byArray);
            this.outs.flush();
            return true;
        }
        catch (Exception exception) {
            System.out.println("EXCEPTION: SerialAdapter-writeCom([]): " + exception);
            return false;
        }
    }
}

