/*
 * Decompiled with CFR 0.152.
 */
package com.sun.management.viperimpl.console.gui;

import com.sun.management.viper.console.VConsoleProperties;
import com.sun.management.viper.console.gui.VDialog;
import com.sun.management.viper.console.gui.VFrame;
import com.sun.management.viper.console.gui.VOptionPane;
import com.sun.management.viper.console.gui.deck.VBaseDeck;
import com.sun.management.viper.console.gui.deck.VCard;
import com.sun.management.viper.console.gui.propsheet.VPropertySheet;
import com.sun.management.viper.console.gui.propsheet.VPropertySheetEditor;
import com.sun.management.viper.resources.ContextHelpLoader;
import com.sun.management.viper.util.ConsoleUtility;
import com.sun.management.viper.util.Debug;
import com.sun.management.viper.util.ResourceManager;
import com.sun.management.viperimpl.console.config.ConfigManagement;
import com.sun.management.viperimpl.console.gui.ComboToolBoxChooser;
import com.sun.management.viperimpl.console.gui.FontChooser;
import com.sun.management.viperimpl.util.ImplResourceManager;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Font;
import java.awt.Frame;
import java.awt.GridLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.net.URL;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.ButtonGroup;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JTextField;
import javax.swing.border.BevelBorder;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;

public class PreferencesPane
extends VPropertySheetEditor {
    protected static Class imageClass = null;
    protected boolean notify = true;
    protected ActionListener actionL = null;
    protected DocumentListener documentL = null;
    protected VConsoleProperties properties = null;
    protected ConsoleSheet consoleSheet = null;
    protected GeneralSheet generalSheet = null;
    protected ToolBarSheet toolBarSheet = null;
    protected FontsSheet fontsSheet = null;
    protected ToolLoadSheet toolLoadSheet = null;
    protected AuthSheet authSheet = null;

    public PreferencesPane() {
        try {
            if (imageClass == null) {
                imageClass = Class.forName("com.sun.management.viper.console.gui.VFilter");
            }
        }
        catch (Exception exception) {}
        ((VOptionPane)this).title = ImplResourceManager.getString("Preferences");
        this.installSheets();
        ((VBaseDeck)this).deckProperties.setProperty("vpsp.okenabled", (Object)"vwp.false");
        ((VBaseDeck)this).deckProperties.setProperty("vpsp.applyenabled", (Object)"vwp.false");
        this.actionL = new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                if (!PreferencesPane.this.notify) {
                    return;
                }
                PreferencesPane.this.getDeckProperties().setProperty("vpsp.okenabled", (Object)"vwp.true");
                PreferencesPane.this.getDeckProperties().setProperty("vpsp.applyenabled", (Object)"vwp.true");
            }
        };
        this.documentL = new DocumentListener(){

            public void changedUpdate(DocumentEvent documentEvent) {
                this.notifyPropSheet();
            }

            public void insertUpdate(DocumentEvent documentEvent) {
                this.notifyPropSheet();
            }

            protected void notifyPropSheet() {
                if (!PreferencesPane.this.notify) {
                    return;
                }
                PreferencesPane.this.getDeckProperties().setProperty("vpsp.okenabled", (Object)"vwp.true");
                PreferencesPane.this.getDeckProperties().setProperty("vpsp.applyenabled", (Object)"vwp.true");
            }

            public void removeUpdate(DocumentEvent documentEvent) {
                this.notifyPropSheet();
            }
        };
    }

    protected Component getContaner() {
        return ((VOptionPane)this).container;
    }

    protected void installSheets() {
        this.consoleSheet = new ConsoleSheet();
        this.addCard("console", (VCard)this.consoleSheet);
        this.generalSheet = new GeneralSheet();
        this.addCard("appearance", (VCard)this.generalSheet);
        this.toolBarSheet = new ToolBarSheet();
        this.addCard("toolbar", (VCard)this.toolBarSheet);
        this.fontsSheet = new FontsSheet();
        this.addCard("fonts", (VCard)this.fontsSheet);
        this.toolLoadSheet = new ToolLoadSheet();
        this.addCard("toolload", (VCard)this.toolLoadSheet);
        this.authSheet = new AuthSheet();
        this.addCard("auth", (VCard)this.authSheet);
    }

    public static void main(String[] stringArray) {
        ResourceManager.seed((boolean)true);
        PreferencesPane preferencesPane = new PreferencesPane();
        preferencesPane.setProperties(VConsoleProperties.newInstance());
        VDialog vDialog = new VDialog((Frame)new VFrame(), "Preferences", true);
        preferencesPane.setContainer((Component)vDialog);
        vDialog.pack();
        vDialog.setLocationRelativeTo(null);
        vDialog.show();
        System.exit(0);
    }

    public void setProperties(VConsoleProperties vConsoleProperties) {
        if (this.properties != null) {
            this.properties.removePropertyChangeListener((PropertyChangeListener)((Object)this));
            this.properties.removePropertyChangeListener((PropertyChangeListener)this.consoleSheet);
            this.consoleSheet.init = false;
            this.properties.removePropertyChangeListener((PropertyChangeListener)this.generalSheet);
            this.generalSheet.init = false;
            this.properties.removePropertyChangeListener((PropertyChangeListener)this.toolBarSheet);
            this.toolBarSheet.init = false;
            this.properties.removePropertyChangeListener((PropertyChangeListener)this.fontsSheet);
            this.fontsSheet.init = false;
            this.properties.removePropertyChangeListener((PropertyChangeListener)this.toolLoadSheet);
            this.toolLoadSheet.init = false;
            this.properties.removePropertyChangeListener((PropertyChangeListener)this.authSheet);
            this.authSheet.init = false;
        }
        this.properties = vConsoleProperties;
        super.setProperties(vConsoleProperties);
    }

    class ConsoleSheet
    extends VPropertySheet
    implements PropertyChangeListener {
        protected JTextField locField = null;
        protected JButton b1 = null;
        protected JButton b2 = null;
        protected JRadioButton rb2 = null;
        protected JRadioButton rb3 = null;
        protected JRadioButton rb4 = null;
        protected JLabel startsLabel = null;
        protected JLabel homeTBLabel = null;
        protected JLabel locLabel = null;
        protected ComboToolBoxChooser chooser = null;
        boolean init = false;

        public ConsoleSheet() {
            ((Container)((Object)this)).setLayout(new BoxLayout((Container)((Object)this), 1));
            JPanel jPanel = new JPanel();
            jPanel.setLayout(new BoxLayout(jPanel, 1));
            jPanel.add(Box.createVerticalStrut(20));
            JPanel jPanel2 = new JPanel();
            jPanel2.setLayout(new BoxLayout(jPanel2, 0));
            this.startsLabel = new JLabel(ImplResourceManager.getString("Console starts with:"));
            jPanel2.add(this.startsLabel);
            jPanel2.add(Box.createHorizontalGlue());
            jPanel.add(jPanel2);
            this.rb2 = new JRadioButton(ImplResourceManager.getString("Home Toolbox"));
            this.rb3 = new JRadioButton(ImplResourceManager.getString("Last Toolbox Opened"));
            this.rb4 = new JRadioButton(ImplResourceManager.getString("Always Prompt"));
            ButtonGroup buttonGroup = new ButtonGroup();
            buttonGroup.add(this.rb2);
            buttonGroup.add(this.rb3);
            buttonGroup.add(this.rb4);
            jPanel.add(Box.createVerticalStrut(10));
            JPanel jPanel3 = new JPanel();
            jPanel3.setLayout(new BoxLayout(jPanel3, 1));
            jPanel3.add(this.rb2);
            jPanel3.add(this.rb3);
            jPanel3.add(this.rb4);
            JPanel jPanel4 = new JPanel();
            jPanel4.setLayout(new BoxLayout(jPanel4, 0));
            jPanel4.add(jPanel3);
            jPanel4.add(Box.createHorizontalGlue());
            jPanel.add(jPanel4);
            jPanel.add(Box.createVerticalStrut(20));
            JPanel jPanel5 = new JPanel(){

                public Dimension getMaximumSize() {
                    return new Dimension(super.getMaximumSize().width, 4);
                }

                public Dimension getPreferredSize() {
                    return new Dimension(super.getPreferredSize().width, 4);
                }
            };
            jPanel5.setBorder(new BevelBorder(0));
            jPanel.add(jPanel5);
            jPanel.add(Box.createVerticalStrut(20));
            JPanel jPanel6 = new JPanel();
            jPanel6.setLayout(new BoxLayout(jPanel6, 0));
            this.homeTBLabel = new JLabel(ImplResourceManager.getString("Home Toolbox:"));
            jPanel6.add(this.homeTBLabel);
            jPanel6.add(Box.createHorizontalGlue());
            jPanel.add(jPanel6);
            JPanel jPanel7 = new JPanel();
            jPanel7.setLayout(new BoxLayout(jPanel7, 0));
            jPanel7.add(jPanel);
            jPanel7.add(Box.createHorizontalGlue());
            ((Container)((Object)this)).add(jPanel7);
            ((Container)((Object)this)).add(Box.createVerticalStrut(10));
            JPanel jPanel8 = new JPanel();
            jPanel8.setLayout(new BoxLayout(jPanel8, 0));
            this.locLabel = new JLabel(ImplResourceManager.getString("Location:"));
            jPanel8.add(this.locLabel);
            jPanel8.add(Box.createHorizontalStrut(10));
            this.locField = new JTextField(){

                public Dimension getMaximumSize() {
                    return new Dimension(super.getMaximumSize().width, super.getMinimumSize().height);
                }

                public Dimension getPreferredSize() {
                    return new Dimension(super.getPreferredSize().width, super.getMinimumSize().height);
                }
            };
            jPanel8.add(this.locField);
            JPanel jPanel9 = new JPanel();
            jPanel9.setLayout(new BoxLayout(jPanel9, 0));
            jPanel9.add(Box.createHorizontalGlue());
            this.b1 = new JButton(ImplResourceManager.getString("Use Current Toolbox"));
            this.b1.setEnabled(false);
            this.b1.addActionListener(new ActionListener(this){
                private final /* synthetic */ ConsoleSheet this$1;
                {
                    this.this$1 = consoleSheet;
                }

                public void actionPerformed(ActionEvent actionEvent) {
                    if (ConsoleSheet.access$0((ConsoleSheet)this.this$1).properties == null) {
                        return;
                    }
                    String string = ConsoleSheet.access$0((ConsoleSheet)this.this$1).properties.getProperty("vconsole.currenttoolbox");
                    if (string == null) {
                        this.this$1.locField.setText("");
                    } else {
                        this.this$1.locField.setText(string);
                    }
                }
            });
            this.b2 = new JButton(ImplResourceManager.getString("Browse..."));
            this.b2.addActionListener(new ActionListener(this){
                private final /* synthetic */ ConsoleSheet this$1;
                {
                    this.this$1 = consoleSheet;
                }

                public void actionPerformed(ActionEvent actionEvent) {
                    this.this$1.promptUserForToolbox();
                }
            });
            jPanel9.add(this.b1);
            jPanel9.add(Box.createHorizontalStrut(10));
            jPanel9.add(this.b2);
            JPanel jPanel10 = new JPanel();
            jPanel10.setLayout(new BorderLayout());
            jPanel10.add((Component)jPanel8, "North");
            jPanel10.add(Box.createVerticalStrut(10), "Center");
            jPanel10.add((Component)jPanel9, "South");
            JPanel jPanel11 = new JPanel();
            jPanel11.setLayout(new BorderLayout());
            jPanel11.add((Component)jPanel10, "North");
            ((Container)((Object)this)).add(jPanel11);
            ((Container)((Object)this)).add(Box.createVerticalGlue());
            this.setTitle(ImplResourceManager.getString("Console"));
            String string = ImplResourceManager.getString("ConsoleHelp");
            string = ContextHelpLoader.getContextHelp((String)string, null);
            this.setHelpHTML(string);
            this.updateFontAndColor();
        }

        static /* synthetic */ PreferencesPane access$0(ConsoleSheet consoleSheet) {
            return consoleSheet.PreferencesPane.this;
        }

        public boolean apply() {
            if (PreferencesPane.this.properties == null) {
                return true;
            }
            if (!this.init) {
                return true;
            }
            if (this.rb2.isSelected()) {
                PreferencesPane.this.properties.setProperty("vconsole.loadonstartup", "vconsole.hometoolbox");
            } else if (this.rb3.isSelected()) {
                PreferencesPane.this.properties.setProperty("vconsole.loadonstartup", "vconsole.lasttoolbox");
            } else if (this.rb4.isSelected()) {
                PreferencesPane.this.properties.setProperty("vconsole.loadonstartup", "vconsole.promptfortoolbox");
            }
            PreferencesPane.this.properties.setProperty("vconsole.hometoolbox", this.locField.getText());
            return true;
        }

        protected void promptUserForToolbox() {
            int n;
            if (this.chooser == null) {
                this.chooser = new ComboToolBoxChooser();
                this.chooser.setProperties(PreferencesPane.this.properties);
            }
            if ((n = this.chooser.showOpenDialog(null)) != -1) {
                URL uRL = this.chooser.getToolBoxURL();
                uRL = ConfigManagement.aliasifyURL(uRL);
                this.locField.setText(uRL.toString());
            }
        }

        public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
            if (propertyChangeEvent == null) {
                return;
            }
            try {
                String string = propertyChangeEvent.getPropertyName();
                String string2 = (String)propertyChangeEvent.getNewValue();
                if (string == null) {
                    return;
                }
                PreferencesPane.this.notify = false;
                if (string.equals("vconsole.loadonstartup")) {
                    this.reflectValue1(string2);
                } else if (string.equals("vconsole.hometoolbox")) {
                    this.reflectValue2(string2);
                } else if (string.equals("vconsole.currenttoolbox")) {
                    this.reflectValue3(string2);
                }
                PreferencesPane.this.notify = true;
            }
            catch (Exception exception) {}
        }

        protected void reflectValue1(String string) {
            if (string == null) {
                return;
            }
            if (string.equals("vconsole.hometoolbox")) {
                this.rb2.setSelected(true);
            } else if (string.equals("vconsole.lasttoolbox")) {
                this.rb3.setSelected(true);
            } else if (string.equals("vconsole.promptfortoolbox")) {
                this.rb4.setSelected(true);
            }
            ((Container)((Object)this)).validate();
            ((Component)((Object)this)).repaint();
        }

        protected void reflectValue2(String string) {
            if (string == null || string.equals("null")) {
                this.locField.setText("");
            } else {
                this.locField.setText(string);
            }
        }

        protected void reflectValue3(String string) {
            if (string == null || string.equals("null")) {
                this.b1.setEnabled(false);
            } else {
                this.b1.setEnabled(true);
            }
        }

        public void reset() {
            if (PreferencesPane.this.properties == null) {
                return;
            }
            PreferencesPane.this.notify = false;
            String string = PreferencesPane.this.properties.getProperty("vconsole.toolloading");
            this.reflectValue1(string);
            string = PreferencesPane.this.properties.getProperty("vconsole.hometoolbox");
            this.reflectValue2(string);
            string = PreferencesPane.this.properties.getProperty("vconsole.currenttoolbox");
            this.reflectValue3(string);
            PreferencesPane.this.notify = true;
        }

        public void start() {
            this.updateFontAndColor();
            if (this.init || PreferencesPane.this.properties == null) {
                return;
            }
            try {
                PreferencesPane.this.properties.addPropertyChangeListener((PropertyChangeListener)this);
                String string = PreferencesPane.this.properties.getProperty("vconsole.loadonstartup");
                if (string == null) {
                    PreferencesPane.this.properties.setProperty("vconsole.loadonstartup", "vconsole.promptfortoolbox");
                    string = "vconsole.promptfortoolbox";
                }
                this.reflectValue1(string);
                string = PreferencesPane.this.properties.getProperty("vconsole.hometoolbox");
                this.reflectValue2(string);
                string = PreferencesPane.this.properties.getProperty("vconsole.currenttoolbox");
                this.reflectValue3(string);
                this.init = true;
                this.rb2.addActionListener(PreferencesPane.this.actionL);
                this.rb3.addActionListener(PreferencesPane.this.actionL);
                this.rb4.addActionListener(PreferencesPane.this.actionL);
                this.locField.getDocument().addDocumentListener(PreferencesPane.this.documentL);
            }
            catch (Exception exception) {}
        }

        public boolean stop() {
            return true;
        }

        protected void updateFontAndColor() {
            this.locField.setFont(ResourceManager.bodyFont);
            this.locField.setForeground(ResourceManager.bodyColor);
            this.b1.setFont(ResourceManager.menuFont);
            this.b1.setForeground(ResourceManager.menuColor);
            this.b2.setFont(ResourceManager.menuFont);
            this.b2.setForeground(ResourceManager.menuColor);
            this.rb2.setFont(ResourceManager.menuFont);
            this.rb2.setForeground(ResourceManager.menuColor);
            this.rb3.setFont(ResourceManager.menuFont);
            this.rb3.setForeground(ResourceManager.menuColor);
            this.rb4.setFont(ResourceManager.menuFont);
            this.rb4.setForeground(ResourceManager.menuColor);
            this.startsLabel.setFont(ResourceManager.labelFont);
            this.startsLabel.setForeground(ResourceManager.labelColor);
            this.homeTBLabel.setFont(ResourceManager.labelFont);
            this.homeTBLabel.setForeground(ResourceManager.labelColor);
            this.locLabel.setFont(ResourceManager.labelFont);
            this.locLabel.setForeground(ResourceManager.labelColor);
        }
    }

    class NetworkSheet
    extends VPropertySheet
    implements PropertyChangeListener {
        protected JTextField proxyField = null;
        protected JTextField portField = null;
        protected JRadioButton rb1 = null;
        protected JRadioButton rb2 = null;
        protected JLabel proxyLabel = null;
        protected JLabel httpLabel = null;
        protected JLabel portLabel = null;
        protected boolean init = false;

        public NetworkSheet() {
            ((Container)((Object)this)).setLayout(new BoxLayout((Container)((Object)this), 1));
            JPanel jPanel = new JPanel();
            jPanel.setLayout(new BoxLayout(jPanel, 1));
            this.proxyLabel = new JLabel(ImplResourceManager.getString("Network Proxy"));
            jPanel.add(Box.createVerticalStrut(20));
            jPanel.add(this.proxyLabel);
            jPanel.add(Box.createVerticalStrut(10));
            this.rb1 = new JRadioButton(ImplResourceManager.getString("Direct Connection"));
            this.rb1.addActionListener(new ActionListener(this){
                private final /* synthetic */ NetworkSheet this$1;
                {
                    this.this$1 = networkSheet;
                }

                public void actionPerformed(ActionEvent actionEvent) {
                    this.this$1.proxyField.setEnabled(false);
                    this.this$1.portField.setEnabled(false);
                }
            });
            this.rb2 = new JRadioButton(ImplResourceManager.getString("Manual Proxy"));
            this.rb2.addActionListener(new ActionListener(this){
                private final /* synthetic */ NetworkSheet this$1;
                {
                    this.this$1 = networkSheet;
                }

                public void actionPerformed(ActionEvent actionEvent) {
                    this.this$1.proxyField.setEnabled(true);
                    this.this$1.portField.setEnabled(true);
                }
            });
            ButtonGroup buttonGroup = new ButtonGroup();
            buttonGroup.add(this.rb1);
            buttonGroup.add(this.rb2);
            jPanel.add(this.rb1);
            jPanel.add(this.rb2);
            jPanel.add(Box.createVerticalStrut(25));
            JPanel jPanel2 = new JPanel();
            jPanel2.setLayout(new BorderLayout());
            jPanel2.add((Component)jPanel, "West");
            JPanel jPanel3 = new JPanel();
            jPanel3.setLayout(new BoxLayout(jPanel3, 0));
            this.httpLabel = new JLabel(ImplResourceManager.getString("Http Proxy:"));
            jPanel3.add(this.httpLabel);
            jPanel3.add(Box.createHorizontalStrut(10));
            this.proxyField = new JTextField(){

                public Dimension getMaximumSize() {
                    return new Dimension(super.getMaximumSize().width, super.getMinimumSize().height);
                }

                public Dimension getPreferredSize() {
                    return new Dimension(super.getPreferredSize().width, super.getMinimumSize().height);
                }
            };
            this.portField = new JTextField(5){

                public Dimension getMaximumSize() {
                    return new Dimension(super.getPreferredSize().width, super.getMinimumSize().height);
                }

                public Dimension getPreferredSize() {
                    return new Dimension(super.getPreferredSize().width, super.getMinimumSize().height);
                }
            };
            jPanel3.add(this.proxyField);
            jPanel3.add(Box.createHorizontalStrut(10));
            this.portLabel = new JLabel(ImplResourceManager.getString("Port:"));
            jPanel3.add(this.portLabel);
            jPanel3.add(Box.createHorizontalStrut(10));
            jPanel3.add(this.portField);
            JPanel jPanel4 = new JPanel();
            jPanel4.setLayout(new BorderLayout());
            jPanel4.add((Component)jPanel3, "North");
            JPanel jPanel5 = new JPanel();
            jPanel5.setLayout(new BorderLayout());
            jPanel5.add((Component)jPanel2, "North");
            jPanel5.add((Component)jPanel4, "South");
            JPanel jPanel6 = new JPanel();
            jPanel6.setLayout(new BorderLayout());
            jPanel6.add((Component)jPanel5, "North");
            ((Container)((Object)this)).add(jPanel6);
            ((Container)((Object)this)).add(Box.createVerticalGlue());
            this.setTitle(ImplResourceManager.getString("Network"));
            String string = ImplResourceManager.getString("NetworkHelp");
            string = ContextHelpLoader.getContextHelp((String)string, null);
            this.setHelpHTML(string);
            this.updateFontAndColor();
        }

        public boolean apply() {
            if (PreferencesPane.this.properties == null) {
                return true;
            }
            if (!this.init) {
                return true;
            }
            if (this.rb1.isSelected()) {
                PreferencesPane.this.properties.setProperty("vconsole.networkconnection", "vconsole.directconnection");
            } else if (this.rb2.isSelected()) {
                PreferencesPane.this.properties.setProperty("vconsole.networkconnection", "vconsole.proxyconnection");
                String string = this.proxyField.getText();
                int n = string.indexOf("://");
                if (n != -1) {
                    string = string.substring(n + 3, string.length());
                }
                String string2 = this.portField.getText();
                n = string.indexOf(":");
                if (n != -1) {
                    string2 = string.substring(n + 1, string.length());
                    string = string.substring(0, n);
                }
                PreferencesPane.this.properties.setProperty("vconsole.httpproxy", String.valueOf(string) + ":" + string2);
            }
            return true;
        }

        public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
            if (propertyChangeEvent == null) {
                return;
            }
            try {
                String string = propertyChangeEvent.getPropertyName();
                String string2 = (String)propertyChangeEvent.getNewValue();
                if (string == null) {
                    return;
                }
                PreferencesPane.this.notify = false;
                if (string.equals("vconsole.networkconnection")) {
                    this.reflectValue1(string2);
                } else if (string.equals("vconsole.httpproxy")) {
                    this.reflectValue2(string2);
                }
                PreferencesPane.this.notify = true;
            }
            catch (Exception exception) {}
        }

        protected void reflectValue1(String string) {
            if (string == null) {
                return;
            }
            if (string.equals("vconsole.directconnection")) {
                this.rb1.setSelected(true);
                this.proxyField.setEnabled(false);
                this.portField.setEnabled(false);
            } else if (string.equals("vconsole.proxyconnection")) {
                this.rb2.setSelected(true);
                this.proxyField.setEnabled(true);
                this.portField.setEnabled(true);
            }
            ((Container)((Object)this)).validate();
            ((Component)((Object)this)).repaint();
        }

        protected void reflectValue2(String string) {
            if (string == null) {
                return;
            }
            int n = string.indexOf(":");
            if (n != -1) {
                this.proxyField.setText(string.substring(0, n));
                this.portField.setText(string.substring(n + 1, string.length()));
            } else {
                this.proxyField.setText(string);
                this.portField.setText("");
            }
            ((Container)((Object)this)).validate();
            ((Component)((Object)this)).repaint();
        }

        public void reset() {
            if (PreferencesPane.this.properties == null) {
                return;
            }
            PreferencesPane.this.notify = false;
            String string = PreferencesPane.this.properties.getProperty("vconsole.networkconnection");
            this.reflectValue1(string);
            string = PreferencesPane.this.properties.getProperty("vconsole.httpproxy");
            this.reflectValue2(string);
            PreferencesPane.this.notify = true;
        }

        public void start() {
            this.updateFontAndColor();
            if (this.init || PreferencesPane.this.properties == null) {
                return;
            }
            try {
                PreferencesPane.this.properties.addPropertyChangeListener((PropertyChangeListener)this);
                String string = PreferencesPane.this.properties.getProperty("vconsole.networkconnection");
                if (string == null) {
                    PreferencesPane.this.properties.setProperty("vconsole.networkconnection", "vconsole.directconnection");
                    string = "vconsole.directconnection";
                }
                this.reflectValue1(string);
                string = PreferencesPane.this.properties.getProperty("vconsole.httpproxy");
                this.reflectValue2(string);
                this.init = true;
                this.rb1.addActionListener(PreferencesPane.this.actionL);
                this.rb2.addActionListener(PreferencesPane.this.actionL);
                this.proxyField.getDocument().addDocumentListener(PreferencesPane.this.documentL);
                this.portField.getDocument().addDocumentListener(PreferencesPane.this.documentL);
            }
            catch (Exception exception) {}
        }

        public boolean stop() {
            return true;
        }

        protected void updateFontAndColor() {
            this.proxyField.setFont(ResourceManager.bodyFont);
            this.proxyField.setForeground(ResourceManager.bodyColor);
            this.portField.setFont(ResourceManager.bodyFont);
            this.portField.setForeground(ResourceManager.bodyColor);
            this.rb1.setFont(ResourceManager.menuFont);
            this.rb1.setForeground(ResourceManager.menuColor);
            this.rb2.setFont(ResourceManager.menuFont);
            this.rb2.setForeground(ResourceManager.menuColor);
            this.proxyLabel.setFont(ResourceManager.labelFont);
            this.proxyLabel.setForeground(ResourceManager.labelColor);
            this.httpLabel.setFont(ResourceManager.labelFont);
            this.httpLabel.setForeground(ResourceManager.labelColor);
            this.portLabel.setFont(ResourceManager.labelFont);
            this.portLabel.setForeground(ResourceManager.labelColor);
        }
    }

    class ToolLoadSheet
    extends VPropertySheet
    implements PropertyChangeListener {
        protected boolean init = false;
        protected JRadioButton rb1 = null;
        protected JRadioButton rb3 = null;
        protected JLabel openLabel = null;
        protected JCheckBox override = null;

        public ToolLoadSheet() {
            ((Container)((Object)this)).setLayout(new BoxLayout((Container)((Object)this), 1));
            JPanel jPanel = new JPanel();
            jPanel.setLayout(new BoxLayout(jPanel, 1));
            this.openLabel = new JLabel(ImplResourceManager.getString("After opening a Toolbox:"));
            jPanel.add(this.openLabel);
            jPanel.add(Box.createVerticalStrut(10));
            this.rb1 = new JRadioButton(ImplResourceManager.getString("Display the console, then load tools when selected"));
            this.rb3 = new JRadioButton(ImplResourceManager.getString("Load all tools before displaying the console"));
            ButtonGroup buttonGroup = new ButtonGroup();
            buttonGroup.add(this.rb1);
            buttonGroup.add(this.rb3);
            jPanel.add(this.rb1);
            jPanel.add(Box.createVerticalStrut(10));
            jPanel.add(this.rb3);
            jPanel.add(Box.createVerticalStrut(10));
            JPanel jPanel2 = new JPanel();
            jPanel2.setLayout(new BorderLayout());
            jPanel2.add((Component)jPanel, "West");
            this.override = new JCheckBox(ImplResourceManager.getString("These settings always override any Toolbox settings"));
            jPanel.add(Box.createVerticalStrut(20));
            jPanel.add(this.override);
            ((Container)((Object)this)).add(Box.createVerticalStrut(20));
            ((Container)((Object)this)).add(jPanel);
            ((Container)((Object)this)).add(Box.createVerticalGlue());
            this.setTitle(ImplResourceManager.getString("Tool Loading"));
            String string = ImplResourceManager.getString("ToolLoadingHelpHelp");
            string = ContextHelpLoader.getContextHelp((String)string, null);
            this.setHelpHTML(string);
            this.updateFontAndColor();
        }

        public boolean apply() {
            if (PreferencesPane.this.properties == null) {
                return true;
            }
            if (!this.init) {
                return true;
            }
            if (this.rb1.isSelected()) {
                PreferencesPane.this.properties.setProperty("vconsole.toolloading", "vconsole.loadondemand");
            } else if (this.rb3.isSelected()) {
                PreferencesPane.this.properties.setProperty("vconsole.toolloading", "vconsole.loadbeforedisplay");
            }
            if (this.override.isSelected()) {
                PreferencesPane.this.properties.setProperty("vconsole.overridetoolbox", "true");
            } else {
                PreferencesPane.this.properties.setProperty("vconsole.overridetoolbox", "false");
            }
            return true;
        }

        public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
            if (propertyChangeEvent == null) {
                return;
            }
            try {
                String string = propertyChangeEvent.getPropertyName();
                String string2 = (String)propertyChangeEvent.getNewValue();
                if (string == null) {
                    return;
                }
                PreferencesPane.this.notify = false;
                if (string.equals("vconsole.toolloading")) {
                    this.reflectValue(string2);
                } else if (string.equals("vconsole.overridetoolbox")) {
                    this.reflectSetting(string2);
                }
                PreferencesPane.this.notify = true;
            }
            catch (Exception exception) {}
        }

        protected void reflectSetting(String string) {
            if (string == null) {
                return;
            }
            if (string.equals("true")) {
                this.override.setSelected(true);
            } else if (string.equals("false")) {
                this.override.setSelected(false);
            }
        }

        protected void reflectValue(String string) {
            if (string == null) {
                return;
            }
            if (string.equals("vconsole.loadondemand")) {
                this.rb1.setSelected(true);
            } else if (string.equals("vconsole.loadbeforedisplay")) {
                this.rb3.setSelected(true);
            }
            ((Container)((Object)this)).validate();
            ((Component)((Object)this)).repaint();
        }

        public void reset() {
            if (PreferencesPane.this.properties == null) {
                return;
            }
            PreferencesPane.this.notify = false;
            String string = PreferencesPane.this.properties.getProperty("vconsole.toolloading");
            this.reflectValue(string);
            string = PreferencesPane.this.properties.getProperty("vconsole.overridetoolbox");
            this.reflectSetting(string);
            PreferencesPane.this.notify = true;
        }

        public void start() {
            this.updateFontAndColor();
            if (this.init || PreferencesPane.this.properties == null) {
                return;
            }
            try {
                PreferencesPane.this.properties.addPropertyChangeListener((PropertyChangeListener)this);
                String string = PreferencesPane.this.properties.getProperty("vconsole.toolloading");
                if (string == null) {
                    PreferencesPane.this.properties.setProperty("vconsole.toolloading", "vconsole.loadbeforedisplay");
                    string = "vconsole.loadbeforedisplay";
                }
                this.reflectValue(string);
                string = PreferencesPane.this.properties.getProperty("vconsole.overridetoolbox");
                if (string == null) {
                    PreferencesPane.this.properties.setProperty("vconsole.overridetoolbox", "false");
                    string = "false";
                }
                this.reflectSetting(string);
                this.init = true;
                this.rb1.addActionListener(PreferencesPane.this.actionL);
                this.rb3.addActionListener(PreferencesPane.this.actionL);
                this.override.addActionListener(PreferencesPane.this.actionL);
            }
            catch (Exception exception) {}
        }

        public boolean stop() {
            return true;
        }

        protected void updateFontAndColor() {
            this.rb1.setFont(ResourceManager.menuFont);
            this.rb1.setForeground(ResourceManager.menuColor);
            this.rb3.setFont(ResourceManager.menuFont);
            this.rb3.setForeground(ResourceManager.menuColor);
            this.openLabel.setFont(ResourceManager.labelFont);
            this.openLabel.setForeground(ResourceManager.labelColor);
            this.override.setFont(ResourceManager.menuFont);
            this.override.setForeground(ResourceManager.menuColor);
        }
    }

    class GeneralSheet
    extends VPropertySheet
    implements PropertyChangeListener {
        protected JRadioButton rb1 = null;
        protected JRadioButton rb2 = null;
        protected JRadioButton rb3 = null;
        protected JRadioButton rb4 = null;
        protected JButton i1 = null;
        protected JButton i2 = null;
        protected JLabel layoutLabel = null;
        protected JLabel styleLabel = null;
        protected boolean init = false;

        public GeneralSheet() {
            ((Container)((Object)this)).setLayout(new BoxLayout((Container)((Object)this), 1));
            ((Container)((Object)this)).add(Box.createVerticalStrut(20));
            this.layoutLabel = new JLabel(ImplResourceManager.getString("Console Layout:"));
            JPanel jPanel = new JPanel(){

                public Dimension getMaximumSize() {
                    return new Dimension(super.getMaximumSize().width, super.getMinimumSize().height);
                }

                public Dimension getPreferredSize() {
                    return new Dimension(super.getPreferredSize().width, super.getMinimumSize().height);
                }
            };
            jPanel.setLayout(new FlowLayout(0));
            jPanel.add(this.layoutLabel);
            ((Container)((Object)this)).add(jPanel);
            ((Container)((Object)this)).add(Box.createVerticalStrut(10));
            this.rb1 = new JRadioButton();
            Insets insets = new Insets(0, 0, 0, 0);
            this.i1 = new JButton(ConsoleUtility.loadImageIcon((String)"images/hlayout.gif", (Class)imageClass));
            this.i1.setBorderPainted(false);
            this.i1.setMargin(insets);
            this.i1.addActionListener(new ActionListener(this){
                private final /* synthetic */ GeneralSheet this$1;
                {
                    this.this$1 = generalSheet;
                }

                public void actionPerformed(ActionEvent actionEvent) {
                    this.this$1.rb1.setSelected(true);
                }
            });
            this.rb2 = new JRadioButton();
            this.i2 = new JButton(ConsoleUtility.loadImageIcon((String)"images/vlayout.gif", (Class)imageClass));
            this.i2.setBorderPainted(false);
            this.i2.setMargin(insets);
            this.i2.addActionListener(new ActionListener(this){
                private final /* synthetic */ GeneralSheet this$1;
                {
                    this.this$1 = generalSheet;
                }

                public void actionPerformed(ActionEvent actionEvent) {
                    this.this$1.rb2.setSelected(true);
                }
            });
            ButtonGroup buttonGroup = new ButtonGroup();
            JPanel jPanel2 = new JPanel(){

                public Dimension getMaximumSize() {
                    return new Dimension(super.getMaximumSize().width, super.getMinimumSize().height);
                }

                public Dimension getPreferredSize() {
                    return new Dimension(super.getPreferredSize().width, super.getMinimumSize().height);
                }
            };
            jPanel2.setLayout(new FlowLayout(0));
            jPanel2.add(this.rb1);
            jPanel2.add(this.i1);
            JPanel jPanel3 = new JPanel(){

                public Dimension getMaximumSize() {
                    return new Dimension(super.getMaximumSize().width, super.getMinimumSize().height);
                }

                public Dimension getPreferredSize() {
                    return new Dimension(super.getPreferredSize().width, super.getMinimumSize().height);
                }
            };
            jPanel3.setLayout(new FlowLayout(0));
            jPanel3.add(this.rb2);
            jPanel3.add(this.i2);
            buttonGroup.add(this.rb1);
            buttonGroup.add(this.rb2);
            ((Container)((Object)this)).add(jPanel2);
            ((Container)((Object)this)).add(jPanel3);
            ((Container)((Object)this)).add(Box.createVerticalStrut(20));
            JPanel jPanel4 = new JPanel(){

                public Dimension getMaximumSize() {
                    return new Dimension(super.getMaximumSize().width, super.getMinimumSize().height);
                }

                public Dimension getPreferredSize() {
                    return new Dimension(super.getPreferredSize().width, super.getMinimumSize().height);
                }
            };
            jPanel4.setLayout(new FlowLayout(0));
            this.styleLabel = new JLabel(ImplResourceManager.getString("Interaction Style:"));
            jPanel4.add(this.styleLabel);
            ((Container)((Object)this)).add(jPanel4);
            ((Container)((Object)this)).add(Box.createVerticalStrut(10));
            this.rb3 = new JRadioButton(ImplResourceManager.getString("Classic"));
            this.rb4 = new JRadioButton(ImplResourceManager.getString("Web"));
            ButtonGroup buttonGroup2 = new ButtonGroup();
            buttonGroup2.add(this.rb3);
            buttonGroup2.add(this.rb4);
            JPanel jPanel5 = new JPanel(){

                public Dimension getMaximumSize() {
                    return new Dimension(super.getMaximumSize().width, super.getMinimumSize().height);
                }

                public Dimension getPreferredSize() {
                    return new Dimension(super.getPreferredSize().width, super.getMinimumSize().height);
                }
            };
            jPanel5.setLayout(new FlowLayout(0));
            jPanel5.add(this.rb3);
            JPanel jPanel6 = new JPanel(){

                public Dimension getMaximumSize() {
                    return new Dimension(super.getMaximumSize().width, super.getMinimumSize().height);
                }

                public Dimension getPreferredSize() {
                    return new Dimension(super.getPreferredSize().width, super.getMinimumSize().height);
                }
            };
            jPanel6.setLayout(new FlowLayout(0));
            jPanel6.add(this.rb4);
            ((Container)((Object)this)).add(Box.createVerticalStrut(10));
            ((Container)((Object)this)).add(jPanel5);
            ((Container)((Object)this)).add(jPanel6);
            ((Container)((Object)this)).add(Box.createVerticalGlue());
            this.setTitle(ImplResourceManager.getString("Appearance"));
            String string = ImplResourceManager.getString("AppearanceHelp");
            string = ContextHelpLoader.getContextHelp((String)string, null);
            this.setHelpHTML(string);
            this.updateFontAndColor();
        }

        public boolean apply() {
            if (PreferencesPane.this.properties == null) {
                return true;
            }
            if (!this.init) {
                return true;
            }
            if (this.rb1.isSelected()) {
                PreferencesPane.this.properties.setProperty("vconsole.layout", "horizontal");
            } else if (this.rb2.isSelected()) {
                PreferencesPane.this.properties.setProperty("vconsole.layout", "vertical");
            }
            if (this.rb3.isSelected()) {
                PreferencesPane.this.properties.setProperty("vconsole.clickstyle", "classic");
            } else if (this.rb4.isSelected()) {
                PreferencesPane.this.properties.setProperty("vconsole.clickstyle", "web");
            }
            return true;
        }

        public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
            if (propertyChangeEvent == null) {
                return;
            }
            try {
                String string = propertyChangeEvent.getPropertyName();
                String string2 = (String)propertyChangeEvent.getNewValue();
                if (string == null) {
                    return;
                }
                PreferencesPane.this.notify = false;
                if (string.equals("vconsole.layout")) {
                    this.reflectValue1(string2);
                } else if (string.equals("vconsole.clickstyle")) {
                    this.reflectValue2(string2);
                }
                PreferencesPane.this.notify = true;
            }
            catch (Exception exception) {}
        }

        protected void reflectValue1(String string) {
            if (string == null) {
                return;
            }
            if (string.equals("horizontal")) {
                this.rb1.setSelected(true);
            } else if (string.equals("vertical")) {
                this.rb2.setSelected(true);
            }
        }

        protected void reflectValue2(String string) {
            if (string == null) {
                return;
            }
            if (string.equals("classic")) {
                this.rb3.setSelected(true);
            } else if (string.equals("web")) {
                this.rb4.setSelected(true);
            }
        }

        public void reset() {
            if (PreferencesPane.this.properties == null) {
                return;
            }
            PreferencesPane.this.notify = false;
            this.reflectValue1(PreferencesPane.this.properties.getProperty("vconsole.layout"));
            this.reflectValue2(PreferencesPane.this.properties.getProperty("vconsole.clickstyle"));
            PreferencesPane.this.notify = true;
        }

        public void start() {
            this.updateFontAndColor();
            if (this.init || PreferencesPane.this.properties == null) {
                return;
            }
            try {
                PreferencesPane.this.properties.addPropertyChangeListener((PropertyChangeListener)this);
                String string = PreferencesPane.this.properties.getProperty("vconsole.layout");
                if (string == null) {
                    PreferencesPane.this.properties.setProperty("vconsole.layout", "horizontal");
                    string = "horizontal";
                }
                this.reflectValue1(string);
                this.rb1.addActionListener(PreferencesPane.this.actionL);
                this.rb2.addActionListener(PreferencesPane.this.actionL);
                this.i1.addActionListener(PreferencesPane.this.actionL);
                this.i2.addActionListener(PreferencesPane.this.actionL);
                string = PreferencesPane.this.properties.getProperty("vconsole.clickstyle");
                if (string == null) {
                    PreferencesPane.this.properties.setProperty("vconsole.clickstyle", "classic");
                    string = "classic";
                }
                this.reflectValue2(string);
                this.init = true;
                this.rb3.addActionListener(PreferencesPane.this.actionL);
                this.rb4.addActionListener(PreferencesPane.this.actionL);
            }
            catch (Exception exception) {}
        }

        public boolean stop() {
            return true;
        }

        protected void updateFontAndColor() {
            this.rb1.setFont(ResourceManager.menuFont);
            this.rb1.setForeground(ResourceManager.menuColor);
            this.rb2.setFont(ResourceManager.menuFont);
            this.rb2.setForeground(ResourceManager.menuColor);
            this.rb3.setFont(ResourceManager.menuFont);
            this.rb3.setForeground(ResourceManager.menuColor);
            this.rb4.setFont(ResourceManager.menuFont);
            this.rb4.setForeground(ResourceManager.menuColor);
            this.layoutLabel.setFont(ResourceManager.labelFont);
            this.layoutLabel.setForeground(ResourceManager.labelColor);
            this.styleLabel.setFont(ResourceManager.labelFont);
            this.styleLabel.setForeground(ResourceManager.labelColor);
        }
    }

    class FontsSheet
    extends VPropertySheet
    implements PropertyChangeListener {
        protected JLabel menuLabel = null;
        protected JLabel labelLabel = null;
        protected JLabel bodyLabel = null;
        protected JLabel menuFont = null;
        protected JButton changeMenu = null;
        protected JLabel labelFont = null;
        protected JButton changeLabel = null;
        protected JLabel bodyFont = null;
        protected JButton changeBody = null;
        protected boolean init = false;
        protected FontChooser fontChooser = null;

        public FontsSheet() {
            ((Container)((Object)this)).setLayout(new BoxLayout((Container)((Object)this), 1));
            ActionListener actionListener = new ActionListener(this){
                private final /* synthetic */ FontsSheet this$1;
                {
                    this.this$1 = fontsSheet;
                }

                public void actionPerformed(ActionEvent actionEvent) {
                    if (actionEvent.getSource() == this.this$1.changeMenu) {
                        this.this$1.promptUserForFont(this.this$1.menuFont);
                    } else if (actionEvent.getSource() == this.this$1.changeLabel) {
                        this.this$1.promptUserForFont(this.this$1.labelFont);
                    } else {
                        this.this$1.promptUserForFont(this.this$1.bodyFont);
                    }
                }
            };
            JPanel jPanel = new JPanel();
            jPanel.setLayout(new BoxLayout(jPanel, 0));
            this.menuLabel = new JLabel();
            jPanel.add(this.menuLabel);
            jPanel.add(Box.createHorizontalGlue());
            ((Container)((Object)this)).add(jPanel);
            ((Container)((Object)this)).add(Box.createVerticalStrut(10));
            JPanel jPanel2 = new JPanel(new GridLayout(1, 2));
            JPanel jPanel3 = new JPanel();
            jPanel3.setLayout(new BoxLayout(jPanel3, 0));
            this.menuFont = new JLabel();
            jPanel3.add(this.menuFont);
            jPanel3.add(Box.createHorizontalGlue());
            jPanel2.add(jPanel3);
            JPanel jPanel4 = new JPanel();
            jPanel4.setLayout(new BoxLayout(jPanel4, 0));
            this.changeMenu = new JButton();
            jPanel4.add(this.changeMenu);
            jPanel4.add(Box.createHorizontalGlue());
            jPanel2.add(jPanel4);
            this.changeMenu.addActionListener(actionListener);
            ((Container)((Object)this)).add(jPanel2);
            ((Container)((Object)this)).add(Box.createVerticalStrut(10));
            JPanel jPanel5 = new JPanel();
            jPanel5.setLayout(new BoxLayout(jPanel5, 0));
            this.labelLabel = new JLabel();
            jPanel5.add(this.labelLabel);
            jPanel5.add(Box.createHorizontalGlue());
            ((Container)((Object)this)).add(jPanel5);
            ((Container)((Object)this)).add(Box.createVerticalStrut(10));
            JPanel jPanel6 = new JPanel(new GridLayout(1, 2));
            JPanel jPanel7 = new JPanel();
            jPanel7.setLayout(new BoxLayout(jPanel7, 0));
            this.labelFont = new JLabel();
            jPanel7.add(this.labelFont);
            jPanel7.add(Box.createHorizontalGlue());
            jPanel6.add(jPanel7);
            JPanel jPanel8 = new JPanel();
            jPanel8.setLayout(new BoxLayout(jPanel8, 0));
            this.changeLabel = new JButton();
            jPanel8.add(this.changeLabel);
            jPanel8.add(Box.createHorizontalGlue());
            jPanel6.add(jPanel8);
            this.changeLabel.addActionListener(actionListener);
            ((Container)((Object)this)).add(jPanel6);
            ((Container)((Object)this)).add(Box.createVerticalStrut(10));
            JPanel jPanel9 = new JPanel();
            jPanel9.setLayout(new BoxLayout(jPanel9, 0));
            this.bodyLabel = new JLabel();
            jPanel9.add(this.bodyLabel);
            jPanel9.add(Box.createHorizontalGlue());
            ((Container)((Object)this)).add(jPanel9);
            ((Container)((Object)this)).add(Box.createVerticalStrut(10));
            JPanel jPanel10 = new JPanel(new GridLayout(1, 2));
            JPanel jPanel11 = new JPanel();
            jPanel11.setLayout(new BoxLayout(jPanel11, 0));
            this.bodyFont = new JLabel();
            jPanel11.add(this.bodyFont);
            jPanel11.add(Box.createHorizontalGlue());
            jPanel10.add(jPanel11);
            JPanel jPanel12 = new JPanel();
            jPanel12.setLayout(new BoxLayout(jPanel12, 0));
            this.changeBody = new JButton();
            jPanel12.add(this.changeBody);
            jPanel12.add(Box.createHorizontalGlue());
            jPanel10.add(jPanel12);
            this.changeBody.addActionListener(actionListener);
            ((Container)((Object)this)).add(jPanel10);
            ((Container)((Object)this)).add(Box.createVerticalStrut(10));
            this.setTitle(ImplResourceManager.getString("Fonts"));
            String string = ImplResourceManager.getString("FontsHelp");
            string = ContextHelpLoader.getContextHelp((String)string, null);
            this.setHelpHTML(string);
            this.installStrings();
        }

        public boolean apply() {
            if (PreferencesPane.this.properties == null) {
                return true;
            }
            if (!this.init) {
                return true;
            }
            if (this.menuFont.getFont() != ResourceManager.menuFont) {
                PreferencesPane.this.properties.setPropertyObject("vconsole.menufont", (Object)this.menuFont.getFont());
            }
            if (this.menuFont.getForeground() != ResourceManager.menuColor) {
                PreferencesPane.this.properties.setPropertyObject("vconsole.menucolor", (Object)this.menuFont.getForeground());
            }
            if (this.labelFont.getFont() != ResourceManager.labelFont) {
                PreferencesPane.this.properties.setPropertyObject("vconsole.labelfont", (Object)this.labelFont.getFont());
            }
            if (this.labelFont.getForeground() != ResourceManager.labelColor) {
                PreferencesPane.this.properties.setPropertyObject("vconsole.labelcolor", (Object)this.labelFont.getForeground());
            }
            if (this.bodyFont.getFont() != ResourceManager.bodyFont) {
                PreferencesPane.this.properties.setPropertyObject("vconsole.bodyfont", (Object)this.bodyFont.getFont());
            }
            if (this.bodyFont.getForeground() != ResourceManager.bodyColor) {
                PreferencesPane.this.properties.setPropertyObject("vconsole.bodycolor", (Object)this.bodyFont.getForeground());
            }
            return true;
        }

        public Dimension getMinimumSize() {
            return ((JComponent)((Object)this)).getPreferredSize();
        }

        protected void installStrings() {
            this.menuLabel.setText(ImplResourceManager.getString("Menu:"));
            String string = ImplResourceManager.getString("Change...");
            this.changeMenu.setText(string);
            this.labelLabel.setText(ImplResourceManager.getString("Label:"));
            this.changeLabel.setText(string);
            this.bodyLabel.setText(ImplResourceManager.getString("Body:"));
            this.changeBody.setText(string);
        }

        protected void promptUserForFont(JLabel jLabel) {
            if (this.fontChooser == null) {
                this.fontChooser = new FontChooser();
            }
            String string = null;
            string = jLabel == this.labelFont ? "FontChooserLabelHelp" : (jLabel == this.menuFont ? "FontChooserMenuHelp" : "FontChooserHelp");
            this.fontChooser.setContextHelp(ImplResourceManager.getString(string));
            try {
                int n = this.fontChooser.showFontDialog(jLabel.getFont(), jLabel.getForeground(), PreferencesPane.this.getContainer());
                if (n != 1) {
                    if (jLabel == this.menuFont) {
                        this.reflectFontAndColor(this.menuFont, this.fontChooser.getFont(), this.fontChooser.getColor());
                    } else if (jLabel == this.labelFont) {
                        this.reflectFontAndColor(this.labelFont, this.fontChooser.getFont(), this.fontChooser.getColor());
                    } else {
                        this.reflectFontAndColor(this.bodyFont, this.fontChooser.getFont(), this.fontChooser.getColor());
                    }
                    PreferencesPane.this.actionL.actionPerformed(null);
                }
            }
            catch (Throwable throwable) {
                throwable.printStackTrace();
                Debug.trace((String)"FontsSheet", (int)Debug.WARNING, (String)"Problem prompting for font", (Throwable)throwable);
            }
        }

        public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
        }

        protected void reflectFontAndColor(JLabel jLabel, Font font, Color color) {
            if (jLabel == null || font == null || color == null) {
                return;
            }
            String string = font.getFontName(ResourceManager.currentLocale);
            int n = font.getSize();
            String string2 = "";
            string2 = font.isBold() ? ImplResourceManager.getString("Bold") : (font.isItalic() ? ImplResourceManager.getString("Italic") : ImplResourceManager.getString("Plain"));
            jLabel.setText(String.valueOf(string) + ", " + n + ", " + string2);
            jLabel.setFont(font);
            jLabel.setForeground(color);
            jLabel.validate();
            jLabel.repaint();
        }

        public void reset() {
        }

        public void start() {
            this.updateFontAndColor();
            if (this.init || PreferencesPane.this.properties == null) {
                return;
            }
            try {
                PreferencesPane.this.properties.addPropertyChangeListener((PropertyChangeListener)this);
                this.reflectFontAndColor(this.bodyFont, ResourceManager.bodyFont, ResourceManager.bodyColor);
                this.reflectFontAndColor(this.labelFont, ResourceManager.labelFont, ResourceManager.labelColor);
                this.reflectFontAndColor(this.menuFont, ResourceManager.menuFont, ResourceManager.menuColor);
                this.init = true;
            }
            catch (Throwable throwable) {
                Debug.trace((String)"FontsSheet", (int)Debug.WARNING, (String)"Problem in start()", (Throwable)throwable);
            }
        }

        public boolean stop() {
            return true;
        }

        protected void updateFontAndColor() {
            this.menuLabel.setFont(ResourceManager.labelFont);
            this.menuLabel.setForeground(ResourceManager.labelColor);
            this.labelLabel.setFont(ResourceManager.labelFont);
            this.labelLabel.setForeground(ResourceManager.labelColor);
            this.bodyLabel.setFont(ResourceManager.labelFont);
            this.bodyLabel.setForeground(ResourceManager.labelColor);
        }
    }

    class ToolBarSheet
    extends VPropertySheet
    implements PropertyChangeListener {
        protected JLabel displayLabel = null;
        protected JRadioButton rb1 = null;
        protected JRadioButton rb2 = null;
        protected JRadioButton rb3 = null;
        protected JButton b1 = null;
        protected JButton b2 = null;
        protected JButton b3 = null;
        protected boolean init = false;

        public ToolBarSheet() {
            ((Container)((Object)this)).setLayout(new BoxLayout((Container)((Object)this), 1));
            this.displayLabel = new JLabel(ImplResourceManager.getString("Display As:"));
            ((Container)((Object)this)).add(Box.createVerticalStrut(20));
            JPanel jPanel = new JPanel(){

                public Dimension getMaximumSize() {
                    return new Dimension(super.getMaximumSize().width, super.getMinimumSize().height);
                }

                public Dimension getPreferredSize() {
                    return new Dimension(super.getPreferredSize().width, super.getMinimumSize().height);
                }
            };
            jPanel.setLayout(new FlowLayout(0));
            jPanel.add(this.displayLabel);
            ((Container)((Object)this)).add(jPanel);
            this.rb1 = new JRadioButton();
            this.rb2 = new JRadioButton();
            this.rb3 = new JRadioButton();
            ButtonGroup buttonGroup = new ButtonGroup();
            buttonGroup.add(this.rb1);
            buttonGroup.add(this.rb2);
            buttonGroup.add(this.rb3);
            JPanel jPanel2 = new JPanel(){

                public Dimension getMaximumSize() {
                    return new Dimension(super.getMaximumSize().width, super.getMinimumSize().height);
                }

                public Dimension getPreferredSize() {
                    return new Dimension(super.getPreferredSize().width, super.getMinimumSize().height);
                }
            };
            jPanel2.setLayout(new FlowLayout(0));
            jPanel2.add(this.rb1);
            ImageIcon imageIcon = ConsoleUtility.loadImageIcon((String)"images/delete16.gif", (Class)imageClass);
            this.b1 = new JButton(imageIcon);
            Insets insets = new Insets(0, 0, 0, 0);
            this.b1.addActionListener(new ActionListener(this){
                private final /* synthetic */ ToolBarSheet this$1;
                {
                    this.this$1 = toolBarSheet;
                }

                public void actionPerformed(ActionEvent actionEvent) {
                    this.this$1.rb1.setSelected(true);
                }
            });
            this.b1.setMargin(insets);
            jPanel2.add(this.b1);
            ((Container)((Object)this)).add(Box.createVerticalStrut(10));
            ((Container)((Object)this)).add(jPanel2);
            ((Container)((Object)this)).add(Box.createVerticalStrut(10));
            JPanel jPanel3 = new JPanel(){

                public Dimension getMaximumSize() {
                    return new Dimension(super.getMaximumSize().width, super.getMinimumSize().height);
                }

                public Dimension getPreferredSize() {
                    return new Dimension(super.getPreferredSize().width, super.getMinimumSize().height);
                }
            };
            jPanel3.setLayout(new FlowLayout(0));
            jPanel3.add(this.rb2);
            String string = ImplResourceManager.getString("Delete");
            this.b2 = new JButton(string, imageIcon);
            this.b2.addActionListener(new ActionListener(this){
                private final /* synthetic */ ToolBarSheet this$1;
                {
                    this.this$1 = toolBarSheet;
                }

                public void actionPerformed(ActionEvent actionEvent) {
                    this.this$1.rb2.setSelected(true);
                }
            });
            this.b2.setMargin(insets);
            jPanel3.add(this.b2);
            ((Container)((Object)this)).add(jPanel3);
            ((Container)((Object)this)).add(Box.createVerticalStrut(10));
            JPanel jPanel4 = new JPanel(){

                public Dimension getMaximumSize() {
                    return new Dimension(super.getMaximumSize().width, super.getMinimumSize().height);
                }

                public Dimension getPreferredSize() {
                    return new Dimension(super.getPreferredSize().width, super.getMinimumSize().height);
                }
            };
            jPanel4.setLayout(new FlowLayout(0));
            jPanel4.add(this.rb3);
            this.b3 = new JButton(string);
            this.b3.addActionListener(new ActionListener(this){
                private final /* synthetic */ ToolBarSheet this$1;
                {
                    this.this$1 = toolBarSheet;
                }

                public void actionPerformed(ActionEvent actionEvent) {
                    this.this$1.rb3.setSelected(true);
                }
            });
            this.b3.setMargin(insets);
            jPanel4.add(this.b3);
            ((Container)((Object)this)).add(jPanel4);
            this.setTitle(ImplResourceManager.getString("Toolbar"));
            String string2 = ImplResourceManager.getString("ToolbarHelp");
            string2 = ContextHelpLoader.getContextHelp((String)string2, null);
            this.setHelpHTML(string2);
            this.updateFontAndColor();
        }

        public boolean apply() {
            if (PreferencesPane.this.properties == null) {
                return true;
            }
            if (!this.init) {
                return true;
            }
            if (this.rb1.isSelected()) {
                PreferencesPane.this.properties.setProperty("vconsole.buttondisplay", "vconsole.icononly");
            } else if (this.rb2.isSelected()) {
                PreferencesPane.this.properties.setProperty("vconsole.buttondisplay", "vconsole.textandicon");
            } else if (this.rb3.isSelected()) {
                PreferencesPane.this.properties.setProperty("vconsole.buttondisplay", "vconsole.textonly");
            }
            return true;
        }

        public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
            if (propertyChangeEvent == null) {
                return;
            }
            try {
                String string = propertyChangeEvent.getPropertyName();
                String string2 = (String)propertyChangeEvent.getNewValue();
                if (string == null) {
                    return;
                }
                PreferencesPane.this.notify = false;
                if (string.equals("vconsole.buttondisplay")) {
                    this.reflectValue(string2);
                }
                PreferencesPane.this.notify = true;
            }
            catch (Exception exception) {}
        }

        protected void reflectValue(String string) {
            if (string == null) {
                return;
            }
            if (string.equals("vconsole.icononly")) {
                this.rb1.setSelected(true);
            } else if (string.equals("vconsole.textandicon")) {
                this.rb2.setSelected(true);
            } else if (string.equals("vconsole.textonly")) {
                this.rb3.setSelected(true);
            }
        }

        public void reset() {
            if (PreferencesPane.this.properties == null) {
                return;
            }
            PreferencesPane.this.notify = false;
            String string = PreferencesPane.this.properties.getProperty("vconsole.buttondisplay");
            this.reflectValue(string);
            PreferencesPane.this.notify = true;
        }

        public void start() {
            this.updateFontAndColor();
            if (this.init || PreferencesPane.this.properties == null) {
                return;
            }
            try {
                PreferencesPane.this.properties.addPropertyChangeListener((PropertyChangeListener)this);
                String string = PreferencesPane.this.properties.getProperty("vconsole.buttondisplay");
                if (string == null) {
                    PreferencesPane.this.properties.setProperty("vconsole.buttondisplay", "vconsole.icononly");
                    string = "vconsole.icononly";
                }
                this.reflectValue(string);
                this.init = true;
                this.rb1.addActionListener(PreferencesPane.this.actionL);
                this.rb2.addActionListener(PreferencesPane.this.actionL);
                this.rb3.addActionListener(PreferencesPane.this.actionL);
                this.b1.addActionListener(PreferencesPane.this.actionL);
                this.b2.addActionListener(PreferencesPane.this.actionL);
                this.b3.addActionListener(PreferencesPane.this.actionL);
            }
            catch (Exception exception) {}
        }

        public boolean stop() {
            return true;
        }

        protected void updateFontAndColor() {
            this.displayLabel.setFont(ResourceManager.labelFont);
            this.displayLabel.setForeground(ResourceManager.labelColor);
            this.rb1.setFont(ResourceManager.menuFont);
            this.rb1.setForeground(ResourceManager.menuColor);
            this.rb2.setFont(ResourceManager.menuFont);
            this.rb2.setForeground(ResourceManager.menuColor);
            this.rb3.setFont(ResourceManager.menuFont);
            this.rb3.setForeground(ResourceManager.menuColor);
            this.b1.setFont(ResourceManager.menuFont);
            this.b1.setForeground(ResourceManager.menuColor);
            this.b2.setFont(ResourceManager.menuFont);
            this.b2.setForeground(ResourceManager.menuColor);
            this.b3.setFont(ResourceManager.menuFont);
            this.b3.setForeground(ResourceManager.menuColor);
        }
    }

    class AuthSheet
    extends VPropertySheet
    implements PropertyChangeListener {
        protected JCheckBox cb = null;
        protected JCheckBox cb2 = null;
        protected JRadioButton rb1 = null;
        protected JRadioButton rb2 = null;
        protected JLabel loadLabel = null;
        protected JLabel advLabel = null;
        protected boolean init = false;

        public AuthSheet() {
            ((Container)((Object)this)).setLayout(new BoxLayout((Container)((Object)this), 1));
            ((Container)((Object)this)).add(Box.createVerticalStrut(20));
            this.loadLabel = new JLabel(ImplResourceManager.getString("When loading tools from multiple servers:"));
            this.advLabel = new JLabel(ImplResourceManager.getString("Advanced login allows user and role login in a single step:"));
            this.rb1 = new JRadioButton(ImplResourceManager.getString("Prompt for initial credentials and use them for all servers"));
            this.rb2 = new JRadioButton(ImplResourceManager.getString("Prompt for credentials for every server"));
            ButtonGroup buttonGroup = new ButtonGroup();
            buttonGroup.add(this.rb1);
            buttonGroup.add(this.rb2);
            this.cb = new JCheckBox(ImplResourceManager.getString("Prompt if credentials fail"));
            this.cb2 = new JCheckBox(ImplResourceManager.getString("Enable advanced login"));
            ((Container)((Object)this)).add(this.loadLabel);
            ((Container)((Object)this)).add(Box.createVerticalStrut(10));
            ((Container)((Object)this)).add(this.rb1);
            ((Container)((Object)this)).add(Box.createVerticalStrut(10));
            ((Container)((Object)this)).add(this.rb2);
            ((Container)((Object)this)).add(Box.createVerticalStrut(20));
            ((Container)((Object)this)).add(this.cb);
            ((Container)((Object)this)).add(Box.createVerticalStrut(40));
            ((Container)((Object)this)).add(this.advLabel);
            ((Container)((Object)this)).add(Box.createVerticalStrut(10));
            ((Container)((Object)this)).add(this.cb2);
            ((Container)((Object)this)).add(Box.createVerticalGlue());
            this.setTitle(ImplResourceManager.getString("Authentication"));
            String string = ImplResourceManager.getString("AuthenticationHelp");
            string = ContextHelpLoader.getContextHelp((String)string, null);
            this.setHelpHTML(string);
            this.updateFontAndColor();
        }

        public boolean apply() {
            if (PreferencesPane.this.properties == null) {
                return true;
            }
            if (!this.init) {
                return true;
            }
            if (this.rb1.isSelected()) {
                PreferencesPane.this.properties.setProperty("vconsole.authpreference", "vconsole.alwaysuseinitial");
            } else if (this.rb2.isSelected()) {
                PreferencesPane.this.properties.setProperty("vconsole.authpreference", "vconsole.alwaysprompt");
            }
            if (this.cb.isSelected()) {
                PreferencesPane.this.properties.setProperty("vconsole.promptonfailure", "true");
            } else {
                PreferencesPane.this.properties.setProperty("vconsole.promptonfailure", "false");
            }
            if (this.cb2.isSelected()) {
                PreferencesPane.this.properties.setProperty("vconsole.loginmode", "vconsole.advanced");
            } else {
                PreferencesPane.this.properties.setProperty("vconsole.loginmode", "vconsole.basic");
            }
            return true;
        }

        public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
            if (propertyChangeEvent == null) {
                return;
            }
            try {
                String string = propertyChangeEvent.getPropertyName();
                String string2 = (String)propertyChangeEvent.getNewValue();
                if (string == null) {
                    return;
                }
                PreferencesPane.this.notify = false;
                if (string.equals("vconsole.authpreference")) {
                    this.reflectValue1(string2);
                } else if (string.equals("vconsole.promptonfailure")) {
                    this.reflectValue2(string2);
                } else if (string.equals("vconsole.loginmode")) {
                    this.reflectValue3(string2);
                }
                PreferencesPane.this.notify = true;
            }
            catch (Exception exception) {}
        }

        protected void reflectValue1(String string) {
            if (string == null) {
                return;
            }
            if (string.equals("vconsole.alwaysuseinitial")) {
                this.rb1.setSelected(true);
            } else if (string.equals("vconsole.alwaysprompt")) {
                this.rb2.setSelected(true);
            }
        }

        protected void reflectValue2(String string) {
            if (string == null) {
                return;
            }
            if (string.equals("true")) {
                this.cb.setSelected(true);
            } else if (string.equals("false")) {
                this.cb.setSelected(false);
            }
        }

        protected void reflectValue3(String string) {
            if (string == null) {
                return;
            }
            if (string.equals("vconsole.advanced")) {
                this.cb2.setSelected(true);
            } else if (string.equals("vconsole.basic")) {
                this.cb2.setSelected(false);
            }
        }

        public void reset() {
            if (PreferencesPane.this.properties == null) {
                return;
            }
            PreferencesPane.this.notify = false;
            String string = PreferencesPane.this.properties.getProperty("vconsole.authpreference");
            this.reflectValue1(string);
            string = PreferencesPane.this.properties.getProperty("vconsole.promptonfailure");
            this.reflectValue2(string);
            string = PreferencesPane.this.properties.getProperty("vconsole.loginmode");
            this.reflectValue3(string);
            PreferencesPane.this.notify = true;
        }

        public void start() {
            this.updateFontAndColor();
            if (this.init || PreferencesPane.this.properties == null) {
                return;
            }
            try {
                PreferencesPane.this.properties.addPropertyChangeListener((PropertyChangeListener)this);
                String string = PreferencesPane.this.properties.getProperty("vconsole.authpreference");
                if (string == null) {
                    PreferencesPane.this.properties.setProperty("vconsole.authpreference", "vconsole.alwaysuseinitial");
                    string = "vconsole.alwaysuseinitial";
                }
                this.reflectValue1(string);
                string = PreferencesPane.this.properties.getProperty("vconsole.promptonfailure");
                if (string == null) {
                    PreferencesPane.this.properties.setProperty("vconsole.promptonfailure", "true");
                    string = "true";
                }
                this.reflectValue2(string);
                string = PreferencesPane.this.properties.getProperty("vconsole.loginmode");
                if (string == null) {
                    PreferencesPane.this.properties.setProperty("vconsole.loginmode", "vconsole.basic");
                    string = "vconsole.basic";
                }
                this.reflectValue3(string);
                this.init = true;
                this.rb1.addActionListener(PreferencesPane.this.actionL);
                this.rb2.addActionListener(PreferencesPane.this.actionL);
                this.cb.addActionListener(PreferencesPane.this.actionL);
                this.cb2.addActionListener(PreferencesPane.this.actionL);
            }
            catch (Exception exception) {}
        }

        public boolean stop() {
            return true;
        }

        protected void updateFontAndColor() {
            this.cb.setFont(ResourceManager.menuFont);
            this.cb.setForeground(ResourceManager.menuColor);
            this.cb2.setFont(ResourceManager.menuFont);
            this.cb2.setForeground(ResourceManager.menuColor);
            this.rb1.setFont(ResourceManager.menuFont);
            this.rb1.setForeground(ResourceManager.menuColor);
            this.rb2.setFont(ResourceManager.menuFont);
            this.rb2.setForeground(ResourceManager.menuColor);
            this.loadLabel.setFont(ResourceManager.labelFont);
            this.loadLabel.setForeground(ResourceManager.labelColor);
            this.advLabel.setFont(ResourceManager.labelFont);
            this.advLabel.setForeground(ResourceManager.labelColor);
        }
    }
}

