/*
 * Decompiled with CFR 0.152.
 */
package com.sun.management.viperimpl.console;

import com.sun.management.viper.AdminMgmtScope;
import com.sun.management.viper.util.CommandOption;
import com.sun.management.viperimpl.util.ImplResourceManager;
import java.net.InetAddress;
import java.net.URL;

public class BaseConsoleOptions {
    public static CommandOption getAuthDataOption() {
        return new CommandOption("authentication data", ImplResourceManager.getString("AuthDataOption"), new String[]{"auth-data"}, 1, true, false, null, false);
    }

    public static CommandOption getDebugOption() {
        CommandOption commandOption = new CommandOption("debug", ImplResourceManager.getString("DebugOption"), new String[]{"d", "debug"}, 2, true, false, null, false);
        commandOption.setHidden(true);
        return commandOption;
    }

    public static CommandOption getHelpOption() {
        return new CommandOption("help", ImplResourceManager.getString("HelpOption"), new String[]{"h", "?", "help", "usage"}, 0, true, false, null, false, false);
    }

    public static CommandOption getHostOption(String string) {
        return new CommandOption("hostname:port", ImplResourceManager.getString("HostnamePortOption"), new String[]{"H", "hostname"}, 1, true, false, string, false){

            protected Object isValidValue(Object object) throws Exception {
                try {
                    String string = (String)object;
                    int n = string.lastIndexOf(":");
                    if (n != -1) {
                        string = string.substring(0, n);
                    }
                    InetAddress.getByName(string);
                    return object;
                }
                catch (Exception exception) {
                    throw new Exception("Invalid host argument.");
                }
            }
        };
    }

    public static CommandOption getPassThruOption() {
        return new CommandOption("tool options", ImplResourceManager.getString("PassThruOption"), "-", 1, true, false, (Object)"none", false);
    }

    public static CommandOption getPasswordOption(String string) {
        return new CommandOption("password", ImplResourceManager.getString("PasswordOption"), new String[]{"p", "password", "passwd"}, 1, true, false, null, true);
    }

    public static CommandOption getRoleNameOption(String string) {
        return new CommandOption("rolename", ImplResourceManager.getString("RolenameOption"), new String[]{"r", "rolename"}, 1, true, false, (Object)string, false);
    }

    public static CommandOption getRolePasswordOption(String string) {
        return new CommandOption("rolepassword", ImplResourceManager.getString("RolepasswordOption"), new String[]{"l", "rolepassword", "rolepasswd"}, 1, true, false, null, true);
    }

    public static CommandOption getScopeOption(AdminMgmtScope adminMgmtScope) {
        return new CommandOption("domain", ImplResourceManager.getString("DomainOption"), new String[]{"D", "domain", "scope"}, 1, true, false, adminMgmtScope, false){

            protected Object isValidValue(Object object) throws Exception {
                try {
                    return new AdminMgmtScope(null, (String)object);
                }
                catch (Exception exception) {
                    throw new Exception("Invalid domain/scope argument.");
                }
            }
        };
    }

    public static CommandOption getSilentOption() {
        return new CommandOption("silent", ImplResourceManager.getString("SilentOption"), new String[]{"s", "silent"}, 0, true, false, null, false);
    }

    public static CommandOption getTerminalOption() {
        return new CommandOption("terminal", ImplResourceManager.getString("TerminalOption"), new String[]{"t", "terminal", "tty"}, 0, true, false, null, false);
    }

    public static CommandOption getToolBoxOption(URL uRL) {
        return new CommandOption("toolbox", ImplResourceManager.getString("ToolboxOption"), new String[]{"B", "toolbox"}, 1, true, false, null, false);
    }

    public static CommandOption getToolOption(String string) {
        return new CommandOption("tool", ImplResourceManager.getString("ToolOption"), new String[]{"T", "tool"}, 1, true, true, null, false);
    }

    public static CommandOption getTrustedOption() {
        CommandOption commandOption = new CommandOption("trust", ImplResourceManager.getString("TrustOption"), new String[]{"trust"}, 0, true, false, null, false);
        return commandOption;
    }

    public static CommandOption getUserNameOption(String string) {
        return new CommandOption("username", ImplResourceManager.getString("UsernameOption"), new String[]{"u", "username"}, 1, true, false, (Object)string, false);
    }

    public static CommandOption getVersionOption() {
        return new CommandOption("version", ImplResourceManager.getString("VersionOption"), new String[]{"v", "version", "about"}, 0, true, false, null, false, false);
    }

    public static CommandOption getYesOption() {
        CommandOption commandOption = new CommandOption("yes", ImplResourceManager.getString("YesOption"), new String[]{"y", "yes"}, 0, true, false, null, false);
        return commandOption;
    }
}

