/*
 * Decompiled with CFR 0.152.
 */
package com.sun.wbem.cim;

import com.sun.wbem.cim.CIMDataType;
import com.sun.wbem.cim.CIMElement;
import com.sun.wbem.cim.CIMQualifier;
import com.sun.wbem.cim.MOFFormatter;
import com.sun.wbem.cim.XmlInstance;
import java.util.Enumeration;
import java.util.Vector;

public class CIMParameter
extends CIMElement
implements Cloneable {
    static final long serialVersionUID = 200L;
    private CIMDataType type;
    private int size = 0;
    private Vector qualifiers = new Vector();

    public CIMParameter() {
        this("");
    }

    public CIMParameter(String string) {
        super(string);
    }

    public synchronized Object clone() {
        return this.clone(true);
    }

    synchronized Object clone(boolean bl) {
        CIMParameter cIMParameter = new CIMParameter();
        cIMParameter.name = this.name;
        cIMParameter.identifier = this.identifier;
        cIMParameter.type = this.type;
        cIMParameter.size = this.size;
        if (this.qualifiers == null || !bl) {
            cIMParameter.qualifiers = new Vector();
        } else {
            Vector<Object> vector = new Vector<Object>();
            Enumeration enumeration = this.qualifiers.elements();
            while (enumeration.hasMoreElements()) {
                CIMQualifier cIMQualifier = (CIMQualifier)enumeration.nextElement();
                vector.addElement(cIMQualifier.clone());
            }
            cIMParameter.qualifiers = vector;
        }
        return cIMParameter;
    }

    public CIMQualifier getQualifier(String string) {
        if (string == null) {
            return null;
        }
        int n = this.qualifiers.indexOf(new CIMQualifier(string));
        CIMQualifier cIMQualifier = n >= 0 ? (CIMQualifier)this.qualifiers.elementAt(n) : null;
        return cIMQualifier;
    }

    public Vector getQualifiers() {
        return this.qualifiers;
    }

    public int getSize() {
        return this.size;
    }

    public CIMDataType getType() {
        return this.type;
    }

    public void setQualifiers(Vector vector) {
        this.qualifiers = vector;
    }

    public void setSize(int n) {
        this.size = n;
    }

    public void setType(CIMDataType cIMDataType) {
        this.type = cIMDataType;
    }

    public String toMOF() {
        MOFFormatter mOFFormatter = new MOFFormatter();
        return mOFFormatter.toString(this);
    }

    public String toString() {
        return this.toMOF();
    }

    public String toXml() {
        XmlInstance xmlInstance = new XmlInstance();
        return xmlInstance.toXml(this);
    }
}

