/*
 * Decompiled with CFR 0.152.
 */
package com.sun.audiocontrol.SDtAudioControl;

import com.sun.audiocontrol.SDtAudioControl.AudioControlHelp;
import com.sun.audiocontrol.SDtAudioControl.AudioLED;
import com.sun.audiocontrol.SDtAudioControl.AudioSlider;
import com.sun.audiocontrol.SDtAudioControl.AudioSliderPanel;
import com.sun.audiocontrol.SDtAudioControl.BalanceSliderPanel;
import com.sun.audiocontrol.SDtAudioControl.CheckList;
import com.sun.audiocontrol.SDtAudioControl.CheckableItem;
import com.sun.audiocontrol.SDtAudioControl.Debug;
import com.sun.audiocontrol.SDtAudioControl.GeneralClassLoader;
import com.sun.audiocontrol.SDtAudioControl.RadioList;
import com.sun.dt.Xsession;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Frame;
import java.awt.Image;
import java.awt.Insets;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.text.DecimalFormat;
import java.util.Locale;
import java.util.MissingResourceException;
import java.util.ResourceBundle;
import javax.help.CSH;
import javax.help.HelpBroker;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JCheckBoxMenuItem;
import javax.swing.JComponent;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JProgressBar;
import javax.swing.JScrollPane;
import javax.swing.JSeparator;
import javax.swing.JTabbedPane;
import javax.swing.KeyStroke;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;

class AudioControl
extends JFrame {
    static AudioControl theAudioControl;
    static AudioStatus theAudioStatus;
    static final String progname = "sdtaudiocontrol";
    static final Image APPICON;
    static String audio_device;
    static final String newline = "\n";
    static final String colon = ": ";
    static boolean appctrls;
    static boolean debug;
    Dimension listDim = new Dimension(175, 55);
    private static ResourceBundle bundle;
    static final int MASTER_CHANNEL = -1;
    static final String MASTER_CHANNEL_STR = "Master";
    static final Object[] EMPTYSET;
    static int currSelectedChan;
    static boolean currMixerMode;
    static boolean currPBMuted;
    static boolean mixer_supported;
    static boolean mixermodeIgnoreChange;
    static boolean MPBMuteIgnoreChange;
    static final int UNINIT_VALUE = -1;
    static final int AUDIO_MIN_GAIN = 0;
    static final int AUDIO_MAX_GAIN = 100;
    static final int AUDIO_LEFT_BALANCE = 0;
    static final int AUDIO_MID_BALANCE = 32;
    static final int AUDIO_RIGHT_BALANCE = 64;
    static final int AM_PLAY_GAIN = 1;
    static final int AM_RECORD_GAIN = 2;
    static final int AM_MONITOR_GAIN = 4;
    static final int AM_RESERVE_GAIN = 8;
    static final int AM_PLAY_BAL = 16;
    static final int AM_RECORD_BAL = 32;
    static final int AUDIO_NONE = 0;
    static final int AUDIO_SPEAKER = 1;
    static final int AUDIO_HEADPHONE = 2;
    static final int AUDIO_LINE_OUT = 4;
    static final int AUDIO_SPDIF_OUT = 8;
    static final int AUDIO_AUX1_OUT = 16;
    static final int AUDIO_AUX2_OUT = 32;
    static final int AUDIO_MICROPHONE = 1;
    static final int AUDIO_LINE_IN = 2;
    static final int AUDIO_CD = 4;
    static final int AUDIO_INTERNAL_CD_IN = 4;
    static final int AUDIO_SPDIF_IN = 8;
    static final int AUDIO_AUX1_IN = 16;
    static final int AUDIO_AUX2_IN = 32;
    static final int AUDIO_CODEC_LOOPB_IN = 64;
    static final int AUDIO_SUNVTS = 128;
    static final int sizeOfInt = 32;
    static final String[] Encoding;
    Font plain8 = new Font("Dialog", 0, 8);
    Font plain10 = new Font("Dialog", 0, 10);
    Font plain12 = new Font("Dialog", 0, 12);
    Font plain14 = new Font("Dialog", 0, 14);
    Font bold8 = new Font("dialog.bold", 0, 8);
    Font bold10 = new Font("dialog.bold", 0, 10);
    Font bold12 = new Font("dialog.bold", 0, 12);
    Font bold14 = new Font("dialog.bold", 0, 14);
    static JTabbedPane JTabbedPane1;
    static JPanel PlaybackPanel;
    static JPanel MPBPanel;
    static JLabel JLabel1;
    static JScrollPane JScrollPane1;
    static CheckList OutputList;
    static AudioSliderPanel MPBVolSliderPanel;
    static AudioSliderPanel AppPBVolSliderPanel;
    static AudioSliderPanel MRecGainSliderPanel;
    static AudioSliderPanel MRecMonitorSliderPanel;
    static AudioSliderPanel AppRecGainSliderPanel;
    static AudioSlider MPBVolSlider;
    static AudioSlider AppPBVolSlider;
    static AudioSlider MRecGainSlider;
    static AudioSlider MRecMonitorSlider;
    static BalanceSliderPanel MPBBalSliderPanel;
    static BalanceSliderPanel AppPBBalSliderPanel;
    static BalanceSliderPanel MRecBalSliderPanel;
    static BalanceSliderPanel AppRecBalSliderPanel;
    static AudioSlider MPBBalSlider;
    static AudioSlider AppPBBalSlider;
    static AudioSlider MRecBalSlider;
    static AudioSlider AppRecBalSlider;
    static JLabel MPBVolCurrentValue;
    static JLabel AppPBVolCurrentValue;
    static JLabel MRecGainCurrentValue;
    static JLabel MRecMonitorCurrentValue;
    static JProgressBar MRecGainProgressBar;
    static JCheckBox MPBMuteCheckbox;
    static JPanel AppPBPanel;
    static JLabel JLabel3;
    static JScrollPane JScrollPane3;
    static JList AppPBList;
    static JCheckBox AppPBMuteCheckbox;
    static JPanel RecordPanel;
    static JPanel MRecPanel;
    static JLabel JLabel2;
    static JScrollPane JScrollPane2;
    static RadioList InputList;
    static JPanel JPanel3;
    static JPanel AppRecPanel;
    static JLabel JLabel4;
    static JScrollPane JScrollPane4;
    static JList AppRecList;
    static JProgressBar AppRecGainProgressBar;
    static AudioSlider AppRecGainSlider;
    static JLabel AppRecGainCurrentValue;
    static JMenuBar AudioControlMenubar;
    static JMenu fileMenu;
    static JCheckBoxMenuItem mixermodeItem;
    static JMenuItem exitItem;
    static JMenu viewMenu;
    static JCheckBoxMenuItem appcontrolsItem;
    static JMenuItem statusItem;
    static JMenu helpMenu;
    static JMenuItem helpItem;
    static JMenuItem aboutItem;
    HelpBroker helpBroker = null;
    ActionListener helpBrokerListener;
    private static String classname;
    private static GeneralClassLoader loader;
    boolean noHelpJar = false;

    static {
        theAudioStatus = null;
        APPICON = Toolkit.getDefaultToolkit().getImage("icons/sdtaudiocontrol.gif");
        audio_device = "/dev/audio";
        appctrls = false;
        debug = false;
        bundle = null;
        EMPTYSET = new Object[0];
        currSelectedChan = -1;
        mixermodeIgnoreChange = false;
        MPBMuteIgnoreChange = false;
        Encoding = new String[]{"", "u-law", "A-law", "linear PCM"};
        JTabbedPane1 = new JTabbedPane();
        PlaybackPanel = new JPanel();
        MPBPanel = new JPanel();
        JLabel1 = new JLabel();
        JScrollPane1 = new JScrollPane();
        MPBMuteCheckbox = new JCheckBox();
        AppPBPanel = new JPanel();
        JLabel3 = new JLabel();
        JScrollPane3 = new JScrollPane();
        AppPBList = new JList();
        AppPBMuteCheckbox = new JCheckBox();
        RecordPanel = new JPanel();
        MRecPanel = new JPanel();
        JLabel2 = new JLabel();
        JScrollPane2 = new JScrollPane();
        JPanel3 = new JPanel();
        AppRecPanel = new JPanel();
        JLabel4 = new JLabel();
        JScrollPane4 = new JScrollPane();
        AppRecList = new JList();
        AppRecGainProgressBar = new JProgressBar();
        AudioControlMenubar = new JMenuBar();
        fileMenu = new JMenu();
        mixermodeItem = new JCheckBoxMenuItem();
        exitItem = new JMenuItem();
        viewMenu = new JMenu();
        appcontrolsItem = new JCheckBoxMenuItem();
        statusItem = new JMenuItem();
        helpMenu = new JMenu();
        helpItem = new JMenuItem();
        aboutItem = new JMenuItem();
        System.loadLibrary("AudioControl");
    }

    public AudioControl() {
        mixer_supported = AudioControl.jniInit(audio_device, Debug.getDebug());
        this.setTitle(AudioControl.localize("ProgramTitle"));
        this.setDefaultCloseOperation(2);
        Container contentPane = this.getContentPane();
        contentPane.setLayout(new BorderLayout());
        AudioControlMenubar.setFont(this.bold12);
        fileMenu.setFont(this.bold12);
        viewMenu.setFont(this.bold12);
        helpMenu.setFont(this.bold12);
        mixermodeItem.setFont(this.bold12);
        exitItem.setFont(this.bold12);
        appcontrolsItem.setFont(this.bold12);
        statusItem.setFont(this.bold12);
        helpItem.setFont(this.bold12);
        aboutItem.setFont(this.bold12);
        JTabbedPane1.setFont(this.bold12);
        JLabel1.setFont(this.bold12);
        JLabel2.setFont(this.bold12);
        JLabel3.setFont(this.bold12);
        JLabel4.setFont(this.bold12);
        MPBMuteCheckbox.setFont(this.bold12);
        AppPBMuteCheckbox.setFont(this.bold12);
        fileMenu.setText(AudioControl.localize("File"));
        fileMenu.setActionCommand("File");
        fileMenu.setMnemonic(AudioControl.localizeChar("FileMnemonic"));
        mixermodeItem.setText(AudioControl.localize("Mixermode"));
        mixermodeItem.setActionCommand("Mixer mode");
        mixermodeItem.setMnemonic(AudioControl.localizeChar("MixermodeMnemonic"));
        mixermodeItem.setOpaque(false);
        mixermodeItem.setState(true);
        mixermodeItem.setSelected(false);
        exitItem.setText(AudioControl.localize("Exit"));
        exitItem.setActionCommand("Exit");
        exitItem.setMnemonic(AudioControl.localizeChar("ExitMnemonic"));
        exitItem.setAccelerator(KeyStroke.getKeyStroke(115, 8));
        viewMenu.setText(AudioControl.localize("View"));
        viewMenu.setActionCommand("Edit");
        viewMenu.setMnemonic(AudioControl.localizeChar("ViewMnemonic"));
        appcontrolsItem.setText(AudioControl.localize("AppCtrls"));
        appcontrolsItem.setActionCommand("Mixer mode");
        appcontrolsItem.setMnemonic(AudioControl.localizeChar("AppCtrlsMnemonic"));
        appcontrolsItem.setAccelerator(KeyStroke.getKeyStroke(65, 2));
        appcontrolsItem.setOpaque(false);
        appcontrolsItem.setState(false);
        appcontrolsItem.setSelected(false);
        statusItem.setText(AudioControl.localize("Status"));
        statusItem.setActionCommand("Status...");
        statusItem.setMnemonic(AudioControl.localizeChar("StatusMnemonic"));
        statusItem.setAccelerator(KeyStroke.getKeyStroke(83, 2));
        helpMenu.setText(AudioControl.localize("Help"));
        helpMenu.setMnemonic(AudioControl.localizeChar("HelpMnemonic"));
        helpMenu.setHorizontalTextPosition(4);
        helpItem.setText(AudioControl.localize("HelpItem"));
        helpItem.setActionCommand("Help");
        helpItem.setMnemonic(AudioControl.localizeChar("HelpItemMnemonic"));
        aboutItem.setText(AudioControl.localize("About"));
        aboutItem.setActionCommand("AboutAudioControl");
        aboutItem.setMnemonic(AudioControl.localizeChar("AboutMnemonic"));
        fileMenu.add(mixermodeItem);
        fileMenu.add(new JSeparator());
        fileMenu.add(exitItem);
        viewMenu.add(appcontrolsItem);
        viewMenu.add(new JSeparator());
        viewMenu.add(statusItem);
        helpMenu.add(helpItem);
        helpMenu.add(new JSeparator());
        helpMenu.add(aboutItem);
        AudioControlMenubar.add(fileMenu);
        AudioControlMenubar.add(viewMenu);
        AudioControlMenubar.add(Box.createHorizontalGlue());
        AudioControlMenubar.add(helpMenu);
        this.setJMenuBar(AudioControlMenubar);
        String volumeLabel = AudioControl.localize("Volume");
        String gainLabel = AudioControl.localize("Gain");
        String monitorLabel = AudioControl.localize("Monitor");
        MPBVolSliderPanel = new AudioSliderPanel(volumeLabel, 0, 100, 25, 50);
        AppPBVolSliderPanel = new AudioSliderPanel(volumeLabel, 0, 100, 25, 50);
        MRecGainSliderPanel = new AudioSliderPanel(gainLabel, 0, 100, 25, 50);
        MRecMonitorSliderPanel = new AudioSliderPanel(monitorLabel, 0, 100, 25, 50);
        AppRecGainSliderPanel = new AudioSliderPanel(gainLabel, 0, 100, 25, 50);
        String balanceLabel = AudioControl.localize("Balance");
        MPBBalSliderPanel = new BalanceSliderPanel(balanceLabel, 0, 64, 32, 32);
        AppPBBalSliderPanel = new BalanceSliderPanel(balanceLabel, 0, 64, 32, 32);
        MRecBalSliderPanel = new BalanceSliderPanel(balanceLabel, 0, 64, 32, 32);
        AppRecBalSliderPanel = new BalanceSliderPanel(balanceLabel, 0, 64, 32, 32);
        PlaybackPanel.setLayout(new BoxLayout(PlaybackPanel, 0));
        if (AudioControl.supportsPlay()) {
            JTabbedPane1.addTab(AudioControl.localize("Playback"), PlaybackPanel);
        }
        PlaybackPanel.setBorder(BorderFactory.createEmptyBorder(5, 5, 5, 5));
        MPBPanel.setLayout(new BoxLayout(MPBPanel, 1));
        PlaybackPanel.add(MPBPanel);
        PlaybackPanel.add(Box.createHorizontalGlue());
        MPBPanel.setBorder(BorderFactory.createEmptyBorder(5, 5, 5, 5));
        MPBPanel.setBorder(BorderFactory.createCompoundBorder(BorderFactory.createEtchedBorder(), MPBPanel.getBorder()));
        JLabel1.setHorizontalTextPosition(0);
        JLabel1.setHorizontalAlignment(0);
        JLabel1.setText(AudioControl.localize("MPBPanelTitle"));
        JLabel1.setAlignmentX(0.5f);
        MPBPanel.add(JLabel1);
        JLabel1.setForeground(Color.black);
        JScrollPane1.setOpaque(true);
        JScrollPane1.setPreferredSize(this.listDim);
        JScrollPane1.setMaximumSize(JScrollPane1.getPreferredSize());
        MPBPanel.add(JScrollPane1);
        OutputList = new CheckList(AudioControl.buildCheckableItems((String[])AudioControl.getPortNames(1), AudioControl.getAvailPorts(1), AudioControl.getActivePorts(1), AudioControl.getModPorts(1)));
        JScrollPane1.getViewport().setView(OutputList);
        MPBPanel.add(Box.createRigidArea(new Dimension(0, 5)));
        MPBPanel.add(MPBVolSliderPanel);
        MPBPanel.add(Box.createRigidArea(new Dimension(0, 5)));
        MPBPanel.add(MPBBalSliderPanel);
        MPBVolSlider = MPBVolSliderPanel.getSlider();
        MPBVolCurrentValue = MPBVolSliderPanel.getValueLabel();
        MPBBalSlider = MPBBalSliderPanel.getSlider();
        MPBPanel.add(Box.createRigidArea(new Dimension(0, 5)));
        MPBMuteCheckbox.setHorizontalAlignment(0);
        MPBMuteCheckbox.setText(AudioControl.localize("Mute"));
        MPBMuteCheckbox.setActionCommand("Mute");
        MPBMuteCheckbox.setAlignmentX(0.5f);
        MPBPanel.add(MPBMuteCheckbox);
        Debug.setBorder(PlaybackPanel, Color.red);
        Debug.setBorder(MPBPanel, Color.red);
        Debug.setBorder(JLabel1, Color.blue);
        Debug.setBorder(JScrollPane1, Color.blue);
        Debug.setBorder(MPBMuteCheckbox, Color.blue);
        AppPBPanel.setLayout(new BoxLayout(AppPBPanel, 1));
        AppPBPanel.setBorder(BorderFactory.createEmptyBorder(5, 5, 5, 5));
        AppPBPanel.setBorder(BorderFactory.createCompoundBorder(BorderFactory.createEtchedBorder(), AppPBPanel.getBorder()));
        JLabel3.setHorizontalTextPosition(0);
        JLabel3.setHorizontalAlignment(0);
        JLabel3.setText(AudioControl.localize("AppPBPanelTitle"));
        JLabel3.setLabelFor(AppPBList);
        JLabel3.setAlignmentX(0.5f);
        AppPBPanel.add(JLabel3);
        JLabel3.setForeground(Color.black);
        JScrollPane3.setOpaque(true);
        JScrollPane3.setPreferredSize(this.listDim);
        JScrollPane3.setMaximumSize(JScrollPane3.getPreferredSize());
        AppPBPanel.add(JScrollPane3);
        JScrollPane3.getViewport().add(AppPBList);
        AppPBPanel.add(Box.createRigidArea(new Dimension(0, 5)));
        AppPBPanel.add(AppPBVolSliderPanel);
        AppPBPanel.add(Box.createRigidArea(new Dimension(0, 5)));
        AppPBPanel.add(AppPBBalSliderPanel);
        AppPBVolSlider = AppPBVolSliderPanel.getSlider();
        AppPBVolSlider.setEnabled(false);
        AppPBVolCurrentValue = AppPBVolSliderPanel.getValueLabel();
        AppPBVolCurrentValue.setEnabled(false);
        AppPBBalSlider = AppPBBalSliderPanel.getSlider();
        AppPBBalSlider.setEnabled(false);
        AppPBPanel.add(Box.createRigidArea(new Dimension(0, 5)));
        AppPBMuteCheckbox.setHorizontalAlignment(0);
        AppPBMuteCheckbox.setText(AudioControl.localize("Mute"));
        AppPBMuteCheckbox.setActionCommand("Mute");
        AppPBMuteCheckbox.setAlignmentX(0.5f);
        AppPBPanel.add(AppPBMuteCheckbox);
        AppPBMuteCheckbox.setEnabled(false);
        Debug.setBorder(AppPBPanel, Color.red);
        Debug.setBorder(JLabel3, Color.blue);
        Debug.setBorder(JScrollPane3, Color.blue);
        Debug.setBorder(AppPBMuteCheckbox, Color.blue);
        RecordPanel.setLayout(new BoxLayout(RecordPanel, 0));
        if (AudioControl.supportsRecord()) {
            JTabbedPane1.addTab(AudioControl.localize("Record"), RecordPanel);
        }
        RecordPanel.setBorder(BorderFactory.createEmptyBorder(5, 5, 5, 5));
        MRecPanel.setLayout(new BoxLayout(MRecPanel, 1));
        RecordPanel.add(MRecPanel);
        RecordPanel.add(Box.createHorizontalGlue());
        MRecPanel.setBorder(BorderFactory.createEmptyBorder(5, 5, 5, 5));
        MRecPanel.setBorder(BorderFactory.createCompoundBorder(BorderFactory.createEtchedBorder(), MRecPanel.getBorder()));
        RecordPanel.setVisible(false);
        JLabel2.setHorizontalTextPosition(0);
        JLabel2.setHorizontalAlignment(0);
        JLabel2.setText(AudioControl.localize("MRecPanelTitle"));
        JLabel2.setAlignmentX(0.5f);
        MRecPanel.add(JLabel2);
        JLabel2.setForeground(Color.black);
        JScrollPane2.setOpaque(true);
        JScrollPane2.setPreferredSize(this.listDim);
        JScrollPane2.setMaximumSize(JScrollPane2.getPreferredSize());
        MRecPanel.add(JScrollPane2);
        InputList = new RadioList(AudioControl.buildCheckableItems((String[])AudioControl.getPortNames(2), AudioControl.getAvailPorts(2), AudioControl.getActivePorts(2), AudioControl.getModPorts(2)));
        JScrollPane2.getViewport().add(InputList);
        MRecPanel.add(Box.createRigidArea(new Dimension(0, 5)));
        JPanel3.setLayout(new BoxLayout(JPanel3, 0));
        JPanel3.add(MRecGainSliderPanel);
        if (AudioControl.supportsPlay()) {
            JPanel3.add(MRecMonitorSliderPanel);
        }
        MRecPanel.add(JPanel3);
        MRecMonitorSlider = MRecMonitorSliderPanel.getSlider();
        MRecGainSlider = MRecGainSliderPanel.getSlider();
        MRecGainCurrentValue = MRecGainSliderPanel.getValueLabel();
        MRecMonitorCurrentValue = MRecMonitorSliderPanel.getValueLabel();
        MRecBalSlider = MRecBalSliderPanel.getSlider();
        MRecPanel.add(Box.createRigidArea(new Dimension(0, 5)));
        MRecPanel.add(MRecBalSliderPanel);
        MRecPanel.add(Box.createVerticalStrut(30));
        Debug.setBorder(RecordPanel, Color.red);
        Debug.setBorder(MRecPanel, Color.red);
        Debug.setBorder(JLabel2, Color.blue);
        Debug.setBorder(JScrollPane2, Color.blue);
        Debug.setBorder(JPanel3, Color.red);
        AppRecPanel.setLayout(new BoxLayout(AppRecPanel, 1));
        AppRecPanel.setBorder(BorderFactory.createEmptyBorder(5, 5, 5, 5));
        AppRecPanel.setBorder(BorderFactory.createCompoundBorder(BorderFactory.createEtchedBorder(), AppRecPanel.getBorder()));
        JLabel4.setHorizontalTextPosition(0);
        JLabel4.setHorizontalAlignment(0);
        JLabel4.setText(AudioControl.localize("AppRecPanelTitle"));
        JLabel4.setLabelFor(AppRecList);
        JLabel4.setAlignmentX(0.5f);
        AppRecPanel.add(JLabel4);
        JLabel4.setForeground(Color.black);
        JScrollPane4.setOpaque(true);
        JScrollPane4.setPreferredSize(this.listDim);
        JScrollPane4.setMaximumSize(JScrollPane4.getPreferredSize());
        AppRecPanel.add(JScrollPane4);
        JScrollPane4.getViewport().add(AppRecList);
        AppRecPanel.add(Box.createRigidArea(new Dimension(0, 5)));
        AppRecPanel.add(AppRecGainSliderPanel);
        AppRecGainSlider = AppRecGainSliderPanel.getSlider();
        AppRecGainSlider.setEnabled(false);
        AppRecGainCurrentValue = AppRecGainSliderPanel.getValueLabel();
        AppRecGainCurrentValue.setEnabled(false);
        AppRecBalSlider = AppRecBalSliderPanel.getSlider();
        AppRecBalSlider.setEnabled(false);
        AppRecPanel.add(Box.createRigidArea(new Dimension(0, 5)));
        AppRecPanel.add(AppRecBalSliderPanel);
        AppRecPanel.add(Box.createVerticalStrut(30));
        Debug.setBorder(AppRecPanel, Color.red);
        Debug.setBorder(JLabel4, Color.blue);
        Debug.setBorder(JScrollPane4, Color.blue);
        JTabbedPane1.setSelectedIndex(0);
        JTabbedPane1.setSelectedComponent(JTabbedPane1.getComponentAt(0));
        contentPane.add((Component)JTabbedPane1, "Center");
        loader = GeneralClassLoader.ourLoader;
        try {
            loader.loadClass("javax.help.HelpSet");
        }
        catch (ClassNotFoundException classNotFoundException) {
            this.noHelpJar = true;
            System.err.println("sdtaudiocontrol: " + AudioControl.localize("jarfiles"));
        }
        if (!this.noHelpJar) {
            this.helpBroker = AudioControlHelp.getHelpBroker();
            if (this.helpBroker != null) {
                this.helpBrokerListener = new CSH.DisplayHelpFromSource(this.helpBroker);
            }
        }
        CheckBoxMenuListener cbmChange = new CheckBoxMenuListener();
        mixermodeItem.addItemListener(cbmChange);
        appcontrolsItem.addItemListener(cbmChange);
        CheckBoxListener cbChange = new CheckBoxListener();
        MPBMuteCheckbox.addItemListener(cbChange);
        AppPBMuteCheckbox.addItemListener(cbChange);
        this.addWindowListener(new SymWindow());
        SymAction lSymAction = new SymAction();
        exitItem.addActionListener(lSymAction);
        statusItem.addActionListener(lSymAction);
        aboutItem.addActionListener(lSymAction);
        if (this.helpBroker != null) {
            helpItem.addActionListener(this.helpBrokerListener);
        }
        SliderSymChange lSymChange = new SliderSymChange();
        MPBVolSlider.addChangeListener(lSymChange);
        MPBBalSlider.addChangeListener(lSymChange);
        MRecMonitorSlider.addChangeListener(lSymChange);
        MRecGainSlider.addChangeListener(lSymChange);
        MRecBalSlider.addChangeListener(lSymChange);
        AppPBVolSlider.addChangeListener(lSymChange);
        AppPBBalSlider.addChangeListener(lSymChange);
        AppRecGainSlider.addChangeListener(lSymChange);
        AppRecBalSlider.addChangeListener(lSymChange);
        AppListSelListener alsvChanged = new AppListSelListener();
        AppPBList.addListSelectionListener(alsvChanged);
        AppRecList.addListSelectionListener(alsvChanged);
        OutputListSelListener olsvChanged = new OutputListSelListener();
        OutputList.addListSelectionListener(olsvChanged);
        InputListSelListener ilsvChanged = new InputListSelListener();
        InputList.addListSelectionListener(ilsvChanged);
        AppRecList.addListSelectionListener(alsvChanged);
        if (mixer_supported) {
            currMixerMode = AudioControl.getMixerMode();
            mixermodeItem.setSelected(currMixerMode);
            AppPBVolCurrentValue.setText(String.valueOf(AppPBVolSlider.getValue()));
            AppRecGainCurrentValue.setText(String.valueOf(AppRecGainSlider.getValue()));
            if (currMixerMode) {
                AudioControl.updateChannelList();
            } else {
                AppPBList.setListData(EMPTYSET);
                AppRecList.setListData(EMPTYSET);
            }
        } else {
            mixermodeItem.setEnabled(false);
            appcontrolsItem.setEnabled(false);
        }
        AudioControl.MPBVolSlider.ignoreChange = false;
        AudioControl.play_volume_cb(AudioControl.getPlayVol());
        MPBVolCurrentValue.setText(String.valueOf(MPBVolSlider.getValue()));
        AudioControl.MPBBalSlider.ignoreChange = false;
        AudioControl.play_balance_cb(AudioControl.getPlayBal());
        StringBuffer status = new StringBuffer(0);
        MPBMuteCheckbox.setSelected(AudioControl.getPlayMuted(status));
        if (status.length() != 0) {
            JOptionPane.showMessageDialog(this, String.valueOf(AudioControl.localize("Error getting device status.")) + newline + AudioControl.localize("Error") + status, AudioControl.localize("Error"), 2);
        }
        AudioControl.MRecGainSlider.ignoreChange = false;
        AudioControl.record_gain_cb(AudioControl.getRecGain());
        MRecGainCurrentValue.setText(String.valueOf(MRecGainSlider.getValue()));
        AudioControl.MRecBalSlider.ignoreChange = false;
        AudioControl.record_balance_cb(AudioControl.getRecBal());
        AudioControl.MRecMonitorSlider.ignoreChange = false;
        AudioControl.monitor_gain_cb(AudioControl.getMonGain());
        MRecMonitorCurrentValue.setText(String.valueOf(MRecMonitorSlider.getValue()));
    }

    void AppPBBalSlider_stateChanged(ChangeEvent event, int newval) {
        AudioControl.setChannelValue(currSelectedChan, newval, 16);
    }

    void AppPBMuteItem_itemStateChanged(ItemEvent event) {
        AudioControl.setChannelMuted(currSelectedChan, AppPBMuteCheckbox.isSelected());
    }

    void AppPBVolSlider_stateChanged(ChangeEvent event, int newval) {
        AudioControl.setChannelValue(currSelectedChan, newval, 1);
    }

    void AppRecBalSlider_stateChanged(ChangeEvent event, int newval) {
        AudioControl.setChannelValue(currSelectedChan, newval, 32);
    }

    void AppRecGainSlider_stateChanged(ChangeEvent event, int newval) {
        AudioControl.setChannelValue(currSelectedChan, newval, 2);
    }

    void AudioControl_windowClosing(WindowEvent event) {
        try {
            this.exitApplication(0);
        }
        catch (Exception exception) {}
    }

    void MPBBalSlider_stateChanged(ChangeEvent event, int newval) {
        AudioControl.setPlayBal(newval);
    }

    void MPBMuteItem_itemStateChanged(ItemEvent event) {
        AudioControl.setPlayMuted(MPBMuteCheckbox.isSelected());
    }

    void MPBVolSlider_stateChanged(ChangeEvent event, int newval) {
        AudioControl.setPlayVol(newval);
    }

    void MRecBalSlider_stateChanged(ChangeEvent event, int newval) {
        AudioControl.setRecBal(newval);
    }

    void MRecGainSlider_stateChanged(ChangeEvent event, int newval) {
        AudioControl.setRecGain(newval);
    }

    void MRecMonitorSlider_stateChanged(ChangeEvent event, int newval) {
        AudioControl.setMonGain(newval);
    }

    void aboutItem_actionPerformed(ActionEvent event) {
        JOptionPane.showMessageDialog(this, AudioControl.localize("AboutMsg"));
    }

    void appcontrolsItem_itemStateChanged(ItemEvent event, JComponent item) {
        if (!mixer_supported) {
            return;
        }
        if (appcontrolsItem.isSelected()) {
            PlaybackPanel.add(AppPBPanel);
            RecordPanel.add(AppRecPanel);
        } else {
            PlaybackPanel.remove(AppPBPanel);
            RecordPanel.remove(AppRecPanel);
        }
        JComponent pobj = item;
        JComponent parent = item;
        while (pobj != null) {
            parent = pobj;
            pobj = (JComponent)parent.getParent();
        }
        JMenu menu = (JMenu)((JPopupMenu)parent).getInvoker();
        JFrame top = (JFrame)menu.getTopLevelAncestor();
        top.pack();
    }

    private static CheckableItem[] buildCheckableItems(String[] strs, int avail, int active, int mod) {
        int count = 0;
        int n = strs.length;
        CheckableItem[] items = new CheckableItem[n];
        int i = 0;
        while (i < 32) {
            boolean enabled;
            boolean available = (avail & 1) != 0;
            boolean selected = (active & 1) != 0;
            boolean bl = enabled = (mod & 1) != 0;
            if (available) {
                items[count] = new CheckableItem(AudioControl.localize(strs[count]), selected, enabled, i);
                ++count;
            }
            avail >>= 1;
            active >>= 1;
            mod >>= 1;
            ++i;
        }
        return items;
    }

    public static void chan_list_cb(int newValue) {
        AudioControl.updateChannelList();
        AudioControl.updateStatusChannelList();
    }

    public static void chan_muted_cb(int chan, boolean newValue) {
        if (chan == currSelectedChan && newValue != AppPBMuteCheckbox.isSelected()) {
            AppPBMuteCheckbox.setSelected(newValue);
        }
    }

    public static void chan_slider_cb(int chan, int newValue, int mode) {
        AudioSlider slider;
        switch (mode) {
            case 1: {
                slider = AppPBVolSlider;
                break;
            }
            case 2: {
                slider = AppRecGainSlider;
                break;
            }
            case 16: {
                slider = AppPBBalSlider;
                break;
            }
            case 32: {
                slider = AppRecBalSlider;
                break;
            }
            default: {
                return;
            }
        }
        if (chan == currSelectedChan && newValue != slider.getValue()) {
            slider.ignoreChange = true;
            slider.setValue(newValue);
        }
    }

    void exitApplication(int exitStatus) {
        ((Component)this).setVisible(false);
        this.dispose();
        System.exit(exitStatus);
    }

    void exitItem_actionPerformed(ActionEvent event) {
        try {
            this.exitApplication(0);
        }
        catch (Exception exception) {}
    }

    public static native int getActivePorts(int var0);

    public static native int getAvailPorts(int var0);

    public static native Object[] getChanList(int var0, StringBuffer var1);

    public static native boolean getChannelMuted(int var0, StringBuffer var1);

    public static native int getChannelValue(int var0, int var1);

    private static synchronized void getLocaleBundle() {
        block2: {
            Locale currentLocale = Locale.getDefault();
            if (bundle != null) break block2;
            try {
                bundle = ResourceBundle.getBundle("com.sun.audiocontrol.locale.AudioControlMsgs", currentLocale);
            }
            catch (MissingResourceException missingResourceException) {
                System.err.println("sdtaudiocontrol: Localization data unavailable");
                System.exit(1);
            }
        }
    }

    public static native boolean getMixerMode();

    public static native int getModPorts(int var0);

    public static native int getMonGain();

    public static native int getPlayBal();

    public static native boolean getPlayMuted(StringBuffer var0);

    public static native int getPlayVol();

    public static native Object[] getPortNames(int var0);

    public static native int getRecBal();

    public static native int getRecGain();

    public static native float[] getStatusInfo(int var0, StringBuffer var1);

    public static native boolean jniInit(String var0, boolean var1);

    public static native void jniLoop();

    public static String localize(String key) {
        String value = null;
        AudioControl.getLocaleBundle();
        try {
            value = (String)bundle.getObject(key);
        }
        catch (MissingResourceException missingResourceException) {
            value = key;
        }
        return value;
    }

    public static int localizeChar(String key) {
        int value = 0;
        AudioControl.getLocaleBundle();
        try {
            value = (Integer)bundle.getObject(key);
        }
        catch (MissingResourceException missingResourceException) {
            value = 0;
        }
        return value;
    }

    public static Object localizeObject(String key) {
        Object value = null;
        AudioControl.getLocaleBundle();
        try {
            value = bundle.getObject(key);
        }
        catch (MissingResourceException missingResourceException) {
            value = null;
        }
        return value;
    }

    public static void main(String[] args) {
        try {
            String cmd_str = new String("/usr/dt/bin/sdtaudiocontrol");
            audio_device = new String("/dev/audio");
            int i = 0;
            while (i < args.length) {
                if (args[i].equals("-d")) {
                    audio_device = new String(args[++i]);
                } else if (args[i].equals("-ac")) {
                    appctrls = true;
                } else if (args[i].equals("-debug")) {
                    Debug.setDebug();
                } else if (args[i].equals("-dGUI")) {
                    Debug.setDebugGUI();
                } else {
                    System.err.println("sdtaudiocontrol: " + AudioControl.localize("Invalid argument") + " " + args[i] + " - " + AudioControl.localize("ignored") + ".");
                }
                ++i;
            }
            theAudioControl = new AudioControl();
            theAudioControl.setResizable(false);
            theAudioControl.pack();
            ((Component)theAudioControl).setVisible(true);
            ((Frame)theAudioControl).setIconImage(APPICON);
            Xsession.WMcommand((Frame)theAudioControl, (String)cmd_str);
            if (mixer_supported && appctrls) {
                appcontrolsItem.setState(appctrls);
            }
            AudioControl.jniLoop();
        }
        catch (Exception e) {
            Debug.println("General Exception found");
            System.err.println("sdtaudiocontrol: Exception encountered, printing stacktrace");
            e.printStackTrace();
            System.exit(1);
        }
    }

    public static String[] makeStatusChanList(String[] chList) {
        String[] newChList;
        if (chList != null) {
            newChList = new String[chList.length + 1];
            newChList[0] = AudioControl.localize(MASTER_CHANNEL_STR);
            System.arraycopy(chList, 0, newChList, 1, chList.length);
        } else {
            newChList = new String[]{AudioControl.localize(MASTER_CHANNEL_STR)};
        }
        return newChList;
    }

    public static void mixer_enabled_cb(boolean newValue) {
        if (newValue != currMixerMode) {
            mixermodeIgnoreChange = true;
            mixermodeItem.setSelected(newValue);
            currMixerMode = newValue;
        }
        if (!currMixerMode) {
            AudioControl.setEnableAppPBSliders(false);
            AudioControl.setEnableAppRecSliders(false);
        }
        if (currMixerMode) {
            AudioControl.updateChannelList();
        } else {
            AppPBList.setListData(EMPTYSET);
            AppRecList.setListData(EMPTYSET);
        }
        AudioControl.updateStatusChannelList();
    }

    void mixermodeItem_itemStateChanged(ItemEvent event) {
        if (!mixer_supported) {
            return;
        }
        boolean mixermode = mixermodeItem.isSelected();
        String status = AudioControl.setMixerMode(mixermode);
        if (!status.equals("SUCCESS")) {
            JOptionPane.showMessageDialog(this, "Error setting audio mixer mode: " + status, "Error", 2);
            mixermodeItem.setSelected(mixermode ^ true);
            currMixerMode = mixermode ^ true;
        } else if (appcontrolsItem.isSelected()) {
            if (mixermode) {
                AudioControl.updateChannelList();
            } else {
                AppPBList.setListData(EMPTYSET);
                AppRecList.setListData(EMPTYSET);
            }
        }
        currMixerMode = mixermode;
        AudioControl.updateStatusChannelList();
    }

    public static void monitor_gain_cb(int newValue) {
        if (newValue != -1 && newValue != MRecMonitorSlider.getValue()) {
            AudioControl.MRecMonitorSlider.ignoreChange = true;
            MRecMonitorSlider.setValue(newValue);
        }
    }

    public static void play_balance_cb(int newValue) {
        if (newValue != -1 && newValue != MPBBalSlider.getValue()) {
            AudioControl.MPBBalSlider.ignoreChange = true;
            MPBBalSlider.setValue(newValue);
        }
    }

    public static void play_muted_cb(boolean newValue) {
        if (newValue != currPBMuted) {
            MPBMuteIgnoreChange = true;
            MPBMuteCheckbox.setSelected(newValue);
            currPBMuted = newValue;
        }
    }

    public static void play_ports_cb(int newValue) {
        OutputList.setListData(AudioControl.buildCheckableItems((String[])AudioControl.getPortNames(1), AudioControl.getAvailPorts(1), AudioControl.getActivePorts(1), AudioControl.getModPorts(1)));
    }

    public static void play_volume_cb(int newValue) {
        if (newValue != -1 && newValue != MPBVolSlider.getValue()) {
            AudioControl.MPBVolSlider.ignoreChange = true;
            MPBVolSlider.setValue(newValue);
        }
    }

    public static void record_balance_cb(int newValue) {
        if (newValue != -1 && newValue != MRecBalSlider.getValue()) {
            AudioControl.MRecBalSlider.ignoreChange = true;
            MRecBalSlider.setValue(newValue);
        }
    }

    public static void record_gain_cb(int newValue) {
        if (newValue != -1 && newValue != MRecGainSlider.getValue()) {
            AudioControl.MRecGainSlider.ignoreChange = true;
            MRecGainSlider.setValue(newValue);
        }
    }

    public static void record_ports_cb(int newValue) {
        InputList.setListData(AudioControl.buildCheckableItems((String[])AudioControl.getPortNames(2), AudioControl.getAvailPorts(2), AudioControl.getActivePorts(2), AudioControl.getModPorts(2)));
    }

    public static native void setActivePorts(int var0, int var1, boolean var2);

    public static native void setChannelMuted(int var0, boolean var1);

    public static native void setChannelValue(int var0, int var1, int var2);

    static void setEnableAppPBSliders(boolean state) {
        AppPBVolSlider.setEnabled(state);
        AppPBBalSlider.setEnabled(state);
        AppPBVolCurrentValue.setEnabled(state);
        AppPBMuteCheckbox.setEnabled(state);
    }

    static void setEnableAppRecSliders(boolean state) {
        AppRecGainSlider.setEnabled(state);
        AppRecBalSlider.setEnabled(state);
        AppRecGainCurrentValue.setEnabled(state);
    }

    public static native String setMixerMode(boolean var0);

    public static native void setMonGain(int var0);

    public static native void setPlayBal(int var0);

    public static native void setPlayMuted(boolean var0);

    public static native void setPlayVol(int var0);

    public static native void setRecBal(int var0);

    public static native void setRecGain(int var0);

    void statusItem_actionPerformed(ActionEvent event) {
        if (theAudioStatus == null) {
            theAudioStatus = new AudioStatus();
            theAudioStatus.setResizable(false);
            theAudioStatus.pack();
        }
        ((Component)theAudioStatus).setVisible(true);
        theAudioStatus.ContinuousUpdateIfNeeded();
    }

    public static native boolean supportsPlay();

    public static native boolean supportsRecord();

    void updateChannelGUI(JList list, int chan) {
        if (list.equals(AppPBList)) {
            if (chan == -1) {
                AudioControl.setEnableAppPBSliders(false);
            } else {
                AudioControl.setEnableAppPBSliders(true);
                AudioControl.AppPBVolSlider.ignoreChange = true;
                AppPBVolSlider.setValue(AudioControl.getChannelValue(chan, 1));
                AudioControl.AppPBBalSlider.ignoreChange = true;
                AppPBBalSlider.setValue(AudioControl.getChannelValue(chan, 16));
                StringBuffer status = new StringBuffer(0);
                AppPBMuteCheckbox.setSelected(AudioControl.getChannelMuted(chan, status));
                if (status.length() != 0) {
                    JOptionPane.showMessageDialog(this, String.valueOf(AudioControl.localize("Error getting device status.")) + newline + AudioControl.localize("Error") + status, AudioControl.localize("Error"), 2);
                }
            }
        } else if (list.equals(AppRecList)) {
            if (chan == -1) {
                AudioControl.setEnableAppRecSliders(false);
            } else {
                AudioControl.setEnableAppRecSliders(true);
                AudioControl.AppRecGainSlider.ignoreChange = true;
                AppRecGainSlider.setValue(AudioControl.getChannelValue(chan, 2));
                AudioControl.AppRecBalSlider.ignoreChange = true;
                AppRecBalSlider.setValue(AudioControl.getChannelValue(chan, 32));
            }
        }
    }

    public static void updateChannelList() {
        StringBuffer dummy = new StringBuffer(0);
        String[] chPBList = (String[])AudioControl.getChanList(1, dummy);
        String[] chRecList = (String[])AudioControl.getChanList(2, dummy);
        AppPBList.setListData(chPBList);
        AppRecList.setListData(chRecList);
        if (chPBList.length >= 1) {
            AppPBList.setSelectedIndex(chPBList.length - 1);
        } else {
            AppPBList.clearSelection();
        }
        if (chRecList.length >= 1) {
            AppRecList.setSelectedIndex(chRecList.length - 1);
        } else {
            AppRecList.clearSelection();
        }
    }

    public static void updateStatusChannelList() {
        if (theAudioStatus == null) {
            return;
        }
        StringBuffer dummy = new StringBuffer(0);
        String[] chList = AudioControl.makeStatusChanList((String[])AudioControl.getChanList(3, dummy));
        AudioControl.theAudioStatus.ChannelList.setListData(chList);
        if (chList.length >= 1) {
            AudioControl.theAudioStatus.ChannelList.setSelectedIndex(chList.length - 1);
        }
    }

    public static void update_status_cb() {
        theAudioStatus.updateNow();
    }

    class SymWindow
    extends WindowAdapter {
        SymWindow() {
        }

        public void windowClosing(WindowEvent event) {
            Object object = event.getSource();
            if (object == AudioControl.this) {
                AudioControl.this.AudioControl_windowClosing(event);
            }
        }
    }

    class SymAction
    implements ActionListener {
        SymAction() {
        }

        public void actionPerformed(ActionEvent event) {
            Object object = event.getSource();
            if (object == exitItem) {
                AudioControl.this.exitItem_actionPerformed(event);
            } else if (object == statusItem) {
                AudioControl.this.statusItem_actionPerformed(event);
            } else if (object == aboutItem) {
                AudioControl.this.aboutItem_actionPerformed(event);
            }
        }
    }

    class OutputListSelListener
    implements ListSelectionListener {
        OutputListSelListener() {
        }

        public void valueChanged(ListSelectionEvent e) {
            if (e.getValueIsAdjusting()) {
                return;
            }
            JList list = (JList)e.getSource();
            if (!list.isSelectionEmpty()) {
                CheckableItem c = (CheckableItem)list.getSelectedValue();
                AudioControl.setActivePorts(1, c.getItemID(), c.isSelected() ^ true);
            }
            list.clearSelection();
        }
    }

    class InputListSelListener
    implements ListSelectionListener {
        InputListSelListener() {
        }

        public void valueChanged(ListSelectionEvent e) {
            if (e.getValueIsAdjusting()) {
                return;
            }
            JList list = (JList)e.getSource();
            if (!list.isSelectionEmpty()) {
                CheckableItem c = (CheckableItem)list.getSelectedValue();
                AudioControl.setActivePorts(2, c.getItemID(), c.isSelected() ^ true);
            }
            list.clearSelection();
        }
    }

    class AppListSelListener
    implements ListSelectionListener {
        AppListSelListener() {
        }

        public void valueChanged(ListSelectionEvent event) {
            if (event.getValueIsAdjusting()) {
                return;
            }
            String selItem = "EMPTY";
            JList list = (JList)event.getSource();
            if (!list.isSelectionEmpty()) {
                selItem = (String)list.getSelectedValue();
                if (selItem != null && !selItem.equals("EMPTY")) {
                    int wsindex = selItem.indexOf(" ", 3);
                    String substr = selItem.substring(3, wsindex);
                    currSelectedChan = Integer.parseInt(substr);
                } else {
                    currSelectedChan = -1;
                }
            } else {
                currSelectedChan = -1;
            }
            AudioControl.this.updateChannelGUI(list, currSelectedChan);
        }
    }

    class CheckBoxListener
    implements ItemListener {
        CheckBoxListener() {
        }

        public void itemStateChanged(ItemEvent event) {
            JCheckBox item = (JCheckBox)event.getSource();
            if (item == MPBMuteCheckbox) {
                if (!MPBMuteIgnoreChange) {
                    AudioControl.this.MPBMuteItem_itemStateChanged(event);
                } else {
                    MPBMuteIgnoreChange = false;
                }
            } else if (item == AppPBMuteCheckbox) {
                AudioControl.this.AppPBMuteItem_itemStateChanged(event);
            }
        }
    }

    class CheckBoxMenuListener
    implements ItemListener {
        CheckBoxMenuListener() {
        }

        public void itemStateChanged(ItemEvent event) {
            JCheckBoxMenuItem item = (JCheckBoxMenuItem)event.getSource();
            if (item == mixermodeItem) {
                if (!mixermodeIgnoreChange) {
                    AudioControl.this.mixermodeItem_itemStateChanged(event);
                } else {
                    mixermodeIgnoreChange = false;
                }
            } else if (item == appcontrolsItem) {
                AudioControl.this.appcontrolsItem_itemStateChanged(event, item);
            }
        }
    }

    class SliderSymChange
    implements ChangeListener {
        SliderSymChange() {
        }

        public void stateChanged(ChangeEvent event) {
            AudioSlider slider = (AudioSlider)event.getSource();
            int newval = slider.getValue();
            if (slider.getValueLabel() != null) {
                try {
                    slider.getValueLabel().setText(String.valueOf(newval));
                }
                catch (Exception exception) {}
            }
            if (!slider.ignoreChange) {
                if (slider == MPBVolSlider) {
                    AudioControl.this.MPBVolSlider_stateChanged(event, newval);
                } else if (slider == MPBBalSlider) {
                    AudioControl.this.MPBBalSlider_stateChanged(event, newval);
                } else if (slider == MRecMonitorSlider) {
                    AudioControl.this.MRecMonitorSlider_stateChanged(event, newval);
                } else if (slider == MRecGainSlider) {
                    AudioControl.this.MRecGainSlider_stateChanged(event, newval);
                } else if (slider == MRecBalSlider) {
                    AudioControl.this.MRecBalSlider_stateChanged(event, newval);
                } else if (slider == AppPBVolSlider) {
                    AudioControl.this.AppPBVolSlider_stateChanged(event, newval);
                } else if (slider == AppPBBalSlider) {
                    AudioControl.this.AppPBBalSlider_stateChanged(event, newval);
                } else if (slider == AppRecGainSlider) {
                    AudioControl.this.AppRecGainSlider_stateChanged(event, newval);
                } else if (slider == AppRecBalSlider) {
                    AudioControl.this.AppRecBalSlider_stateChanged(event, newval);
                }
            } else {
                slider.ignoreChange = false;
            }
        }
    }

    class AudioStatus
    extends JFrame {
        Dimension listDim = new Dimension(175, 55);
        JPanel StatusPanel = new JPanel();
        JPanel TopPanel = new JPanel();
        JList ChannelList = new JList();
        JScrollPane ChannelScrollList = new JScrollPane();
        JPanel UpdatePanel = new JPanel();
        JCheckBox ContinuousCheckBox = new JCheckBox(AudioControl.localize("ContUpdateCBTitle"));
        JButton UpdateNowButton = new JButton(AudioControl.localize("UpdateNowTitle"));
        JPanel MiddlePanel = new JPanel();
        JPanel PBPanel = new JPanel();
        JPanel PBPanelTop = new JPanel();
        JPanel PBPanelBot = new JPanel();
        JPanel PBPanelBotL = new JPanel();
        JPanel PBPanelBotR = new JPanel();
        JPanel RecPanel = new JPanel();
        JPanel RecPanelTop = new JPanel();
        JPanel RecPanelBot = new JPanel();
        JPanel RecPanelBotL = new JPanel();
        JPanel RecPanelBotR = new JPanel();
        JPanel ButtonPanel = new JPanel();
        JButton CloseButton = new JButton(AudioControl.localize("Close"));
        JButton HelpButton = new JButton(AudioControl.localize("Help"));
        String openLabel = AudioControl.localize("Open");
        String pauseLabel = AudioControl.localize("Paused");
        String activeLabel = AudioControl.localize("Active");
        String underflowLabel = AudioControl.localize("Underflow");
        String owLabel = AudioControl.localize("Open-Waiting");
        AudioLED PBOpenCheck = new AudioLED(this.openLabel);
        AudioLED PBPausedCheck = new AudioLED(this.pauseLabel);
        AudioLED PBActiveCheck = new AudioLED(this.activeLabel);
        AudioLED PBUnderflowCheck = new AudioLED(this.underflowLabel);
        AudioLED PBWaitingCheck = new AudioLED(this.owLabel);
        AudioLED RecOpenCheck = new AudioLED(this.openLabel);
        AudioLED RecPausedCheck = new AudioLED(this.pauseLabel);
        AudioLED RecActiveCheck = new AudioLED(this.activeLabel);
        AudioLED RecUnderflowCheck = new AudioLED(this.underflowLabel);
        AudioLED RecWaitingCheck = new AudioLED(this.owLabel);
        String eofLabel = String.valueOf(AudioControl.localize("EOF Count")) + ": ";
        String sampleLabel = String.valueOf(AudioControl.localize("Samples")) + ": ";
        String granLabel = String.valueOf(AudioControl.localize("Granularity")) + ": ";
        String delayLabel = String.valueOf(AudioControl.localize("Input Delay")) + ": ";
        String encodeLabel = String.valueOf(AudioControl.localize("Encoding")) + ": ";
        String rateLabel = String.valueOf(AudioControl.localize("Sample rate")) + ": ";
        String chanLabel = String.valueOf(AudioControl.localize("Channels")) + ": ";
        JLabel PBEofCount = new JLabel(this.eofLabel);
        JLabel PBEofCountVal = new JLabel("0");
        JLabel PBSamples = new JLabel(this.sampleLabel);
        JLabel PBSamplesVal = new JLabel("0");
        JLabel PBGranularity = new JLabel(this.granLabel);
        JLabel PBGranularityVal = new JLabel("0.000 secs");
        JLabel PBEncoding = new JLabel(this.encodeLabel);
        JLabel PBEncodingVal = new JLabel("unknown");
        JLabel PBSampleRate = new JLabel(this.rateLabel);
        JLabel PBSampleRateVal = new JLabel("unknown");
        JLabel PBChannels = new JLabel(this.chanLabel);
        JLabel PBChannelsVal = new JLabel("unknown");
        JLabel RecDummy = new JLabel(" ");
        JLabel RecDummyVal = new JLabel(" ");
        JLabel RecSamples = new JLabel(this.sampleLabel);
        JLabel RecSamplesVal = new JLabel("0");
        JLabel RecInputDelay = new JLabel(this.delayLabel);
        JLabel RecInputDelayVal = new JLabel("0.000 secs");
        JLabel RecEncoding = new JLabel(this.encodeLabel);
        JLabel RecEncodingVal = new JLabel("unknown");
        JLabel RecSampleRate = new JLabel(this.rateLabel);
        JLabel RecSampleRateVal = new JLabel("unknown");
        JLabel RecChannels = new JLabel(this.chanLabel);
        JLabel RecChannelsVal = new JLabel("unknown");
        String PBPrecisionVal;
        String RecPrecisionVal;
        JLabel PlaybackTitle = new JLabel(AudioControl.localize("Playback"));
        JLabel RecordTitle = new JLabel(AudioControl.localize("Record"));
        float[] currStatusArray = new float[]{-1.0f, -1.0f, -1.0f, -1.0f, -1.0f, -1.0f, -1.0f, -1.0f, -1.0f, -1.0f, -1.0f, -1.0f, -1.0f, -1.0f, -1.0f, -1.0f, -1.0f, -1.0f, -1.0f, -1.0f, -1.0f, -1.0f, -1.0f, -1.0f};
        int statusCurrSelChan = -1;
        private volatile ContinuousMonitorThread cmThread = null;

        public AudioStatus() {
            Container ContentPane = this.getContentPane();
            ContentPane.add(this.StatusPanel);
            this.setTitle(AudioControl.localize("AudioStatusTitle"));
            this.setDefaultCloseOperation(1);
            this.StatusPanel.setLayout(new BorderLayout());
            this.TopPanel.setLayout(new BoxLayout(this.TopPanel, 0));
            this.UpdatePanel.setLayout(new BoxLayout(this.UpdatePanel, 1));
            this.MiddlePanel.setLayout(new BoxLayout(this.MiddlePanel, 0));
            this.PBPanel.setLayout(new BoxLayout(this.PBPanel, 1));
            this.PBPanelTop.setLayout(new BoxLayout(this.PBPanelTop, 1));
            this.PBPanelBotL.setLayout(new BoxLayout(this.PBPanelBotL, 1));
            this.PBPanelBotR.setLayout(new BoxLayout(this.PBPanelBotR, 1));
            this.RecPanel.setLayout(new BoxLayout(this.RecPanel, 1));
            this.RecPanelTop.setLayout(new BoxLayout(this.RecPanelTop, 1));
            this.RecPanelBotL.setLayout(new BoxLayout(this.RecPanelBotL, 1));
            this.RecPanelBotR.setLayout(new BoxLayout(this.RecPanelBotR, 1));
            this.ButtonPanel.setLayout(new BoxLayout(this.ButtonPanel, 0));
            CheckBoxListener nullListener = new CheckBoxListener();
            this.PBOpenCheck.addItemListener(nullListener);
            this.PBPanelTop.add(this.PBOpenCheck);
            this.PBPausedCheck.addItemListener(nullListener);
            this.PBPanelTop.add(this.PBPausedCheck);
            this.PBActiveCheck.addItemListener(nullListener);
            this.PBPanelTop.add(this.PBActiveCheck);
            this.PBUnderflowCheck.addItemListener(nullListener);
            this.PBPanelTop.add(this.PBUnderflowCheck);
            this.PBWaitingCheck.addItemListener(nullListener);
            this.PBPanelTop.add(this.PBWaitingCheck);
            this.RecOpenCheck.addItemListener(nullListener);
            this.RecPanelTop.add(this.RecOpenCheck);
            this.RecPausedCheck.addItemListener(nullListener);
            this.RecPanelTop.add(this.RecPausedCheck);
            this.RecActiveCheck.addItemListener(nullListener);
            this.RecPanelTop.add(this.RecActiveCheck);
            this.RecUnderflowCheck.addItemListener(nullListener);
            this.RecPanelTop.add(this.RecUnderflowCheck);
            this.RecWaitingCheck.addItemListener(nullListener);
            this.RecPanelTop.add(this.RecWaitingCheck);
            this.PBPanelTop.setAlignmentX(0.5f);
            this.PBPanelBot.setAlignmentX(0.5f);
            this.RecPanelTop.setAlignmentX(0.5f);
            this.RecPanelBot.setAlignmentX(0.5f);
            this.PlaybackTitle.setAlignmentX(0.5f);
            this.PlaybackTitle.setForeground(Color.black);
            this.RecordTitle.setAlignmentX(0.5f);
            this.RecordTitle.setForeground(Color.black);
            this.PBEofCount.setAlignmentX(1.0f);
            this.PBEofCount.setForeground(Color.black);
            this.PBPanelBotL.add(this.PBEofCount);
            this.PBPanelBotR.add(this.PBEofCountVal);
            this.PBSamples.setAlignmentX(1.0f);
            this.PBSamples.setForeground(Color.black);
            this.PBPanelBotL.add(this.PBSamples);
            this.PBPanelBotR.add(this.PBSamplesVal);
            this.PBGranularity.setAlignmentX(1.0f);
            this.PBGranularity.setForeground(Color.black);
            this.PBPanelBotL.add(this.PBGranularity);
            this.PBPanelBotR.add(this.PBGranularityVal);
            FontMetrics fm = this.getFontMetrics(this.PBEncoding.getFont());
            int sw = fm.stringWidth("MMMMMMMMMMMM");
            int fh = fm.getHeight();
            Insets insets = this.PBEncodingVal.getInsets();
            Dimension encodingSize = new Dimension(insets.left + sw + insets.right, insets.top + fh + insets.bottom);
            this.fixedSize(this.PBEncodingVal, encodingSize);
            this.fixedSize(this.RecEncodingVal, encodingSize);
            this.PBEncoding.setAlignmentX(1.0f);
            this.PBEncoding.setForeground(Color.black);
            this.PBPanelBotL.add(this.PBEncoding);
            this.PBPanelBotR.add(this.PBEncodingVal);
            this.PBSampleRate.setAlignmentX(1.0f);
            this.PBSampleRate.setForeground(Color.black);
            this.PBPanelBotL.add(this.PBSampleRate);
            this.PBPanelBotR.add(this.PBSampleRateVal);
            this.PBChannels.setAlignmentX(1.0f);
            this.PBChannels.setForeground(Color.black);
            this.PBPanelBotL.add(this.PBChannels);
            this.PBPanelBotR.add(this.PBChannelsVal);
            this.RecPanelBotL.add(Box.createVerticalGlue());
            this.RecPanelBotR.add(Box.createVerticalGlue());
            this.RecDummy.setAlignmentX(1.0f);
            this.RecDummy.setForeground(Color.black);
            this.RecPanelBotL.add(this.RecDummy);
            this.RecPanelBotR.add(this.RecDummyVal);
            this.RecSamples.setAlignmentX(1.0f);
            this.RecSamples.setForeground(Color.black);
            this.RecPanelBotL.add(this.RecSamples);
            this.RecPanelBotR.add(this.RecSamplesVal);
            this.RecInputDelay.setAlignmentX(1.0f);
            this.RecInputDelay.setForeground(Color.black);
            this.RecPanelBotL.add(this.RecInputDelay);
            this.RecPanelBotR.add(this.RecInputDelayVal);
            this.RecEncoding.setAlignmentX(1.0f);
            this.RecEncoding.setForeground(Color.black);
            this.RecPanelBotL.add(this.RecEncoding);
            this.RecPanelBotR.add(this.RecEncodingVal);
            this.RecSampleRate.setAlignmentX(1.0f);
            this.RecSampleRate.setForeground(Color.black);
            this.RecPanelBotL.add(this.RecSampleRate);
            this.RecPanelBotR.add(this.RecSampleRateVal);
            this.RecChannels.setAlignmentX(1.0f);
            this.RecChannels.setForeground(Color.black);
            this.RecPanelBotL.add(this.RecChannels);
            this.RecPanelBotR.add(this.RecChannelsVal);
            this.PBPanelBot.add((Component)this.PBPanelBotL, "West");
            this.PBPanelBot.add((Component)this.PBPanelBotR, "East");
            this.PBPanel.add(this.PlaybackTitle);
            this.PBPanel.add(this.PBPanelTop);
            this.PBPanel.add(Box.createRigidArea(new Dimension(0, 5)));
            this.PBPanel.add(this.PBPanelBot);
            this.RecPanelBot.add((Component)this.RecPanelBotL, "West");
            this.RecPanelBot.add((Component)this.RecPanelBotR, "East");
            this.RecPanel.add(this.RecordTitle);
            this.RecPanel.add(this.RecPanelTop);
            this.RecPanel.add(Box.createRigidArea(new Dimension(0, 5)));
            this.RecPanel.add(this.RecPanelBot);
            if (AudioControl.supportsPlay()) {
                this.MiddlePanel.add(this.PBPanel);
            }
            if (AudioControl.supportsRecord()) {
                this.MiddlePanel.add(this.RecPanel);
            }
            this.StatusPanel.add((Component)this.MiddlePanel, "Center");
            this.fixedSize(this.ChannelScrollList, this.listDim);
            this.TopPanel.setBorder(BorderFactory.createEmptyBorder(5, 5, 5, 5));
            this.ContinuousCheckBox.setToolTipText(AudioControl.localize("Click for continuous status update"));
            this.UpdatePanel.add(this.ContinuousCheckBox);
            this.UpdateNowButton.setActionCommand("updatenow");
            this.UpdateNowButton.setToolTipText(AudioControl.localize("Click to update status information now"));
            this.UpdatePanel.add(this.UpdateNowButton);
            StatusChanListSelListener slsvChanged = new StatusChanListSelListener();
            this.ChannelList.addListSelectionListener(slsvChanged);
            this.ChannelScrollList.getViewport().add(this.ChannelList);
            this.TopPanel.add(this.ChannelScrollList);
            this.TopPanel.add(Box.createRigidArea(new Dimension(10, 0)));
            this.TopPanel.add(this.UpdatePanel);
            this.StatusPanel.add((Component)this.TopPanel, "North");
            this.ButtonPanel.setBorder(BorderFactory.createEmptyBorder(10, 10, 10, 10));
            this.ButtonPanel.add(Box.createHorizontalGlue());
            this.CloseButton.setActionCommand("close");
            this.CloseButton.setToolTipText(AudioControl.localize("Click to close status window"));
            this.ButtonPanel.add(this.CloseButton);
            this.ButtonPanel.add(Box.createHorizontalStrut(10));
            this.HelpButton.setActionCommand("help");
            this.HelpButton.setToolTipText(AudioControl.localize("Click to get online help"));
            this.ButtonPanel.add(this.HelpButton);
            this.ButtonPanel.add(Box.createHorizontalGlue());
            this.StatusPanel.add((Component)this.ButtonPanel, "South");
            this.StatusPanel.setBorder(BorderFactory.createCompoundBorder(BorderFactory.createEtchedBorder(), this.StatusPanel.getBorder()));
            this.PBPanel.setBorder(BorderFactory.createCompoundBorder(BorderFactory.createEmptyBorder(0, 5, 0, 5), this.PBPanel.getBorder()));
            this.PBPanel.setBorder(BorderFactory.createCompoundBorder(BorderFactory.createEtchedBorder(), this.PBPanel.getBorder()));
            this.RecPanel.setBorder(BorderFactory.createCompoundBorder(BorderFactory.createEmptyBorder(0, 5, 0, 5), this.RecPanel.getBorder()));
            this.RecPanel.setBorder(BorderFactory.createCompoundBorder(BorderFactory.createEtchedBorder(), this.RecPanel.getBorder()));
            Debug.setBorder(this.StatusPanel, Color.red);
            Debug.setBorder(this.TopPanel, Color.red);
            Debug.setBorder(this.ChannelScrollList, Color.blue);
            Debug.setBorder(this.ContinuousCheckBox, Color.blue);
            Debug.setBorder(this.UpdateNowButton, Color.blue);
            Debug.setBorder(this.UpdatePanel, Color.red);
            Debug.setBorder(this.PBOpenCheck, Color.blue);
            Debug.setBorder(this.PBPausedCheck, Color.blue);
            Debug.setBorder(this.PBActiveCheck, Color.blue);
            Debug.setBorder(this.PBUnderflowCheck, Color.blue);
            Debug.setBorder(this.PBWaitingCheck, Color.blue);
            Debug.setBorder(this.PBPanel, Color.red);
            Debug.setBorder(this.PBPanelTop, Color.red);
            Debug.setBorder(this.PBPanelBot, Color.red);
            Debug.setBorder(this.PBPanelBotR, Color.red);
            Debug.setBorder(this.PBPanelBotL, Color.red);
            Debug.setBorder(this.RecPanel, Color.red);
            Debug.setBorder(this.RecOpenCheck, Color.blue);
            Debug.setBorder(this.RecPausedCheck, Color.blue);
            Debug.setBorder(this.RecActiveCheck, Color.blue);
            Debug.setBorder(this.RecUnderflowCheck, Color.blue);
            Debug.setBorder(this.RecWaitingCheck, Color.blue);
            Debug.setBorder(this.RecPanelTop, Color.red);
            Debug.setBorder(this.RecPanelBot, Color.red);
            Debug.setBorder(this.RecPanelBotR, Color.red);
            Debug.setBorder(this.RecPanelBotL, Color.red);
            Debug.setBorder(this.MiddlePanel, Color.red);
            Debug.setBorder(this.CloseButton, Color.blue);
            Debug.setBorder(this.HelpButton, Color.blue);
            Debug.setBorder(this.ButtonPanel, Color.red);
            CheckBoxListener continuousUpdateCB = new CheckBoxListener();
            this.ContinuousCheckBox.addItemListener(continuousUpdateCB);
            ButtonChangeListener statusButtonsCB = new ButtonChangeListener();
            this.UpdateNowButton.addActionListener(statusButtonsCB);
            this.CloseButton.addActionListener(statusButtonsCB);
            if (AudioControl.this.helpBroker != null) {
                this.HelpButton.addActionListener(AudioControl.this.helpBrokerListener);
            }
            StringBuffer status = new StringBuffer(0);
            String[] chList = AudioControl.makeStatusChanList((String[])AudioControl.getChanList(3, status));
            if (status.length() != 0) {
                JOptionPane.showMessageDialog(this, String.valueOf(AudioControl.localize("Error getting device status.")) + AudioControl.newline + AudioControl.localize("Error") + status, AudioControl.localize("Error"), 2);
            }
            this.ChannelList.setListData(chList);
            if (chList.length >= 1) {
                this.ChannelList.setSelectedIndex(chList.length - 1);
            }
            this.addWindowListener(new StatusWindowListener());
        }

        void ContinuousUpdateIfNeeded() {
            if (this.ContinuousCheckBox.isSelected()) {
                if (this.cmThread == null) {
                    this.cmThread = new ContinuousMonitorThread();
                    this.cmThread.start();
                }
            } else {
                this.cmThread = null;
            }
        }

        void fixedSize(JComponent obj, int width, int height) {
            Dimension dim = new Dimension(width, height);
            obj.setPreferredSize(dim);
            obj.setMinimumSize(dim);
            obj.setMaximumSize(dim);
        }

        void fixedSize(JComponent obj, Dimension dim) {
            obj.setPreferredSize(dim);
            obj.setMinimumSize(dim);
            obj.setMaximumSize(dim);
        }

        public void updateNow() {
            int enc_index;
            int i;
            DecimalFormat df = new DecimalFormat("0.###");
            StringBuffer status = new StringBuffer(0);
            float[] status_array = AudioControl.getStatusInfo(this.statusCurrSelChan, status);
            if (status_array[i = 0] == -1.0f) {
                JOptionPane.showMessageDialog(this, String.valueOf(AudioControl.localize("Error getting device status.")) + AudioControl.newline + AudioControl.localize("Error") + status, AudioControl.localize("Error"), 2);
                return;
            }
            if (this.currStatusArray[++i] != status_array[i] && status_array[i] != -1.0f) {
                if (status_array[i] == 0.0f) {
                    this.PBOpenCheck.setSelected(false);
                } else {
                    this.PBOpenCheck.setSelected(true);
                }
            }
            if (this.currStatusArray[++i] != status_array[i] && status_array[i] != -1.0f) {
                if (status_array[i] == 0.0f) {
                    this.PBPausedCheck.setSelected(false);
                } else {
                    this.PBPausedCheck.setSelected(true);
                }
            }
            if (this.currStatusArray[++i] != status_array[i] && status_array[i] != -1.0f) {
                if (status_array[i] == 0.0f) {
                    this.PBActiveCheck.setSelected(false);
                } else {
                    this.PBActiveCheck.setSelected(true);
                }
            }
            if (this.currStatusArray[++i] != status_array[i] && status_array[i] != -1.0f) {
                if (status_array[i] == 0.0f) {
                    this.PBUnderflowCheck.setSelected(false);
                } else {
                    this.PBUnderflowCheck.setSelected(true);
                }
            }
            if (this.currStatusArray[++i] != status_array[i] && status_array[i] != -1.0f) {
                if (status_array[i] == 0.0f) {
                    this.PBWaitingCheck.setSelected(false);
                } else {
                    this.PBWaitingCheck.setSelected(true);
                }
            }
            if (this.currStatusArray[++i] != status_array[i]) {
                this.PBEofCountVal.setText(Integer.toString((int)status_array[i]));
            }
            if (this.currStatusArray[++i] != status_array[i]) {
                this.PBSamplesVal.setText(Integer.toString((int)status_array[i]));
            }
            if (this.currStatusArray[++i] != status_array[i]) {
                this.PBGranularityVal.setText(String.valueOf(df.format(status_array[i])) + " secs");
            }
            if (this.currStatusArray[++i] != status_array[i]) {
                this.PBPrecisionVal = Integer.toString((int)status_array[i]);
            }
            if (this.currStatusArray[++i] != status_array[i] || this.currStatusArray[i - 1] != status_array[i - 1]) {
                enc_index = (int)status_array[i];
                if (enc_index < Encoding.length) {
                    this.PBEncodingVal.setText(String.valueOf(this.PBPrecisionVal) + "-bit " + Encoding[enc_index]);
                } else {
                    this.PBEncodingVal.setText("Unknown");
                }
            }
            if (this.currStatusArray[++i] != status_array[i]) {
                this.PBSampleRateVal.setText(String.valueOf(Float.toString((float)((double)status_array[i] / 1000.0))) + "kHz");
            }
            if (this.currStatusArray[++i] != status_array[i]) {
                switch ((int)status_array[i]) {
                    case 0: {
                        this.PBChannelsVal.setText("zero");
                        break;
                    }
                    case 1: {
                        this.PBChannelsVal.setText("mono");
                        break;
                    }
                    case 2: {
                        this.PBChannelsVal.setText("stereo");
                        break;
                    }
                    default: {
                        this.PBChannelsVal.setText("unknown");
                        break;
                    }
                }
            }
            if (this.currStatusArray[++i] != status_array[i] && status_array[i] != -1.0f) {
                if (status_array[i] == 0.0f) {
                    this.RecOpenCheck.setSelected(false);
                } else {
                    this.RecOpenCheck.setSelected(true);
                }
            }
            if (this.currStatusArray[++i] != status_array[i] && status_array[i] != -1.0f) {
                if (status_array[i] == 0.0f) {
                    this.RecPausedCheck.setSelected(false);
                } else {
                    this.RecPausedCheck.setSelected(true);
                }
            }
            if (this.currStatusArray[++i] != status_array[i] && status_array[i] != -1.0f) {
                if (status_array[i] == 0.0f) {
                    this.RecActiveCheck.setSelected(false);
                } else {
                    this.RecActiveCheck.setSelected(true);
                }
            }
            if (this.currStatusArray[++i] != status_array[i] && status_array[i] != -1.0f) {
                if (status_array[i] == 0.0f) {
                    this.RecUnderflowCheck.setSelected(false);
                } else {
                    this.RecUnderflowCheck.setSelected(true);
                }
            }
            if (this.currStatusArray[++i] != status_array[i] && status_array[i] != -1.0f) {
                if (status_array[i] == 0.0f) {
                    this.RecWaitingCheck.setSelected(false);
                } else {
                    this.RecWaitingCheck.setSelected(true);
                }
            }
            if (this.currStatusArray[++i] != status_array[i]) {
                this.RecSamplesVal.setText(Integer.toString((int)status_array[i]));
            }
            if (this.currStatusArray[++i] != status_array[i]) {
                this.RecInputDelayVal.setText(String.valueOf(df.format(status_array[i])) + " secs");
            }
            if (this.currStatusArray[++i] != status_array[i]) {
                this.RecPrecisionVal = Integer.toString((int)status_array[i]);
            }
            if (this.currStatusArray[++i] != status_array[i] || this.currStatusArray[i - 1] != status_array[i - 1]) {
                enc_index = (int)status_array[i];
                if (enc_index < Encoding.length) {
                    this.RecEncodingVal.setText(String.valueOf(this.RecPrecisionVal) + "-bit " + Encoding[enc_index]);
                } else {
                    this.RecEncodingVal.setText("Unknown");
                }
            }
            if (this.currStatusArray[++i] != status_array[i]) {
                this.RecSampleRateVal.setText(String.valueOf(Float.toString((float)((double)status_array[i] / 1000.0))) + "kHz");
            }
            if (this.currStatusArray[++i] != status_array[i]) {
                switch ((int)status_array[i]) {
                    case 0: {
                        this.RecChannelsVal.setText("zero");
                        break;
                    }
                    case 1: {
                        this.RecChannelsVal.setText("mono");
                        break;
                    }
                    case 2: {
                        this.RecChannelsVal.setText("stereo");
                        break;
                    }
                    default: {
                        this.RecChannelsVal.setText("unknown");
                        break;
                    }
                }
            }
            ++i;
            this.currStatusArray = status_array;
        }

        class CheckBoxListener
        implements ItemListener {
            CheckBoxListener() {
            }

            public void itemStateChanged(ItemEvent event) {
                JCheckBox item = (JCheckBox)event.getSource();
                if (item == AudioStatus.this.ContinuousCheckBox) {
                    AudioStatus.this.ContinuousUpdateIfNeeded();
                }
            }
        }

        class ContinuousMonitorThread
        extends Thread {
            ContinuousMonitorThread() {
            }

            public void run() {
                Thread thisThread = Thread.currentThread();
                while (AudioStatus.this.cmThread == thisThread) {
                    try {
                        Thread.sleep(250L);
                        AudioStatus.this.updateNow();
                    }
                    catch (InterruptedException interruptedException) {}
                }
            }
        }

        class ButtonChangeListener
        implements ActionListener {
            ButtonChangeListener() {
            }

            public void actionPerformed(ActionEvent e) {
                if (e.getActionCommand().equals("close")) {
                    JButton item = (JButton)e.getSource();
                    JFrame top = (JFrame)item.getTopLevelAncestor();
                    AudioStatus.this.cmThread = null;
                    ((Component)top).setVisible(false);
                } else if (e.getActionCommand().equals("updatenow")) {
                    AudioStatus.this.updateNow();
                }
            }
        }

        class StatusChanListSelListener
        implements ListSelectionListener {
            StatusChanListSelListener() {
            }

            public void valueChanged(ListSelectionEvent event) {
                if (event.getValueIsAdjusting()) {
                    return;
                }
                String selItem = "EMPTY";
                JList list = (JList)event.getSource();
                if (!list.isSelectionEmpty()) {
                    selItem = (String)list.getSelectedValue();
                    if (selItem.equals(AudioControl.localize(AudioControl.MASTER_CHANNEL_STR))) {
                        AudioStatus.this.statusCurrSelChan = -1;
                    } else {
                        int wsindex = selItem.indexOf(" ", 3);
                        String substr = selItem.substring(3, wsindex);
                        AudioStatus.this.statusCurrSelChan = Integer.parseInt(substr);
                    }
                } else {
                    AudioStatus.this.statusCurrSelChan = -1;
                }
                boolean masterSelected = AudioStatus.this.statusCurrSelChan == -1;
                boolean openEnabled = AudioStatus.this.PBOpenCheck.isEnabled();
                if (currMixerMode && masterSelected && openEnabled) {
                    AudioStatus.this.PBOpenCheck.setEnabled(false);
                    AudioStatus.this.PBPausedCheck.setEnabled(false);
                    AudioStatus.this.RecOpenCheck.setEnabled(false);
                    AudioStatus.this.RecPausedCheck.setEnabled(false);
                } else if (!openEnabled) {
                    AudioStatus.this.PBOpenCheck.setEnabled(true);
                    AudioStatus.this.PBPausedCheck.setEnabled(true);
                    AudioStatus.this.RecOpenCheck.setEnabled(true);
                    AudioStatus.this.RecPausedCheck.setEnabled(true);
                }
                AudioStatus.this.updateNow();
            }
        }

        class StatusWindowListener
        extends WindowAdapter {
            StatusWindowListener() {
            }

            public void windowClosing(WindowEvent event) {
                AudioStatus.this.cmThread = null;
            }

            public void windowDeiconified(WindowEvent event) {
                AudioStatus.this.ContinuousUpdateIfNeeded();
            }

            public void windowIconified(WindowEvent event) {
                AudioStatus.this.cmThread = null;
            }
        }
    }
}

