/*
 * Decompiled with CFR 0.152.
 */
package com.sun.opencard.terminal.scm.SCMI2c;

import com.scmmicro.smartos.core.Session;
import com.scmmicro.smartos.core.SessionListener;
import com.scmmicro.smartos.physical.Drive;
import com.scmmicro.smartos.util.Buffer;
import com.sun.opencard.terminal.scm.SCMI2c.SCMI2cCardEvent;
import java.util.Date;
import java.util.Properties;
import opencard.core.terminal.CardID;
import opencard.core.terminal.CardTerminal;
import opencard.core.terminal.CardTerminalException;
import opencard.core.terminal.CommandAPDU;
import opencard.core.terminal.ResponseAPDU;
import opencard.core.terminal.Slot;
import opencard.core.util.Tracer;

public class SCMI2cCardTerminal
extends CardTerminal
implements SessionListener {
    private Tracer itracer = new Tracer((Object)this, class$com$sun$opencard$terminal$scm$SCMI2c$SCMI2cCardTerminal != null ? class$com$sun$opencard$terminal$scm$SCMI2c$SCMI2cCardTerminal : (class$com$sun$opencard$terminal$scm$SCMI2c$SCMI2cCardTerminal = SCMI2cCardTerminal.class$("com.sun.opencard.terminal.scm.SCMI2c.SCMI2cCardTerminal")));
    private boolean closed = true;
    private boolean cardInserted;
    private static final int MAX_TIMEOUT = 60;
    private CardID cid = null;
    private Drive reader = null;
    private Session session = null;
    private SCMI2cCardEvent scEvent = null;
    private String DriverName;
    private String DriverType;
    private String DriverAddress;
    static /* synthetic */ Class class$com$sun$opencard$terminal$scm$SCMI2c$SCMI2cCardTerminal;

    public SCMI2cCardTerminal(String string, String string2, String string3) throws CardTerminalException {
        super(string, string2, string3);
        this.itracer.debug("SCMI2cCardTerminal", "add one slot");
        this.DriverName = string;
        this.DriverType = string2;
        this.DriverAddress = string3;
        this.slots.addElement(new Slot((CardTerminal)this, 0));
        this.slots.trimToSize();
    }

    public synchronized void cardInsert() {
        super.cardInserted(0);
    }

    public void cardMovement(byte by) {
        if (by == -96) {
            this.itracer.debug("cardMovement", "Card inserted! ");
            this.cardInserted = true;
        } else if (by == -95) {
            this.itracer.debug("cardMovement", "Card removed! ");
            this.cardInserted = false;
        }
        this.cid = null;
        this.scEvent = new SCMI2cCardEvent(this);
        this.scEvent.start(this.cardInserted);
    }

    public synchronized void cardRemove() {
        super.cardRemoved(0);
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    public void close() throws CardTerminalException {
        if (!this.closed) {
            if (this.cardInserted && this.cid != null) {
                this.itracer.debug("close", "card inserted - try to power down card");
                try {
                    this.powerDownCard(0);
                }
                catch (Exception exception) {}
            } else {
                this.itracer.debug("close", "no card inserted");
            }
            try {
                this.session.close();
                this.session = null;
            }
            catch (Exception exception) {
                this.itracer.debug("close", "session closing error");
                throw new CardTerminalException(exception.toString());
            }
        } else {
            this.itracer.debug("close", "Terminal already closed!");
            throw new CardTerminalException("SCMI2cCardTerminal: already closed");
        }
        this.closed = true;
    }

    protected void finalize() {
        try {
            if (!this.closed) {
                this.close();
            }
        }
        catch (CardTerminalException cardTerminalException) {}
    }

    private byte[] getATR(int n) throws CardTerminalException {
        Buffer buffer = new Buffer(0);
        Buffer buffer2 = new Buffer(0);
        try {
            this.session.readerExchange((byte)0, buffer2, buffer);
        }
        catch (Exception exception) {
            try {
                this.powerDownCard(n);
            }
            catch (Exception exception2) {}
            this.cid = null;
            throw new CardTerminalException(exception.toString());
        }
        return buffer.getData();
    }

    public CardID getCardID(int n) throws CardTerminalException {
        return this.getCardID(n, 60);
    }

    public CardID getCardID(int n, int n2) throws CardTerminalException {
        if (this.closed || n != 0) {
            throw new CardTerminalException("SCMI2cCardTerminal: CardTerminal not initialized");
        }
        if (!this.cardInserted || this.cid == null) {
            this.powerUpCard(n, n2);
        }
        return this.cid;
    }

    protected Properties internalFeatures(Properties properties) {
        return properties;
    }

    protected CardID internalReset(int n, int n2) throws CardTerminalException {
        if (this.closed || n != 0) {
            throw new CardTerminalException("SCMI2cCardTerminal: CardTerminal not initialized");
        }
        if (!this.cardInserted || this.cid == null) {
            this.powerUpCard(n, n2);
        }
        return this.cid;
    }

    protected ResponseAPDU internalSendAPDU(int n, CommandAPDU commandAPDU, int n2) throws CardTerminalException {
        System.out.println("send APDU " + commandAPDU);
        if (this.closed || n != 0) {
            throw new CardTerminalException("SCMI2cCardTerminal: CardTerminal not initialized");
        }
        Buffer buffer = new Buffer(0);
        buffer.setData(commandAPDU.getBuffer(), commandAPDU.getLength());
        Buffer buffer2 = new Buffer(0);
        byte[] byArray = null;
        try {
            this.session.cardExchange(buffer, buffer2);
            byArray = buffer2.getData();
        }
        catch (Exception exception) {
            try {
                this.powerDownCard(n);
            }
            catch (Exception exception2) {}
            this.cid = null;
            throw new CardTerminalException(exception.toString());
        }
        ResponseAPDU responseAPDU = new ResponseAPDU(byArray);
        return responseAPDU;
    }

    public boolean isCardPresent(int n) throws CardTerminalException {
        if (this.closed || n != 0) {
            throw new CardTerminalException("SCMI2cCardTerminal: CardTerminal not initialized");
        }
        if (!this.cardInserted) {
            this.cid = null;
        }
        return this.cardInserted;
    }

    public void open() throws CardTerminalException {
        if (this.closed) {
            try {
                String string = "com.scmmicro.smartos.physical." + this.DriverType;
                Class<?> clazz = Class.forName(string);
                Object obj = clazz.newInstance();
                this.reader = (Drive)obj;
                this.reader.setInitializer(this.DriverName, this.DriverType, this.DriverAddress);
            }
            catch (Exception exception) {
                throw new CardTerminalException(exception.toString());
            }
            try {
                this.session = new Session(this.reader);
                this.session.setListener((SessionListener)this);
            }
            catch (Exception exception) {
                throw new CardTerminalException(exception.toString());
            }
            this.closed = false;
            try {
                this.cardInserted = this.session.getParameter((byte)4) != 0L;
            }
            catch (Exception exception) {
                throw new CardTerminalException("driverIsCardPresent :" + exception.toString());
            }
        }
    }

    public synchronized void powerDownCard(int n) throws CardTerminalException {
        if (this.closed || n != 0) {
            throw new CardTerminalException("SCMI2cCardTerminal: CardTerminal not initialized");
        }
        if (this.cardInserted) {
            Buffer buffer = new Buffer(0);
            Buffer buffer2 = new Buffer(0);
            try {
                this.session.readerExchange((byte)2, buffer2, buffer);
            }
            catch (Exception exception) {
                throw new CardTerminalException(exception.toString());
            }
        }
        this.cid = null;
    }

    public void powerUpCard(int n, int n2) throws CardTerminalException {
        if (this.closed || n != 0) {
            throw new CardTerminalException("SCMI2cCardTerminal: CardTerminal not initialized");
        }
        if (n2 == 0) {
            n2 = 1;
        }
        if (n2 == -1) {
            while (!this.requestCard(n, 60)) {
            }
        } else {
            if (n2 > 60) {
                while (n2 > 60) {
                    if (this.requestCard(n, 60)) {
                        return;
                    }
                    n2 -= 60;
                }
            }
            if (!this.requestCard(n, n2)) {
                throw new CardTerminalException("operation timed out", (CardTerminal)this);
            }
        }
    }

    private synchronized boolean requestCard(int n, int n2) throws CardTerminalException {
        if (n2 < 1 || n2 > 60) {
            throw new CardTerminalException("Invalid timeout: " + n2, (CardTerminal)this);
        }
        this.cid = null;
        long l = new Date().getTime() + (long)(n2 * 1000);
        while (new Date().getTime() < l) {
            if (this.cardInserted) break;
        }
        if (this.cardInserted) {
            this.cid = new CardID(this.slots()[0], this.getATR(n));
        }
        return this.cardInserted;
    }
}

