/*
 * Decompiled with CFR 0.152.
 */
package java.rmi;

import COM.odi.ClassInfo;
import COM.odi.GenericObject;
import COM.odi.IPersistent;
import COM.odi.ObjectStore;
import COM.odi.imp.ObjectReference;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectInputFilter;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.OutputStream;
import java.io.Serializable;
import java.rmi.MarshalledObjectClassInfo;
import java.security.AccessController;
import sun.rmi.server.MarshalInputStream;
import sun.rmi.server.MarshalOutputStream;

public final class MarshalledObject
implements Serializable,
IPersistent {
    private byte[] objBytes;
    private byte[] locBytes;
    private int hash;
    private static final long serialVersionUID = 8988374069173025854L;
    private transient ObjectReference ODIref;
    public transient byte ODIObjectState;
    static ClassInfo myOdiClassInfoInstance = ClassInfo.register((ClassInfo)new MarshalledObjectClassInfo());

    public MarshalledObject(Object object) throws IOException {
        MarshalledObject marshalledObject;
        byte[] byArray = null;
        this.objBytes = null;
        this.locBytes = null;
        if (object == null) {
            this.hash = 13;
            return;
        }
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        ByteArrayOutputStream byteArrayOutputStream2 = new ByteArrayOutputStream();
        MarshalledObjectOutputStream marshalledObjectOutputStream = new MarshalledObjectOutputStream((OutputStream)byteArrayOutputStream, byteArrayOutputStream2);
        marshalledObjectOutputStream.writeObject(object);
        marshalledObjectOutputStream.flush();
        this.objBytes = byteArrayOutputStream.toByteArray();
        byte[] byArray2 = marshalledObjectOutputStream.hadAnnotations() ? byteArrayOutputStream2.toByteArray() : null;
        if (((marshalledObject = this).ODIObjectState & 2) != 0) {
            marshalledObject = marshalledObject;
            ObjectStore.dirty((IPersistent)marshalledObject);
        }
        marshalledObject.locBytes = byArray2;
        int n = 0;
        int n2 = 0;
        while (n2 < this.objBytes.length) {
            byte[] byArray3 = this.objBytes;
            if (this.objBytes != byArray) {
                ObjectStore.fetch((Object)byArray3);
                byArray3 = byArray = byArray3;
            }
            n = 31 * n + byArray3[n2];
            ++n2;
        }
        this.hash = n;
    }

    public boolean equals(Object object) {
        block14: {
            MarshalledObject marshalledObject;
            MarshalledObject marshalledObject2;
            byte[] byArray;
            byte[] byArray2;
            block16: {
                MarshalledObject marshalledObject3;
                block15: {
                    MarshalledObject marshalledObject4;
                    byArray2 = null;
                    byArray = null;
                    if (this.ODIObjectState < 0) {
                        ObjectStore.fetch((IPersistent)this);
                    }
                    if (object == this) {
                        return true;
                    }
                    if (object == null || !(object instanceof MarshalledObject)) break block14;
                    marshalledObject2 = (MarshalledObject)object;
                    if (this.objBytes == null) break block15;
                    if ((marshalledObject4 = marshalledObject2).ODIObjectState < 0) {
                        marshalledObject4 = marshalledObject4;
                        ObjectStore.fetch((IPersistent)marshalledObject4);
                    }
                    if (marshalledObject4.objBytes != null) break block16;
                }
                if ((marshalledObject3 = marshalledObject2).ODIObjectState < 0) {
                    marshalledObject3 = marshalledObject3;
                    ObjectStore.fetch((IPersistent)marshalledObject3);
                }
                return this.objBytes == marshalledObject3.objBytes;
            }
            int n = this.objBytes.length;
            if ((marshalledObject = marshalledObject2).ODIObjectState < 0) {
                marshalledObject = marshalledObject;
                ObjectStore.fetch((IPersistent)marshalledObject);
            }
            if (n != marshalledObject.objBytes.length) {
                return false;
            }
            int n2 = 0;
            while (n2 < this.objBytes.length) {
                MarshalledObject marshalledObject5;
                byte[] byArray3 = this.objBytes;
                if (this.objBytes != byArray2) {
                    ObjectStore.fetch((Object)byArray3);
                    byArray3 = byArray2 = byArray3;
                }
                byte by = byArray3[n2];
                if ((marshalledObject5 = marshalledObject2).ODIObjectState < 0) {
                    marshalledObject5 = marshalledObject5;
                    ObjectStore.fetch((IPersistent)marshalledObject5);
                }
                byte[] byArray4 = marshalledObject5.objBytes;
                if (marshalledObject5.objBytes != byArray) {
                    ObjectStore.fetch((Object)byArray4);
                    byArray4 = byArray = byArray4;
                }
                if (by != byArray4[n2]) {
                    return false;
                }
                ++n2;
            }
            return true;
        }
        return false;
    }

    public Object get() throws IOException, ClassNotFoundException {
        ByteArrayInputStream byteArrayInputStream;
        if (this.ODIObjectState < 0) {
            ObjectStore.fetch((IPersistent)this);
        }
        if (this.objBytes == null) {
            return null;
        }
        byte[] byArray = this.objBytes;
        if (this.objBytes != null) {
            byArray = byArray;
            ObjectStore.fetch((Object)byArray);
        }
        ByteArrayInputStream byteArrayInputStream2 = new ByteArrayInputStream(byArray);
        if (this.locBytes == null) {
            byteArrayInputStream = null;
        } else {
            byte[] byArray2 = this.locBytes;
            if (this.locBytes != null) {
                byArray2 = byArray2;
                ObjectStore.fetch((Object)byArray2);
            }
            byteArrayInputStream = new ByteArrayInputStream(byArray2);
        }
        ByteArrayInputStream byteArrayInputStream3 = byteArrayInputStream;
        MarshalledObjectInputStream marshalledObjectInputStream = new MarshalledObjectInputStream((InputStream)byteArrayInputStream2, (InputStream)byteArrayInputStream3);
        return marshalledObjectInputStream.readObject();
    }

    public int hashCode() {
        if (this.ODIObjectState < 0) {
            ObjectStore.fetch((IPersistent)this);
        }
        return this.hash;
    }

    public ObjectReference ODIgetRef() {
        return this.ODIref;
    }

    public void ODIsetRef(ObjectReference objectReference) {
        this.ODIref = objectReference;
    }

    public byte ODIgetState() {
        return this.ODIObjectState;
    }

    public void ODIsetState(byte by) {
        this.ODIObjectState = by;
    }

    public void preDestroyPersistent() {
    }

    public void postInitializeContents() {
    }

    public void preFlushContents() {
    }

    public void preClearContents() {
    }

    protected synchronized Object clone() throws CloneNotSupportedException {
        if (this.ODIObjectState < 0) {
            ObjectStore.fetch((IPersistent)this);
        }
        ((MarshalledObject)super.clone()).ODIref = null;
        ((MarshalledObject)super.clone()).ODIObjectState = 0;
        return (MarshalledObject)super.clone();
    }

    public void initializeContents(GenericObject genericObject) {
        ClassInfo classInfo = myOdiClassInfoInstance;
        this.objBytes = (byte[])genericObject.getArrayField(1, classInfo);
        this.locBytes = (byte[])genericObject.getArrayField(2, classInfo);
        this.hash = genericObject.getIntField(3, classInfo);
    }

    public void flushContents(GenericObject genericObject) {
        ClassInfo classInfo = myOdiClassInfoInstance;
        genericObject.setArrayField(1, (Object)this.objBytes, classInfo);
        genericObject.setArrayField(2, (Object)this.locBytes, classInfo);
        genericObject.setIntField(3, this.hash, classInfo);
    }

    public void clearContents() {
        this.objBytes = null;
        this.locBytes = null;
        this.hash = 0;
    }

    public MarshalledObject(ClassInfo classInfo) {
    }

    private static class MarshalledObjectOutputStream
    extends MarshalOutputStream {
        private ObjectOutputStream locOut;
        private boolean hadAnnotations;

        MarshalledObjectOutputStream(OutputStream objOut, OutputStream locOut) throws IOException {
            super(objOut);
            this.useProtocolVersion(2);
            this.locOut = new ObjectOutputStream(locOut);
            this.hadAnnotations = false;
        }

        boolean hadAnnotations() {
            return this.hadAnnotations;
        }

        @Override
        protected void writeLocation(String loc) throws IOException {
            this.hadAnnotations |= loc != null;
            this.locOut.writeObject(loc);
        }

        @Override
        public void flush() throws IOException {
            super.flush();
            this.locOut.flush();
        }
    }

    private static class MarshalledObjectInputStream
    extends MarshalInputStream {
        private ObjectInputStream locIn;

        MarshalledObjectInputStream(InputStream objIn, InputStream locIn, ObjectInputFilter filter) throws IOException {
            super(objIn);
            ObjectInputStream objectInputStream = this.locIn = locIn == null ? null : new ObjectInputStream(locIn);
            if (filter != null) {
                AccessController.doPrivileged(() -> {
                    this.setObjectInputFilter(filter);
                    if (this.locIn != null) {
                        this.locIn.setObjectInputFilter(filter);
                    }
                    return null;
                });
            }
        }

        @Override
        protected Object readLocation() throws IOException, ClassNotFoundException {
            return this.locIn == null ? null : this.locIn.readObject();
        }
    }
}

