/*
 * Decompiled with CFR 0.152.
 */
package com.sun.smartcard;

import com.sun.smartcard.SmartcardException;
import com.sun.smartcard.SmartcardUnknownException;
import com.sun.smartcard.SmartcardUnknownObjectException;
import com.sun.smartcard.SmartcardUnknownStatusException;
import java.io.IOException;
import java.util.StringTokenizer;
import java.util.Vector;
import sun.misc.BASE64Decoder;

public class OCFDecoder {
    private static final String OCFStatusAttribute = "OCFstatus=";
    private static final String OCF_Success = "OCFstatus=OCF_Success";
    private static final String OCFAuth_Success = "OCFStatus=OCFAuth_Success";
    private static final String OCF_Exception = "OCFstatus=OCF_Exception";
    private final String OCF_InvalidClientHandle = "OCF_InvalidClientHandle";
    private final String OCF_InvalidCardHandle = "OCF_InvalidCardHandle";
    private final String OCFAuth_Failed = "OCFAuth_Failed";
    private final String OCF_AuthOp = "OCF_AuthOp";
    private final String OCF_InvalidPin = "OCF_InvalidPin";
    private final String OCF_InvalidPassword = "OCF_InvalidPassword";
    private final String OCF_UnsupportedAuthMech = "OCF_UnsupportedAuthMech";

    public static String base64DecodeParam(String string) throws IOException {
        BASE64Decoder bASE64Decoder = new BASE64Decoder();
        String string2 = new String(bASE64Decoder.decodeBuffer(string));
        return string2;
    }

    protected static Vector decode(String string) throws SmartcardException {
        String string2;
        Vector<Integer> vector = null;
        StringTokenizer stringTokenizer = new StringTokenizer(string, "\n");
        if (stringTokenizer.hasMoreTokens()) {
            string2 = stringTokenizer.nextToken();
            if (!string2.startsWith(OCFStatusAttribute)) {
                throw new SmartcardUnknownStatusException(string2);
            }
            if (string2.equalsIgnoreCase(OCF_Exception)) {
                String string3 = "No message";
                if (stringTokenizer.hasMoreElements()) {
                    string2 = stringTokenizer.nextToken();
                    StringTokenizer stringTokenizer2 = new StringTokenizer(string2, "=");
                    if (stringTokenizer2.hasMoreTokens()) {
                        stringTokenizer2.nextToken();
                    }
                    if (stringTokenizer2.hasMoreTokens()) {
                        string3 = stringTokenizer2.nextToken();
                    }
                }
                throw new SmartcardException(string3);
            }
            if (!string2.equals(OCF_Success) && !string2.equals(OCFAuth_Success)) {
                return OCFDecoder.decodeError(string2);
            }
        }
        Object object = null;
        while (stringTokenizer.hasMoreTokens()) {
            block17: {
                string2 = stringTokenizer.nextToken();
                int n = string2.indexOf("=");
                String string4 = string2.substring(0, n);
                String string5 = string2.substring(n + 1, string2.length());
                try {
                    if (string4.equalsIgnoreCase("int") || string4.equalsIgnoreCase("slotid")) {
                        object = OCFDecoder.decodeInt(string5);
                        break block17;
                    }
                    if (string4.equalsIgnoreCase("long") || string4.equalsIgnoreCase("clienthandle") || string4.equalsIgnoreCase("cardhandle")) {
                        object = OCFDecoder.decodeLong(string5);
                        break block17;
                    }
                    if (string4.equalsIgnoreCase("String") || string4.equalsIgnoreCase("value") || string4.equalsIgnoreCase("uitag") || string4.equalsIgnoreCase("password") || string4.equalsIgnoreCase("cardname") || string4.equalsIgnoreCase("readername") || string4.equalsIgnoreCase("username")) {
                        object = OCFDecoder.decodeString(string5);
                        break block17;
                    }
                    if (string4.equalsIgnoreCase("list")) {
                        object = OCFDecoder.decodeVector(string5);
                        break block17;
                    }
                    if (string4.equalsIgnoreCase("uid")) {
                        object = OCFDecoder.decodeLong(string5);
                        break block17;
                    }
                    if (string4.equalsIgnoreCase("signedData")) {
                        object = OCFDecoder.decodeBytes(string5);
                        break block17;
                    }
                    throw new SmartcardUnknownObjectException(string4);
                }
                catch (IOException iOException) {
                    throw new SmartcardException(iOException.getMessage());
                }
            }
            if (vector == null) {
                vector = new Vector<Integer>();
            }
            vector.add((Integer)object);
        }
        return vector;
    }

    protected static byte[] decodeBytes(String string) throws IOException {
        BASE64Decoder bASE64Decoder = new BASE64Decoder();
        return bASE64Decoder.decodeBuffer(string);
    }

    protected static Vector decodeError(String string) throws SmartcardException {
        String string2 = string.substring(OCFStatusAttribute.length());
        SmartcardException smartcardException = null;
        if (string2.startsWith("OCF_")) {
            String string3 = new String("com.sun.smartcard.Smartcard" + string2.substring(4) + "Exception");
            try {
                Class<?> clazz = Class.forName(string3);
                smartcardException = (SmartcardException)clazz.newInstance();
            }
            catch (Exception exception) {
                exception.printStackTrace();
                throw new SmartcardUnknownException(string2);
            }
            throw smartcardException;
        }
        throw new SmartcardException(string2);
    }

    protected static Integer decodeInt(String string) throws IOException {
        return new Integer(OCFDecoder.base64DecodeParam(string));
    }

    protected static Long decodeLong(String string) throws IOException {
        return Long.valueOf(OCFDecoder.base64DecodeParam(string));
    }

    protected static String decodeString(String string) throws IOException {
        return new String(OCFDecoder.base64DecodeParam(string));
    }

    protected static Vector decodeVector(String string) throws IOException {
        Vector<String> vector = new Vector<String>();
        String string2 = OCFDecoder.base64DecodeParam(string);
        StringTokenizer stringTokenizer = new StringTokenizer(string2, " ");
        while (stringTokenizer.hasMoreTokens()) {
            vector.add(stringTokenizer.nextToken());
        }
        return vector;
    }
}

