/*
 * Decompiled with CFR 0.152.
 */
package com.sun.smartcard;

import com.sun.smartcard.OCFClientSocket;
import com.sun.smartcard.OCFDecoder;
import com.sun.smartcard.OCFEncoder;
import com.sun.smartcard.Smartcard;
import com.sun.smartcard.SmartcardException;
import java.lang.reflect.Constructor;
import java.util.Enumeration;
import java.util.Vector;

public class Card {
    private Smartcard sc;
    private long cardHandle;
    private OCFClientSocket server;
    public static final String PIN_CARD_SERVICE = "com.sun.smartcard.PinCardService";
    public static final String USERINFO_CARD_SERVICE = "com.sun.smartcard.UserInfoCardService";
    public static final String KEYIMPORT_CARD_SERVICE = "com.sun.smartcard.KeyImportCardService";
    public static final String CARDLETADMIN_CARD_SERVICE = "com.sun.smartcard.CardletAdminCardService";
    public static final String SIGNATURE_CARD_SERVICE = "com.sun.smartcard.SignatureCardService";
    public static final String PASSTHRU_CARD_SERVICE = "com.sun.smartcard.PassThruCardService";

    private Card() {
    }

    protected Card(Smartcard smartcard, long l) throws SmartcardException {
        this.sc = smartcard;
        this.cardHandle = l;
        this.server = new OCFClientSocket();
    }

    public void deleteProperty(String string) throws SmartcardException {
        Vector<Object> vector = new Vector<Object>();
        vector.add(new Long(this.sc.getClientHandle()));
        vector.add(new Long(this.cardHandle));
        vector.add(string);
        String string2 = OCFEncoder.encode(vector);
        String string3 = this.server.serverResponse("OCF", "OCFService", "deleteCardProperty", string2);
        OCFDecoder.decode(string3);
    }

    public boolean equals(Object object) {
        if (!(object instanceof Card)) {
            return false;
        }
        Card card = (Card)object;
        return card.cardHandle == this.cardHandle;
    }

    protected long getCardHandle() {
        return this.cardHandle;
    }

    public String getCardName() throws SmartcardException {
        Vector<Long> vector = new Vector<Long>();
        vector.add(new Long(this.cardHandle));
        String string = OCFEncoder.encode(vector);
        String string2 = this.server.serverResponse("OCF", "OCFService", "getCardName", string);
        Vector vector2 = OCFDecoder.decode(string2);
        if (vector2 == null || vector2.size() == 0) {
            return null;
        }
        return (String)vector2.elementAt(0);
    }

    public Object getCardService(String string) throws Exception {
        Class<?> clazz = Class.forName(string);
        Class[] classArray = new Class[]{Class.forName("com.sun.smartcard.Card")};
        Constructor<?> constructor = clazz.getConstructor(classArray);
        Object[] objectArray = new Object[]{this};
        return constructor.newInstance(objectArray);
    }

    protected long getClientHandle() {
        return this.sc.getClientHandle();
    }

    public String getProperty(String string) throws SmartcardException {
        Vector<Object> vector = new Vector<Object>();
        vector.add(new Long(this.sc.getClientHandle()));
        vector.add(new Long(this.cardHandle));
        vector.add(string);
        String string2 = OCFEncoder.encode(vector);
        String string3 = this.server.serverResponse("OCF", "OCFService", "getCardProperty", string2);
        Vector vector2 = OCFDecoder.decode(string3);
        if (vector2 == null || vector2.size() == 0) {
            return null;
        }
        return (String)vector2.elementAt(0);
    }

    public String getReaderName() throws SmartcardException {
        Vector<Long> vector = new Vector<Long>();
        vector.add(new Long(this.cardHandle));
        String string = OCFEncoder.encode(vector);
        String string2 = this.server.serverResponse("OCF", "OCFService", "getReaderName", string);
        Vector vector2 = OCFDecoder.decode(string2);
        if (vector2 == null || vector2.size() == 0) {
            return null;
        }
        return (String)vector2.elementAt(0);
    }

    public int getSlotID() throws SmartcardException {
        Vector<Long> vector = new Vector<Long>();
        vector.add(new Long(this.cardHandle));
        String string = OCFEncoder.encode(vector);
        String string2 = this.server.serverResponse("OCF", "OCFService", "getSlotID", string);
        Vector vector2 = OCFDecoder.decode(string2);
        if (vector2 == null || vector2.size() == 0) {
            return 0;
        }
        return (Integer)vector2.elementAt(0);
    }

    public Enumeration properties() throws SmartcardException {
        Vector<Long> vector = new Vector<Long>();
        vector.add(new Long(this.sc.getClientHandle()));
        vector.add(new Long(this.cardHandle));
        String string = OCFEncoder.encode(vector);
        String string2 = this.server.serverResponse("OCF", "OCFService", "listCardProperties", string);
        Vector vector2 = OCFDecoder.decode(string2);
        if (vector2 == null) {
            return null;
        }
        Vector vector3 = (Vector)vector2.elementAt(0);
        return vector3 == null ? null : vector3.elements();
    }

    public void setProperty(String string, String string2) throws SmartcardException {
        Vector<Object> vector = new Vector<Object>();
        vector.add(new Long(this.sc.getClientHandle()));
        vector.add(new Long(this.cardHandle));
        vector.add(string);
        vector.add(string2);
        String string3 = OCFEncoder.encode(vector);
        String string4 = this.server.serverResponse("OCF", "OCFService", "setCardProperty", string3);
        OCFDecoder.decode(string4);
    }

    public String toString() {
        return new String("Client Handle: " + this.sc.getClientHandle() + " Card Handle: " + this.cardHandle);
    }

    public void waitForCardRemoved() throws SmartcardException {
        this.sc.waitForCardRemoved(this);
    }
}

