/*
 * Decompiled with CFR 0.152.
 */
package com.sun.jdmk;

import com.sun.jdmk.TraceFilter;
import com.sun.jdmk.TraceListener;
import com.sun.jdmk.TraceNotification;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Properties;
import javax.management.NotificationFilter;
import javax.management.NotificationListener;

public class Trace {
    public static final int LEVEL_TRACE = 1;
    public static final int LEVEL_DEBUG = 2;
    public static final int INFO_MBEANSERVER = 1;
    public static final int INFO_MLET = 2;
    public static final int INFO_MONITOR = 4;
    public static final int INFO_TIMER = 8;
    public static final int INFO_ADAPTOR_HTML = 16;
    public static final int INFO_MISC = 32;
    public static final int INFO_SNMP = 64;
    public static final int INFO_NOTIFICATION = 128;
    public static final int INFO_CONNECTOR_RMI = 256;
    public static final int INFO_CONNECTOR_HTTP = 512;
    public static final int INFO_ADAPTOR_SNMP = 1024;
    public static final int INFO_CONNECTOR_HTTPS = 2048;
    public static final int INFO_DISCOVERY = 4096;
    public static final int INFO_HEARTBEAT = 8192;
    public static final int INFO_RELATION = 16384;
    public static final int INFO_MODELMBEAN = 32768;
    public static final int INFO_ADAPTOR_CONNECTOR = 3856;
    public static int INFO_ALL = 65535;
    private static ArrayList listeners = new ArrayList();
    private static int selectedLevels = 0;
    private static int selectedTypes = 0;
    private static HashMap type_seq = new HashMap(20);
    protected static final String UNKOWNTYPE = "Unknown type";
    private static TraceListener traceListener = null;

    private Trace() {
    }

    static boolean JDMKSelectedCheck(int n, int n2) {
        boolean bl = n == 1 || n == 2 || n == 3;
        return bl &= (n2 | INFO_ALL) == INFO_ALL;
    }

    public static void addNotificationListener(TraceListener traceListener, Object object) throws IllegalArgumentException {
        if (traceListener == null) {
            throw new IllegalArgumentException("A listener should be specified.");
        }
        TraceFilter traceFilter = new TraceFilter(1, INFO_ALL);
        listeners.add(new ListenerInfo(traceListener, new TraceFilter(1, INFO_ALL), object));
        Trace.updateSelected(1, INFO_ALL);
    }

    public static void addNotificationListener(NotificationListener notificationListener, NotificationFilter notificationFilter, Object object) throws IllegalArgumentException {
        TraceFilter traceFilter;
        if (notificationListener == null) {
            throw new IllegalArgumentException("A listener should be specified.");
        }
        if (notificationFilter == null) {
            traceFilter = new TraceFilter(2, INFO_ALL);
        } else if (notificationFilter instanceof TraceFilter) {
            traceFilter = (TraceFilter)notificationFilter;
        } else {
            throw new IllegalArgumentException("The filter should be an instance of the class TraceFilter.");
        }
        listeners.add(new ListenerInfo(notificationListener, traceFilter, object));
        Trace.updateSelected(traceFilter.getLevels(), traceFilter.getTypes());
    }

    private static void distribute(TraceNotification traceNotification) {
        ArrayList arrayList = listeners;
        synchronized (arrayList) {
            int n = 0;
            while (n < listeners.size()) {
                block7: {
                    ListenerInfo listenerInfo = (ListenerInfo)listeners.get(n);
                    if (listenerInfo.filter == null || listenerInfo.filter.isNotificationEnabled(traceNotification)) {
                        try {
                            listenerInfo.listener.handleNotification(traceNotification, listenerInfo.handback);
                        }
                        catch (Exception exception) {
                            Trace.removeNotificationListener(listenerInfo.listener);
                            if (!Trace.isSelected(2, 32)) break block7;
                            Trace.send(2, 32, "Trace", "distribute", exception);
                        }
                    }
                }
                ++n;
            }
        }
    }

    static String getLevel(int n) {
        String string = null;
        switch (n) {
            case 1: {
                string = "LEVEL_TRACE";
                break;
            }
            case 2: {
                string = "LEVEL_DEBUG";
                break;
            }
            default: {
                string = "Unkown level";
            }
        }
        return string;
    }

    private static long getSeq(int n) {
        long l;
        Integer n2 = new Integer(n);
        Long l2 = (Long)type_seq.get(n2);
        if (l2 == null) {
            l2 = new Long(0L);
            type_seq.put(n2, l2);
        }
        l = (l = l2.longValue()) == Long.MAX_VALUE ? 1L : ++l;
        type_seq.put(n2, new Long(l));
        return l;
    }

    static String getType(int n) {
        String string = "";
        switch (n) {
            case 16: {
                string = "INFO_ADAPTOR_HTML";
                break;
            }
            case 4096: {
                string = "INFO_DISCOVERY";
                break;
            }
            case 1: {
                string = "INFO_MBEANSERVER";
                break;
            }
            case 2: {
                string = "INFO_MLET";
                break;
            }
            case 4: {
                string = "INFO_MONITOR";
                break;
            }
            case 8: {
                string = "INFO_TIMER";
                break;
            }
            case 32: {
                string = "INFO_MISC";
                break;
            }
            case 3856: {
                string = "INFO_ADAPTOR_CONNECTOR";
                break;
            }
            case 256: {
                string = "INFO_CONNECTOR_RMI";
                break;
            }
            case 512: {
                string = "INFO_CONNECTOR_HTTP";
                break;
            }
            case 2048: {
                string = "INFO_CONNECTOR_HTTPS";
                break;
            }
            case 1024: {
                string = "INFO_ADAPTOR_SNMP";
                break;
            }
            case 64: {
                string = "INFO_SNMP";
                break;
            }
            case 128: {
                string = "INFO_NOTIFICATION";
                break;
            }
            case 8192: {
                string = "INFO_HEARTBEAT";
                break;
            }
            case 16384: {
                string = "INFO_RELATION";
                break;
            }
            case 32768: {
                string = "INFO_MODELMBEAN";
                break;
            }
        }
        return string;
    }

    public static boolean isSelected(int n, int n2) {
        boolean bl = false;
        bl = n == 1 && selectedLevels != 0 ? true : (selectedLevels & n) != 0;
        return bl &= (selectedTypes & n2) != 0;
    }

    public static void parseTraceProperties() throws IOException {
        int n = 0;
        int n2 = 0;
        Properties properties = System.getProperties();
        String string = properties.getProperty("TRACE_OUTPUT");
        if (properties.getProperty("LEVEL_TRACE") != null) {
            n |= 1;
        }
        if (properties.getProperty("LEVEL_DEBUG") != null) {
            n |= 2;
        }
        if (properties.getProperty("INFO_ADAPTOR_HTML") != null) {
            n2 |= 0x10;
        }
        if (properties.getProperty("INFO_CONNECTOR_HTTP") != null) {
            n2 |= 0x200;
        }
        if (properties.getProperty("INFO_CONNECTOR_HTTPS") != null) {
            n2 |= 0x800;
        }
        if (properties.getProperty("INFO_CONNECTOR_RMI") != null) {
            n2 |= 0x100;
        }
        if (properties.getProperty("INFO_ADAPTOR_SNMP") != null) {
            n2 |= 0x400;
        }
        if (properties.getProperty("INFO_ADAPTOR_CONNECTOR") != null) {
            n2 |= 0xF10;
        }
        if (properties.getProperty("INFO_DISCOVERY") != null) {
            n2 |= 0x1000;
        }
        if (properties.getProperty("INFO_MBEANSERVER") != null) {
            n2 |= 1;
        }
        if (properties.getProperty("INFO_MLET") != null) {
            n2 |= 2;
        }
        if (properties.getProperty("INFO_SNMP") != null) {
            n2 |= 0x40;
        }
        if (properties.getProperty("INFO_MONITOR") != null) {
            n2 |= 4;
        }
        if (properties.getProperty("INFO_TIMER") != null) {
            n2 |= 8;
        }
        if (properties.getProperty("INFO_NOTIFICATION") != null) {
            n2 |= 0x80;
        }
        if (properties.getProperty("INFO_HEARTBEAT") != null) {
            n2 |= 0x2000;
        }
        if (properties.getProperty("INFO_RELATION") != null) {
            n2 |= 0x4000;
        }
        if (properties.getProperty("INFO_MODELMBEAN") != null) {
            n2 |= 0x8000;
        }
        if (properties.getProperty("INFO_MISC") != null) {
            n2 |= 0x20;
        }
        if (properties.getProperty("INFO_ALL") != null) {
            n2 = INFO_ALL;
        }
        if (string != null || n != 0 || n2 != 0) {
            if (n == 0) {
                n = 1;
            }
            if (n2 == 0) {
                n2 = INFO_ALL;
            }
            TraceFilter traceFilter = new TraceFilter(n, n2);
            Trace.removeNotificationListener(traceListener);
            traceListener = string != null && !string.equals("") ? new TraceListener(string) : new TraceListener();
            Trace.addNotificationListener(traceListener, traceFilter, null);
        }
    }

    public static void removeAllListeners() {
        listeners.clear();
        selectedLevels = 0;
        selectedTypes = 0;
    }

    public static void removeNotificationListener(NotificationListener notificationListener) {
        ListenerInfo listenerInfo;
        int n;
        ArrayList arrayList = listeners;
        synchronized (arrayList) {
            n = 0;
            while (n < listeners.size()) {
                listenerInfo = (ListenerInfo)listeners.get(n);
                if (listenerInfo.listener == notificationListener) {
                    listeners.remove(n);
                    break;
                }
                ++n;
            }
        }
        arrayList = listeners;
        synchronized (arrayList) {
            n = 0;
            while (n < listeners.size()) {
                listenerInfo = (ListenerInfo)listeners.get(n);
                Trace.updateSelected(listenerInfo.filter.getLevels(), listenerInfo.filter.getTypes());
                ++n;
            }
        }
    }

    static boolean selectedCheck(int n, int n2) {
        boolean bl = n == 1 || n == 2 || n == 3;
        return bl &= (n2 | INFO_ALL) == INFO_ALL;
    }

    public static boolean send(int n, int n2, String string, String string2, String string3) {
        if (!Trace.isSelected(n, n2)) {
            return false;
        }
        TraceNotification traceNotification = new TraceNotification("Trace", Trace.getSeq(n2), Trace.getSeq(0), n, n2, string, string2, string3, null);
        Trace.distribute(traceNotification);
        return true;
    }

    public static boolean send(int n, int n2, String string, String string2, Throwable throwable) {
        if (!Trace.isSelected(n, n2)) {
            return false;
        }
        TraceNotification traceNotification = new TraceNotification("Trace", Trace.getSeq(n2), Trace.getSeq(0), n, n2, string, string2, null, throwable);
        Trace.distribute(traceNotification);
        return true;
    }

    private static void updateSelected(int n, int n2) {
        selectedLevels |= n;
        selectedTypes |= n2;
    }

    private static class ListenerInfo {
        public NotificationListener listener;
        public TraceFilter filter;
        public Object handback;

        public ListenerInfo(NotificationListener notificationListener, TraceFilter traceFilter, Object object) {
            this.listener = notificationListener;
            this.filter = traceFilter;
            this.handback = object;
        }
    }
}

