/*
 * Decompiled with CFR 0.152.
 */
package com.sun.dhcpmgr.client;

import com.sun.dhcpmgr.client.DataManager;
import com.sun.dhcpmgr.client.MultipleOperationDialog;
import com.sun.dhcpmgr.client.ResourceStrings;
import com.sun.dhcpmgr.data.DhcpClientRecord;
import com.sun.dhcpmgr.server.DhcpNetMgr;
import com.sun.dhcpmgr.ui.ExtendedCellRenderer;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Frame;
import java.util.Date;
import javax.swing.BorderFactory;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.table.AbstractTableModel;

public class ReleaseAddressDialog
extends MultipleOperationDialog {
    private DhcpClientRecord[] recs;
    private String table;
    boolean showAddresses;
    static /* synthetic */ Class class$java$util$Date;
    static /* synthetic */ Class class$com$sun$dhcpmgr$data$IPAddress;
    static /* synthetic */ Class class$java$lang$String;
    static /* synthetic */ Class class$java$lang$Object;

    public ReleaseAddressDialog(Frame frame, DhcpClientRecord[] dhcpClientRecordArray, String string, boolean bl) {
        super(frame, false);
        this.recs = dhcpClientRecordArray;
        this.table = string;
        this.showAddresses = bl;
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    protected void fireActionPerformed() {
        this.fireActionPerformed(this, "ok");
    }

    protected Class getErrorClass() {
        return class$com$sun$dhcpmgr$data$IPAddress != null ? class$com$sun$dhcpmgr$data$IPAddress : (class$com$sun$dhcpmgr$data$IPAddress = ReleaseAddressDialog.class$("com.sun.dhcpmgr.data.IPAddress"));
    }

    protected String getErrorHeading() {
        return ResourceStrings.getString("address_column");
    }

    protected String getHelpKey() {
        return "release_addresses";
    }

    protected JPanel getMainPanel() {
        JPanel jPanel = new JPanel(new BorderLayout(10, 10));
        jPanel.setBorder(BorderFactory.createEmptyBorder(10, 10, 10, 10));
        JLabel jLabel = new JLabel(ResourceStrings.getString("release_address_confirm"));
        jPanel.add((Component)jLabel, "North");
        JTable jTable = new JTable(new AddressTableModel());
        JScrollPane jScrollPane = new JScrollPane(jTable);
        Dimension dimension = jTable.getPreferredScrollableViewportSize();
        dimension.height = 100;
        jTable.setPreferredScrollableViewportSize(dimension);
        ExtendedCellRenderer extendedCellRenderer = new ExtendedCellRenderer();
        jTable.setDefaultRenderer(class$java$util$Date != null ? class$java$util$Date : (class$java$util$Date = ReleaseAddressDialog.class$("java.util.Date")), extendedCellRenderer);
        jTable.setDefaultRenderer(class$com$sun$dhcpmgr$data$IPAddress != null ? class$com$sun$dhcpmgr$data$IPAddress : (class$com$sun$dhcpmgr$data$IPAddress = ReleaseAddressDialog.class$("com.sun.dhcpmgr.data.IPAddress")), extendedCellRenderer);
        jPanel.add((Component)jScrollPane, "Center");
        this.buttonPanel.setOkEnabled(true);
        return jPanel;
    }

    protected Thread getOperationThread() {
        return new Thread(){

            public void run() {
                DhcpNetMgr dhcpNetMgr = DataManager.get().getDhcpNetMgr();
                int n = 0;
                while (n < ReleaseAddressDialog.this.recs.length) {
                    DhcpClientRecord dhcpClientRecord = (DhcpClientRecord)ReleaseAddressDialog.this.recs[n].clone();
                    Date date = new Date(0L);
                    try {
                        dhcpClientRecord.setClientId(DhcpClientRecord.DEFAULT_CLIENT_ID);
                        dhcpClientRecord.setFlags(DhcpClientRecord.DEFAULT_FLAGS);
                        dhcpClientRecord.setExpiration(date);
                        dhcpNetMgr.modifyClient(ReleaseAddressDialog.this.recs[n], dhcpClientRecord, ReleaseAddressDialog.this.table);
                        ReleaseAddressDialog.this.updateProgress(n + 1, ReleaseAddressDialog.this.recs[n].getClientIPAddress());
                    }
                    catch (InterruptedException interruptedException) {
                        ReleaseAddressDialog.this.closeDialog();
                        return;
                    }
                    catch (Throwable throwable) {
                        ReleaseAddressDialog.this.addError(ReleaseAddressDialog.this.recs[n].getClientIP(), throwable.getMessage());
                    }
                    ++n;
                }
                if (ReleaseAddressDialog.this.errorsOccurred()) {
                    ReleaseAddressDialog.this.displayErrors(ResourceStrings.getString("release_address_error"));
                }
                ReleaseAddressDialog.this.closeDialog();
            }
        };
    }

    protected int getProgressLength() {
        return this.recs.length;
    }

    protected String getProgressMessage() {
        return ResourceStrings.getString("release_addr_progress");
    }

    public String getTitle() {
        return ResourceStrings.getString("release_address_title");
    }

    class AddressTableModel
    extends AbstractTableModel {
        AddressTableModel() {
        }

        public Class getColumnClass(int n) {
            switch (n) {
                case 0: {
                    if (ReleaseAddressDialog.this.showAddresses) {
                        return class$com$sun$dhcpmgr$data$IPAddress != null ? class$com$sun$dhcpmgr$data$IPAddress : (class$com$sun$dhcpmgr$data$IPAddress = ReleaseAddressDialog.class$("com.sun.dhcpmgr.data.IPAddress"));
                    }
                    return class$java$lang$String != null ? class$java$lang$String : (class$java$lang$String = ReleaseAddressDialog.class$("java.lang.String"));
                }
                case 1: {
                    return class$java$lang$String != null ? class$java$lang$String : (class$java$lang$String = ReleaseAddressDialog.class$("java.lang.String"));
                }
                case 2: {
                    return class$java$util$Date != null ? class$java$util$Date : (class$java$util$Date = ReleaseAddressDialog.class$("java.util.Date"));
                }
            }
            return class$java$lang$Object != null ? class$java$lang$Object : (class$java$lang$Object = ReleaseAddressDialog.class$("java.lang.Object"));
        }

        public int getColumnCount() {
            return 3;
        }

        public String getColumnName(int n) {
            switch (n) {
                case 0: {
                    if (ReleaseAddressDialog.this.showAddresses) {
                        return ResourceStrings.getString("address_column");
                    }
                    return ResourceStrings.getString("client_name_column");
                }
                case 1: {
                    return ResourceStrings.getString("client_column");
                }
                case 2: {
                    return ResourceStrings.getString("expires_column");
                }
            }
            return null;
        }

        public int getRowCount() {
            if (ReleaseAddressDialog.this.recs == null) {
                return 0;
            }
            return ReleaseAddressDialog.this.recs.length;
        }

        public Object getValueAt(int n, int n2) {
            switch (n2) {
                case 0: {
                    if (ReleaseAddressDialog.this.showAddresses) {
                        return ReleaseAddressDialog.this.recs[n].getClientIP();
                    }
                    return ReleaseAddressDialog.this.recs[n].getClientName();
                }
                case 1: {
                    return ReleaseAddressDialog.this.recs[n].getClientId();
                }
                case 2: {
                    return ReleaseAddressDialog.this.recs[n].getExpiration();
                }
            }
            return null;
        }
    }
}

