/*
 * Decompiled with CFR 0.152.
 */
package com.sun.management.viperimpl.services.authentication.client;

import com.sun.management.viper.util.Debug;
import com.sun.management.viperimpl.services.authentication.AuthenticationRequest;
import com.sun.management.viperimpl.services.authentication.client.ClientSecurityContext;
import com.sun.management.viperimpl.util.TimerTask;

public class HeartbeatTask
extends TimerTask {
    private AuthenticationRequest requester;
    private ClientSecurityContext csc;

    public HeartbeatTask(AuthenticationRequest authenticationRequest, ClientSecurityContext clientSecurityContext) {
        if (authenticationRequest == null || clientSecurityContext == null) {
            throw new IllegalArgumentException("null parameter");
        }
        this.requester = authenticationRequest;
        this.csc = clientSecurityContext;
    }

    public void run() {
        if (this.csc.getAuthState() == 4 && this.csc.getHeartbeatPeriod() > 0L) {
            try {
                this.requester.authRequest("heartbeat", this.csc.generateMessageToken(null));
                return;
            }
            catch (Throwable throwable) {
                Debug.trace((String)"Authentication Client", (int)Debug.ERROR, (String)"Heart beat exception", (Throwable)throwable);
            }
        }
        this.cancel();
    }
}

