/*
 * Decompiled with CFR 0.152.
 */
package com.sun.management.viperimpl;

import com.sun.management.viper.ComponentInfo;
import com.sun.management.viper.ToolInfo;
import com.sun.management.viperimpl.LibInfoImpl;
import com.sun.management.viperimpl.server.repository.VRegistry;
import java.util.Date;
import java.util.Properties;

public class ToolInfoImpl
extends LibInfoImpl
implements Cloneable,
ToolInfo {
    private String classname = null;
    private String helpBase = null;
    private String APIversion = "0.0";
    private String[] parameterList = null;
    private String[] scopeList = null;
    private String[] contextList = null;
    private String[] prefConfigTypes = null;
    private Date editDate = null;
    private LibInfoImpl[] attachments = null;

    public ToolInfoImpl(ToolInfo toolInfo) {
        super((ComponentInfo)toolInfo);
        if (toolInfo == null) {
            return;
        }
        this.classname = toolInfo.getClassName();
        this.helpBase = toolInfo.getHelpBaseName();
        this.APIversion = toolInfo.getAPIVersion();
        this.parameterList = toolInfo.getParameterList();
        this.scopeList = toolInfo.getSupportedScopes();
        this.contextList = toolInfo.getSupportedContexts();
        this.prefConfigTypes = toolInfo.getPreferredConfigTypes();
        if (toolInfo instanceof ToolInfoImpl) {
            this.editDate = ((ToolInfoImpl)toolInfo).getEditDate();
            this.attachments = ((ToolInfoImpl)toolInfo).getAttachments();
        }
        if (this.editDate == null) {
            this.editDate = new Date();
        }
        if (this.getJarName() == null) {
            this.setJarName(VRegistry.toJarName((int)1, (String)this.classname));
        }
    }

    public ToolInfoImpl(String string, String string2, String string3, String string4, String string5, String[] stringArray, Properties properties, String[] stringArray2, String[] stringArray3, String[] stringArray4, String string6) {
        super(string4, string2, properties, string6);
        this.classname = string;
        this.helpBase = string3;
        this.APIversion = string5;
        this.parameterList = stringArray;
        this.scopeList = stringArray2;
        this.contextList = stringArray3;
        this.prefConfigTypes = stringArray4;
        this.setJarName(VRegistry.toJarName((int)1, (String)string));
        this.setComponentType(1);
        this.attachments = new LibInfoImpl[0];
        this.editDate = new Date();
    }

    public synchronized Object clone() {
        return new ToolInfoImpl(this);
    }

    public String getAPIVersion() {
        return this.APIversion;
    }

    public LibInfoImpl[] getAttachments() {
        return this.attachments;
    }

    public String getClassName() {
        return this.classname;
    }

    public Date getEditDate() {
        return this.editDate;
    }

    public String getHelpBaseName() {
        return this.helpBase;
    }

    public String[] getJarPaths() {
        String[] stringArray = new String[1 + this.attachments.length];
        stringArray[0] = this.getJarPath();
        int n = 0;
        while (n < this.attachments.length) {
            stringArray[1 + n] = this.attachments[n].getJarPath();
            ++n;
        }
        return stringArray;
    }

    public String[] getParameterList() {
        return this.parameterList;
    }

    public String[] getPreferredConfigTypes() {
        return this.prefConfigTypes;
    }

    public String[] getSupportedContexts() {
        return this.contextList;
    }

    public String[] getSupportedScopes() {
        return this.scopeList;
    }

    public void setAttachments(LibInfoImpl[] libInfoImplArray) {
        this.attachments = libInfoImplArray != null ? libInfoImplArray : new LibInfoImpl[]{};
        this.editDate = new Date();
    }

    public String toString() {
        return "Tool info:\n\timpl-class=" + this.getClassName() + "\n\thelp-base=" + this.getHelpBaseName() + "\n\tapi-version=" + this.getAPIVersion() + "\n\tparam-list=" + this.printArray(this.getParameterList()) + "\n\tsupported-scopes=" + this.printArray(this.getSupportedScopes()) + "\n\tsupported-contexts=" + this.printArray(this.getSupportedContexts()) + "\n\tpreferred-configs=" + this.printArray(this.getPreferredConfigTypes()) + "\n" + "\n\tlast-modified=" + this.getEditDate() + "\n\tattachments=" + this.printArray(this.getAttachments()) + "\n" + super.toString();
    }
}

