/*
 * Decompiled with CFR 0.152.
 */
package com.sun.dhcpmgr.client;

import com.sun.dhcpmgr.client.CreateMacroDialog;
import com.sun.dhcpmgr.client.DeleteMacroDialog;
import com.sun.dhcpmgr.client.DhcpmgrApplet;
import com.sun.dhcpmgr.client.MacroLoader;
import com.sun.dhcpmgr.client.ResourceStrings;
import com.sun.dhcpmgr.data.IncludeOptionValue;
import com.sun.dhcpmgr.data.Macro;
import com.sun.dhcpmgr.data.OptionValue;
import com.sun.dhcpmgr.data.ValidationException;
import com.sun.dhcpmgr.ui.AutosizingTable;
import com.sun.dhcpmgr.ui.MainFrame;
import com.sun.dhcpmgr.ui.SelectionListener;
import com.sun.dhcpmgr.ui.View;
import java.awt.Component;
import java.awt.Frame;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.text.MessageFormat;
import java.util.Enumeration;
import java.util.Vector;
import javax.swing.JCheckBoxMenuItem;
import javax.swing.JList;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.JScrollPane;
import javax.swing.JSplitPane;
import javax.swing.JTree;
import javax.swing.SwingUtilities;
import javax.swing.event.TreeSelectionEvent;
import javax.swing.event.TreeSelectionListener;
import javax.swing.table.AbstractTableModel;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.DefaultTreeModel;
import javax.swing.tree.TreeNode;
import javax.swing.tree.TreePath;

public class MacroView
implements View {
    private JTree macroTree;
    protected static MacroTreeModel macroTreeModel = null;
    private AutosizingTable macroTable;
    private JScrollPane treePane;
    private JScrollPane macroTablePane;
    private JSplitPane splitPane;
    private boolean firstActivation = true;
    private MacroTableModel macroTableModel;
    private JCheckBoxMenuItem showGrid;
    private JMenuItem macroHelp;
    private Vector[] menuItems;
    private Frame myFrame;
    private boolean firstview = true;
    private Vector selectionListeners = new Vector();
    static /* synthetic */ Class class$java$lang$String;

    public MacroView() {
        macroTreeModel = new MacroTreeModel(new MacroTreeRootNode());
        this.macroTree = new JTree(macroTreeModel);
        this.macroTree.addTreeSelectionListener(new TreeSelectionListener(){

            public void valueChanged(TreeSelectionEvent treeSelectionEvent) {
                TreePath treePath = MacroView.this.macroTree.getSelectionPath();
                if (treePath != null) {
                    TreeNode treeNode = (TreeNode)treePath.getLastPathComponent();
                    if (treeNode instanceof MacroTreeNode) {
                        MacroView.this.macroTableModel.display(((MacroTreeNode)treeNode).getMacro());
                    } else {
                        MacroView.this.macroTableModel.display(null);
                    }
                } else {
                    MacroView.this.macroTableModel.display(null);
                }
                MacroView.this.notifySelectionListeners();
            }
        });
        this.macroTree.getSelectionModel().setSelectionMode(1);
        this.treePane = new JScrollPane();
        this.treePane.getViewport().add(this.macroTree);
        this.macroTree.addMouseListener(new MouseAdapter(){

            public void mouseClicked(MouseEvent mouseEvent) {
                if (mouseEvent.getClickCount() == 2) {
                    TreePath treePath = MacroView.this.macroTree.getClosestPathForLocation(mouseEvent.getX(), mouseEvent.getY());
                    MacroView.this.macroTree.addSelectionPath(treePath);
                    if (treePath.getPathCount() != 1) {
                        MacroView.this.handleProperties();
                    }
                }
            }
        });
        this.macroTableModel = new MacroTableModel();
        this.macroTable = new AutosizingTable(this.macroTableModel);
        this.macroTable.getTableHeader().setReorderingAllowed(false);
        this.macroTable.setRowSelectionAllowed(false);
        this.macroTable.setColumnSelectionAllowed(false);
        this.macroTablePane = new JScrollPane(this.macroTable);
        this.splitPane = new JSplitPane(1, this.treePane, this.macroTablePane);
        this.showGrid = new JCheckBoxMenuItem(ResourceStrings.getString("show_grid"), true);
        this.showGrid.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                MacroView.this.macroTable.setShowGrid(MacroView.this.showGrid.getState());
            }
        });
        this.macroHelp = new JMenuItem(ResourceStrings.getString("on_macros_item"));
        this.macroHelp.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                DhcpmgrApplet.showHelp("macros_reference");
            }
        });
        this.menuItems = new Vector[5];
        int n = 0;
        while (n < this.menuItems.length) {
            this.menuItems[n] = new Vector();
            ++n;
        }
        this.menuItems[2].addElement(this.showGrid);
        this.menuItems[4].addElement(this.macroHelp);
    }

    public void addSelectionListener(SelectionListener selectionListener) {
        this.selectionListeners.addElement(selectionListener);
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    public void find(String string) {
        MacroTreeNode macroTreeNode;
        MainFrame.setStatusText("");
        MacroTreeNode macroTreeNode2 = (MacroTreeNode)this.macroTree.getLastSelectedPathComponent();
        if (macroTreeNode2 == null) {
            macroTreeNode2 = macroTreeModel.getRootNode();
        }
        if ((macroTreeNode = this.searchUnderNode(macroTreeNode2, string)) != null) {
            this.selectNode(macroTreeNode);
            return;
        }
        TreeNode[] treeNodeArray = macroTreeModel.getPathToRoot(macroTreeNode2);
        MacroTreeNode macroTreeNode3 = null;
        int n = treeNodeArray.length - 1;
        while (n >= 0) {
            macroTreeNode = this.searchNodeLevel((MacroTreeNode)treeNodeArray[n], macroTreeNode2, string);
            if (macroTreeNode != null) {
                this.selectNode(macroTreeNode);
                return;
            }
            macroTreeNode2 = (MacroTreeNode)treeNodeArray[n];
            if (macroTreeNode2.getMacro() != null && macroTreeNode2.getMacro().getKey().indexOf(string) != -1) {
                macroTreeNode3 = macroTreeNode2;
            }
            --n;
        }
        if (macroTreeNode3 != null) {
            this.selectNode(macroTreeNode3);
            return;
        }
        MessageFormat messageFormat = null;
        Object[] objectArray = new Object[1];
        messageFormat = new MessageFormat(ResourceStrings.getString("find_macro_error"));
        objectArray[0] = string;
        MainFrame.setStatusText(messageFormat.format(objectArray));
    }

    public Component getDisplay() {
        return this.splitPane;
    }

    public String getName() {
        return ResourceStrings.getString("macro_view_name");
    }

    private Macro getSelectedMacro() {
        TreeNode treeNode;
        TreePath treePath = this.macroTree.getSelectionPath();
        if (treePath != null && (treeNode = (TreeNode)treePath.getLastPathComponent()) instanceof MacroTreeNode) {
            return ((MacroTreeNode)treeNode).getMacro();
        }
        return null;
    }

    public void handleCreate() {
        CreateMacroDialog createMacroDialog = new CreateMacroDialog(this.myFrame, 0);
        createMacroDialog.addActionListener(new DialogListener());
        createMacroDialog.pack();
        createMacroDialog.show();
    }

    public void handleDelete() {
        Macro macro = this.getSelectedMacro();
        if (macro == null) {
            return;
        }
        DeleteMacroDialog deleteMacroDialog = new DeleteMacroDialog(this.myFrame, macro);
        deleteMacroDialog.addActionListener(new DialogListener());
        deleteMacroDialog.pack();
        deleteMacroDialog.show();
    }

    public void handleDuplicate() {
        Macro macro = this.getSelectedMacro();
        if (macro == null) {
            return;
        }
        CreateMacroDialog createMacroDialog = new CreateMacroDialog(this.myFrame, 2);
        createMacroDialog.addActionListener(new DialogListener());
        createMacroDialog.setMacro((Macro)macro.clone());
        createMacroDialog.pack();
        createMacroDialog.show();
    }

    public void handleProperties() {
        Macro macro = this.getSelectedMacro();
        if (macro == null) {
            return;
        }
        CreateMacroDialog createMacroDialog = new CreateMacroDialog(this.myFrame, 1);
        createMacroDialog.addActionListener(new DialogListener());
        createMacroDialog.setMacro((Macro)macro.clone());
        createMacroDialog.pack();
        createMacroDialog.show();
    }

    public void handleUpdate() {
        this.reload();
    }

    public boolean isSelectionEmpty() {
        TreePath treePath = this.macroTree.getSelectionPath();
        return treePath == null || treePath.getPathCount() == 1;
    }

    public boolean isSelectionMultiple() {
        return false;
    }

    public Enumeration menuItems(int n) {
        return this.menuItems[n].elements();
    }

    public Enumeration menus() {
        return null;
    }

    private void notifySelectionListeners() {
        Enumeration enumeration = this.selectionListeners.elements();
        while (enumeration.hasMoreElements()) {
            SelectionListener selectionListener = (SelectionListener)enumeration.nextElement();
            selectionListener.valueChanged();
        }
    }

    private void reload() {
        macroTreeModel.load();
    }

    private void reloadCompleted() {
        this.splitPane.resetToPreferredSizes();
        Object[] objectArray = new Integer[]{new Integer(macroTreeModel.getRootNode().getChildCount())};
        String string = MessageFormat.format(ResourceStrings.getString("macro_status_message"), objectArray);
        MainFrame.setStatusText(string);
        this.macroTree.clearSelection();
        this.macroTable.clearSelection();
        MacroTreeRootNode macroTreeRootNode = macroTreeModel.getRootNode();
        Vector<String> vector = new Vector<String>();
        int n = 0;
        while (n < macroTreeRootNode.macros.length) {
            try {
                macroTreeRootNode.macros[n].validate();
            }
            catch (ValidationException validationException) {
                vector.addElement(macroTreeRootNode.macros[n].getKey());
            }
            ++n;
        }
        if (vector.size() != 0) {
            Object[] objectArray2 = new Object[2];
            objectArray2[0] = ResourceStrings.getString("macro_validation_warning");
            JList jList = new JList(vector);
            JScrollPane jScrollPane = new JScrollPane(jList);
            jList.setVisibleRowCount(4);
            objectArray2[1] = jScrollPane;
            JOptionPane.showMessageDialog(this.macroTable, objectArray2, ResourceStrings.getString("warning"), 2);
        }
        this.macroTree.setSelectionRow(1);
    }

    public void removeSelectionListener(SelectionListener selectionListener) {
        this.selectionListeners.removeElement(selectionListener);
    }

    private MacroTreeNode searchNode(MacroTreeNode macroTreeNode, String string) {
        if (macroTreeNode.getMacro().getKey().indexOf(string) != -1 || macroTreeNode.getMacro().getValue().indexOf(string) != -1) {
            return macroTreeNode;
        }
        return this.searchUnderNode(macroTreeNode, string);
    }

    private MacroTreeNode searchNodeLevel(MacroTreeNode macroTreeNode, MacroTreeNode macroTreeNode2, String string) {
        MacroTreeNode macroTreeNode3;
        MacroTreeNode macroTreeNode4;
        Enumeration<TreeNode> enumeration = macroTreeNode.children();
        while (enumeration.hasMoreElements()) {
            macroTreeNode4 = (MacroTreeNode)enumeration.nextElement();
            if (macroTreeNode4 == macroTreeNode2) break;
        }
        while (enumeration.hasMoreElements()) {
            macroTreeNode4 = (MacroTreeNode)enumeration.nextElement();
            macroTreeNode3 = this.searchNode(macroTreeNode4, string);
            if (macroTreeNode3 == null) continue;
            return macroTreeNode3;
        }
        enumeration = macroTreeNode.children();
        while (enumeration.hasMoreElements()) {
            macroTreeNode4 = (MacroTreeNode)enumeration.nextElement();
            if (macroTreeNode4 == macroTreeNode2) break;
            macroTreeNode3 = this.searchNode(macroTreeNode4, string);
            if (macroTreeNode3 == null) continue;
            return macroTreeNode3;
        }
        return null;
    }

    private MacroTreeNode searchUnderNode(MacroTreeNode macroTreeNode, String string) {
        Enumeration<TreeNode> enumeration = macroTreeNode.children();
        while (enumeration.hasMoreElements()) {
            MacroTreeNode macroTreeNode2 = (MacroTreeNode)enumeration.nextElement();
            if (macroTreeNode2.getMacro().getKey().indexOf(string) != -1 || macroTreeNode2.getMacro().getValue().indexOf(string) != -1) {
                return macroTreeNode2;
            }
            MacroTreeNode macroTreeNode3 = this.searchUnderNode(macroTreeNode2, string);
            if (macroTreeNode3 == null) continue;
            return macroTreeNode3;
        }
        return null;
    }

    private void selectNode(MacroTreeNode macroTreeNode) {
        this.macroTree.clearSelection();
        TreePath treePath = new TreePath(macroTreeModel.getPathToRoot(macroTreeNode));
        this.macroTree.addSelectionPath(treePath);
        this.macroTree.scrollPathToVisible(treePath);
    }

    public void setActive(boolean bl) {
        if (bl && this.firstview) {
            try {
                this.myFrame = (Frame)SwingUtilities.getAncestorOfClass(Class.forName("com.sun.dhcpmgr.ui.MainFrame"), this.macroTree);
            }
            catch (ClassNotFoundException classNotFoundException) {
                this.myFrame = null;
            }
            this.reload();
            this.firstview = false;
        }
    }

    class MacroTreeNode
    extends DefaultMutableTreeNode {
        private boolean scannedIncludes = false;
        private boolean isScanning = false;

        public MacroTreeNode(Object object) {
            super(object);
        }

        public int getChildCount() {
            if (!this.scannedIncludes && !this.isScanning) {
                this.isScanning = true;
                Macro macro = (Macro)this.getUserObject();
                Enumeration enumeration = macro.elements();
                while (enumeration.hasMoreElements()) {
                    Macro macro2;
                    OptionValue optionValue = (OptionValue)enumeration.nextElement();
                    if (!(optionValue instanceof IncludeOptionValue) || (macro2 = macroTreeModel.getRootNode().getMacro(optionValue.getValue())) == null) continue;
                    this.add(new MacroTreeNode(macro2));
                }
                this.scannedIncludes = true;
                this.isScanning = false;
            }
            return super.getChildCount();
        }

        public Macro getMacro() {
            return (Macro)this.getUserObject();
        }

        public String toString() {
            Macro macro = (Macro)this.getUserObject();
            return macro.getKey();
        }
    }

    class MacroTreeRootNode
    extends MacroTreeNode {
        private Macro[] macros = null;

        public MacroTreeRootNode() {
            super(new Macro());
        }

        public MacroTreeRootNode(Object object) {
            super(object);
        }

        public int getChildCount() {
            if (this.macros == null) {
                return 0;
            }
            return super.getChildCount();
        }

        public Macro getMacro() {
            return null;
        }

        public Macro getMacro(String string) {
            if (this.macros != null) {
                int n = 0;
                while (n < this.macros.length) {
                    if (string.equals(this.macros[n].getKey())) {
                        return this.macros[n];
                    }
                    ++n;
                }
            }
            return null;
        }

        public void load() {
            MainFrame.setStatusText(ResourceStrings.getString("loading_macros"));
            this.removeAllChildren();
            macroTreeModel.reload();
            MacroLoader macroLoader = new MacroLoader();
        }

        protected void setMacros(Macro[] macroArray) {
            this.macros = macroArray;
            if (macroArray != null) {
                int n = 0;
                while (n < this.macros.length) {
                    this.add(new MacroTreeNode(this.macros[n]));
                    ++n;
                }
            }
            macroTreeModel.reload();
            MacroView.this.reloadCompleted();
        }

        public String toString() {
            return ResourceStrings.getString("macros");
        }
    }

    class MacroTreeModel
    extends DefaultTreeModel {
        public MacroTreeModel(MacroTreeRootNode macroTreeRootNode) {
            super(macroTreeRootNode);
        }

        public Macro getMacro(String string) {
            return this.getRootNode().getMacro(string);
        }

        public MacroTreeRootNode getRootNode() {
            return (MacroTreeRootNode)super.getRoot();
        }

        public void load() {
            this.getRootNode().load();
        }
    }

    class MacroTableModel
    extends AbstractTableModel {
        private Macro macro = null;

        public void display(Macro macro) {
            this.macro = macro;
            this.fireTableDataChanged();
        }

        public Class getColumnClass(int n) {
            switch (n) {
                case 0: 
                case 1: {
                    return class$java$lang$String != null ? class$java$lang$String : (class$java$lang$String = MacroView.class$("java.lang.String"));
                }
            }
            super.getColumnClass(n);
            return null;
        }

        public int getColumnCount() {
            return 2;
        }

        public String getColumnName(int n) {
            switch (n) {
                case 0: {
                    return ResourceStrings.getString("option_column");
                }
                case 1: {
                    return ResourceStrings.getString("value_column");
                }
            }
            super.getColumnName(n);
            return null;
        }

        public int getRowCount() {
            if (this.macro == null) {
                return 0;
            }
            return this.macro.optionCount();
        }

        public Object getValueAt(int n, int n2) {
            if (this.macro == null) {
                return null;
            }
            switch (n2) {
                case 0: {
                    return this.macro.getOptionAt(n).getName();
                }
                case 1: {
                    return this.macro.getOptionAt(n).getValue();
                }
            }
            return null;
        }
    }

    class DialogListener
    implements ActionListener {
        DialogListener() {
        }

        public void actionPerformed(ActionEvent actionEvent) {
            if (!actionEvent.getActionCommand().equals("cancel")) {
                MacroView.this.reload();
            }
        }
    }
}

