/*
 * Decompiled with CFR 0.152.
 */
package com.sun.dhcpmgr.client;

import com.sun.dhcpmgr.bridge.BridgeException;
import com.sun.dhcpmgr.client.AddressView;
import com.sun.dhcpmgr.client.ConfigWizard;
import com.sun.dhcpmgr.client.ConfigureChoiceDialog;
import com.sun.dhcpmgr.client.ConfigureRelayDialog;
import com.sun.dhcpmgr.client.ConvertWizard;
import com.sun.dhcpmgr.client.DataManager;
import com.sun.dhcpmgr.client.DisableServiceDialog;
import com.sun.dhcpmgr.client.ExportWizard;
import com.sun.dhcpmgr.client.ImportWizard;
import com.sun.dhcpmgr.client.MacroView;
import com.sun.dhcpmgr.client.OptionView;
import com.sun.dhcpmgr.client.RelayView;
import com.sun.dhcpmgr.client.ResourceStrings;
import com.sun.dhcpmgr.client.ServerOptionsDialog;
import com.sun.dhcpmgr.client.UnconfigureDialog;
import com.sun.dhcpmgr.data.DhcpdOptions;
import com.sun.dhcpmgr.server.DhcpServiceMgr;
import com.sun.dhcpmgr.ui.HelpIds;
import com.sun.dhcpmgr.ui.MainFrame;
import java.applet.AppletContext;
import java.awt.Component;
import java.awt.Frame;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.io.IOException;
import java.net.URL;
import java.text.MessageFormat;
import javax.swing.AbstractAction;
import javax.swing.JApplet;
import javax.swing.JButton;
import javax.swing.JOptionPane;
import javax.swing.SwingUtilities;

public class DhcpmgrApplet
extends JApplet {
    private static MainFrame frame = null;
    private JButton button;
    public static boolean modeIsRelay;
    private static HelpIds helpIds;
    private static URL docBase;
    private static AppletContext appletContext;
    private AddressView addressView;
    private RestartAction restartAction;
    private StopAction stopAction;
    private StartAction startAction;
    private DisableAction disableAction;
    private EnableAction enableAction;

    static {
        helpIds = null;
        docBase = null;
        appletContext = null;
    }

    static /* synthetic */ EnableAction access$7(DhcpmgrApplet dhcpmgrApplet) {
        return dhcpmgrApplet.enableAction;
    }

    static /* synthetic */ DisableAction access$8(DhcpmgrApplet dhcpmgrApplet) {
        return dhcpmgrApplet.disableAction;
    }

    private void createFrame() {
        if (frame == null) {
            frame = new MainFrame(ResourceStrings.getString("dhcp_manager"));
            if (modeIsRelay) {
                frame.addView(new RelayView(), true);
            } else {
                this.addressView = new AddressView();
                frame.addView(this.addressView, true);
                frame.addView(new MacroView(), false);
                frame.addView(new OptionView(), false);
            }
            this.restartAction = new RestartAction();
            frame.addMenuAction(3, this.restartAction);
            this.stopAction = new StopAction();
            frame.addMenuAction(3, this.stopAction);
            this.startAction = new StartAction();
            frame.addMenuAction(3, this.startAction);
            this.disableAction = new DisableAction();
            frame.addMenuAction(3, this.disableAction);
            this.enableAction = new EnableAction();
            frame.addMenuAction(3, this.enableAction);
            frame.addMenuAction(3, new ModifyServiceAction());
            if (!modeIsRelay) {
                frame.addMenuAction(3, new ExportAction());
                frame.addMenuAction(3, new ImportAction());
                frame.addMenuAction(3, new ConvertAction());
            }
            frame.addMenuAction(3, new UnconfigureServiceAction());
            frame.addMenuAction(4, new OverviewAction());
            frame.addMenuAction(4, new HowToAction());
            frame.addMenuAction(4, new IndexAction());
            frame.addMenuAction(4, new ServiceAction());
            if (modeIsRelay) {
                frame.pack();
            } else {
                ((Component)frame).setSize(800, 600);
            }
            frame.addWindowListener(new WindowAdapter(){

                public void windowClosed(WindowEvent windowEvent) {
                    frame = null;
                    DataManager.get().reset();
                    DhcpmgrApplet.this.requestExit();
                }

                public void windowClosing(WindowEvent windowEvent) {
                    this.windowClosed(windowEvent);
                }
            });
        }
    }

    public static void main(String[] stringArray) {
        if (!System.getProperty("user.name").equals("root")) {
            System.err.println(ResourceStrings.getString("err_must_be_root"));
            System.exit(0);
        }
        DhcpmgrApplet dhcpmgrApplet = new DhcpmgrApplet();
        dhcpmgrApplet.startMeUp();
    }

    private void requestExit() {
        System.exit(0);
    }

    private void showFrame() {
        if (frame == null) {
            this.createFrame();
        }
        frame.initialize();
        if (modeIsRelay) {
            frame.setMenuEnabled(1, false);
            frame.setMenuEnabled(2, false);
        }
        try {
            DhcpdOptions dhcpdOptions = DataManager.get().getDhcpServiceMgr().readDefaults();
            boolean bl = dhcpdOptions.isDaemonEnabled();
            this.enableAction.setEnabled(bl ^ true);
            this.disableAction.setEnabled(bl);
            boolean bl2 = DataManager.get().getDhcpServiceMgr().isServerRunning();
            this.restartAction.setEnabled(bl2 && bl);
            this.stopAction.setEnabled(bl2);
            this.startAction.setEnabled(!bl2 && bl);
        }
        catch (Throwable throwable) {
            this.restartAction.setEnabled(true);
            this.stopAction.setEnabled(true);
            this.startAction.setEnabled(true);
            this.enableAction.setEnabled(true);
            this.disableAction.setEnabled(true);
        }
        frame.show();
    }

    public static void showHelp(String string) {
        if (helpIds == null) {
            try {
                helpIds = new HelpIds("com.sun.dhcpmgr.client.HelpBundle");
            }
            catch (Throwable throwable) {
                JOptionPane.showMessageDialog(frame, ResourceStrings.getString("err_initializing_help"), ResourceStrings.getString("server_error_title"), 0);
                return;
            }
        }
        try {
            Runtime.getRuntime().exec("/usr/dt/bin/netscape file:" + helpIds.getFilePath(string));
        }
        catch (IOException iOException) {
            JOptionPane.showMessageDialog(frame, ResourceStrings.getString("err_starting_help"), ResourceStrings.getString("server_error_title"), 0);
        }
    }

    private void startMeUp() {
        try {
            DhcpServiceMgr dhcpServiceMgr;
            DhcpdOptions dhcpdOptions;
            if (DataManager.get().getServer() == null) {
                DataManager.get().setServer(this.getCodeBase().getHost());
            }
            if (!((modeIsRelay = (dhcpdOptions = (dhcpServiceMgr = DataManager.get().getDhcpServiceMgr()).readDefaults()).isRelay()) || dhcpdOptions.getResource() != null && dhcpdOptions.getPath() != null)) {
                System.err.println(ResourceStrings.getString("err_initializing_options"));
                this.requestExit();
            }
            this.showFrame();
            if (!modeIsRelay && !dhcpServiceMgr.isVersionCurrent()) {
                SwingUtilities.invokeLater(new ConversionTransition());
            }
        }
        catch (BridgeException bridgeException) {
            int n = ConfigureChoiceDialog.showDialog(frame);
            if (n == 1) {
                ConfigWizard configWizard = new ConfigWizard(frame, ResourceStrings.getString("cfg_wiz_title"), true);
                configWizard.addActionListener(new ActionListener(){

                    public void actionPerformed(ActionEvent actionEvent) {
                        if (actionEvent.getActionCommand().equals("finished")) {
                            modeIsRelay = false;
                            DhcpmgrApplet.this.showFrame();
                            SwingUtilities.invokeLater(new WizardTransition());
                        } else {
                            DhcpmgrApplet.this.requestExit();
                        }
                    }
                });
                configWizard.pack();
                configWizard.setVisible(true);
            } else if (n == 2) {
                ConfigureRelayDialog configureRelayDialog = new ConfigureRelayDialog(frame);
                configureRelayDialog.addActionListener(new ActionListener(){

                    public void actionPerformed(ActionEvent actionEvent) {
                        if (actionEvent.getActionCommand().equals("ok")) {
                            modeIsRelay = true;
                            DhcpmgrApplet.this.showFrame();
                        } else {
                            DhcpmgrApplet.this.requestExit();
                        }
                    }
                });
                configureRelayDialog.pack();
                configureRelayDialog.show();
            } else {
                this.requestExit();
            }
        }
        catch (Throwable throwable) {
            System.err.println(ResourceStrings.getString("err_initializing_program"));
            System.err.println(throwable.getMessage());
            throwable.printStackTrace();
            this.requestExit();
        }
    }

    class OverviewAction
    extends AbstractAction {
        public OverviewAction() {
            super(ResourceStrings.getString("overview_item"));
        }

        public void actionPerformed(ActionEvent actionEvent) {
            DhcpmgrApplet.showHelp("overview");
        }
    }

    class HowToAction
    extends AbstractAction {
        public HowToAction() {
            super(ResourceStrings.getString("howto_item"));
        }

        public void actionPerformed(ActionEvent actionEvent) {
            DhcpmgrApplet.showHelp("howto");
        }
    }

    class IndexAction
    extends AbstractAction {
        public IndexAction() {
            super(ResourceStrings.getString("index_item"));
        }

        public void actionPerformed(ActionEvent actionEvent) {
            DhcpmgrApplet.showHelp("index");
        }
    }

    class ServiceAction
    extends AbstractAction {
        public ServiceAction() {
            super(ResourceStrings.getString("on_service_item"));
        }

        public void actionPerformed(ActionEvent actionEvent) {
            DhcpmgrApplet.showHelp("service_reference");
        }
    }

    class RestartAction
    extends AbstractAction {
        public RestartAction() {
            super(ResourceStrings.getString("restart_item"));
        }

        public void actionPerformed(ActionEvent actionEvent) {
            try {
                DataManager.get().getDhcpServiceMgr().reload();
                MainFrame.setStatusText(ResourceStrings.getString("service_restarted"));
            }
            catch (Throwable throwable) {
                Object[] objectArray = new Object[1];
                MessageFormat messageFormat = new MessageFormat(ResourceStrings.getString("restart_server_error"));
                objectArray[0] = throwable.getMessage();
                JOptionPane.showMessageDialog(frame, messageFormat.format(objectArray), ResourceStrings.getString("server_error_title"), 0);
            }
        }
    }

    class StopAction
    extends AbstractAction {
        public StopAction() {
            super(ResourceStrings.getString("stop_item"));
        }

        public void actionPerformed(ActionEvent actionEvent) {
            try {
                DataManager.get().getDhcpServiceMgr().shutdown();
                MainFrame.setStatusText(ResourceStrings.getString("service_stopped"));
                DhcpmgrApplet.this.startAction.setEnabled(true);
                DhcpmgrApplet.this.restartAction.setEnabled(false);
                this.setEnabled(false);
            }
            catch (Throwable throwable) {
                Object[] objectArray = new Object[1];
                MessageFormat messageFormat = new MessageFormat(ResourceStrings.getString("shutdown_server_error"));
                objectArray[0] = throwable.getMessage();
                JOptionPane.showMessageDialog(frame, messageFormat.format(objectArray), ResourceStrings.getString("server_error_title"), 0);
            }
        }
    }

    class StartAction
    extends AbstractAction {
        public StartAction() {
            super(ResourceStrings.getString("start_item"));
        }

        public void actionPerformed(ActionEvent actionEvent) {
            try {
                DataManager.get().getDhcpServiceMgr().startup();
                MainFrame.setStatusText(ResourceStrings.getString("service_started"));
                DhcpmgrApplet.this.stopAction.setEnabled(true);
                DhcpmgrApplet.this.restartAction.setEnabled(true);
                this.setEnabled(false);
            }
            catch (Throwable throwable) {
                Object[] objectArray = new Object[1];
                MessageFormat messageFormat = new MessageFormat(ResourceStrings.getString("startup_server_error"));
                objectArray[0] = throwable.getMessage();
                JOptionPane.showMessageDialog(frame, messageFormat.format(objectArray), ResourceStrings.getString("server_error_title"), 0);
            }
        }
    }

    class DisableAction
    extends AbstractAction {
        public DisableAction() {
            super(ResourceStrings.getString("disable_item"));
        }

        static /* synthetic */ DhcpmgrApplet access$0(DisableAction disableAction) {
            return disableAction.DhcpmgrApplet.this;
        }

        public void actionPerformed(ActionEvent actionEvent) {
            DisableServiceDialog disableServiceDialog = new DisableServiceDialog((Frame)frame, true);
            disableServiceDialog.addActionListener(new ActionListener(this){
                private final /* synthetic */ DisableAction this$1;
                {
                    this.this$1 = disableAction;
                }

                public void actionPerformed(ActionEvent actionEvent) {
                    DhcpmgrApplet.access$7(DisableAction.access$0(this.this$1)).setEnabled(true);
                    DhcpmgrApplet.access$8(DisableAction.access$0(this.this$1)).setEnabled(false);
                    DhcpmgrApplet.access$6(DisableAction.access$0(this.this$1)).setEnabled(false);
                    DhcpmgrApplet.access$4(DisableAction.access$0(this.this$1)).setEnabled(false);
                    DhcpmgrApplet.access$5(DisableAction.access$0(this.this$1)).setEnabled(false);
                }
            });
            disableServiceDialog.pack();
            disableServiceDialog.show();
        }
    }

    class EnableAction
    extends AbstractAction {
        public EnableAction() {
            super(ResourceStrings.getString("enable_item"));
        }

        static /* synthetic */ DhcpmgrApplet access$0(EnableAction enableAction) {
            return enableAction.DhcpmgrApplet.this;
        }

        public void actionPerformed(ActionEvent actionEvent) {
            DisableServiceDialog disableServiceDialog = new DisableServiceDialog((Frame)frame, false);
            disableServiceDialog.addActionListener(new ActionListener(this){
                private final /* synthetic */ EnableAction this$1;
                {
                    this.this$1 = enableAction;
                }

                public void actionPerformed(ActionEvent actionEvent) {
                    DhcpmgrApplet.access$8(EnableAction.access$0(this.this$1)).setEnabled(true);
                    DhcpmgrApplet.access$7(EnableAction.access$0(this.this$1)).setEnabled(false);
                    DhcpmgrApplet.access$6(EnableAction.access$0(this.this$1)).setEnabled(true);
                    DhcpmgrApplet.access$4(EnableAction.access$0(this.this$1)).setEnabled(false);
                    DhcpmgrApplet.access$5(EnableAction.access$0(this.this$1)).setEnabled(true);
                }
            });
            disableServiceDialog.pack();
            disableServiceDialog.show();
        }
    }

    class ModifyServiceAction
    extends AbstractAction {
        public ModifyServiceAction() {
            super(ResourceStrings.getString("modify_service_item"));
        }

        public void actionPerformed(ActionEvent actionEvent) {
            try {
                DhcpdOptions dhcpdOptions = DataManager.get().getDhcpServiceMgr().readDefaults();
                ServerOptionsDialog serverOptionsDialog = new ServerOptionsDialog((Frame)frame, dhcpdOptions);
                serverOptionsDialog.pack();
                serverOptionsDialog.show();
            }
            catch (BridgeException bridgeException) {
                MessageFormat messageFormat = new MessageFormat(ResourceStrings.getString("err_reading_options"));
                Object[] objectArray = new Object[]{bridgeException.getMessage()};
                JOptionPane.showMessageDialog(frame, messageFormat.format(objectArray), ResourceStrings.getString("server_error_title"), 0);
            }
        }
    }

    class ConvertAction
    extends AbstractAction {
        public ConvertAction() {
            super(ResourceStrings.getString("cvt_service_item"));
        }

        static /* synthetic */ DhcpmgrApplet access$0(ConvertAction convertAction) {
            return convertAction.DhcpmgrApplet.this;
        }

        public void actionPerformed(ActionEvent actionEvent) {
            ConvertWizard convertWizard = new ConvertWizard((Frame)frame, ResourceStrings.getString("cvt_wiz_title"));
            convertWizard.addActionListener(new ActionListener(this){
                private final /* synthetic */ ConvertAction this$1;
                {
                    this.this$1 = convertAction;
                }

                public void actionPerformed(ActionEvent actionEvent) {
                    if (actionEvent.getActionCommand().equals("finished")) {
                        DhcpmgrApplet.access$0().refreshAllViews();
                        DhcpmgrApplet.access$3(ConvertAction.access$0(this.this$1));
                    }
                }
            });
            convertWizard.pack();
            convertWizard.setModal(true);
            convertWizard.setVisible(true);
        }

        public void setEnabled(boolean bl) {
            if (!modeIsRelay) {
                super.setEnabled(bl);
            } else {
                super.setEnabled(false);
            }
        }
    }

    class UnconfigureServiceAction
    extends AbstractAction {
        public UnconfigureServiceAction() {
            super(ResourceStrings.getString("unconfigure_service_item"));
        }

        public void actionPerformed(ActionEvent actionEvent) {
            UnconfigureDialog unconfigureDialog = new UnconfigureDialog(frame);
            unconfigureDialog.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent actionEvent) {
                    if (actionEvent.getActionCommand().equals("ok")) {
                        ((Component)DhcpmgrApplet.access$0()).setVisible(false);
                        DhcpmgrApplet.access$0().dispose();
                        DhcpmgrApplet.access$1(null);
                    }
                }
            });
            unconfigureDialog.pack();
            unconfigureDialog.show();
        }
    }

    class ExportAction
    extends AbstractAction {
        public ExportAction() {
            super(ResourceStrings.getString("export_item"));
        }

        static /* synthetic */ DhcpmgrApplet access$0(ExportAction exportAction) {
            return exportAction.DhcpmgrApplet.this;
        }

        public void actionPerformed(ActionEvent actionEvent) {
            ExportWizard exportWizard = new ExportWizard(frame);
            exportWizard.addActionListener(new ActionListener(this){
                private final /* synthetic */ ExportAction this$1;
                {
                    this.this$1 = exportAction;
                }

                public void actionPerformed(ActionEvent actionEvent) {
                    if (actionEvent.getActionCommand().equals("finished")) {
                        DhcpmgrApplet.access$0().refreshAllViews();
                        DhcpmgrApplet.access$3(ExportAction.access$0(this.this$1));
                    }
                }
            });
            exportWizard.pack();
            exportWizard.setVisible(true);
        }
    }

    class ImportAction
    extends AbstractAction {
        public ImportAction() {
            super(ResourceStrings.getString("import_item"));
        }

        static /* synthetic */ DhcpmgrApplet access$0(ImportAction importAction) {
            return importAction.DhcpmgrApplet.this;
        }

        public void actionPerformed(ActionEvent actionEvent) {
            ImportWizard importWizard = new ImportWizard(frame);
            importWizard.addActionListener(new ActionListener(this){
                private final /* synthetic */ ImportAction this$1;
                {
                    this.this$1 = importAction;
                }

                public void actionPerformed(ActionEvent actionEvent) {
                    if (actionEvent.getActionCommand().equals("finished")) {
                        DhcpmgrApplet.access$0().refreshAllViews();
                        DhcpmgrApplet.access$3(ImportAction.access$0(this.this$1));
                    }
                }
            });
            importWizard.pack();
            importWizard.setVisible(true);
        }
    }

    class WizardTransition
    implements Runnable {
        WizardTransition() {
        }

        public void run() {
            int n = JOptionPane.showConfirmDialog(frame, ResourceStrings.getString("start_address_wizard"), ResourceStrings.getString("start_address_wizard_title"), 0);
            if (n == 0) {
                DhcpmgrApplet.this.addressView.startAddressWizard();
            }
        }
    }

    class ConversionTransition
    implements Runnable {
        ConversionTransition() {
        }

        public void run() {
            try {
                DhcpServiceMgr dhcpServiceMgr = DataManager.get().getDhcpServiceMgr();
                while (!dhcpServiceMgr.isVersionCurrent()) {
                    int n = JOptionPane.showConfirmDialog(frame, ResourceStrings.getString("start_cvt_wizard"), ResourceStrings.getString("start_cvt_wizard_title"), 0);
                    if (n == 0) {
                        ConvertAction convertAction = new ConvertAction();
                        ActionEvent actionEvent = new ActionEvent(this, 1001, "");
                        convertAction.actionPerformed(actionEvent);
                        continue;
                    }
                    frame = null;
                    DataManager.get().reset();
                    DhcpmgrApplet.this.requestExit();
                }
            }
            catch (Throwable throwable) {
                System.err.println(ResourceStrings.getString("err_initializing_program"));
                System.err.println(throwable.getMessage());
                DhcpmgrApplet.this.requestExit();
            }
        }
    }
}

