/*
 * Decompiled with CFR 0.152.
 */
package com.sun.dhcpmgr.client;

import com.sun.dhcpmgr.bridge.BridgeException;
import com.sun.dhcpmgr.client.DataManager;
import com.sun.dhcpmgr.client.MultipleOperationDialog;
import com.sun.dhcpmgr.client.ResourceStrings;
import com.sun.dhcpmgr.data.DhcpdOptions;
import com.sun.dhcpmgr.data.Network;
import com.sun.dhcpmgr.ui.LeftButton;
import com.sun.dhcpmgr.ui.ProportionalLayout;
import com.sun.dhcpmgr.ui.RightButton;
import com.sun.dhcpmgr.ui.VerticalButtonLayout;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Frame;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.Vector;
import javax.swing.AbstractListModel;
import javax.swing.BorderFactory;
import javax.swing.JCheckBox;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;

public class DeleteNetworksDialog
extends MultipleOperationDialog {
    private JList keepNets;
    private JList deleteNets;
    private JCheckBox deleteHosts;
    private LeftButton leftButton;
    private RightButton rightButton;

    public DeleteNetworksDialog(Frame frame) {
        super(frame, true);
    }

    protected void doReset() {
        try {
            this.buttonPanel.setOkEnabled(false);
            this.deleteHosts.setSelected(false);
            ((NetworkListModel)this.deleteNets.getModel()).setNetworks(null);
            ((NetworkListModel)this.keepNets.getModel()).setNetworks(DataManager.get().getNetworks(false));
        }
        catch (Throwable throwable) {
            throwable.printStackTrace();
        }
    }

    protected void fireActionPerformed() {
        this.fireActionPerformed(this, "ok");
    }

    protected String getErrorHeading() {
        return ResourceStrings.getString("network_column");
    }

    protected String getHelpKey() {
        return "delete_network";
    }

    protected JPanel getMainPanel() {
        JPanel jPanel = new JPanel(new BorderLayout());
        jPanel.setBorder(BorderFactory.createEmptyBorder(10, 10, 10, 10));
        JPanel jPanel2 = new JPanel(new ProportionalLayout());
        JPanel jPanel3 = new JPanel(new BorderLayout(5, 5));
        jPanel3.add((Component)new JLabel(ResourceStrings.getString("delete_networks_keep")), "North");
        this.keepNets = new JList(new NetworkListModel());
        this.keepNets.setSelectionMode(2);
        JScrollPane jScrollPane = new JScrollPane(this.keepNets);
        jPanel3.add((Component)jScrollPane, "Center");
        jPanel2.add("2", jPanel3);
        jPanel3 = new JPanel(new VerticalButtonLayout());
        this.leftButton = new LeftButton();
        this.rightButton = new RightButton();
        this.rightButton.setEnabled(false);
        this.leftButton.setEnabled(false);
        jPanel3.add(this.rightButton);
        jPanel3.add(this.leftButton);
        jPanel2.add("1", jPanel3);
        jPanel3 = new JPanel(new BorderLayout(5, 5));
        jPanel3.add((Component)new JLabel(ResourceStrings.getString("delete_networks_delete")), "North");
        this.deleteNets = new JList(new NetworkListModel());
        this.deleteNets.setSelectionMode(2);
        jScrollPane = new JScrollPane(this.deleteNets);
        jPanel3.add((Component)jScrollPane, "Center");
        jPanel2.add("2", jPanel3);
        jPanel.add((Component)jPanel2, "Center");
        this.deleteHosts = new JCheckBox(ResourceStrings.getString("delete_networks_delete_hosts"));
        jPanel3 = new JPanel();
        jPanel3.add(this.deleteHosts);
        jPanel.add((Component)jPanel3, "South");
        this.deleteHosts.setEnabled(true);
        try {
            DhcpdOptions dhcpdOptions = DataManager.get().getDhcpServiceMgr().readDefaults();
            if (dhcpdOptions.getHostsResource() == null) {
                this.deleteHosts.setEnabled(false);
            }
        }
        catch (BridgeException bridgeException) {}
        this.keepNets.addListSelectionListener(new ListSelectionListener(){

            public void valueChanged(ListSelectionEvent listSelectionEvent) {
                DeleteNetworksDialog.this.rightButton.setEnabled(DeleteNetworksDialog.this.keepNets.isSelectionEmpty() ^ true);
                if (!DeleteNetworksDialog.this.keepNets.isSelectionEmpty()) {
                    DeleteNetworksDialog.this.deleteNets.clearSelection();
                }
            }
        });
        this.deleteNets.addListSelectionListener(new ListSelectionListener(){

            public void valueChanged(ListSelectionEvent listSelectionEvent) {
                DeleteNetworksDialog.this.leftButton.setEnabled(DeleteNetworksDialog.this.deleteNets.isSelectionEmpty() ^ true);
                if (!DeleteNetworksDialog.this.deleteNets.isSelectionEmpty()) {
                    DeleteNetworksDialog.this.keepNets.clearSelection();
                }
            }
        });
        this.rightButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                Object[] objectArray = DeleteNetworksDialog.this.keepNets.getSelectedValues();
                ((NetworkListModel)DeleteNetworksDialog.this.deleteNets.getModel()).addNetworks(objectArray);
                ((NetworkListModel)DeleteNetworksDialog.this.keepNets.getModel()).deleteNetworks(objectArray);
                if (DeleteNetworksDialog.this.deleteNets.getModel().getSize() != 0) {
                    DeleteNetworksDialog.this.buttonPanel.setOkEnabled(true);
                }
                DeleteNetworksDialog.this.keepNets.clearSelection();
            }
        });
        this.leftButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                Object[] objectArray = DeleteNetworksDialog.this.deleteNets.getSelectedValues();
                ((NetworkListModel)DeleteNetworksDialog.this.keepNets.getModel()).addNetworks(objectArray);
                ((NetworkListModel)DeleteNetworksDialog.this.deleteNets.getModel()).deleteNetworks(objectArray);
                DeleteNetworksDialog.this.deleteNets.clearSelection();
                if (DeleteNetworksDialog.this.deleteNets.getModel().getSize() == 0) {
                    DeleteNetworksDialog.this.buttonPanel.setOkEnabled(false);
                }
            }
        });
        this.doReset();
        return jPanel;
    }

    protected Thread getOperationThread() {
        return new Thread(){

            public void run() {
                NetworkListModel networkListModel = (NetworkListModel)DeleteNetworksDialog.this.deleteNets.getModel();
                int n = 0;
                while (n < networkListModel.getSize()) {
                    Network network = (Network)networkListModel.getElementAt(n);
                    try {
                        DataManager.get().getDhcpNetMgr().deleteNetwork(network.toString(), true, DeleteNetworksDialog.this.deleteHosts.isSelected());
                        DeleteNetworksDialog.this.updateProgress(n + 1, network.toString());
                    }
                    catch (InterruptedException interruptedException) {
                        DeleteNetworksDialog.this.closeDialog();
                        return;
                    }
                    catch (Throwable throwable) {
                        DeleteNetworksDialog.this.addError(network.toString(), throwable.getMessage());
                    }
                    ++n;
                }
                if (DeleteNetworksDialog.this.errorsOccurred()) {
                    DeleteNetworksDialog.this.displayErrors(ResourceStrings.getString("delete_networks_error"));
                }
                DeleteNetworksDialog.this.closeDialog();
            }
        };
    }

    protected int getProgressLength() {
        return this.deleteNets.getModel().getSize();
    }

    protected String getProgressMessage() {
        return ResourceStrings.getString("delete_networks_progress");
    }

    public String getTitle() {
        return ResourceStrings.getString("delete_networks_title");
    }

    class NetworkListModel
    extends AbstractListModel {
        private Vector networks = new Vector();

        public void addNetworks(Object[] objectArray) {
            if (objectArray != null) {
                int n = 0;
                while (n < objectArray.length) {
                    this.networks.addElement((Network)objectArray[n]);
                    ++n;
                }
            }
            this.fireContentsChanged(this, 0, this.networks.size() - 1);
        }

        public void deleteNetworks(Object[] objectArray) {
            int n = 0;
            while (n < objectArray.length) {
                this.networks.removeElement((Network)objectArray[n]);
                ++n;
            }
            this.fireContentsChanged(this, 0, this.networks.size() - 1);
        }

        public Object getElementAt(int n) {
            return this.networks.elementAt(n);
        }

        public int getSize() {
            return this.networks.size();
        }

        public void setNetworks(Network[] networkArray) {
            this.networks.removeAllElements();
            this.addNetworks(networkArray);
        }
    }
}

