/*
 * Decompiled with CFR 0.152.
 */
package com.sun.audiocontrol.SDtAudioControl;

import com.sun.audiocontrol.SDtAudioControl.CheckableItem;
import com.sun.audiocontrol.SDtAudioControl.Debug;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import javax.swing.JList;
import javax.swing.JRadioButton;
import javax.swing.ListCellRenderer;
import javax.swing.UIManager;
import javax.swing.border.EmptyBorder;

public class RadioList
extends JList {
    public RadioList(CheckableItem[] items) {
        this._init(items);
    }

    private void _init(CheckableItem[] items) {
        this.setListData(items);
        this.setCellRenderer(new CheckListRenderer());
        this.setSelectionMode(0);
        this.setBorder(new EmptyBorder(0, 4, 0, 0));
        this.addMouseListener(new MouseAdapter(){

            public void mouseClicked(MouseEvent e) {
                CheckableItem item;
                Debug.println("RadioList mouseClicked event");
                RadioList list = (RadioList)e.getSource();
                int i = 0;
                while (i < list.getModel().getSize()) {
                    item = (CheckableItem)list.getModel().getElementAt(i);
                    item.setSelected(false);
                    ++i;
                }
                int index = list.locationToIndex(e.getPoint());
                item = (CheckableItem)list.getModel().getElementAt(index);
                item.setSelected(true);
                list.repaint();
            }
        });
    }

    class CheckListRenderer
    extends JRadioButton
    implements ListCellRenderer {
        public CheckListRenderer() {
            this.setBackground(UIManager.getColor("List.textBackground"));
            this.setForeground(UIManager.getColor("List.textForeground"));
        }

        public Component getListCellRendererComponent(JList list, Object value, int index, boolean isSelected, boolean hasFocus) {
            Dimension mydim = new Dimension();
            mydim = this.getPreferredSize();
            mydim.height = 17;
            this.setPreferredSize(mydim);
            this.setEnabled(((CheckableItem)value).isEnabled());
            this.setSelected(((CheckableItem)value).isSelected());
            this.setFont(list.getFont());
            this.setText(value.toString());
            return this;
        }
    }
}

