/*
 * Decompiled with CFR 0.152.
 */
package com.sun.pdasync.HotSync;

import com.sun.pdasync.CommPort.CommPortConst;
import com.sun.pdasync.CommPort.DataAvailableEvent;
import com.sun.pdasync.CommPort.DataAvailableListener;
import com.sun.pdasync.CommPort.SerialPortCommunicator;
import com.sun.pdasync.HotSync.CConduitJar;
import com.sun.pdasync.HotSync.CConduitManager;
import com.sun.pdasync.HotSync.CHotSyncState;
import com.sun.pdasync.HotSync.CPostGeneralSyncManager;
import com.sun.pdasync.HotSync.CPreSyncManager;
import com.sun.pdasync.HotSync.CSyncTask;
import com.sun.pdasync.HotSync.CTaskMaster;
import com.sun.pdasync.HotSync.HotSyncException;
import com.sun.pdasync.HotSync.NonStdUtils;
import com.sun.pdasync.HotSync.ScreenLockState;
import com.sun.pdasync.HotSync.UserResolver;
import com.sun.pdasync.Logger.Logger;
import com.sun.pdasync.Registry.ConduitInstall;
import com.sun.pdasync.SyncMgr.CDbList;
import com.sun.pdasync.SyncMgr.CSyncFindDbByNameParams;
import com.sun.pdasync.SyncMgr.CSyncFindDbByTypeCreatorParams;
import com.sun.pdasync.SyncMgr.CSyncProperties;
import com.sun.pdasync.SyncMgr.CSystemInfo;
import com.sun.pdasync.SyncMgr.SyncDatabaseInfoType;
import com.sun.pdasync.SyncUI.LogProperties;
import com.sun.pdasync.SyncUI.PDASyncDlgUI;
import com.sun.pdasync.SyncUI.PDASyncProperties;
import com.sun.pdasync.SyncUtils.PropertyChangeEvent;
import com.sun.pdasync.SyncUtils.PropertyChangeListener;
import com.sun.pdasync.SyncUtils.SyncConstants;
import com.sun.pdasync.SyncUtils.SyncUtils;
import com.sun.pdasync.SyncUtils.UserInteractionEvent;
import com.sun.pdasync.SyncUtils.UserInteractionListener;
import com.sun.pdasync.Transport.CTransportPAD;
import java.io.Serializable;
import java.util.Date;
import java.util.Locale;
import java.util.MissingResourceException;
import java.util.ResourceBundle;
import java.util.Vector;
import palm.conduit.Card;
import palm.conduit.Conduit;
import palm.conduit.SyncException;
import palm.conduit.SyncManager;
import palm.conduit.SyncProdCompInfo;
import palm.conduit.SyncProperties;

public class HotSync
extends Thread
implements Serializable,
DataAvailableListener,
UserInteractionListener,
PropertyChangeListener {
    private static final int PRV_HS_DESIRED_SYNCMGR_VER_MAJOR = 2;
    private static final int PRV_HS_MIN_SYNCMGR_VER_MINOR = 2;
    public static final int FATAL_ERROR_MASK = 0x10000000;
    public static final int HOTERR_NONE = 0;
    public static final int HOTERR_FIRST = 32768;
    public static final int HOTERR_USERCANCEL = 0x10008001;
    public static final int HOTERR_LOGFILE = 268468226;
    public static final int HOTERR_READDBLIST = 268468227;
    public static final int HOTERR_ESTABLISHUSER = 268468228;
    public static final int HOTERR_RECVWAKEUP = 268468229;
    public static final int HOTERR_TASKMASTER = 268468230;
    public static final int HOTERR_CONDUITMANAGER = 268468231;
    public static final int HOTERR_SETCONNECTION = 0x10008008;
    public static final int HOTERR_NOTIFYSYNC = 268468233;
    public static final int HOTERR_DISKSPACE = 268468234;
    public static final int HOTERR_BAD_PASSWORD = 268468235;
    public static final int HOTERR_INCOMPATIBLE_PRODUCTS = 268468236;
    public static final int HOTERR_GENERAL_ERROR = 268468288;
    public static final int HOTERR_DUPLICATE_USERNAME = 32781;
    public static final int MIN_CONDUIT_VERSION = 257;
    public static final int MAX_CONDUIT_VERSION = 512;
    private static final short HOTSYNC_FIRST_LOCAL_PROD_COMP_VER_MAJOR = 1;
    private static final short HOTSYNC_FIRST_LOCAL_PROD_COMP_VER_MINOR = 0;
    private static final short HOTSYNC_LAST_LOCAL_PROD_COMP_VER_MAJOR = 3;
    private static final short HOTSYNC_LAST_LOCAL_PROD_COMP_VER_MINOR = 0;
    private static final int NUM_TICKS = 6;
    private static final String DEFAULT_PORT = "/dev/term/a";
    private String feedback;
    private static Locale theLocale;
    private static ResourceBundle messages;
    private HotSyncException hse;
    public static int numTries;
    public static final int NUM_ATTEMPTS = 5;
    private static final int prvPilotNetCreator;
    private static final short prvPilotNetFtrNumVersion = 0;
    private static final int prvPilotHtalLibType;
    private static final int prvPilotTCPHtalCreator;
    private static final String prvPilotTCPHtalLibName = "NetSync";
    private static final String prvHostNameOverride = "!!";
    protected CTaskMaster m_pTaskMaster;
    protected boolean m_bDirect;
    protected CTransportPAD m_pCurTransport;
    protected CTransportPAD m_pDirectTransport;
    protected CTransportPAD m_pTcpTransport;
    protected boolean m_bVerbose;
    protected boolean m_bStartEndSync;
    protected static boolean gfTransportInitialized;
    protected long m_nSyncExitCode;
    protected boolean m_bInTimerProc;
    protected long m_nDisableHotSync;
    protected boolean m_bForcingRestore;
    protected boolean m_bLocalUserCancel;
    protected int m_dwTotalWarnings;
    protected boolean m_bNetwork;
    protected CConduitManager m_ConduitManager;
    protected CPostGeneralSyncManager m_PostSyncConduitManager;
    protected CPreSyncManager m_PreSyncConduitManager;
    protected CHotSyncState gSyncState;
    protected CSyncProperties m_GeneralProperties;
    public boolean m_bNetSyncSupported;
    String usedPort = "";
    int portSpeed = 0;
    String pilotName = null;
    String pilotPasswd = null;
    String pilotAssoc = null;
    Vector addInfo = null;
    boolean doRestore;
    public PDASyncProperties props;
    public LogProperties logProps;
    public Logger logger;
    int dwVerMajor = 0;
    int dwVerMinor = 0;
    boolean propChanged = false;
    UserResolver userResolver;

    static {
        numTries = 0;
        try {
            theLocale = Locale.getDefault();
            messages = ResourceBundle.getBundle("com.sun.pdasync.ListResourceBundle.HotSyncMessages", theLocale);
        }
        catch (MissingResourceException e) {
            Logger.doLogging((String)"PDASync: can't find properties", (boolean)true);
            Logger.doLogging((String)("PDASync:" + e.getMessage()), (boolean)true);
            System.exit(1);
        }
        prvPilotNetCreator = SyncUtils.creatorStringToInt((String)"netl");
        prvPilotHtalLibType = SyncUtils.creatorStringToInt((String)"htal");
        prvPilotTCPHtalCreator = SyncUtils.creatorStringToInt((String)"htcp");
        gfTransportInitialized = false;
    }

    public HotSync() {
        this((PDASyncDlgUI)null, (Logger)null);
    }

    public HotSync(PDASyncDlgUI uiDlg, Logger l) {
        this.props = uiDlg.appProps;
        this.logProps = uiDlg.logProps;
        this.logger = l;
        this.gSyncState = new CHotSyncState();
    }

    public void AddPostGeneralSyncTasks() {
    }

    public boolean CheckForSyncConnection() {
        if (this.m_bInTimerProc || !this.IsHotSyncEnabled()) {
            return false;
        }
        this.m_bInTimerProc = true;
        this.m_pCurTransport = null;
        if (this.m_pDirectTransport != null && this.m_pDirectTransport.PollConnection() == 0L) {
            this.m_pCurTransport = this.m_pDirectTransport;
        }
        this.m_bInTimerProc = false;
        return this.m_pCurTransport != null;
    }

    public long CreateTaskMaster() {
        long nRtn = 268468230L;
        if (this.m_pTaskMaster == null) {
            this.m_pTaskMaster = new CTaskMaster();
            if (this.m_pTaskMaster != null) {
                nRtn = this.RestoreFromBackup();
                this.feedback = messages.getString("Retrieving handheld databases...");
                this.updateViewerAndHHProgress(7, this.feedback, 0);
                nRtn = this.ReadRemoteDBList(this.m_pTaskMaster);
                if (nRtn == 0L) {
                    this.feedback = messages.getString("Successfully retrieved handheld databases.");
                    this.updateViewerAndHHProgress(7, this.feedback, 0);
                    Logger.doProgressUpdate((String)this.feedback, (int)0);
                    this.m_pTaskMaster.m_bValidDbList = true;
                }
                if ((nRtn & 0x10000000L) == 0L) {
                    if (!this.m_pTaskMaster.createTasks()) {
                        nRtn = 268468230L;
                    } else {
                        this.feedback = messages.getString("Successfully initialized task manager.");
                        Logger.doDebugLogging((String)this.feedback, (int)4);
                        this.AddPostGeneralSyncTasks();
                    }
                }
            }
        }
        HotSync hotSync = this;
        synchronized (hotSync) {
            if (this.m_bLocalUserCancel) {
                nRtn = 0x10008001L;
            }
        }
        return nRtn;
    }

    protected void DisableHotSync() {
        ++this.m_nDisableHotSync;
    }

    public long DiscoverCommState() {
        long nRtn = 0L;
        this.gSyncState.m_fEndPoint = false;
        if (this.m_pCurTransport == this.m_pTcpTransport) {
            this.gSyncState.m_fEndPoint = true;
        }
        this.gSyncState.m_ConnType = ((long)this.m_pCurTransport.GetAttributes() & 0x80000000L) != 0L ? 2 : 1;
        this.gSyncState.m_ConnOrigin = ((long)this.m_pCurTransport.GetAttributes() & 0x40000000L) != 0L ? 1 : 2;
        this.gSyncState.m_fPCNetSettingIsOn = this.m_bNetwork;
        long[] nErr = new long[1];
        this.gSyncState.m_fPilotHasNetsync = this.IsDatabaseOnPilot(prvPilotTCPHtalLibName, prvPilotHtalLibType, prvPilotTCPHtalCreator, nErr);
        if ((nRtn & 0x10000000L) == 0L) {
            nRtn = 0L;
        }
        return nRtn;
    }

    public long DiscoverProductCompatibility() {
        long nRtn = 0L;
        try {
            SyncProdCompInfo prodInfo = SyncManager.readProdCompInfo();
            prodInfo.copyToSyncProdCompInfoType(this.gSyncState.m_ProdCompInfo);
        }
        catch (SyncException ex) {
            Logger.doDebugLogging((String)("SyncProdCompInfo() failed: " + ex.getMessage()), (int)4);
            return ex.errorCode;
        }
        Logger.doDebugLogging((String)("Product Compatibility: " + this.gSyncState.dumpFormatted()), (int)4);
        if (nRtn == 0L) {
            long dtVerRangeStart = SyncUtils.makeLong((short)0, (short)1);
            long dtVerRangeEnd = SyncUtils.makeLong((short)0, (short)3);
            long hhVer = SyncUtils.makeLong((short)this.gSyncState.m_ProdCompInfo.compVer.wMinor_u, (short)this.gSyncState.m_ProdCompInfo.compVer.wMajor_u);
            Logger.doDebugLogging((String)("Handheld version: " + new Long(hhVer).toString()), (int)4);
            Logger.doDebugLogging((String)("Desktop compatibility start: " + new Long(dtVerRangeStart).toString()), (int)4);
            Logger.doDebugLogging((String)("Desktop compatibility end: " + new Long(dtVerRangeEnd).toString()), (int)4);
            this.gSyncState.m_fLocalCompatible = hhVer >= dtVerRangeStart && hhVer <= dtVerRangeEnd;
            this.gSyncState.m_fLanCompatible = false;
            String str = "m_bNetSyncSupported: " + this.m_bNetSyncSupported + "\n" + "gSyncState.m_fLocalCompatible: " + this.gSyncState.m_fLocalCompatible + "\n" + "gSyncState.m_fLanCompatible: " + this.gSyncState.m_fLanCompatible + "\n" + "NetSync not supported AND Not Local Compatible: " + (!this.m_bNetSyncSupported && !this.gSyncState.m_fLocalCompatible) + "\n" + "Not Local Compatible and Not Lan Compatible: " + (!this.gSyncState.m_fLocalCompatible && !this.gSyncState.m_fLanCompatible);
            Logger.doDebugLogging((String)str, (int)4);
            if (!this.m_bNetSyncSupported && !this.gSyncState.m_fLocalCompatible || !this.gSyncState.m_fLocalCompatible && !this.gSyncState.m_fLanCompatible) {
                nRtn = 268468236L;
            }
        }
        return nRtn;
    }

    private long DoBackupRestore() {
        long nRtn = 0L;
        CSyncProperties properties = new CSyncProperties();
        if (this.userResolver.isProfiled()) {
            return nRtn;
        }
        nRtn = this.TestSyncEnvironment();
        if (nRtn != 0L) {
            return nRtn;
        }
        properties.m_RemoteDbList = null;
        CSyncTask pBackupTask = this.m_pTaskMaster.GetBackupTask();
        if (pBackupTask != null && pBackupTask.getState() == 1) {
            CConduitJar pConduit = this.m_PostSyncConduitManager.FindConduit(pBackupTask.GetCreator());
            if (pConduit != null) {
                boolean isActive = pConduit.conduit.getUsersActiveState();
                boolean isDeleted = pConduit.conduit.getUsersDeletedState();
                if (!this.doRestore && !isActive || isDeleted) {
                    Logger.doDebugLogging((String)"System conduit marked inactive - no backup performed", (int)4);
                    return 0L;
                }
                if (this.SetSyncProperties(pBackupTask, pConduit, properties)) {
                    if (properties.m_SyncType == 4) {
                        pConduit = this.m_PreSyncConduitManager.FindConduit(0);
                    }
                    this.feedback = properties.m_SyncType == 4 ? messages.getString("Restoring handheld databases...") : messages.getString("Backing up handheld databases...");
                    if (pConduit != null) {
                        Logger.doProgressMsg((String)this.feedback, (int)0);
                        Logger.doLogging((String)this.feedback);
                        nRtn = this.EngageConduit((Conduit)pConduit.conduitObj, properties);
                    } else {
                        pBackupTask.setState(3);
                    }
                } else {
                    pBackupTask.setState(3);
                    this.feedback = messages.getString("Failed to set up backup properties!");
                    if (this.m_bVerbose) {
                        Logger.doLogging((String)this.feedback);
                    }
                    Logger.doDebugLogging((String)this.feedback, (int)4);
                }
                this.freeDbList(properties.m_RemoteDbList);
            } else {
                pBackupTask.setState(3);
                this.feedback = messages.getString("Backup task not found!");
                if (this.m_bVerbose) {
                    Logger.doLogging((String)this.feedback);
                }
                Logger.doDebugLogging((String)this.feedback, (int)4);
            }
        }
        HotSync hotSync = this;
        synchronized (hotSync) {
            if (this.m_bLocalUserCancel) {
                nRtn = 0x10008001L;
            }
        }
        return nRtn;
    }

    private long DoConduitSync(boolean[] fFatalError) {
        long nRtn = 0L;
        if (!fFatalError[0]) {
            nRtn = this.DoPreGeneralSync();
            fFatalError[0] = this.DoError(nRtn);
        }
        if (!fFatalError[0]) {
            nRtn = this.DoSync();
            fFatalError[0] = this.DoError(nRtn);
        }
        if (!fFatalError[0]) {
            nRtn = this.DoPreGeneralSync();
            fFatalError[0] = this.DoError(nRtn);
        }
        if (!fFatalError[0]) {
            nRtn = this.DoBackupRestore();
            fFatalError[0] = this.DoError(nRtn);
        }
        return nRtn;
    }

    public boolean DoError(long nErrorCode) {
        boolean bFatal;
        boolean bl = bFatal = (nErrorCode & 0x10000000L) != 0L;
        if (bFatal) {
            this.gSyncState.m_fFatalError = true;
        }
        if (nErrorCode != 0L) {
            this.feedback = "Fatal error: 0x" + Integer.toHexString((int)nErrorCode);
            Logger.doDebugLogging((String)this.feedback, (int)4);
        }
        return bFatal;
    }

    private long DoPreGeneralSync() {
        long nRtn = 0L;
        CSyncTask pTask = null;
        CConduitJar pConduit = null;
        Logger.doDebugLogging((String)"Running pre-synchronization conduits...", (int)4);
        nRtn = this.TestSyncEnvironment();
        if (nRtn != 0L) {
            return nRtn;
        }
        int nCount = this.m_PreSyncConduitManager.GetConduitCount();
        int i = 0;
        while (i < nCount && (nRtn & 0x10000000L) == 0L) {
            pConduit = this.m_PreSyncConduitManager.GetConduit(i);
            if (pConduit != null) {
                this.feedback = String.valueOf(messages.getString("Found pre-synchronization conduit:")) + "\n" + pConduit.conduit.dumpFormatted();
                Logger.doDebugLogging((String)this.feedback, (int)4);
                pTask = this.m_pTaskMaster.FindTask(pConduit.GetViewerAppID());
                if (pTask != null) {
                    this.feedback = String.valueOf(messages.getString("Found pre-synchronization task:")) + "\n" + pTask.dumpFormatted();
                    Logger.doDebugLogging((String)this.feedback, (int)4);
                    if (pTask.getState() != 1) {
                        // empty if block
                    }
                }
            }
            ++i;
        }
        if (pTask != null && pConduit != null && pTask.getState() == 1) {
            boolean isActive = pConduit.conduit.getUsersActiveState();
            boolean isDeleted = pConduit.conduit.getUsersDeletedState();
            if ((this.doRestore || isActive) && !isDeleted) {
                nRtn = this.SyncConduit(pTask, pConduit, messages.getString("Installing handheld applications."));
            } else {
                pTask.setState(4);
                Logger.doDebugLogging((String)"Install conduit marked inactive.", (int)4);
            }
        } else {
            this.feedback = messages.getString("No pre-synchronization work done.");
            Logger.doDebugLogging((String)this.feedback, (int)4);
        }
        HotSync hotSync = this;
        synchronized (hotSync) {
            if (this.m_bLocalUserCancel) {
                nRtn = 0x10008001L;
            }
        }
        return nRtn;
    }

    private long DoSync() {
        long nRtn = 0L;
        nRtn = this.TestSyncEnvironment();
        if (nRtn != 0L) {
            return nRtn;
        }
        int nCount = this.m_ConduitManager.GetConduitCount();
        if (this.m_bVerbose) {
            this.feedback = String.valueOf(messages.getString("Conduit count: ")) + nCount;
            Logger.doLogging((String)this.feedback);
        }
        int n = 0;
        while (n < nCount && (nRtn & 0x10000000L) == 0L) {
            CConduitJar pConduit = this.m_ConduitManager.GetConduit(n);
            CSyncTask pTask = this.m_pTaskMaster.FindTask(pConduit.conduit.getCreatorID());
            if (pTask != null) {
                boolean isActive = pConduit.conduit.getUsersActiveState();
                boolean isDeleted = pConduit.conduit.getUsersDeletedState();
                if ((this.doRestore || isActive) && !isDeleted) {
                    nRtn = this.SyncConduit(pTask, pConduit, true);
                } else {
                    pTask.setState(4);
                    Logger.doDebugLogging((String)("Conduit marked inactive: " + pConduit.conduit.getName()), (int)4);
                }
            } else {
                this.feedback = messages.getString("No task found for conduit!");
                if (this.m_bVerbose) {
                    Logger.doLogging((String)this.feedback);
                }
                Logger.doDebugLogging((String)this.feedback, (int)4);
            }
            Logger.doProgressUpdate(null, (int)0);
            ++n;
        }
        this.m_pTaskMaster.addPendingToBackup();
        return nRtn;
    }

    protected void EnableHotSync() {
        --this.m_nDisableHotSync;
    }

    public void EndSync(long nSyncResult) {
        block18: {
            long nRtn = 0L;
            if (!this.gSyncState.m_fConnected) break block18;
            this.doRestore = false;
            if (this.gSyncState.m_EndStatus == 0) {
                Logger.doDebugLogging((String)"gSyncState.m_EndStatus is eNormal", (int)4);
                Logger.doDebugLogging((String)("nSyncResult is " + nSyncResult + " (0x" + Integer.toHexString((int)nSyncResult) + ")"), (int)4);
                if (nSyncResult != 0L) {
                    this.gSyncState.m_EndStatus = nSyncResult == 0x10008001L ? 2 : (nSyncResult == 268468236L ? 4 : 3);
                } else if (this.gSyncState.m_fRmtMemError) {
                    this.gSyncState.m_EndStatus = 1;
                }
            }
            try {
                try {
                    nRtn = SyncManager.sunwSyncEndOfSync((int)this.gSyncState.m_EndStatus);
                }
                catch (SyncException syncException) {
                    Logger.doDebugLogging((String)("Failed to end sync session: " + new Long(nRtn).toString()), (int)4);
                }
                Object var6_3 = null;
                this.m_pCurTransport.Disconnect();
            }
            catch (Throwable throwable) {
                Object var6_4 = null;
                this.m_pCurTransport.Disconnect();
                throw throwable;
            }
            String msg = "";
            if (this.gSyncState.m_EndStatus == 0) {
                Logger.doDebugLogging((String)"SyncEndOfSync: eNormal", (int)4);
                msg = messages.getString("Successfully synchronized data.");
            } else if (this.gSyncState.m_EndStatus == 2) {
                Logger.doDebugLogging((String)"SyncEndOfSync: eUserCancel", (int)4);
                msg = messages.getString("Synchronization aborted - canceled by user.");
            } else if (this.gSyncState.m_EndStatus == 1) {
                Logger.doDebugLogging((String)"SyncEndOfSync: eLowHHMemory", (int)4);
                msg = messages.getString("Synchronization aborted - handheld ran out of memory.");
            } else if (this.gSyncState.m_EndStatus == 3) {
                Logger.doDebugLogging((String)"SyncEndOfSync: eOther", (int)4);
                msg = messages.getString("Synchronization aborted.");
            } else if (this.gSyncState.m_EndStatus == 4) {
                Logger.doDebugLogging((String)"SyncEndOfSync: eIncompatibleProducts", (int)4);
                msg = messages.getString("Synchronization aborted - handheld is incompatible with software.");
            } else {
                Logger.doDebugLogging((String)("SyncEndOfSync: UNKNOWN EndOfSync Code: " + Integer.toHexString(this.gSyncState.m_EndStatus)), (int)4);
                msg = String.valueOf(messages.getString("Synchronization unsuccessful - unknown code returned: 0x")) + Integer.toHexString(this.gSyncState.m_EndStatus);
            }
            Date date = new Date();
            msg = String.valueOf(msg) + "\n" + date.toString() + "\n\n";
            Logger.doLogging((String)msg, (boolean)true);
            this.gSyncState.m_fConnected = false;
        }
    }

    public long EngageConduit(Conduit conduit, CSyncProperties properties) {
        long nRtn = 0L;
        SyncProperties syncProps = new SyncProperties();
        syncProps.copyFromCSyncProperties(properties);
        try {
            nRtn = SyncManager.sunwOpenConduit();
        }
        catch (SyncException ex) {
            ex.getMessage().endsWith("User Canceled");
            return 0x10008001L;
        }
        this.feedback = String.valueOf(messages.getString("Loading ")) + conduit.name() + messages.getString(" conduit.");
        if (this.m_bVerbose) {
            Logger.doProgressMsg((String)this.feedback, (int)0);
            Logger.doLogging((String)this.feedback);
        }
        Logger.doDebugLogging((String)"Loading ", (int)4);
        this.feedback = syncProps.dumpFormatted();
        Logger.doDebugLogging((String)this.feedback, (int)4);
        conduit.open(syncProps);
        return nRtn;
    }

    public long EstablishSyncType() {
        long nRtn = 0L;
        this.gSyncState.m_SyncLocale = 1;
        return nRtn;
    }

    long IdentifyPilotUser() {
        long nRtn = 268468228L;
        this.feedback = messages.getString("Identifying user...");
        this.updateViewerAndHHProgress(7, this.feedback, 0);
        if (this.userResolver != null) {
            nRtn = this.userResolver.readUserInfo();
            if (nRtn == 0L) {
                if (!this.userResolver.isFirstTimer()) {
                    this.gSyncState.m_fPilotHasUserId = true;
                    if (this.userResolver.matchUser()) {
                        this.gSyncState.m_fUserIdMatch = true;
                        this.gSyncState.m_fProfileHotSync = this.userResolver.isProfiled();
                        this.gSyncState.m_PrimaryPCStatus = 1;
                    } else {
                        Logger.doDebugLogging((String)"MATCH USER FAILED", (int)4);
                        Logger.doDebugLogging((String)this.userResolver.dumpFormatted(), (int)4);
                    }
                } else {
                    this.feedback = messages.getString("Device has no identification.");
                    this.updateViewerAndHHProgress(7, this.feedback, 0);
                    Logger.doDebugLogging((String)this.feedback, (int)4);
                    Logger.doDebugLogging((String)this.userResolver.dumpFormatted(), (int)4);
                    if (!this.userResolver.associated) {
                        this.logger.notifyListeners(this.pilotName, false);
                        boolean stop = false;
                        while (!stop) {
                            if (this.pilotName != null) {
                                stop = true;
                                continue;
                            }
                            Logger.doDebugLogging((String)"Waiting for user to provide a name for handheld.", (int)4);
                            try {
                                Thread.sleep(1500L);
                            }
                            catch (Exception exception) {}
                        }
                        if (this.pilotName.equals("usercancel")) {
                            Logger.doDebugLogging((String)"User did not give PalmPilot a name.", (int)4);
                            nRtn = 268468228L;
                        } else {
                            Logger.doDebugLogging((String)("PalmPilot named as: " + this.pilotName), (int)4);
                            this.gSyncState.m_fUserIdMatch = true;
                            nRtn = 0L;
                        }
                    } else {
                        nRtn = 0L;
                    }
                }
            } else {
                this.feedback = "FAILED TO RETRIEVE USER INFORMATION FROM HANDHELD.";
                Logger.doProgressMsg((String)this.feedback, (int)0);
            }
        } else {
            Logger.doDebugLogging((String)"UserResolver is null!", (int)4);
        }
        HotSync hotSync = this;
        synchronized (hotSync) {
            if (this.m_bLocalUserCancel) {
                nRtn = 0x10008001L;
            }
        }
        return nRtn;
    }

    private void InitGeneralSyncProperties() {
        this.m_GeneralProperties = new CSyncProperties();
        this.m_GeneralProperties.m_CardNo_u = 0;
        this.m_GeneralProperties.m_DbType_u = 0x44415441;
        this.m_GeneralProperties.m_Connection = this.gSyncState.m_ConnOrigin == 1 ? 0 : 1;
        byte[] name = SyncConstants.USER_NAME.getBytes();
        int len = name.length;
        if (len > 256) {
            len = 256;
        }
        System.arraycopy(name, 0, this.m_GeneralProperties.m_UserName, 0, len);
        if (this.m_bVerbose) {
            this.feedback = String.valueOf(messages.getString("User synchronizing: ")) + SyncConstants.USER_NAME;
            Logger.doLogging((String)this.feedback);
        }
        Logger.doDebugLogging((String)("User synchronizing: " + SyncConstants.USER_NAME), (int)4);
        this.InitSyncFirstDevice();
    }

    public void InitInstance() throws HotSyncException {
        String portToUse = this.getRequestPort();
        boolean portSpeedChanged = this.checkPortSpeedChanged();
        if (!Logger.getDebugCmdLineLevel()) {
            if (this.logProps.logShowDebug) {
                Logger.setDebugLevel((int)5);
            } else {
                Logger.setDebugLevel((int)0);
            }
        }
        if (portToUse.compareTo(this.usedPort) != 0) {
            this.m_pDirectTransport = this.props.pdasyncPortSpeed == 0 ? new CTransportPAD(false, SyncUtils.getMaxBaud()) : new CTransportPAD(false, this.props.pdasyncPortSpeed);
            if (this.m_pDirectTransport.TransInit(this.m_bVerbose) == 0L) {
                gfTransportInitialized = true;
            }
        }
        this.m_pCurTransport = this.m_pDirectTransport;
        if (portSpeedChanged && this.m_pCurTransport != null) {
            this.m_pCurTransport.SetUserSyncBaud(this.props.pdasyncPortSpeed);
        }
        try {
            SyncManager.sunwSyncInit((CTransportPAD)this.m_pCurTransport);
        }
        catch (SyncException e) {
            this.m_pCurTransport.Disconnect();
            this.feedback = HotSyncException.messageNames[1];
            this.hse = new HotSyncException(1, 4, this.feedback, messages);
            this.hse.syncExc = e;
            throw this.hse;
        }
        try {
            int[] version = SyncManager.getAPIVersion();
            this.dwVerMajor = version[0];
            this.dwVerMinor = version[1];
        }
        catch (SyncException syncException) {
            this.feedback = HotSyncException.messageNames[2];
            this.hse = new HotSyncException(2, 5, this.feedback, messages);
            throw this.hse;
        }
        if (this.dwVerMajor != 2 || this.dwVerMinor < 2) {
            this.feedback = HotSyncException.messageNames[3];
            this.hse = new HotSyncException(3, 4, this.feedback, messages);
            throw this.hse;
        }
        if (!this.RetrieveConduits()) {
            Logger.doDebugLogging((String)"Retrieve Conduits failed", (int)4);
        } else {
            Logger.doDebugLogging((String)"Retrieve Conduits ran", (int)4);
        }
        this.logger.notifyListeners(this.getAllManagedConduits(), 0);
        if (portToUse.compareTo(this.usedPort) != 0) {
            this.feedback = String.valueOf(messages.getString("Attempting to get control of port: ")) + portToUse;
            Logger.doDebugLogging((String)this.feedback, (int)4);
            long errno = this.m_pCurTransport.MakePlatformSerialPort(portToUse);
            if (errno == 0L) {
                this.usedPort = portToUse;
                this.feedback = messages.getString("Successfully got control of port.");
                Logger.doDebugLogging((String)this.feedback, (int)4);
            } else {
                int lerr = errno == CommPortConst.serErrNoSuchPort ? 4 : 5;
                this.feedback = HotSyncException.messageNames[lerr];
                this.hse = new HotSyncException(lerr, 5, this.feedback, messages);
                throw this.hse;
            }
        }
        this.m_pCurTransport.m_padState = (short)16384;
        this.EnableHotSync();
        this.eavesDropOnSerialPort();
    }

    private void InitSyncFirstDevice() {
        this.m_GeneralProperties.m_FirstDevice = this.userResolver.isFirstTimer() && !this.userResolver.isProfiled() ? 2 : (!this.userResolver.isFirstTimer() ? 0 : 1);
        if (this.m_bVerbose) {
            switch (this.m_GeneralProperties.m_FirstDevice) {
                case 1: {
                    this.feedback = messages.getString("User synchronizing for the first time...");
                    break;
                }
                case 2: {
                    this.feedback = messages.getString("PDASync synchronizing for the first time...");
                }
            }
            Logger.doLogging((String)this.feedback);
            Logger.doProgressMsg((String)this.feedback, (int)0);
        }
    }

    private void InitSyncProperties(CSyncProperties pProperties) {
        pProperties.m_CardNo_u = this.m_GeneralProperties.m_CardNo_u;
        pProperties.m_DbType_u = this.m_GeneralProperties.m_DbType_u;
        pProperties.m_FirstDevice = this.m_GeneralProperties.m_FirstDevice;
        pProperties.m_Connection = this.m_GeneralProperties.m_Connection;
        pProperties.m_UserName = this.m_GeneralProperties.m_UserName;
    }

    protected boolean IsDatabaseOnPilot(String pszDbName, int dwType_u, int dwCreator_u, long[] pnError) {
        boolean fPresent = false;
        SyncDatabaseInfoType dbInfo = new SyncDatabaseInfoType();
        pnError[0] = 0L;
        int[] bhFile = new int[]{0};
        if (SyncManager.sunwSyncGetHHOSVersion(null) >= 3) {
            if (dwType_u != 0 || dwCreator_u != 0) {
                CSyncFindDbByTypeCreatorParams findParams = new CSyncFindDbByTypeCreatorParams();
                findParams.bOptFlags_u = 0;
                findParams.bSrchFlags_u = (byte)-128;
                findParams.dwType_u = dwType_u;
                findParams.dwCreator_u = dwCreator_u;
                pnError[0] = SyncManager.sunwSyncFindDbByTypeCreator((CSyncFindDbByTypeCreatorParams)findParams, (SyncDatabaseInfoType)dbInfo);
                if (pnError[0] == 0L) {
                    fPresent = true;
                }
            } else {
                CSyncFindDbByNameParams findParams = new CSyncFindDbByNameParams();
                findParams.bOptFlags_u = 0;
                findParams.dwCardNum_u = 0;
                findParams.pcDatabaseName = pszDbName.getBytes();
                pnError[0] = SyncManager.sunwSyncFindDbByName((CSyncFindDbByNameParams)findParams, (SyncDatabaseInfoType)dbInfo);
                if (pnError[0] == 0L) {
                    fPresent = true;
                }
            }
        } else {
            pnError[0] = SyncManager.sunwSyncOpenDB((String)pszDbName, (int)0, (int[])bhFile, (int)128);
            if (pnError[0] == 0L) {
                SyncManager.sunwSyncCloseDB((int)bhFile[0]);
                fPresent = true;
            }
        }
        return fPresent;
    }

    public boolean IsExitPending() {
        boolean bRtn = false;
        return bRtn;
    }

    boolean IsHotSyncEnabled() {
        return this.m_nDisableHotSync <= 0L;
    }

    protected long LocalSync() {
        long nRtn = 0L;
        boolean[] fFatalError = new boolean[]{false};
        this.feedback = messages.getString("Synchronization started.");
        Logger.doLogging((String)this.feedback);
        nRtn = this.PreLocalSync();
        Logger.doProgressUpdate(null, (int)0);
        fFatalError[0] = this.DoError(nRtn);
        if (!fFatalError[0]) {
            nRtn = this.DoConduitSync(fFatalError);
        }
        this.feedback = messages.getString("Writing out user information to handheld...");
        Logger.doDebugLogging((String)this.feedback, (int)4);
        Logger.doDebugLogging((String)this.userResolver.dumpFormatted(), (int)4);
        if (!fFatalError[0]) {
            if (this.pilotName != null) {
                this.userResolver.createAssociation(this.pilotName);
            }
            nRtn = this.userResolver.WriteUserInfo();
            fFatalError[0] = this.DoError(nRtn);
            if (fFatalError[0]) {
                this.feedback = messages.getString("Not writing out user information to handheld,\ndue to conduit synchronization errors.");
                Logger.doDebugLogging((String)this.feedback, (int)4);
            }
        }
        this.m_nSyncExitCode = nRtn;
        this.PostLocalSync();
        Logger.doProgressUpdate(null, (int)((int)nRtn));
        if (fFatalError[0]) {
            this.gSyncState.m_fFatalError = true;
        } else {
            nRtn = 0L;
        }
        return nRtn;
    }

    public long PerformHotSync() {
        HotSync hotSync;
        long nRtn = 0L;
        CSystemInfo csysInfo = new CSystemInfo();
        this.m_dwTotalWarnings = 0;
        this.gSyncState.Reset();
        ScreenLockState s = new ScreenLockState();
        if (s.keyBoardGrabable() == 0) {
            this.m_pCurTransport.Disconnect();
            this.feedback = messages.getString("Sync not permitted while Desktop screen is Locked.");
            Logger.doProgressMsg((String)this.feedback, (int)((int)nRtn));
            Logger.doLogging((String)this.feedback, (int)((int)nRtn));
            return nRtn;
        }
        nRtn = SyncManager.sunwSyncReadSystemInfo((CSystemInfo)csysInfo);
        if (nRtn != 0L) {
            this.m_pCurTransport.Disconnect();
            this.feedback = messages.getString("Failed to get device information.");
            Logger.doProgressMsg((String)this.feedback, (int)((int)nRtn));
            Logger.doLogging((String)this.feedback, (int)((int)nRtn));
            return nRtn;
        }
        this.gSyncState.m_fConnected = true;
        if (this.m_bStartEndSync) {
            UserResolver tempUserInfo = new UserResolver();
            this.feedback = messages.getString("Start/End Sync initiated.");
            Logger.doProgressMsg((String)this.feedback, (int)0);
            Logger.doLogging((String)this.feedback);
            nRtn = tempUserInfo.readUserInfo();
            if (nRtn != 0L) {
                this.feedback = messages.getString("Could not get user information from device.");
                Logger.doLogging((String)this.feedback);
                return nRtn;
            }
            this.feedback = String.valueOf(messages.getString("User information read:")) + "\n" + tempUserInfo.dumpFormatted();
            Logger.doDebugLogging((String)this.feedback, (int)4);
            this.feedback = String.valueOf(messages.getString("Writing out user information to handheld...")) + "\n";
            Logger.doDebugLogging((String)this.feedback, (int)4);
            tempUserInfo.WriteUserInfo();
            this.EndSync(nRtn);
        } else {
            this.userResolver = new UserResolver();
            if (nRtn == 0L) {
                nRtn = this.DiscoverProductCompatibility();
                this.DoError(nRtn);
                if (nRtn == 0L) {
                    Logger.doDebugLogging((String)"DiscoverProductCompatibility() succeeded", (int)4);
                } else {
                    Logger.doDebugLogging((String)("DiscoverProductCompatibility() failed: " + nRtn + " (0x" + Integer.toHexString((int)nRtn) + ")"), (int)4);
                }
            }
            if (nRtn == 0L) {
                nRtn = this.DiscoverCommState();
                if (nRtn == 0L) {
                    Logger.doDebugLogging((String)"DiscoverCommState() succeeded", (int)4);
                } else {
                    Logger.doDebugLogging((String)("DiscoverCommState() failed: " + nRtn + " (0x" + Integer.toHexString((int)nRtn) + ")"), (int)4);
                }
            }
            if (nRtn == 0L && (nRtn = this.IdentifyPilotUser()) != 0L) {
                this.feedback = messages.getString("Could not establish user.");
                Logger.doProgressMsg((String)this.feedback, (int)((int)nRtn));
                Logger.doLogging((String)this.feedback, (int)((int)nRtn));
            }
            if (nRtn == 0L) {
                nRtn = this.EstablishSyncType();
                if (nRtn == 0L) {
                    Logger.doDebugLogging((String)"EstablishSyncType() succeeded", (int)4);
                } else {
                    Logger.doDebugLogging((String)("EstablishSyncType() failed: " + nRtn + " (0x" + Integer.toHexString((int)nRtn) + ")"), (int)4);
                }
            }
            if (nRtn == 0L && this.gSyncState.m_SyncLocale == 1) {
                if (this.gSyncState.m_fLocalCompatible) {
                    nRtn = this.ValidateLocalUser();
                    if (nRtn != 0L) {
                        Logger.doDebugLogging((String)("ValidateLocalUser() failed: " + nRtn + " (0x" + Integer.toHexString((int)nRtn) + ")"), (int)4);
                    } else {
                        nRtn = this.LocalSync();
                    }
                } else {
                    nRtn = 268468236L;
                    Logger.doDebugLogging((String)"Handheld is incompatible with PDASync", (int)4);
                }
            }
            if (nRtn == 0L) {
                this.feedback = messages.getString("Successfully synchronized data.");
            } else {
                switch ((int)nRtn) {
                    case 0x10008001: {
                        this.feedback = messages.getString("Synchronization cancelled by user.");
                        hotSync = this;
                        synchronized (hotSync) {
                            this.m_bLocalUserCancel = false;
                            break;
                        }
                    }
                    case 268468226: {
                        System.out.println("HOTERR_LOGFILE");
                        break;
                    }
                    case 268468227: {
                        System.out.println("HOTERR_READDBLIST");
                        break;
                    }
                    case 268468228: {
                        System.out.println("HOTERR_ESTABLISHUSER");
                        break;
                    }
                    case 268468229: {
                        System.out.println("HOTERR_RECVWAKEUP");
                        break;
                    }
                    case 268468230: {
                        System.out.println("HOTERR_TASKMASTER");
                        break;
                    }
                    case 268468231: {
                        System.out.println("HOTERR_CONDUITMANAGER");
                        break;
                    }
                    case 0x10008008: {
                        System.out.println("HOTERR_SETCONNECTION");
                        break;
                    }
                    case 268468233: {
                        System.out.println("HOTERR_NOTIFYSYNC");
                        break;
                    }
                    case 268468234: {
                        System.out.println("HOTERR_DISKSPACE");
                        break;
                    }
                    case 268468235: {
                        System.out.println("HOTERR_BAD_PASSWORD");
                        break;
                    }
                    case 268468236: {
                        System.out.println("HOTERR_INCOMPATIBLE_PRODUCTS");
                        break;
                    }
                    case 268468288: {
                        System.out.println("HOTERR_GENERAL_ERROR");
                        break;
                    }
                }
            }
            this.updateViewerAndHHProgress(7, this.feedback, (int)nRtn);
            Logger.doLogging((String)this.feedback, (int)((int)nRtn));
            if (this.props.pdasyncAutoClose) {
                this.logger.notifyListeners(true);
            }
            this.EndSync(nRtn);
        }
        Logger.doProgressUpdate((String)this.feedback, (int)((int)nRtn));
        hotSync = this;
        synchronized (hotSync) {
            if (this.m_bLocalUserCancel) {
                nRtn = 0x10008001L;
            }
        }
        return nRtn;
    }

    protected void PostLocalSync() {
        this.m_pTaskMaster.writeDBList();
        this.freeDbList(this.m_pTaskMaster.m_dbList);
        this.m_pTaskMaster = null;
    }

    protected long PreLocalSync() {
        long nRtn = 0L;
        Logger.doDebugLogging((String)"Setting up synchronization environment.", (int)4);
        this.m_dwTotalWarnings = 0;
        this.InitGeneralSyncProperties();
        nRtn = this.CreateTaskMaster();
        HotSync hotSync = this;
        synchronized (hotSync) {
            if (nRtn == 0L && this.m_bLocalUserCancel) {
                nRtn = 0x10008001L;
            }
        }
        return nRtn;
    }

    public void ReInitialize() {
        String portToUse = this.getRequestPort();
        if (portToUse.compareTo(this.usedPort) != 0) {
            if (this.m_pCurTransport != null) {
                this.m_pCurTransport.Disconnect();
            }
            this.m_pCurTransport = null;
            this.m_pDirectTransport = null;
        }
        this.UnInitialize();
        try {
            this.InitInstance();
        }
        catch (HotSyncException e) {
            if (e.syncExc != null) {
                Logger.doDebugLogging((String)e.syncExc.toString(), (int)4);
            }
            this.feedback = e.getLocalizedMessage();
            Logger.doDebugLogging((String)this.feedback, (int)4);
            if (e.visibility == 2 || e.visibility == 5) {
                Logger.doProgressMsg((String)this.feedback, (int)0);
            }
            return;
        }
        this.logger.notifyListeners(0, null, 0);
    }

    public long ReadRemoteDBList(CTaskMaster task) {
        Card card = new Card();
        int nTotal = 0;
        task.m_nDbListCount[0] = 0;
        long nRtn = SyncManager.sunwSyncReadSingleCardInfo((Card)card);
        if (nRtn == 0L) {
            task.m_nDbListCount[0] = card.romDbCount + card.ramDbCount;
            task.m_dbList = CDbList.makeCDbListArray(task.m_nDbListCount[0]);
            int[] nROM = new int[]{card.romDbCount};
            nRtn = SyncManager.sunwSyncReadDBList((int)0, (int)0, (boolean)false, (CDbList[])task.m_dbList, (int[])nROM);
            if (nRtn == 0L) {
                nTotal += nROM[0];
                int[] nRAM = new int[]{card.ramDbCount};
                CDbList[] temp = CDbList.makeCDbListArray(nRAM[0]);
                nRtn = SyncManager.sunwSyncReadDBList((int)0, (int)0, (boolean)true, (CDbList[])temp, (int[])nRAM);
                if (nRtn == 0L) {
                    nTotal += nRAM[0];
                    int n = 0;
                    while (n < nRAM[0]) {
                        task.m_dbList[n + nROM[0]] = temp[n];
                        ++n;
                    }
                }
            }
        }
        return nRtn;
    }

    public long RestoreFromBackup() {
        long nRtn = 0L;
        CSyncProperties properties = new CSyncProperties();
        CSyncProperties backupProps = new CSyncProperties();
        CSyncTask syncTask = new CSyncTask();
        CSyncTask backupTask = new CSyncTask();
        CTaskMaster taskMaster = new CTaskMaster();
        CDbList[] pDbList = null;
        boolean bResult = true;
        int nDbCount = 0;
        this.feedback = messages.getString("Performing restore...");
        Logger.doDebugLogging((String)this.feedback, (int)4);
        if (this.userResolver.isProfiled()) {
            this.feedback = messages.getString("Restore not invoked since handheld is profiled.");
            Logger.doDebugLogging((String)this.feedback, (int)4);
            Logger.doDebugLogging((String)this.userResolver.dumpFormatted(), (int)4);
            return nRtn;
        }
        int nCount = this.m_PostSyncConduitManager.GetConduitCount();
        if (nCount == 0) {
            this.feedback = messages.getString("Could not retrieve Backup conduit.");
            Logger.doDebugLogging((String)this.feedback, (int)4);
        }
        int i = 0;
        while (i < nCount && (nRtn & 0x10000000L) == 0L) {
            CConduitJar backup = this.m_PostSyncConduitManager.GetConduit(i);
            if (backup != null && backup.GetViewerAppID() == -1) {
                backupProps.m_RemoteDbList = null;
                backupTask.setCreator(backup.GetViewerAppID());
                backupTask.setState(1);
                this.InitSyncProperties(backupProps);
                backupProps.m_Creator_u = backupTask.GetCreator();
                this.SetSyncFiles(backupTask, backup, backupProps);
            }
            ++i;
        }
        nCount = this.m_PreSyncConduitManager.GetConduitCount();
        if (nCount == 0) {
            this.feedback = messages.getString("Could not retrieve Install conduit.");
            Logger.doDebugLogging((String)this.feedback, (int)4);
        }
        i = 0;
        while (i < nCount && (nRtn & 0x10000000L) == 0L) {
            CConduitJar pConduit = this.m_PreSyncConduitManager.GetConduit(i);
            if (pConduit != null && pConduit.GetViewerAppID() == 0) {
                properties.m_RemoteDbList = null;
                this.m_bForcingRestore = true;
                syncTask.setCreator(pConduit.GetViewerAppID());
                syncTask.setState(1);
                this.InitSyncProperties(properties);
                if (properties.m_FirstDevice == 2 || this.userResolver.isProfiled()) {
                    properties.m_Creator_u = syncTask.GetCreator();
                    this.SetSyncFiles(syncTask, pConduit, properties);
                    properties.m_PathName = backupProps.m_PathName;
                    nRtn = this.ReadRemoteDBList(taskMaster);
                    pDbList = taskMaster.m_dbList;
                    nDbCount = taskMaster.m_nDbListCount[0];
                    this.SetPropertiesDbList(pDbList, nDbCount, properties);
                    properties.m_SyncType = 4;
                    this.feedback = "RestoreFromBackup() properties: " + properties.dumpFormatted();
                    Logger.doDebugLogging((String)this.feedback, (int)4);
                    if (!pConduit.isLoaded()) {
                        bResult = pConduit.Load();
                    }
                    if (bResult) {
                        this.feedback = messages.getString("Restoring databases...");
                        Logger.doProgressMsg((String)this.feedback, (int)0);
                        Logger.doLogging((String)this.feedback);
                        nRtn = this.EngageConduit((Conduit)pConduit.conduitObj, properties);
                        if (nRtn == 0L) {
                            this.doRestore = true;
                            this.feedback = messages.getString("Restore done.");
                            Logger.doProgressMsg((String)this.feedback, (int)0);
                            Logger.doLogging((String)this.feedback);
                        } else {
                            this.feedback = messages.getString("PDASync was cancelled by user.");
                            Logger.doProgressMsg((String)this.feedback, (int)0x10008001);
                            Logger.doLogging((String)this.feedback);
                        }
                    } else {
                        this.feedback = messages.getString("Failed to load conduit!");
                        if (this.m_bVerbose) {
                            Logger.doLogging((String)this.feedback);
                        }
                        Logger.doDebugLogging((String)this.feedback, (int)4);
                    }
                } else {
                    this.feedback = messages.getString("Restore is not needed.");
                    Logger.doDebugLogging((String)this.feedback, (int)4);
                    Logger.doDebugLogging((String)this.userResolver.dumpFormatted(), (int)4);
                }
                this.freeDbList(pDbList);
                this.freeDbList(properties.m_RemoteDbList);
                this.m_bForcingRestore = false;
            }
            ++i;
        }
        return nRtn;
    }

    protected boolean RetrieveConduits() {
        this.m_ConduitManager = new CConduitManager();
        if (!this.m_ConduitManager.DiscoverConduits()) {
            Logger.doDebugLogging((String)"Could not discover general conduits.", (int)4);
            return false;
        }
        this.m_PreSyncConduitManager = new CPreSyncManager(this.m_ConduitManager.getRegistry());
        if (!this.m_PreSyncConduitManager.DiscoverConduits()) {
            Logger.doDebugLogging((String)"Could not pre-sync conduits.", (int)4);
            return false;
        }
        this.m_PostSyncConduitManager = new CPostGeneralSyncManager(this.m_ConduitManager.getRegistry());
        if (!this.m_PostSyncConduitManager.DiscoverConduits()) {
            Logger.doDebugLogging((String)"Could not post-sync conduits.", (int)4);
            return false;
        }
        int ticks = 6 + this.m_ConduitManager.GetConduitCount();
        this.logger.notifyListeners(ticks);
        return true;
    }

    private boolean SetLocalSyncFiles(CSyncTask pTask, CConduitJar pConduit, CSyncProperties pProperties) {
        boolean bRtn = false;
        bRtn = pConduit.SetLocalSyncFiles(pProperties);
        if (!bRtn) {
            this.feedback = messages.getString("Failed to set local sync files.");
            Logger.doDebugLogging((String)this.feedback, (int)4);
            return bRtn;
        }
        if (this.m_bVerbose) {
            Logger.doLogging((String)(String.valueOf(messages.getString("Local conduit path: ")) + new String(pProperties.m_PathName)));
        }
        Logger.doDebugLogging((String)("Local conduit path: " + new String(pProperties.m_PathName)), (int)4);
        return bRtn;
    }

    protected void SetPropertiesDbList(CDbList[] pDbList, int nDbCount, CSyncProperties properties) {
        this.freeDbList(properties.m_RemoteDbList);
        properties.m_RemoteDbList = CDbList.makeCDbListArray(nDbCount);
        properties.m_RemoteCount = 0;
        int n = 0;
        while (n < nDbCount) {
            CDbList pDatabase = pDbList[n];
            if (pDatabase != null) {
                properties.m_RemoteDbList[n] = pDatabase;
                ++properties.m_RemoteCount;
            }
            ++n;
        }
    }

    private boolean SetRemoteSyncFiles(CSyncTask pTask, CConduitJar pConduit, CSyncProperties pProperties) {
        boolean bRtn = pConduit.SetRemoteSyncFiles(pTask, pProperties);
        if (!bRtn) {
            this.feedback = messages.getString("Failed to set remote sync files.");
            Logger.doDebugLogging((String)this.feedback, (int)4);
        }
        if (this.m_bVerbose && bRtn) {
            int i = 0;
            while (i < pProperties.m_RemoteCount) {
                this.feedback = pProperties.m_RemoteDbList != null ? String.valueOf(messages.getString("Remote database name ")) + i + messages.getString(": ") + pProperties.m_RemoteDbList[i].m_Name : String.valueOf(messages.getString("Remote database name ")) + i + messages.getString(": ") + pProperties.m_RemoteName[i];
                Logger.doDebugLogging((String)this.feedback, (int)4);
                ++i;
            }
        }
        return bRtn;
    }

    private boolean SetSyncFiles(CSyncTask pTask, CConduitJar pConduit, CSyncProperties pProperties) {
        return this.SetLocalSyncFiles(pTask, pConduit, pProperties) && this.SetRemoteSyncFiles(pTask, pConduit, pProperties);
    }

    private boolean SetSyncProperties(CSyncTask pTask, CConduitJar pConduit, CSyncProperties pProperties) {
        boolean bResult = false;
        this.InitSyncProperties(pProperties);
        pProperties.m_Creator_u = pTask.GetCreator();
        pConduit.SetSyncType(this.userResolver, pTask, pProperties);
        bResult = this.SetSyncFiles(pTask, pConduit, pProperties);
        return bResult;
    }

    private long SyncConduit(CSyncTask pTask, CConduitJar pConduit) {
        return this.SyncConduit(pTask, pConduit, null, false, false);
    }

    private long SyncConduit(CSyncTask pTask, CConduitJar pConduit, String msg) {
        return this.SyncConduit(pTask, pConduit, msg, false, false);
    }

    private long SyncConduit(CSyncTask pTask, CConduitJar pConduit, String msg, boolean bGetDisplayName, boolean bIgnoreErrors) {
        HotSync hotSync;
        long nRtn = 0L;
        CSyncProperties properties = new CSyncProperties();
        Conduit cond = (Conduit)pConduit.conduitObj;
        this.feedback = msg == null ? String.valueOf(messages.getString("Synchronizing ")) + cond.name() : msg;
        Logger.doProgressMsg((String)this.feedback, (int)0);
        this.updateViewerAndHHProgress(6, this.feedback, 0);
        if (!this.SetSyncProperties(pTask, pConduit, properties)) {
            if (bIgnoreErrors) {
                HotSync hotSync2 = this;
                synchronized (hotSync2) {
                    if (this.m_bLocalUserCancel) {
                        nRtn = 0x10008001L;
                    }
                }
                return nRtn;
            }
            pTask.setState(3);
            this.feedback = String.valueOf(messages.getString("Failed to set synchronization properties for ")) + cond.name();
            if (this.m_bVerbose) {
                Logger.doProgressMsg((String)this.feedback, (int)0);
                Logger.doLogging((String)this.feedback);
            }
            Logger.doDebugLogging((String)("Failed to set synchronization properties for " + cond.name()), (int)4);
        }
        if (((nRtn = this.EngageConduit(cond, properties)) & 0x10000000L) == 0x10000000L) {
            switch ((int)nRtn) {
                case 0x10008001: {
                    this.feedback = messages.getString("Synchronization cancelled by user.");
                    Logger.doProgressMsg((String)this.feedback, (int)0x10008001);
                    Logger.doLogging((String)this.feedback);
                    pTask.setState(3);
                    hotSync = this;
                    synchronized (hotSync) {
                        this.m_bLocalUserCancel = true;
                        break;
                    }
                }
                case 268468226: {
                    System.out.println("HOTERR_LOGFILE");
                    break;
                }
                case 268468227: {
                    System.out.println("HOTERR_READDBLIST");
                    break;
                }
                case 268468228: {
                    System.out.println("HOTERR_ESTABLISHUSER");
                    Thread.currentThread();
                    Thread.dumpStack();
                    break;
                }
                case 268468229: {
                    System.out.println("HOTERR_RECVWAKEUP");
                    break;
                }
                case 268468230: {
                    System.out.println("HOTERR_TASKMASTER");
                    break;
                }
                case 268468231: {
                    System.out.println("HOTERR_CONDUITMANAGER");
                    break;
                }
                case 0x10008008: {
                    System.out.println("HOTERR_SETCONNECTION");
                    break;
                }
                case 268468233: {
                    System.out.println("HOTERR_NOTIFYSYNC");
                    break;
                }
                case 268468234: {
                    System.out.println("HOTERR_DISKSPACE");
                    break;
                }
                case 268468235: {
                    System.out.println("HOTERR_BAD_PASSWORD");
                    break;
                }
                case 268468236: {
                    System.out.println("HOTERR_INCOMPATIBLE_PRODUCTS");
                    break;
                }
                case 268468288: {
                    System.out.println("HOTERR_GENERAL_ERROR");
                    break;
                }
                default: {
                    System.out.println("HOTERR unlisted " + nRtn);
                    break;
                }
            }
        } else {
            pTask.setState(4);
        }
        hotSync = this;
        synchronized (hotSync) {
            if (this.m_bLocalUserCancel) {
                nRtn = 0x10008001L;
            }
        }
        return nRtn;
    }

    private long SyncConduit(CSyncTask pTask, CConduitJar pConduit, boolean bGetDisplayName) {
        return this.SyncConduit(pTask, pConduit, null, bGetDisplayName, false);
    }

    private long TestSyncEnvironment() {
        int iPreSyncCount = this.m_PreSyncConduitManager.GetConduitCount();
        int iPostSyncCount = this.m_PostSyncConduitManager.GetConduitCount();
        int iSyncCount = this.m_ConduitManager.GetConduitCount();
        if (iSyncCount < 0 || iPreSyncCount < 0 || iPostSyncCount < 0 || iPreSyncCount + iSyncCount + iPostSyncCount == 0) {
            return 268468231L;
        }
        if (this.userResolver == null) {
            return 268468228L;
        }
        if (this.m_pTaskMaster == null || this.m_pTaskMaster.GetTaskCount() <= 0) {
            return 268468230L;
        }
        return 0L;
    }

    public void UnInitialize() {
        this.m_pTaskMaster = null;
        this.m_bDirect = true;
        this.m_bVerbose = false;
        this.m_bInTimerProc = false;
        this.m_nSyncExitCode = 0L;
        this.m_nDisableHotSync = 0L;
        this.m_bForcingRestore = false;
        this.m_dwTotalWarnings = 0;
        this.m_bNetSyncSupported = false;
        this.m_bNetwork = false;
        this.userResolver = null;
        this.m_bStartEndSync = false;
        this.m_GeneralProperties = null;
        this.m_ConduitManager = null;
        this.m_PostSyncConduitManager = null;
        this.m_PreSyncConduitManager = null;
        this.doRestore = false;
        HotSync hotSync = this;
        synchronized (hotSync) {
            this.m_bLocalUserCancel = false;
        }
    }

    public void UpdateProgressUserName() {
    }

    public long ValidateLocalUser() {
        long nRtn = 268468228L;
        String hhPassword = this.userResolver.getHHPassword();
        if (hhPassword != null && !hhPassword.equals("")) {
            NonStdUtils nsu = new NonStdUtils();
            byte[] hhpd = hhPassword.getBytes();
            boolean verified = false;
            int passwordError = 0;
            while (!verified) {
                this.logger.notifyListeners(13, null, passwordError);
                if (this.pilotPasswd.equals("usercancel")) {
                    Logger.doDebugLogging((String)"User did not give PalmPilot a correct password.", (int)4);
                    return 268468235L;
                }
                byte[] upd = this.pilotPasswd.getBytes();
                int ret = nsu.RemovePostGeneralSyncTasks(hhpd, upd);
                if (ret == 1) {
                    verified = true;
                    continue;
                }
                passwordError = 1;
            }
        }
        if (this.gSyncState.m_fUserIdMatch) {
            this.feedback = messages.getString("Resolved device to user.");
            Logger.doProgressMsg((String)this.feedback, (int)0);
            return 0L;
        }
        if (this.gSyncState.m_fPilotHasUserId) {
            if (!this.userResolver.associated) {
                this.feedback = messages.getString("Associating device to user.");
                Logger.doProgressMsg((String)this.feedback, (int)0);
                this.userResolver.createAssociation();
                return 0L;
            }
            this.logger.notifyListeners(this.pilotAssoc);
            boolean stop = false;
            while (!stop) {
                if (this.pilotAssoc != null) {
                    stop = true;
                    continue;
                }
                Logger.doDebugLogging((String)"Waiting for user to continue or to abort the sync.", (int)4);
                try {
                    Thread.sleep(1500L);
                }
                catch (Exception exception) {}
            }
            if (this.pilotAssoc.equals("usercancel")) {
                Logger.doDebugLogging((String)"User discontinued sync - association not updated.", (int)4);
                nRtn = 268468228L;
            } else {
                Logger.doDebugLogging((String)"User continued sync - association file updated.", (int)4);
                this.userResolver.setStoredInfo();
                this.gSyncState.m_fUserIdMatch = true;
                nRtn = 0L;
            }
        } else if (this.userResolver.associated) {
            nRtn = 0L;
        }
        return nRtn;
    }

    public void abortConnection(DataAvailableEvent e) {
    }

    public void answerViewerRequest(UserInteractionEvent e) {
        switch (e.actionType) {
            case 1: {
                HotSync hotSync = this;
                synchronized (hotSync) {
                    this.m_bLocalUserCancel = true;
                }
                String msg = messages.getString("Please wait...finishing\ncurrent operation.");
                this.updateViewerAndHHProgress(-1, msg, 0);
                break;
            }
        }
    }

    private boolean checkPortSpeedChanged() {
        if (this.props.pdasyncPortSpeed == this.portSpeed) {
            return false;
        }
        this.portSpeed = this.props.pdasyncPortSpeed;
        if (this.portSpeed == 0) {
            this.portSpeed = SyncUtils.getMaxBaud();
        }
        return true;
    }

    public void connectionSniffer(long dwSysTime) throws HotSyncException {
        if (this.m_bInTimerProc || !this.IsHotSyncEnabled() || this.IsExitPending()) {
            this.feedback = HotSyncException.messageNames[6];
            this.hse = new HotSyncException(6, 5, this.feedback, messages);
            throw this.hse;
        }
        if (!this.CheckForSyncConnection()) {
            this.feedback = "Bailing: CheckForSyncConnection()";
            Logger.doDebugLogging((String)this.feedback, (int)4);
            this.feedback = HotSyncException.messageNames[6];
            this.hse = new HotSyncException(6, 5, this.feedback, messages);
            if (numTries >= 5) {
                throw this.hse;
            }
            ++numTries;
            return;
        }
        numTries = 0;
        this.logger.notifyListeners(1, null, 0);
        this.logInitialState(this.usedPort);
        this.m_nSyncExitCode = 0L;
        this.m_bInTimerProc = true;
        this.feedback = messages.getString("Synchronization started.");
        Logger.doProgressMsg((String)this.feedback, (int)0);
        this.m_nSyncExitCode = this.m_pCurTransport.EstablishConnection();
        if (this.m_nSyncExitCode != 0L) {
            this.feedback = HotSyncException.messageNames[6];
            this.hse = new HotSyncException(6, 5, this.feedback, messages);
            throw this.hse;
        }
        this.feedback = messages.getString("Connection established...");
        this.updateViewerAndHHProgress(7, this.feedback, 0);
        Logger.doProgressUpdate((String)this.feedback, (int)0);
        this.m_nSyncExitCode = this.PerformHotSync();
        this.m_bInTimerProc = false;
        try {
            Thread.sleep(2000L);
        }
        catch (InterruptedException e) {
            Logger.doDebugLogging((String)e.toString(), (int)4);
        }
        this.logger.notifyListeners(0, null, 0);
    }

    public void eavesDropOnSerialPort() {
        SerialPortCommunicator spc = this.getSerialPortCommunicator();
        if (spc == null) {
            this.feedback = messages.getString("Selected port not available.");
            Logger.doProgressMsg((String)this.feedback, (int)0);
            return;
        }
        spc.addDataAvailableListener((DataAvailableListener)this);
    }

    protected void freeDbList(CDbList[] dbList) {
        if (dbList != null) {
            int i = 0;
            while (i < dbList.length) {
                dbList[i] = null;
                ++i;
            }
            dbList = null;
        }
    }

    protected Vector getAllManagedConduits() {
        Vector all = new Vector();
        Vector temp = this.m_PreSyncConduitManager.getConduitInfo();
        int i = 0;
        while (i < temp.size()) {
            all.addElement(temp.elementAt(i));
            ++i;
        }
        temp = this.m_ConduitManager.getConduitInfo();
        i = 0;
        while (i < temp.size()) {
            all.addElement(temp.elementAt(i));
            ++i;
        }
        temp = this.m_PostSyncConduitManager.getConduitInfo();
        i = 0;
        while (i < temp.size()) {
            all.addElement(temp.elementAt(i));
            ++i;
        }
        return all;
    }

    private String getRequestPort() {
        String port = null;
        port = this.props.pdasyncPort == null ? new String(DEFAULT_PORT) : this.props.pdasyncPort;
        return port;
    }

    public SerialPortCommunicator getSerialPortCommunicator() {
        if (this.m_pCurTransport != null) {
            return this.m_pCurTransport.getSerialPort();
        }
        return null;
    }

    public void ignoreConnection(DataAvailableEvent e) {
    }

    protected void ignoreSerialPortBlurp() {
        SerialPortCommunicator spc = this.getSerialPortCommunicator();
        if (spc == null) {
            Logger.doDebugLogging((String)"NO SERIAL PORT COMMUNICATOR", (int)4);
            this.feedback = messages.getString("Selected port not available.");
            Logger.doProgressMsg((String)this.feedback, (int)0);
            return;
        }
        spc.removeDataAvailableListener((DataAvailableListener)this);
    }

    public void logInitialState(String usedPort) {
        Date date = new Date();
        String str = String.valueOf(date.toString()) + "\n" + messages.getString("SyncManager Version: ") + this.dwVerMajor + "." + this.dwVerMinor + "\n" + messages.getString("Using port: ") + usedPort + "\n";
        Logger.doLogging((String)str, (boolean)true);
    }

    public void pollConnection(DataAvailableEvent e) {
        this.ignoreSerialPortBlurp();
        this.m_pCurTransport.m_padState = (short)16384;
        this.feedback = "Got notification from the Serial Port Communicator";
        Logger.doDebugLogging((String)this.feedback, (int)4);
        try {
            this.connectionSniffer(100L);
        }
        catch (HotSyncException he) {
            this.feedback = he.getLocalizedMessage();
            Logger.doDebugLogging((String)this.feedback, (int)4);
            if (he.visibility == 2 || he.visibility == 5) {
                Logger.doProgressMsg((String)this.feedback, (int)0);
            }
            return;
        }
        if (this.m_pCurTransport != null) {
            this.m_pCurTransport.stopTheTimer();
            this.eavesDropOnSerialPort();
        } else {
            this.ReInitialize();
        }
    }

    public void propertyChanged(PropertyChangeEvent e) {
        CConduitJar pConduit = null;
        switch (e.notificationType) {
            case 2: {
                this.ReInitialize();
                break;
            }
            case 1: {
                if (e.message == null || this.m_ConduitManager.configureConduit((String)e.message) || this.m_PostSyncConduitManager.configureConduit((String)e.message) || this.m_PreSyncConduitManager.configureConduit((String)e.message)) break;
                return;
            }
            case 3: {
                if (e.message == null || this.m_ConduitManager.toggleActiveState((String)e.message) || this.m_PostSyncConduitManager.toggleActiveState((String)e.message) || this.m_PreSyncConduitManager.toggleActiveState((String)e.message)) break;
                return;
            }
            case 4: {
                if (e.message == null || (pConduit = this.m_ConduitManager.toggleDeletedState((String)e.message)) == null && (pConduit = this.m_PostSyncConduitManager.toggleDeletedState((String)e.message)) == null && (pConduit = this.m_PreSyncConduitManager.toggleDeletedState((String)e.message)) == null) break;
                this.logger.notifyListeners(this.getAllManagedConduits(), 0);
                break;
            }
            case 8: {
                if (e.message == null) break;
                int error = 0;
                this.addInfo = (Vector)e.message;
                String installType = this.addInfo.elementAt(0).toString();
                String conduitName = this.addInfo.elementAt(1).toString();
                if (installType.equals("new")) {
                    String fileShortName;
                    String fileFullName;
                    String className = this.addInfo.elementAt(2).toString();
                    String remoteDBName = this.addInfo.elementAt(3).toString();
                    int creatorID = Integer.parseInt(this.addInfo.elementAt(4).toString());
                    int registryType = Integer.parseInt(this.addInfo.elementAt(5).toString());
                    boolean ret = ConduitInstall.registerConduit(registryType, creatorID, remoteDBName, className, fileFullName = this.addInfo.elementAt(6).toString(), conduitName, fileShortName = SyncUtils.getFileShortName((String)fileFullName));
                    if (!ret && registryType == 1) {
                        ret = ConduitInstall.registerConduit(registryType + 1, creatorID, remoteDBName, className, fileFullName, conduitName, fileShortName);
                    }
                    if (ret) {
                        this.ReInitialize();
                    } else {
                        error = 1;
                    }
                } else {
                    pConduit = this.m_ConduitManager.getConduitByName(conduitName);
                    if (pConduit == null || !this.m_ConduitManager.getDeletedState(conduitName) || (pConduit = this.m_ConduitManager.setDeletedState(conduitName, false)) == null) break;
                    this.m_ConduitManager.setActiveState(conduitName, false);
                }
                this.logger.notifyListeners(this.getAllManagedConduits(), error);
                break;
            }
            case 5: {
                if (e.message != null) {
                    this.pilotName = new String((String)e.message);
                    break;
                }
                this.pilotName = new String("usercancel");
                break;
            }
            case 6: {
                this.pilotPasswd = new String((String)e.message);
                break;
            }
            case 7: {
                if (e.message != null) {
                    this.pilotAssoc = new String((String)e.message);
                    break;
                }
                this.pilotAssoc = new String("usercancel");
                break;
            }
        }
    }

    public void run() {
        this.ReInitialize();
    }

    public void setStartEndSync(boolean flag) {
        this.m_bStartEndSync = flag;
    }

    public void updateHandheldProgress(String msg) {
        try {
            SyncManager.addLogEntry((String)msg);
        }
        catch (SyncException e) {
            Logger.doDebugLogging((String)e.toString(), (int)4);
        }
    }

    public void updateViewerAndHHProgress(int type, String msg, int error) {
        Logger.doProgressMsg((String)msg, (int)error);
        this.updateHandheldProgress("\n" + msg);
    }
}

