/*
 * Decompiled with CFR 0.152.
 */
package com.sun.pdasync.HotSync;

import com.sun.pdasync.HotSync.CConduitJar;
import com.sun.pdasync.HotSync.CConduitManager;
import com.sun.pdasync.Logger.Logger;
import com.sun.pdasync.Registry.ConduitStateInfo;
import com.sun.pdasync.Registry.Registry;
import java.io.Serializable;
import java.util.Enumeration;
import java.util.Locale;
import java.util.MissingResourceException;
import java.util.ResourceBundle;

public class CPostGeneralSyncManager
extends CConduitManager
implements Serializable {
    private String feedback;
    private static Locale theLocale;
    private static ResourceBundle messages;

    static {
        try {
            theLocale = Locale.getDefault();
            messages = ResourceBundle.getBundle("com.sun.pdasync.ListResourceBundle.HotSyncMessages", theLocale);
        }
        catch (MissingResourceException e) {
            Logger.doLogging((String)"PDASync: can't find message file");
            Logger.doLogging((String)("PDASync:" + e.getMessage()));
            System.exit(1);
        }
    }

    public CPostGeneralSyncManager(Registry reg) {
        super(reg);
    }

    protected boolean DiscoverBackupConduits() {
        int iConduitCount = this.registry.getRegistryCount();
        Enumeration cList = this.registry.getStateEnumeration();
        CConduitJar pConduit = null;
        while (cList.hasMoreElements()) {
            ConduitStateInfo aConduit = (ConduitStateInfo)cList.nextElement();
            if (aConduit.getCreatorID() != -1 || !this.DiscoverConduitInfo(pConduit = new CConduitJar(aConduit))) continue;
            this.AddConduit(pConduit);
            Logger.doDebugLogging((String)(String.valueOf(messages.getString("Adding to post-sync conduit list: ")) + aConduit.getName() + "\n" + aConduit.dumpFormatted()), (int)4);
        }
        return pConduit != null;
    }

    public boolean DiscoverConduits() {
        Logger.doDebugLogging((String)messages.getString("Discovering post-synchronization conduits..."), (int)4);
        return this.DiscoverBackupConduits();
    }
}

