/*
 * Decompiled with CFR 0.152.
 */
package com.sun.dhcpmgr.server;

import com.sun.dhcpmgr.bridge.Bridge;
import com.sun.dhcpmgr.bridge.BridgeException;
import com.sun.dhcpmgr.bridge.NoEntryException;
import com.sun.dhcpmgr.bridge.NoHostsEntryException;
import com.sun.dhcpmgr.data.DhcpClientRecord;
import com.sun.dhcpmgr.data.DhcpDatastore;
import com.sun.dhcpmgr.data.DhcptabRecord;
import com.sun.dhcpmgr.data.Macro;
import com.sun.dhcpmgr.data.Network;
import com.sun.dhcpmgr.server.DhcpHostsTable;
import com.sun.dhcpmgr.server.DhcpNetMgr;

public class DhcpNetMgrImpl
implements DhcpNetMgr {
    private Bridge bridge;

    public DhcpNetMgrImpl(Bridge bridge) {
        this.bridge = bridge;
    }

    public void addClient(DhcpClientRecord dhcpClientRecord, String string) throws BridgeException {
        this.addClient(dhcpClientRecord, string, null);
    }

    public void addClient(DhcpClientRecord dhcpClientRecord, String string, DhcpDatastore dhcpDatastore) throws BridgeException {
        if (dhcpClientRecord.getClientName().length() != 0 && !dhcpClientRecord.getClientName().equals(dhcpClientRecord.getClientIPAddress())) {
            this.createHostsRecord(dhcpClientRecord.getClientIPAddress(), dhcpClientRecord.getClientName(), dhcpClientRecord.getComment());
        }
        this.bridge.createDhcpClientRecord(dhcpClientRecord, string, dhcpDatastore);
    }

    private void createHostsRecord(String string, String string2, String string3) throws BridgeException {
        DhcpHostsTable dhcpHostsTable;
        block4: {
            dhcpHostsTable = null;
            try {
                dhcpHostsTable = DhcpHostsTable.getCfgHostsTable(this.bridge);
                if (dhcpHostsTable == null) break block4;
                dhcpHostsTable.openTable();
                dhcpHostsTable.createHostsRecord(string, string2, string3);
            }
            catch (Throwable throwable) {
                Object var6_6 = null;
                if (dhcpHostsTable != null) {
                    dhcpHostsTable.closeTable();
                }
                throw throwable;
            }
        }
        Object var6_5 = null;
        if (dhcpHostsTable != null) {
            dhcpHostsTable.closeTable();
        }
    }

    public void createNetwork(String string) throws BridgeException {
        this.createNetwork(string, null);
    }

    public void createNetwork(String string, DhcpDatastore dhcpDatastore) throws BridgeException {
        this.bridge.createDhcpNetwork(string, dhcpDatastore);
    }

    public void cvtNetwork(String string, DhcpDatastore dhcpDatastore) throws BridgeException {
        this.bridge.cvtNetwork(string, dhcpDatastore);
    }

    public void deleteClient(DhcpClientRecord dhcpClientRecord, String string, boolean bl) throws BridgeException {
        this.deleteClient(dhcpClientRecord, string, bl, null);
    }

    public void deleteClient(DhcpClientRecord dhcpClientRecord, String string, boolean bl, DhcpDatastore dhcpDatastore) throws BridgeException {
        this.bridge.deleteDhcpClientRecord(dhcpClientRecord, string, dhcpDatastore);
        if (bl) {
            try {
                this.deleteHostsRecord(dhcpClientRecord.getClientIPAddress());
            }
            catch (NoEntryException noEntryException) {
                throw new NoEntryException("hosts");
            }
        }
    }

    private void deleteHostsRecord(String string) throws BridgeException {
        DhcpHostsTable dhcpHostsTable;
        block4: {
            dhcpHostsTable = null;
            try {
                dhcpHostsTable = DhcpHostsTable.getCfgHostsTable(this.bridge);
                if (dhcpHostsTable == null) break block4;
                dhcpHostsTable.openTable();
                dhcpHostsTable.deleteHostsRecord(string);
            }
            catch (Throwable throwable) {
                Object var4_4 = null;
                if (dhcpHostsTable != null) {
                    dhcpHostsTable.closeTable();
                }
                throw throwable;
            }
        }
        Object var4_3 = null;
        if (dhcpHostsTable != null) {
            dhcpHostsTable.closeTable();
        }
    }

    public void deleteNetwork(String string, boolean bl, boolean bl2) throws BridgeException {
        this.deleteNetwork(string, bl, bl2, null);
    }

    public void deleteNetwork(String string, boolean bl, boolean bl2, DhcpDatastore dhcpDatastore) throws BridgeException {
        DhcpClientRecord[] dhcpClientRecordArray;
        if (bl2 && (dhcpClientRecordArray = this.bridge.loadNetwork(string, dhcpDatastore)) != null) {
            int n = 0;
            while (n < dhcpClientRecordArray.length) {
                try {
                    this.deleteHostsRecord(dhcpClientRecordArray[n].getClientIPAddress());
                }
                catch (Throwable throwable) {}
                ++n;
            }
        }
        this.bridge.deleteDhcpNetwork(string, dhcpDatastore);
        try {
            if (bl) {
                this.bridge.deleteDhcptabRecord((DhcptabRecord)new Macro(string), dhcpDatastore);
            }
        }
        catch (Throwable throwable) {}
    }

    public DhcpClientRecord getClient(DhcpClientRecord dhcpClientRecord, String string, DhcpDatastore dhcpDatastore) throws BridgeException {
        DhcpClientRecord dhcpClientRecord2 = this.bridge.getDhcpClientRecord(dhcpClientRecord, string, dhcpDatastore);
        return dhcpClientRecord2;
    }

    public Network getNetwork(String string) throws BridgeException {
        return this.bridge.getNetwork(string);
    }

    public Network[] getNetworks() throws BridgeException {
        return this.getNetworks(null);
    }

    public Network[] getNetworks(DhcpDatastore dhcpDatastore) throws BridgeException {
        return this.bridge.getNetworks(dhcpDatastore);
    }

    public DhcpClientRecord[] loadNetwork(String string) throws BridgeException {
        return this.loadNetwork(string, null);
    }

    public DhcpClientRecord[] loadNetwork(String string, DhcpDatastore dhcpDatastore) throws BridgeException {
        return this.bridge.loadNetwork(string, dhcpDatastore);
    }

    public DhcpClientRecord[] loadNetworkCompletely(String string) throws BridgeException {
        DhcpClientRecord[] dhcpClientRecordArray = this.loadNetwork(string);
        int n = 0;
        while (n < dhcpClientRecordArray.length) {
            dhcpClientRecordArray[n].getClientName();
            ++n;
        }
        return dhcpClientRecordArray;
    }

    public void modifyClient(DhcpClientRecord dhcpClientRecord, DhcpClientRecord dhcpClientRecord2, String string) throws BridgeException {
        this.modifyClient(dhcpClientRecord, dhcpClientRecord2, string, null);
    }

    public void modifyClient(DhcpClientRecord dhcpClientRecord, DhcpClientRecord dhcpClientRecord2, String string, DhcpDatastore dhcpDatastore) throws BridgeException {
        boolean bl = dhcpClientRecord.getClientName().equals(dhcpClientRecord2.getClientName()) ^ true;
        boolean bl2 = dhcpClientRecord.getComment().equals(dhcpClientRecord2.getComment()) ^ true;
        if (bl) {
            if (dhcpClientRecord2.getClientName().length() == 0) {
                try {
                    this.deleteHostsRecord(dhcpClientRecord2.getClientIPAddress());
                }
                catch (Throwable throwable) {
                    throw new NoHostsEntryException(dhcpClientRecord2.getClientIPAddress());
                }
            } else {
                try {
                    this.modifyHostsRecord(dhcpClientRecord.getClientIPAddress(), dhcpClientRecord2.getClientIPAddress(), dhcpClientRecord2.getClientName(), dhcpClientRecord2.getComment());
                }
                catch (NoHostsEntryException noHostsEntryException) {
                    this.createHostsRecord(dhcpClientRecord2.getClientIPAddress(), dhcpClientRecord2.getClientName(), dhcpClientRecord2.getComment());
                }
            }
        } else if (bl2) {
            try {
                this.modifyHostsRecord(dhcpClientRecord.getClientIPAddress(), dhcpClientRecord2.getClientIPAddress(), dhcpClientRecord2.getClientName(), dhcpClientRecord2.getComment());
            }
            catch (Throwable throwable) {}
        }
        this.bridge.modifyDhcpClientRecord(dhcpClientRecord, dhcpClientRecord2, string, dhcpDatastore);
    }

    private void modifyHostsRecord(String string, String string2, String string3, String string4) throws BridgeException {
        DhcpHostsTable dhcpHostsTable;
        block4: {
            dhcpHostsTable = null;
            try {
                dhcpHostsTable = DhcpHostsTable.getCfgHostsTable(this.bridge);
                if (dhcpHostsTable == null) break block4;
                dhcpHostsTable.openTable();
                dhcpHostsTable.modifyHostsRecord(string, string2, string3, string4);
            }
            catch (Throwable throwable) {
                Object var7_7 = null;
                if (dhcpHostsTable != null) {
                    dhcpHostsTable.closeTable();
                }
                throw throwable;
            }
        }
        Object var7_6 = null;
        if (dhcpHostsTable != null) {
            dhcpHostsTable.closeTable();
        }
    }
}

