/*
 * Decompiled with CFR 0.152.
 */
package com.sun.pdasync.Conduits.AddressSync;

import com.sun.pdasync.Conduits.AddressSync.AddressSyncConstants;
import com.sun.pdasync.Conduits.AddressSync.AddressSyncException;
import com.sun.pdasync.Conduits.AddressSync.AddressSyncRecord;
import com.sun.pdasync.Conduits.AddressSync.AddressSyncUtils;
import com.sun.pdasync.Conduits.AddressSync.SunCardWriter;
import com.sun.pdasync.Conduits.Utils.DesktopManager;
import com.sun.pdasync.Conduits.Utils.SUNWCategory;
import com.sun.pdasync.SyncUtils.SyncConstants;
import com.sun.pdasync.SyncUtils.SyncUtils;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.FileReader;
import java.io.FilenameFilter;
import java.io.IOException;
import java.io.LineNumberReader;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.PrintWriter;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.ResourceBundle;
import java.util.StringTokenizer;
import java.util.Vector;
import palm.conduit.Category;
import palm.conduit.Record;

public class AddressSyncWriter
implements DesktopManager {
    String localFile;
    Vector localRecords;
    Vector localCategories;
    SunCardWriter vcardWriter;
    Vector renamedCategories;
    long syncStamp = 0L;
    public static ResourceBundle addrRes;

    public AddressSyncWriter(String localName) {
        SyncUtils.mkdirIfNotExist((String)AddressSyncConstants.ADDRESSES_DIR_PATH);
        this.localFile = String.valueOf(AddressSyncConstants.ADDRESSES_DIR_PATH) + localName;
        this.vcardWriter = new SunCardWriter();
        this.localRecords = new Vector();
        this.localCategories = new Vector();
        this.renamedCategories = new Vector();
    }

    public void addPalmPilotFieldsToSchema() throws AddressSyncException {
        LineNumberReader lnr;
        FileReader fr;
        File schema = new File(AddressSyncConstants.HOME_VCARD_SCHEMA);
        if (!schema.exists()) {
            return;
        }
        try {
            fr = new FileReader(schema);
            lnr = new LineNumberReader(fr);
        }
        catch (FileNotFoundException fileNotFoundException) {
            throw new AddressSyncException(2);
        }
        catch (IOException iOException) {
            throw new AddressSyncException(2);
        }
        Hashtable[] ht = AddressSyncUtils.makeHashtablesOfExtraPalmPilotFields();
        String line = "";
        while (true) {
            String token;
            try {
                line = lnr.readLine();
            }
            catch (IOException iOException) {
                try {
                    fr.close();
                    lnr.close();
                }
                catch (IOException iOException2) {}
                throw new AddressSyncException(2);
            }
            if (line == null) break;
            StringTokenizer st = new StringTokenizer(line, ":", true);
            if (st.countTokens() == 0 || !ht[0].containsKey(token = st.nextToken())) continue;
            ht[0].put(token, Boolean.TRUE);
        }
        byte[] data = new byte[(int)schema.length() - "END:VCARD\n".length()];
        FileInputStream fis = null;
        try {
            fis = new FileInputStream(schema);
        }
        catch (FileNotFoundException fileNotFoundException) {
            throw new AddressSyncException(2);
        }
        try {
            if (fis.read(data) < data.length) {
                throw new AddressSyncException(2);
            }
            fis.close();
        }
        catch (IOException iOException) {
            throw new AddressSyncException(2);
        }
        FileOutputStream fos = null;
        try {
            fos = new FileOutputStream(schema);
            fos.write(data);
        }
        catch (IOException iOException) {
            throw new AddressSyncException(2);
        }
        int index = 0;
        PrintWriter pw = new PrintWriter(fos);
        Enumeration elements = ht[0].keys();
        while (elements.hasMoreElements()) {
            Object e = elements.nextElement();
            if (ht[0].get(e) == Boolean.FALSE) {
                pw.println(String.valueOf(String.valueOf(e)) + ":\t" + ht[1].get(e) + ":");
            }
            ++index;
        }
        pw.println("END:VCARD");
        pw.flush();
        pw.close();
        try {
            fos.flush();
            fos.close();
        }
        catch (IOException iOException) {}
    }

    public void createCategory(String catName) {
        block2: {
            String dirName = String.valueOf(AddressSyncConstants.USER_OWN_VCARDS_DIR) + catName;
            File dir = new File(dirName);
            if (dir.exists()) break block2;
            try {
                dir.mkdirs();
            }
            catch (Exception exception) {
                AddressSyncUtils.doDebug("Cannot create card category " + dirName);
            }
        }
    }

    public void createDtVCards(Vector dtRecords) {
        int i = 0;
        while (i < dtRecords.size()) {
            AddressSyncRecord addrRec = (AddressSyncRecord)dtRecords.elementAt(i);
            try {
                addrRec.createAddrCardFile(this.localCategories, this.vcardWriter);
            }
            catch (IOException iOException) {
                AddressSyncUtils.doDebug("cannot create card " + addrRec.getCardFilename());
            }
            ++i;
        }
    }

    public static void createLocalVCardSchema() throws AddressSyncException {
        File userSchema = new File(AddressSyncConstants.HOME_VCARD_SCHEMA);
        if (userSchema.exists() && userSchema.length() > 22L) {
            return;
        }
        File sysSchema = new File(AddressSyncConstants.SYSTEM_VCARD_SCHEMA);
        if (!sysSchema.exists() && !(sysSchema = new File(AddressSyncConstants.USER_VCARD_SCHEMA)).exists()) {
            return;
        }
        byte[] data = new byte[(int)sysSchema.length()];
        try {
            FileInputStream sin = new FileInputStream(sysSchema);
            if (sin.read(data) < data.length) {
                throw new AddressSyncException(1);
            }
            FileOutputStream fos = new FileOutputStream(userSchema);
            fos.write(data);
            sin.close();
            fos.flush();
            fos.close();
        }
        catch (FileNotFoundException fileNotFoundException) {
            throw new AddressSyncException(1);
        }
        catch (IOException iOException) {
            throw new AddressSyncException(1);
        }
    }

    public void createRecord(Record hhRecord) {
        try {
            ((AddressSyncRecord)hhRecord).createAddrCardFile(this.localCategories, this.vcardWriter);
        }
        catch (IOException iOException) {
            AddressSyncUtils.doDebug("cannot create VCARD " + ((AddressSyncRecord)hhRecord).getCardFilename());
        }
    }

    public boolean deleteCategory(Category cat) {
        SUNWCategory addrCat = (SUNWCategory)cat;
        File dir = new File(addrCat.getPath());
        boolean removeSuccess = true;
        if (dir.exists() && dir.isDirectory()) {
            String[] fileLists = dir.list();
            boolean subdir = false;
            int i = 0;
            while (i < fileLists.length) {
                File file = new File(dir, fileLists[i]);
                if (file.isFile()) {
                    if (file.lastModified() < this.syncStamp) {
                        try {
                            file.delete();
                        }
                        catch (Exception exception) {}
                    } else {
                        removeSuccess = false;
                    }
                } else {
                    subdir = true;
                }
                ++i;
            }
            if (!subdir) {
                dir.delete();
            }
        }
        return removeSuccess;
    }

    public void deleteRecord(Record record) {
        ((AddressSyncRecord)record).deleteAddrCardFile();
    }

    public Vector getBackupRecords() {
        Vector[] dataVectors = new Vector[2];
        this.readLocalDBFile(dataVectors);
        Vector backupRecs = dataVectors[1] != null ? dataVectors[1] : new Vector();
        return backupRecs;
    }

    public Vector getLocalCategories() {
        return this.localCategories;
    }

    public Vector getLocalRecords() {
        return this.localRecords;
    }

    private void logInvalidVCard(Exception e, String cardName) {
        if (e instanceof AddressSyncException) {
            AddressSyncException ase = (AddressSyncException)e;
            if (ase.errorCode == 7) {
                AddressSyncUtils.doLog(String.valueOf(addrRes.getString("Invalid VCard, size exeeds 8k maximum: ")) + cardName);
            } else if (ase.errorCode == 8) {
                AddressSyncUtils.doLog(String.valueOf(addrRes.getString("Invalid VCard, note size exeeds 4k maximum: ")) + cardName);
            }
        } else {
            AddressSyncUtils.doLog(String.valueOf(addrRes.getString("Invalid VCard: ")) + cardName);
        }
    }

    public Vector makeCategoriesOutOfCardRecords(Vector cardRecords) {
        String[] catInfo;
        if (cardRecords == null || cardRecords.size() == 0) {
            return null;
        }
        int size = cardRecords.size();
        Vector<String[]> catNames = new Vector<String[]>(size);
        int i = 0;
        while (i < cardRecords.size()) {
            AddressSyncRecord cardRec = (AddressSyncRecord)cardRecords.elementAt(i);
            catInfo = cardRec.categoryInfoFromCardName();
            if (catInfo != null && !this.matchCatInfo(catNames, catInfo)) {
                catNames.addElement(catInfo);
            }
            ++i;
        }
        catNames.trimToSize();
        size = catNames.size();
        size = size > 16 ? 16 : size;
        Vector<SUNWCategory> cardCats = new Vector<SUNWCategory>(size);
        int i2 = 0;
        while (i2 < size) {
            catInfo = (String[])catNames.elementAt(i2);
            SUNWCategory cat = new SUNWCategory(catInfo[1], i2, i2, true, catInfo[0]);
            cardCats.addElement(cat);
            ++i2;
        }
        return cardCats;
    }

    public void makeRecordsOutOfCardFiles(Vector cardList, Vector emptyCategories, String directory) throws FileNotFoundException {
        File file;
        File dir;
        if (!directory.endsWith(SyncConstants.SEPARATOR)) {
            directory = String.valueOf(directory) + SyncConstants.SEPARATOR;
        }
        if (!(dir = new File(directory)).isDirectory()) {
            return;
        }
        String path = dir.getPath();
        if (!path.endsWith(SyncConstants.SEPARATOR)) {
            path = String.valueOf(path) + SyncConstants.SEPARATOR;
        }
        FilenameFilter filter = new FilenameFilter(){

            public boolean accept(File dir, String name) {
                File file = new File(dir, name);
                return !file.isDirectory() && name.endsWith("");
            }
        };
        String[] files = dir.list(filter);
        int i = 0;
        while (i < files.length) {
            AddressSyncRecord addrRecord = new AddressSyncRecord();
            String cardName = String.valueOf(path) + files[i];
            addrRecord.setCardFilename(cardName);
            file = new File(dir, files[i]);
            addrRecord.setModTime(file.lastModified());
            cardList.addElement(addrRecord);
            file = null;
            ++i;
        }
        FilenameFilter dirFilter = new FilenameFilter(){

            public boolean accept(File dir, String name) {
                File child = new File(dir, name);
                return child.isDirectory();
            }
        };
        String[] subdirs = dir.list(dirFilter);
        path = dir.getAbsolutePath();
        if (!path.endsWith(SyncConstants.SEPARATOR)) {
            path = String.valueOf(path) + SyncConstants.SEPARATOR;
        }
        int i2 = 0;
        while (i2 < subdirs.length) {
            file = new File(dir, subdirs[i2]);
            files = file.list();
            if (files != null && files.length != 0) {
                this.makeRecordsOutOfCardFiles(cardList, emptyCategories, String.valueOf(path) + subdirs[i2]);
            } else if (files != null && files.length == 0) {
                SUNWCategory cat = new SUNWCategory(subdirs[i2], file.getAbsolutePath());
                emptyCategories.addElement(cat);
            }
            ++i2;
        }
    }

    private boolean matchCatInfo(Vector catInfoVec, String[] catInfo) {
        int i = 0;
        while (i < catInfoVec.size()) {
            if (catInfoVec.elementAt(i) == null) break;
            String[] cat = (String[])catInfoVec.elementAt(i);
            if (cat[0].equals(catInfo[0])) {
                return true;
            }
            ++i;
        }
        return false;
    }

    public void mergeDtVCardCategories(Vector cardCategories) {
        Category cardCat;
        int j;
        Category dtCat;
        if (cardCategories == null || cardCategories.size() == 0) {
            return;
        }
        int lastIndex = 0;
        int i = 0;
        while (i < this.localCategories.size()) {
            dtCat = (Category)this.localCategories.elementAt(i);
            String dtCatName = dtCat.getName();
            if (dtCatName == null || dtCatName.length() == 0) {
                lastIndex = i;
                break;
            }
            j = 0;
            while (j < cardCategories.size()) {
                cardCat = (Category)cardCategories.elementAt(j);
                String cardCatName = cardCat.getName();
                if (dtCatName.equals(cardCatName)) {
                    cardCategories.removeElement(cardCat);
                    cardCategories.trimToSize();
                    break;
                }
                ++j;
            }
            ++i;
        }
        j = 0;
        while (j < cardCategories.size()) {
            cardCat = (Category)cardCategories.elementAt(j);
            try {
                dtCat = (Category)this.localCategories.elementAt(lastIndex);
                dtCat.setName(cardCat.getName());
                dtCat.setIsModified(true);
                ++lastIndex;
            }
            catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
                break;
            }
            ++j;
        }
    }

    public void mergeDtVCardRecords(Vector cardRecords) {
        AddressSyncRecord cardRec;
        if (cardRecords == null || cardRecords.size() == 0) {
            return;
        }
        AddressSyncRecord dtRec = null;
        int i = 0;
        while (i < this.localRecords.size()) {
            dtRec = (AddressSyncRecord)this.localRecords.elementAt(i);
            dtRec.setIsDeleted(true);
            ++i;
        }
        boolean[] newRecs = new boolean[cardRecords.size()];
        int i2 = 0;
        while (i2 < cardRecords.size()) {
            cardRec = (AddressSyncRecord)cardRecords.elementAt(i2);
            String cardFilename = cardRec.getCardFilename();
            boolean found = false;
            int j = 0;
            while (j < this.localRecords.size()) {
                dtRec = (AddressSyncRecord)this.localRecords.elementAt(j);
                String dtFilename = dtRec.getCardFilename();
                if (dtFilename.equals(cardFilename)) {
                    found = true;
                    break;
                }
                ++j;
            }
            if (found) {
                newRecs[i2] = false;
                if (cardRec.modTime > dtRec.modTime) {
                    AddressSyncUtils.doDebug("same card has been modified");
                    try {
                        cardRec.populateFromAddrCard();
                        cardRec.setId(dtRec.getId());
                        cardRec.setIndex(dtRec.getIndex());
                        cardRec.setCategoryIndex(dtRec.getCategoryIndex());
                        cardRec.setIsPrivate(dtRec.isPrivate());
                        cardRec.setDisplayPhone(dtRec.getDisplayPhone());
                        cardRec.setIsNew(false);
                        if (cardRec.isDifferentFrom(dtRec)) {
                            cardRec.setIsModified(true);
                        } else {
                            cardRec.setIsModified(false);
                        }
                        this.localRecords.setElementAt(cardRec, j);
                    }
                    catch (Exception e) {
                        this.logInvalidVCard(e, cardFilename);
                        dtRec.setIsDeleted(false);
                        dtRec.setIsModified(false);
                    }
                } else {
                    dtRec.setIsDeleted(false);
                }
            } else {
                newRecs[i2] = true;
            }
            ++i2;
        }
        int i3 = 0;
        while (i3 < newRecs.length) {
            if (newRecs[i3]) {
                cardRec = (AddressSyncRecord)cardRecords.elementAt(i3);
                try {
                    cardRec.populateFromAddrCard();
                    cardRec.setIsNew(true);
                    this.localRecords.addElement(cardRec);
                }
                catch (Exception e) {
                    this.logInvalidVCard(e, cardRec.getCardFilename());
                }
            }
            ++i3;
        }
    }

    public void openLocalDB() {
        Vector[] dataVectors = new Vector[2];
        this.readLocalDBFile(dataVectors);
        if (dataVectors[0] != null) {
            this.localCategories = dataVectors[0];
        }
        if (dataVectors[1] != null) {
            this.localRecords = dataVectors[1];
        }
        AddressSyncUtils.doDebug("localCategories.size = " + this.localCategories.size());
        AddressSyncUtils.doDebug("localRecords.size = " + this.localRecords.size());
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void readLocalDBFile(Vector[] vectors) {
        File file = new File(this.localFile);
        ObjectInputStream oi = null;
        if (!file.exists()) return;
        try {
            block7: {
                try {
                    FileInputStream fi = new FileInputStream(this.localFile);
                    oi = new ObjectInputStream(fi);
                    this.syncStamp = oi.readLong();
                    vectors[0] = (Vector)oi.readObject();
                    vectors[1] = (Vector)oi.readObject();
                }
                catch (Exception exception) {
                    if (!file.exists()) break block7;
                    AddressSyncUtils.doDebug("Corrupted local database is removed.");
                    file.delete();
                }
            }
            Object var5_5 = null;
            if (oi == null) return;
        }
        catch (Throwable throwable) {
            Object var5_6 = null;
            if (oi == null) throw throwable;
            try {
                oi.close();
                throw throwable;
            }
            catch (IOException iOException) {}
            throw throwable;
        }
        try {
            oi.close();
            return;
        }
        catch (IOException iOException) {}
    }

    public void removeAllDtVCards() {
        File dir = new File(AddressSyncConstants.USER_OWN_VCARDS_DIR);
        this.removeVCardsInDir(dir);
    }

    public void removeLocalDBFile() {
        File file = new File(this.localFile);
        if (file.exists()) {
            file.delete();
        }
    }

    public void removeVCardsInDir(File dir) {
        String[] list = dir.list();
        if (list != null) {
            int i = 0;
            while (i < list.length) {
                File file = new File(dir, list[i]);
                if (file.isDirectory()) {
                    this.removeVCardsInDir(file);
                }
                file.delete();
                ++i;
            }
        }
    }

    public void renameCategory(Category cat, String catName) {
        SUNWCategory addrCat = (SUNWCategory)cat;
        String path = addrCat.getPath();
        File dir = new File(path);
        if (dir.exists() && dir.isDirectory()) {
            int lastIndex = path.lastIndexOf(SyncConstants.SEPARATOR);
            String newName = String.valueOf(path.substring(0, lastIndex + 1)) + catName;
            dir.renameTo(new File(newName));
            String[] renamedCat = new String[]{path, newName};
            this.renamedCategories.addElement(renamedCat);
        }
    }

    public void setDtVCardRecsCategory(Vector cardRecords) {
        if (cardRecords == null || cardRecords.size() == 0) {
            return;
        }
        if (this.localCategories.size() == 0) {
            return;
        }
        int i = 0;
        while (i < cardRecords.size()) {
            AddressSyncRecord cardRec = (AddressSyncRecord)cardRecords.elementAt(i);
            String cardCatName = cardRec.categoryNameFromCardName();
            if (cardCatName != null) {
                int j = 0;
                while (j < this.localCategories.size()) {
                    Category dtCat = (Category)this.localCategories.elementAt(j);
                    String dtCatName = dtCat.getName();
                    if (cardCatName.equals(dtCatName)) {
                        cardRec.setCategoryIndex(j);
                        break;
                    }
                    ++j;
                }
            }
            ++i;
        }
    }

    public void setLocalCategories(Vector categories) {
        if (categories != null) {
            this.localCategories = categories;
        } else {
            this.localCategories.removeAllElements();
        }
    }

    public void setLocalRecords(Vector records) {
        if (records != null) {
            this.localRecords = records;
        } else {
            this.localRecords.removeAllElements();
        }
    }

    public void updateRenamedCategories() {
        if (this.renamedCategories.size() == 0) {
            return;
        }
        int i = 0;
        while (i < this.localRecords.size()) {
            AddressSyncRecord localRec = (AddressSyncRecord)this.localRecords.elementAt(i);
            String cardName = localRec.getCardFilename();
            if (cardName != null) {
                int index = cardName.lastIndexOf(SyncConstants.SEPARATOR);
                int j = 0;
                while (j < this.renamedCategories.size()) {
                    String[] renameCat = (String[])this.renamedCategories.elementAt(j);
                    if (renameCat[0].equals(cardName.substring(0, index))) {
                        localRec.setCardFilename(String.valueOf(renameCat[1]) + SyncConstants.SEPARATOR + SyncUtils.getFileShortName((String)cardName));
                        break;
                    }
                    ++j;
                }
            }
            ++i;
        }
    }

    public void writeLocalDB() {
        try {
            FileOutputStream fo = new FileOutputStream(this.localFile);
            ObjectOutputStream os = new ObjectOutputStream(fo);
            AddressSyncUtils.doDebug("AddressSyncWriter.writeLocalDB: localCategories.size = " + this.localCategories.size());
            AddressSyncUtils.doDebug("AddressSyncWriter.writeLocalDB: localRecords.size = " + this.localRecords.size());
            this.syncStamp = System.currentTimeMillis();
            os.writeLong(this.syncStamp);
            os.writeObject(this.localCategories);
            os.writeObject(this.localRecords);
            os.close();
            String addressDatFile = this.localFile;
            SyncUtils.setFilePermission((String)addressDatFile.trim(), (String)"600");
        }
        catch (IOException iOException) {
            AddressSyncUtils.doDebug("Error in writing local database.");
        }
    }
}

