/*
 * Decompiled with CFR 0.152.
 */
package com.sun.dt.dtpower;

import com.sun.dt.dtpower.Cmpt;
import com.sun.dt.dtpower.Device;
import com.sun.dt.dtpower.DtpowerException;
import com.sun.dt.dtpower.Level;
import java.util.Arrays;

public class SystemInterrogator {
    static final String DISPLAY_PHYSICAL_NAME = "/system-display(s)";
    static final String DISPLAY_LOGICAL_NAME = "display(s)";
    static final String DISPLAY_FB_NAME = "fb(s)";
    static final String DISPLAY_MONITOR_NAME = "monitor(s)";
    private static final String lib = "dtpower";
    private Device[] devices = null;
    private DpmsInfo dpmsInfo = SystemInterrogator.getDpmsInfo();
    private CprInfo cprInfo = SystemInterrogator.getCprInfo();
    private Permissions permission = SystemInterrogator.getPermissions();

    static {
        System.loadLibrary(lib);
    }

    public SystemInterrogator() {
        this.buildDeviceArray();
    }

    private void buildDeviceArray() {
        boolean hasDisplayDevice = this.dpmsInfo.capable;
        try {
            Object[] devnames = SystemInterrogator.getAllDeviceNames();
            Arrays.sort(devnames);
            this.devices = new Device[devnames.length + (hasDisplayDevice ? 1 : 0)];
            int dc = 0;
            while (dc < devnames.length) {
                this.devices[dc] = this.getDevice((DeviceName)devnames[dc]);
                ++dc;
            }
        }
        catch (DtpowerException dtpowerException) {
            this.devices = new Device[hasDisplayDevice ? 1 : 0];
        }
        if (hasDisplayDevice) {
            Device display;
            this.devices[this.devices.length - 1] = display = this.buildDisplayDevice();
        }
    }

    private Device buildDisplayDevice() {
        Cmpt[] components = new Cmpt[2];
        Level[] levels = new Level[]{new Level("On", 0, 0), new Level("Off", 1, this.dpmsInfo.fbpmOn ? 1 : 0)};
        components[0] = new Cmpt(DISPLAY_FB_NAME, levels, 0);
        boolean dpmsEnabled = this.dpmsInfo.enabled;
        levels = new Level[]{new Level("On", 0, this.dpmsInfo.on_stby), new Level("Standby", 1, this.dpmsInfo.on_susp > 0 ? this.dpmsInfo.on_susp - this.dpmsInfo.on_stby : this.dpmsInfo.on_susp), new Level("Suspend", 2, this.dpmsInfo.on_off > 0 ? this.dpmsInfo.on_off - this.dpmsInfo.on_susp : this.dpmsInfo.on_off), new Level("Off", 3, dpmsEnabled ? 1 : 0)};
        components[1] = new Cmpt(DISPLAY_MONITOR_NAME, levels, 0);
        Device device = new Device(DISPLAY_LOGICAL_NAME, DISPLAY_PHYSICAL_NAME, components);
        device.deviceType = "display";
        device.threshold = levels[0].threshold + levels[1].threshold + levels[2].threshold;
        if (dpmsEnabled) {
            if (device.threshold == 0) {
                device.setEnabled(false);
                device.threshold = Integer.MAX_VALUE;
                device.thresholdBasis = 1;
            } else {
                device.setEnabled(true);
                device.thresholdBasis = device.threshold == this.getSystemThreshold() ? 0 : 1;
            }
        } else {
            device.setEnabled(false);
            if (device.threshold == 0) {
                device.threshold = Integer.MAX_VALUE;
            }
            device.thresholdBasis = 1;
        }
        if (!this.dpmsInfo.fbpmCapable) {
            device.state |= 4;
        }
        return device;
    }

    private static native DeviceName[] getAllDeviceNames() throws DtpowerException;

    private Cmpt getComponent(String devname, int compnr, int[] threshold) {
        String cmptName = SystemInterrogator.getComponentName(devname, compnr);
        int index = 0;
        int comp = 0;
        while (comp < compnr) {
            index += threshold[index] + 1;
            ++comp;
        }
        Level[] level = new Level[threshold[index] + 1];
        int lc = 0;
        while (lc < level.length) {
            String powerName = SystemInterrogator.getPowerName(devname, compnr, lc);
            level[lc] = new Level(powerName != null ? powerName : Integer.toString(lc), lc, lc < level.length - 1 ? threshold[index + lc + 1] : 0);
            ++lc;
        }
        return new Cmpt(cmptName != null ? cmptName : Integer.toString(compnr), level, 0);
    }

    private static native String getComponentName(String var0, int var1);

    private static native int[] getComponentThresholds(String var0);

    private Cmpt[] getComponents(String devname) {
        int nrCmpt = SystemInterrogator.getNrComponents(devname);
        Cmpt[] components = new Cmpt[nrCmpt];
        int[] threshold = SystemInterrogator.getComponentThresholds(devname);
        int cc = 0;
        while (cc < components.length) {
            components[cc] = this.getComponent(devname, cc, threshold);
            ++cc;
        }
        return components;
    }

    private static native CprInfo getCprInfo();

    private static native int getCurrentPower(String var0, int var1);

    private Device getDevice(DeviceName devname) {
        Device device;
        int deviceThresholdBasis = SystemInterrogator.getDeviceThresholdBasis(devname.physName);
        String devtype = null;
        if ("harddisk".equals(devname.type)) {
            devtype = "disk";
        }
        if (deviceThresholdBasis == 6) {
            device = new Device(devname.logName != null ? devname.logName : devname.physName, devname.physName, this.getComponents(devname.physName), SystemInterrogator.getDeviceThreshold(devname.physName), 1, devtype);
            device.setCustomized(true);
        } else {
            device = new Device(devname.logName != null ? devname.logName : devname.physName, devname.physName, this.getComponents(devname.physName), 0, 0, devtype);
            if (deviceThresholdBasis == 5) {
                device.thresholdBasis = 0;
                device.threshold = this.getSystemThreshold();
            } else if (deviceThresholdBasis == 7) {
                device.thresholdBasis = 2;
                device.setCustomized(true);
            }
        }
        return device;
    }

    private static native int getDeviceThreshold(String var0);

    private static native int getDeviceThresholdBasis(String var0);

    public Device[] getDevices() {
        return this.devices;
    }

    private static native DpmsInfo getDpmsInfo();

    private static native int getNrComponents(String var0);

    private static native int getNrPowerLevels(String var0, int var1);

    private static native int getPMState();

    private static native Permissions getPermissions();

    private static native String getPowerName(String var0, int var1, int var2);

    public int getShutdownIdleMin() {
        return this.cprInfo.idle;
    }

    public int getShutdownPeriodEnd() {
        return this.cprInfo.finish;
    }

    public int getShutdownPeriodStart() {
        return this.cprInfo.start;
    }

    public String getStatefileDirectory() {
        return this.cprInfo.filepath;
    }

    public String getStatefileName() {
        return this.cprInfo.filename;
    }

    public int getSystemThreshold() {
        return SystemInterrogator.n_getSystemThreshold();
    }

    public int getSystemThresholdDefault() {
        return SystemInterrogator.n_getSystemThresholdDefault();
    }

    public boolean isAutopmDefault() {
        return this.cprInfo.autopmDefault;
    }

    public boolean isAutopmEnabled() {
        return SystemInterrogator.getPMState() == 1;
    }

    public boolean isCprEditable() {
        return this.permission.aschangeperm;
    }

    public boolean isPmEditable() {
        return this.permission.pmchangeperm;
    }

    public boolean isShutdownCapable() {
        return this.cprInfo.shutdownCapable;
    }

    public boolean isShutdownDefault() {
        return this.cprInfo.shutdownDefault;
    }

    public boolean isShutdownEnabled() {
        return this.cprInfo.shutdownEnabled;
    }

    public boolean isWakeupCapable() {
        return this.cprInfo.wakeupCapable;
    }

    public boolean isWakeupEnabled() {
        return this.cprInfo.wakeupEnabled;
    }

    public static void main(String[] argv) {
        SystemInterrogator dtp = new SystemInterrogator();
        System.out.println("System threshold: " + dtp.getSystemThreshold());
        Device[] dev = dtp.getDevices();
        int i = 0;
        while (i < dev.length) {
            System.out.println(dev[i]);
            ++i;
        }
        System.out.println(dtp.cprInfo);
        System.out.println(dtp.dpmsInfo);
    }

    private static native int n_getSystemThreshold();

    private static native int n_getSystemThresholdDefault();

    public void setDisplayThresholds(Device device) {
        if (device.getDeviceType() == "display") {
            SystemInterrogator.setDpmsLevels(device.isEnabled(), device.cmpts[1].levels[0].threshold, device.cmpts[1].levels[0].threshold + device.cmpts[1].levels[1].threshold, device.cmpts[1].levels[0].threshold + device.cmpts[1].levels[1].threshold + device.cmpts[1].levels[2].threshold);
        } else {
            System.out.println("Can only set display from a display device.");
        }
    }

    private static native void setDpmsLevels(boolean var0, int var1, int var2, int var3);

    private class DpmsInfo {
        protected boolean capable;
        protected boolean enabled;
        protected int on_stby;
        protected int on_susp;
        protected int on_off;
        protected boolean fbpmCapable;
        protected boolean fbpmOn;

        protected DpmsInfo(boolean capable, boolean enabled, int on_stby, int on_susp, int on_off, boolean fbpmCapable, boolean fbpmOn) {
            this.capable = capable;
            this.enabled = enabled;
            this.on_stby = on_stby;
            this.on_susp = on_susp;
            this.on_off = on_off;
            this.fbpmCapable = fbpmCapable;
            this.fbpmOn = fbpmOn;
        }

        public String toString() {
            return "capable:" + this.capable + " enabled:" + this.enabled + " on_stby:" + this.on_stby + " on_susp:" + this.on_susp + " on_off:" + this.on_off;
        }
    }

    private class CprInfo {
        protected String filepath;
        protected String filename;
        protected boolean shutdownCapable;
        protected boolean shutdownDefault;
        protected boolean shutdownEnabled;
        protected boolean wakeupCapable;
        protected boolean wakeupEnabled;
        protected boolean autopmDefault;
        protected int idle;
        protected int start;
        protected int finish;

        protected CprInfo(String filepath, String filename, boolean shutdownCapable, boolean shutdownDefault, boolean shutdownEnabled, boolean wakeupCapable, boolean wakeupEnabled, boolean autopmDefault, int idle, int start, int finish) {
            this.filepath = filepath;
            this.filename = filename;
            this.shutdownCapable = shutdownCapable;
            this.shutdownDefault = shutdownDefault;
            this.shutdownEnabled = shutdownEnabled;
            this.wakeupCapable = wakeupCapable;
            this.wakeupEnabled = wakeupEnabled;
            this.autopmDefault = autopmDefault;
            this.idle = idle;
            this.start = start;
            this.finish = finish;
        }

        public String toString() {
            return this.filepath + "," + this.filename + "," + this.shutdownCapable + "," + this.shutdownDefault + "," + this.shutdownEnabled + "," + this.wakeupCapable + "," + this.wakeupEnabled + "," + this.autopmDefault + "," + this.idle + "," + this.start + "," + this.finish;
        }
    }

    private class Permissions {
        boolean aschangeperm;
        boolean pmchangeperm;

        protected Permissions(boolean as, boolean pm) {
            this.aschangeperm = as;
            this.pmchangeperm = pm;
        }

        public String toString() {
            return this.aschangeperm + " " + this.pmchangeperm;
        }
    }

    private class DeviceName
    implements Comparable {
        String physName;
        String logName;
        String type;

        public DeviceName(String physName, String logName, String type) {
            this.physName = physName;
            this.logName = logName;
            this.type = type;
        }

        public int compareTo(Object dn) {
            return this.physName.compareTo(((DeviceName)dn).physName);
        }
    }
}

