/*
 * Decompiled with CFR 0.152.
 */
package com.sun.dt.dtpower;

import com.sun.dt.dtpower.ResourceFactory;
import com.sun.dt.dtpower.TimeConverter;
import com.symantec.itools.awt.GridBagConstraintsD;
import com.symantec.itools.javax.swing.borders.EmptyBorder;
import com.symantec.itools.javax.swing.borders.TitledBorder;
import com.symantec.itools.javax.swing.models.StringComboBoxModel;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.beans.PropertyVetoException;
import java.net.URL;
import java.text.DateFormat;
import java.text.ParseException;
import java.util.Date;
import java.util.GregorianCalendar;
import java.util.ResourceBundle;
import javax.help.HelpBroker;
import javax.help.HelpSet;
import javax.swing.ComboBoxEditor;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JMenuBar;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JTextArea;
import javax.swing.JTextField;
import javax.swing.border.Border;
import symantec.itools.awt.shape.HorizontalLine;

public class Autoshutdown
extends JFrame {
    int startHour;
    int startMin;
    boolean startIsMorning;
    int endHour;
    int endMin;
    boolean endIsMorning;
    int idleMin;
    boolean wakeupEnabled = false;
    boolean edited = false;
    boolean saveEdits = false;
    String statefileDir;
    JTextField idleTextField;
    DateFormat dateformat = DateFormat.getTimeInstance(3);
    private static final String HELPSET = "help/PwrGUI.hs";
    private static HelpBroker helpBroker;
    static ResourceBundle resource;
    boolean frameSizeAdjusted = false;
    JPanel instructionsPanel = new JPanel();
    JTextArea instructionsTextArea = new JTextArea();
    JPanel settingsPanel = new JPanel();
    JPanel JPanel5 = new JPanel();
    JLabel JLabel4 = new JLabel();
    JPanel JPanel6 = new JPanel();
    JTextField startTimeField = new JTextField();
    JLabel andLabel = new JLabel();
    JTextField endTimeField = new JTextField();
    JPanel JPanel7 = new JPanel();
    JCheckBox wakeupCheckBox = new JCheckBox();
    JLabel idleTimeLabel = new JLabel();
    JComboBox idleComboBox = new JComboBox();
    TitledBorder titledBorder1 = new TitledBorder();
    StringComboBoxModel idleComboBoxModel = new StringComboBoxModel();
    HorizontalLine horizontalLine1 = new HorizontalLine();
    JPanel buttonPanel = new JPanel();
    JButton okButton = new JButton();
    JButton cancelButton = new JButton();
    JButton helpButton = new JButton();
    EmptyBorder emptyBorder1 = new EmptyBorder();

    static {
        resource = ResourceFactory.getResources();
    }

    public Autoshutdown() {
    }

    public Autoshutdown(int startTime, int endTime, int idleMinutes, String dir, boolean enabled, boolean capable) {
        this.setDefaultCloseOperation(0);
        this.getContentPane().setLayout(new GridBagLayout());
        ((Component)this).setSize(388, 281);
        ((Component)this).setVisible(false);
        this.instructionsPanel.setLayout(new GridBagLayout());
        this.getContentPane().add((Component)this.instructionsPanel, new GridBagConstraintsD(-1, -1, 0, 1, 1.0, 0.0, 10, 2, new Insets(10, 10, 5, 10), 0, 0));
        this.instructionsTextArea.setText(resource.getString("Autoshutdown Instructions"));
        this.instructionsTextArea.setLineWrap(true);
        this.instructionsTextArea.setBorder((Border)this.emptyBorder1);
        this.instructionsTextArea.setEditable(false);
        this.instructionsTextArea.setWrapStyleWord(true);
        this.instructionsPanel.add((Component)this.instructionsTextArea, new GridBagConstraintsD(-1, -1, 0, 1, 1.0, 0.0, 10, 2, new Insets(0, 0, 0, 0), 0, 0));
        this.instructionsTextArea.setBackground(this.instructionsPanel.getBackground());
        this.settingsPanel.setBorder((Border)this.titledBorder1);
        this.settingsPanel.setLayout(new GridBagLayout());
        this.getContentPane().add((Component)this.settingsPanel, new GridBagConstraintsD(-1, -1, 0, 1, 1.0, 0.5, 10, 2, new Insets(0, 10, 5, 10), 0, 0));
        this.settingsPanel.setForeground(new Color(102, 102, 153));
        this.JPanel5.setLayout(new GridBagLayout());
        this.settingsPanel.add((Component)this.JPanel5, new GridBagConstraintsD(-1, -1, 0, 1, 1.0, 0.0, 10, 2, new Insets(0, 10, 0, 0), 0, 0));
        this.JLabel4.setText(resource.getString("Shut Down Computer If Idle Between:"));
        this.JPanel5.add((Component)this.JLabel4, new GridBagConstraintsD(-1, -1, 0, 1, 1.0, 0.0, 17, 2, new Insets(0, 5, 5, 0), 0, 0));
        this.JPanel6.setLayout(new GridBagLayout());
        this.settingsPanel.add((Component)this.JPanel6, new GridBagConstraintsD(-1, -1, 0, 1, 1.0, 0.0, 10, 2, new Insets(0, 0, 0, 0), 0, 0));
        this.JPanel6.add((Component)this.startTimeField, new GridBagConstraintsD(-1, -1, 1, 1, 0.2, 0.0, 10, 2, new Insets(0, 15, 0, 0), 0, 0));
        this.andLabel.setText(resource.getString("and"));
        this.JPanel6.add((Component)this.andLabel, new GridBagConstraintsD(-1, -1, 1, 1, 0.0, 0.0, 10, 0, new Insets(0, 10, 0, 10), 0, 0));
        this.JPanel6.add((Component)this.endTimeField, new GridBagConstraintsD(-1, -1, 1, 1, 0.2, 0.0, 10, 2, new Insets(0, 0, 0, 15), 0, 0));
        this.JPanel7.setLayout(new GridBagLayout());
        this.settingsPanel.add((Component)this.JPanel7, new GridBagConstraintsD(-1, -1, 0, 1, 1.0, 0.0, 17, 0, new Insets(0, 0, 0, 0), 0, 0));
        this.wakeupCheckBox.setText("Restart.");
        this.wakeupCheckBox.setActionCommand("Restart.");
        this.JPanel7.add((Component)this.wakeupCheckBox, new GridBagConstraintsD(-1, -1, 1, 1, 0.0, 0.0, 10, 0, new Insets(0, 15, 0, 0), 0, 0));
        this.idleTimeLabel.setText(resource.getString("Shutdown During This Interval If Idle For:"));
        this.settingsPanel.add((Component)this.idleTimeLabel, new GridBagConstraintsD(-1, -1, -1, 1, 0.0, 0.0, 17, 0, new Insets(0, 10, 0, 5), 0, 0));
        this.idleComboBox.setModel(this.idleComboBoxModel);
        this.idleComboBox.setEditable(true);
        this.settingsPanel.add((Component)this.idleComboBox, new GridBagConstraintsD(-1, -1, 0, 1, 1.0, 0.0, 10, 2, new Insets(0, 0, 10, 10), 0, 0));
        this.titledBorder1.setTitle(resource.getString("Shutdown Criteria:"));
        String[] tempString = new String[]{"15 " + resource.getString("Minute"), "30 " + resource.getString("Minute"), "45 " + resource.getString("Minute"), "1 " + resource.getString("Hour"), "2 " + resource.getString("Hour"), "3 " + resource.getString("Hour"), "4 " + resource.getString("Hour"), "6 " + resource.getString("Hour")};
        this.idleComboBoxModel.setItems(tempString);
        try {
            this.horizontalLine1.setBevelStyle(0);
        }
        catch (PropertyVetoException propertyVetoException) {}
        this.getContentPane().add((Component)this.horizontalLine1, new GridBagConstraintsD(-1, -1, 0, 1, 1.0, 0.0, 10, 2, new Insets(5, 10, 5, 10), 0, 0));
        this.buttonPanel.setLayout(new GridBagLayout());
        this.getContentPane().add((Component)this.buttonPanel, new GridBagConstraintsD(-1, -1, 0, 1, 0.0, 0.0, 13, 0, new Insets(0, 0, 10, 15), 0, 0));
        this.okButton.setText(resource.getString("OK Button"));
        this.okButton.setActionCommand("OK");
        this.buttonPanel.add((Component)this.okButton, new GridBagConstraintsD(-1, -1, 1, 1, 0.0, 0.0, 10, 0, new Insets(0, 0, 0, 5), 0, 0));
        this.cancelButton.setText(resource.getString("Cancel Button"));
        this.cancelButton.setActionCommand("Cancel");
        this.buttonPanel.add((Component)this.cancelButton, new GridBagConstraintsD(-1, -1, 1, 1, 0.0, 0.0, 10, 0, new Insets(0, 0, 0, 5), 0, 0));
        this.helpButton.setText(resource.getString("Help Button"));
        this.helpButton.setActionCommand("Help");
        this.buttonPanel.add((Component)this.helpButton, new GridBagConstraintsD(-1, -1, 0, 1, 0.0, 0.0, 10, 0, new Insets(0, 0, 0, 0), 0, 0));
        TimeConverter tc = new TimeConverter();
        this.startHour = startTime / 60 % 24;
        this.startMin = startTime % 60;
        this.startIsMorning = this.startHour < 12;
        this.endHour = endTime / 60 % 24;
        this.endMin = endTime % 60;
        this.endIsMorning = this.endHour < 12;
        this.idleMin = idleMinutes;
        this.statefileDir = dir;
        this.wakeupEnabled = enabled;
        this.startTimeField.setText(tc.construct12HourTime(this.startHour, this.startMin));
        this.endTimeField.setText(tc.construct12HourTime(this.endHour, this.endMin));
        this.wakeupCheckBox.setEnabled(capable);
        this.wakeupCheckBox.setSelected(capable && enabled);
        tc.setComboDuration(this.idleMin * 60, this.idleComboBox);
        this.setWakeupText();
        SymAction lSymAction = new SymAction();
        this.idleComboBox.addActionListener(lSymAction);
        this.wakeupCheckBox.addActionListener(lSymAction);
        this.startTimeField.addActionListener(lSymAction);
        this.endTimeField.addActionListener(lSymAction);
        this.okButton.addActionListener(lSymAction);
        this.helpButton.addActionListener(lSymAction);
        this.cancelButton.addActionListener(lSymAction);
        SymWindow aSymWindow = new SymWindow();
        this.addWindowListener(aSymWindow);
        ComboBoxEditor cbEditor = this.idleComboBox.getEditor();
        cbEditor.addActionListener(lSymAction);
        this.idleTextField = (JTextField)cbEditor.getEditorComponent();
        this.setTitle(resource.getString("Autoshutdown Title"));
    }

    public Autoshutdown(String sTitle) {
        this();
        this.setTitle(sTitle);
    }

    void Autoshutdown_windowClosing(WindowEvent event) {
        if (this.edited) {
            JOptionPane.showMessageDialog(this, resource.getString("Unsaved Autoshutdown Dialog"));
        } else {
            ((Component)this).setVisible(false);
            this.dispose();
        }
    }

    boolean acceptEdits() {
        return this.edited && this.saveEdits;
    }

    public void addNotify() {
        Dimension size = this.getSize();
        super.addNotify();
        if (this.frameSizeAdjusted) {
            return;
        }
        this.frameSizeAdjusted = true;
        Insets insets = this.getInsets();
        JMenuBar menuBar = this.getRootPane().getJMenuBar();
        int menuBarHeight = 0;
        if (menuBar != null) {
            menuBarHeight = menuBar.getPreferredSize().height;
        }
        ((Component)this).setSize(insets.left + insets.right + size.width, insets.top + insets.bottom + size.height + menuBarHeight);
    }

    void cancelButton_actionPerformed(ActionEvent event) {
        this.saveEdits = false;
        ((Component)this).setVisible(false);
        this.dispose();
    }

    void endTimeField_actionPerformed(ActionEvent event) {
        String timeString = this.endTimeField.getText();
        Date date = null;
        GregorianCalendar gc = new GregorianCalendar();
        this.dateformat.setLenient(true);
        try {
            date = this.dateformat.parse(timeString);
            gc.setTime(date);
            this.endHour = gc.get(11);
            this.endMin = gc.get(12);
            this.endIsMorning = gc.get(9) == 0;
            this.edited = true;
        }
        catch (ParseException parseException) {
            this.endTimeField.getToolkit().beep();
            gc.set(11, 17);
            gc.set(12, 30);
            JOptionPane.showMessageDialog(this, String.valueOf(resource.getString("Invalid format or value for End Time.")) + "\n" + resource.getString("Ex: ") + this.dateformat.format(gc.getTime()));
        }
        gc.set(11, this.endHour);
        gc.set(12, this.endMin);
        this.endTimeField.setText(this.dateformat.format(gc.getTime()));
        this.setWakeupText();
    }

    int getEndMinutes() {
        int hours12 = this.endHour >= 12 ? this.endHour - 12 : this.endHour;
        return TimeConverter.convert12HourTimeToMinutesSinceMidnight(hours12, this.endMin, this.endIsMorning);
    }

    int getIdleMinutes() {
        return this.idleMin;
    }

    int getStartMinutes() {
        int hours12 = this.startHour >= 12 ? this.startHour - 12 : this.startHour;
        return TimeConverter.convert12HourTimeToMinutesSinceMidnight(hours12, this.startMin, this.startIsMorning);
    }

    String getStatefileDirectory() {
        return this.statefileDir;
    }

    void helpButton_actionPerformed(ActionEvent event) {
        if (helpBroker == null) {
            try {
                URL helpURL = HelpSet.findHelpSet(null, (String)HELPSET);
                HelpSet helpSet = new HelpSet(null, helpURL);
                helpBroker = helpSet.createHelpBroker();
            }
            catch (Exception exception) {
                System.out.println(String.valueOf(resource.getString("Could not find help set file: ")) + HELPSET);
                System.exit(3);
            }
        }
        helpBroker.setDisplayed(true);
    }

    void idleComboBox_actionPerformed(ActionEvent event) {
        TimeConverter tc = new TimeConverter();
        String idleTimeString = (String)this.idleComboBox.getSelectedItem();
        if (!tc.parseDuration(idleTimeString)) {
            JOptionPane.showMessageDialog(this, "Invalid format for duration");
            return;
        }
        this.idleMin = tc.totalMinutes;
        this.edited = true;
    }

    void idleTextField_actionPerformed(ActionEvent event) {
        JTextField textField = (JTextField)event.getSource();
        this.updateComboTime(this.idleComboBox, textField, this.idleMin);
    }

    boolean isEdited() {
        return this.edited;
    }

    boolean isWakeupEnabled() {
        return this.wakeupEnabled;
    }

    public static void main(String[] args) {
        ((Component)new Autoshutdown()).setVisible(true);
    }

    void okButton_actionPerformed(ActionEvent event) {
        this.startTimeField_actionPerformed(new ActionEvent(this.startTimeField, 1001, "entryComplete"));
        this.endTimeField_actionPerformed(new ActionEvent(this.endTimeField, 1001, "entryComplete"));
        this.saveEdits = true;
        ((Component)this).setVisible(false);
        this.dispose();
    }

    void setWakeupText() {
        GregorianCalendar gc = new GregorianCalendar();
        gc.set(11, this.endHour);
        gc.set(12, this.endMin);
        this.wakeupCheckBox.setText(String.valueOf(resource.getString("Restart at ")) + this.dateformat.format(gc.getTime()));
    }

    void startTimeField_actionPerformed(ActionEvent event) {
        String timeString = this.startTimeField.getText();
        Date date = null;
        GregorianCalendar gc = new GregorianCalendar();
        this.dateformat.setLenient(true);
        try {
            date = this.dateformat.parse(timeString);
            gc.setTime(date);
            this.startHour = gc.get(11);
            this.startMin = gc.get(12);
            this.startIsMorning = gc.get(9) == 0;
            this.edited = true;
        }
        catch (ParseException parseException) {
            this.startTimeField.getToolkit().beep();
            gc.set(11, 17);
            gc.set(12, 30);
            JOptionPane.showMessageDialog(this, String.valueOf(resource.getString("Invalid format or value for Start Time.")) + "\n" + resource.getString("Ex: ") + this.dateformat.format(gc.getTime()));
        }
        gc.set(11, this.startHour);
        gc.set(12, this.startMin);
        this.startTimeField.setText(this.dateformat.format(gc.getTime()));
    }

    void updateComboTime(JComboBox cbox, JTextField timeText, int oldSeconds) {
        TimeConverter tc = new TimeConverter();
        if (!tc.parseDuration(timeText.getText())) {
            timeText.setText(TimeConverter.constructDuration(oldSeconds));
            JOptionPane.showMessageDialog(this, resource.getString("Invalid format for duration"));
            return;
        }
        if (tc.totalSeconds == oldSeconds) {
            return;
        }
        tc.setComboDuration(tc.totalSeconds, cbox);
        this.edited = true;
    }

    void wakeupCheckBox_actionPerformed(ActionEvent event) {
        this.wakeupEnabled = this.wakeupCheckBox.isSelected();
        this.edited = true;
    }

    class SymAction
    implements ActionListener {
        SymAction() {
        }

        public void actionPerformed(ActionEvent event) {
            Object object = event.getSource();
            if (object == Autoshutdown.this.idleComboBox) {
                Autoshutdown.this.idleComboBox_actionPerformed(event);
            } else if (object == Autoshutdown.this.wakeupCheckBox) {
                Autoshutdown.this.wakeupCheckBox_actionPerformed(event);
            } else if (object == Autoshutdown.this.startTimeField) {
                Autoshutdown.this.startTimeField_actionPerformed(event);
            } else if (object == Autoshutdown.this.endTimeField) {
                Autoshutdown.this.endTimeField_actionPerformed(event);
            } else if (object == Autoshutdown.this.okButton) {
                Autoshutdown.this.okButton_actionPerformed(event);
            } else if (object == Autoshutdown.this.helpButton) {
                Autoshutdown.this.helpButton_actionPerformed(event);
            } else if (object == Autoshutdown.this.cancelButton) {
                Autoshutdown.this.cancelButton_actionPerformed(event);
            } else if (object == Autoshutdown.this.idleTextField) {
                Autoshutdown.this.idleTextField_actionPerformed(event);
            }
        }
    }

    class SymWindow
    extends WindowAdapter {
        SymWindow() {
        }

        public void windowClosing(WindowEvent event) {
            Object object = event.getSource();
            if (object == Autoshutdown.this) {
                Autoshutdown.this.Autoshutdown_windowClosing(event);
            }
        }
    }
}

