/*
 * Decompiled with CFR 0.152.
 */
package com.sun.management.viper.util;

import com.sun.management.viper.util.CommandOption;
import com.sun.management.viper.util.Debug;
import com.sun.management.viper.util.ResourceManager;
import java.io.InputStream;
import java.io.PrintStream;
import java.text.MessageFormat;
import java.util.HashMap;
import java.util.Map;
import java.util.Vector;

public class CommandParser {
    protected String commandName = null;
    protected String commandDesc = null;
    protected Vector commandOptions = null;
    protected boolean ignoreUnknowns = false;
    protected InputStream inStream = null;
    protected PrintStream outStream = null;
    protected Vector unMatchedOptions = null;
    protected boolean combineFlags = true;
    protected Map subCommands = null;
    protected String subCommand = null;
    protected Vector subCommandArgs = null;

    public CommandParser(String string, String string2, boolean bl, InputStream inputStream, PrintStream printStream) {
        this.commandName = string;
        if (string == null) {
            this.commandName = "program";
        }
        this.commandDesc = string2;
        if (string2 == null) {
            this.commandDesc = "program description";
        }
        this.ignoreUnknowns = bl;
        this.outStream = printStream;
        if (printStream == null) {
            this.outStream = System.out;
        }
        this.inStream = inputStream;
        if (inputStream == null) {
            this.inStream = System.in;
        }
        this.commandOptions = new Vector();
        this.unMatchedOptions = new Vector();
        this.subCommands = new HashMap();
        this.subCommandArgs = new Vector();
    }

    public void addOption(CommandOption commandOption) {
        if (!CommandParser.isValidOption(commandOption)) {
            return;
        }
        int n = 0;
        while (n < this.commandOptions.size()) {
            CommandOption commandOption2 = (CommandOption)this.commandOptions.elementAt(n);
            if (commandOption2.getName().equals(commandOption.getName())) {
                return;
            }
            String[] stringArray = commandOption2.getFlags();
            String[] stringArray2 = commandOption.getFlags();
            int n2 = 0;
            while (n2 < stringArray.length) {
                int n3 = 0;
                while (n3 < stringArray2.length) {
                    if (stringArray[n2].equals(stringArray2[n3])) {
                        Debug.trace("CommandParser", Debug.WARNING, CommandParser.getMessage("Duplicate option: {0} and {1} both use flag {2}.", new String[]{commandOption2.getName(), commandOption.getName(), CommandOption.printFlag(stringArray[n2], this.combineFlags)}), null);
                    }
                    ++n3;
                }
                ++n2;
            }
            ++n;
        }
        this.commandOptions.addElement(commandOption);
    }

    public void addSubCommand(CommandParser commandParser) {
        if (!CommandParser.isValidSubCommand(commandParser)) {
            return;
        }
        if (this.subCommands.containsKey(commandParser.getName())) {
            Debug.trace("CommandParser", Debug.WARNING, CommandParser.getMessage("Duplicate subcommand: {0}", new String[]{commandParser.getName()}), null);
            return;
        }
        this.subCommands.put(commandParser.getName(), commandParser);
    }

    public boolean getCombineFlags() {
        return this.combineFlags;
    }

    public String getDescription() {
        return this.commandDesc;
    }

    protected static String getMessage(String string) {
        return CommandParser.getMessage(string, null);
    }

    protected static String getMessage(String string, Object[] objectArray) {
        if (string == null) {
            return null;
        }
        String string2 = string;
        try {
            string2 = ResourceManager.getString(string2);
            string2 = MessageFormat.format(string2, objectArray);
        }
        catch (Exception exception) {}
        return string2;
    }

    public String getName() {
        return this.commandName;
    }

    public static String[] getPrimaryArgs(String[] stringArray) {
        try {
            if (stringArray == null) {
                return null;
            }
            int n = -1;
            int n2 = 0;
            while (n2 < stringArray.length) {
                if (stringArray[n2].equals("--")) {
                    n = n2;
                    break;
                }
                ++n2;
            }
            if (n > -1) {
                String[] stringArray2 = new String[n];
                int n3 = 0;
                while (n3 < n) {
                    stringArray2[n3] = stringArray[n3];
                    ++n3;
                }
                return stringArray2;
            }
            return stringArray;
        }
        catch (Exception exception) {
            return null;
        }
    }

    public static String[] getSecondaryArgs(String[] stringArray) {
        try {
            if (stringArray == null) {
                return null;
            }
            int n = -1;
            int n2 = 0;
            while (n2 < stringArray.length) {
                if (stringArray[n2].equals("--")) {
                    n = n2;
                    break;
                }
                ++n2;
            }
            if (n > -1) {
                String[] stringArray2 = new String[stringArray.length - n - 1];
                int n3 = n + 1;
                while (n3 < stringArray.length) {
                    stringArray2[n3 - n - 1] = stringArray[n3];
                    ++n3;
                }
                return stringArray2;
            }
        }
        catch (Exception exception) {}
        return null;
    }

    public CommandParser getSubCommand() {
        if (this.subCommand != null) {
            return (CommandParser)this.subCommands.get(this.subCommand);
        }
        return null;
    }

    public String[] getSubCommandArgs() {
        String[] stringArray = new String[this.subCommandArgs.size()];
        int n = 0;
        while (n < stringArray.length) {
            stringArray[n] = (String)this.subCommandArgs.elementAt(n);
            ++n;
        }
        return stringArray;
    }

    public String[] getSubCommandLine() {
        String[] stringArray = new String[1 + this.subCommandArgs.size()];
        stringArray[0] = this.subCommand;
        int n = 0;
        while (n < stringArray.length - 1) {
            stringArray[n + 1] = (String)this.subCommandArgs.elementAt(n);
            ++n;
        }
        return stringArray;
    }

    public String[] getUnmatchedOptions() {
        String[] stringArray = new String[this.unMatchedOptions.size()];
        int n = 0;
        while (n < stringArray.length) {
            stringArray[n] = (String)this.unMatchedOptions.elementAt(n);
            ++n;
        }
        return stringArray;
    }

    private static boolean isValidOption(CommandOption commandOption) {
        if (commandOption == null) {
            Debug.trace("CommandParser", Debug.WARNING, CommandParser.getMessage("Invalid null option"), null);
            return false;
        }
        if (commandOption.getName() == null) {
            Debug.trace("CommandParser", Debug.WARNING, CommandParser.getMessage("Invalid null option name"), null);
            return false;
        }
        if (commandOption.getDescription() == null) {
            Debug.trace("CommandParser", Debug.WARNING, CommandParser.getMessage("Invalid null option description"), null);
            return false;
        }
        if (commandOption.getFlag() == null || commandOption.getFlag().length() == 0) {
            Debug.trace("CommandParser", Debug.WARNING, CommandParser.getMessage("Invalid null or empty option flag"), null);
            return false;
        }
        return true;
    }

    private static boolean isValidSubCommand(CommandParser commandParser) {
        if (commandParser == null) {
            Debug.trace("CommandParser", Debug.WARNING, CommandParser.getMessage("Invalid null subcommand"), null);
            return false;
        }
        if (commandParser.getName() == null || commandParser.getName().length() == 0) {
            Debug.trace("CommandParser", Debug.WARNING, CommandParser.getMessage("Invalid null or empty subcommand name"), null);
            return false;
        }
        return true;
    }

    public static void main(String[] stringArray) {
        ResourceManager.seed(false);
        CommandOption commandOption = new CommandOption("option1", "Option 1", new String[]{"a", "aaaa"}, 2, true, false, null, false);
        CommandOption commandOption2 = new CommandOption("option2", "Option 2", new String[]{"b", "bbbb"}, 2, true, false, null, false);
        CommandParser commandParser = new CommandParser("test", "Arg tester", true, System.in, System.out);
        CommandParser commandParser2 = new CommandParser("stop", "Stop Subcommand", true, System.in, System.out);
        commandParser.addSubCommand(commandParser2);
        commandParser2.addOption(commandOption);
        if (!commandParser.parseArgs(stringArray)) {
            System.err.println("Parsing failure");
            System.exit(1);
        }
        if ((commandParser2 = commandParser.getSubCommand()) != null) {
            System.err.print("Subcommand args:");
            String[] stringArray2 = commandParser.getSubCommandArgs();
            int n = 0;
            while (n < stringArray2.length) {
                System.err.print(" " + stringArray2[n]);
                ++n;
            }
            System.err.println("");
            if (commandParser2.parseArgs(stringArray2)) {
                if (commandOption.wasSet()) {
                    System.err.println("Option 1 value: " + commandOption.getValue());
                }
                if (commandOption2.wasSet()) {
                    System.err.println("Option 2 value: " + commandOption2.getValue());
                }
            }
        }
    }

    protected String missingOptions() {
        StringBuffer stringBuffer = new StringBuffer();
        int n = 0;
        while (n < this.commandOptions.size()) {
            CommandOption commandOption = (CommandOption)this.commandOptions.elementAt(n);
            if (commandOption.hasPriority() && commandOption.wasSet()) {
                return null;
            }
            if (!commandOption.isOptional() && !commandOption.wasSet()) {
                stringBuffer.append(" " + CommandOption.printFlag(commandOption.getFlag(), this.combineFlags));
            }
            ++n;
        }
        if (stringBuffer.length() > 0) {
            return stringBuffer.toString();
        }
        return null;
    }

    public boolean parseArgs(String[] stringArray) {
        try {
            String string;
            String[] stringArray2;
            ArgHandler argHandler = new ArgHandler(CommandParser.getPrimaryArgs(stringArray), true);
            while (argHandler.hasMoreOptions()) {
                stringArray2 = argHandler.getFlag();
                this.unMatchedOptions.addAll(argHandler.getUnusedArgs());
                if (stringArray2 == null) continue;
                this.parseFlag((String)stringArray2, argHandler);
            }
            if (argHandler.getFlag() == null) {
                this.unMatchedOptions.addAll(argHandler.getUnusedArgs());
            }
            if ((stringArray2 = CommandParser.getSecondaryArgs(stringArray)) != null && stringArray2.length > 0) {
                this.unMatchedOptions.addElement(new String("--"));
                int n = 0;
                while (n < stringArray2.length) {
                    this.unMatchedOptions.addElement(stringArray2[n]);
                    ++n;
                }
            }
            if ((string = this.missingOptions()) != null) {
                this.printUsage(CommandParser.getMessage("Missing Option(s): {0}", new String[]{string}));
                return false;
            }
        }
        catch (Exception exception) {
            this.printUsage(exception.getMessage());
            return false;
        }
        return true;
    }

    protected void parseFlag(String string, ArgHandler argHandler) throws Exception {
        if (string == null || argHandler == null) {
            throw new Exception(CommandParser.getMessage("Problem parsing input"));
        }
        int n = 0;
        while (n < this.commandOptions.size()) {
            CommandOption commandOption = (CommandOption)this.commandOptions.elementAt(n);
            if (commandOption.hasFlag(string)) {
                if (commandOption.getType() == 0) {
                    commandOption.addValue(new Boolean(true));
                } else {
                    String string2 = argHandler.getArgument();
                    if (string2 == null) {
                        throw new Exception(CommandParser.getMessage("Missing Argument for {0}", new String[]{CommandOption.printFlag(string, this.combineFlags)}));
                    }
                    commandOption.addValue(string2);
                }
                return;
            }
            ++n;
        }
        this.unMatchedOptions.addElement(CommandOption.printFlag(string, this.combineFlags));
        if (!this.ignoreUnknowns) {
            throw new Exception(CommandParser.getMessage("Unknown option: {0}", new String[]{CommandOption.printFlag(string, this.combineFlags)}));
        }
    }

    public void printUsage(String string) {
        this.outStream.println(this.commandDesc);
        if (string != null) {
            this.outStream.println(CommandParser.getMessage("Error: {0}", new String[]{string}));
        }
        if (this.subCommands.size() > 0) {
            Object object;
            this.outStream.println(CommandParser.getMessage("Usage: {0} [flags] command [flags]", new String[]{this.commandName}));
            this.outStream.println("\n" + CommandParser.getMessage("Common flags:"));
            int n = 0;
            while (n < this.commandOptions.size()) {
                object = (CommandOption)this.commandOptions.elementAt(n);
                ((CommandOption)object).printUsageVerbose(this.outStream, this.combineFlags);
                ++n;
            }
            this.outStream.println("\n" + CommandParser.getMessage("Commands:"));
            object = this.subCommands.keySet().iterator();
            while (object.hasNext()) {
                String string2 = (String)object.next();
                String string3 = ((CommandParser)this.subCommands.get(string2)).getDescription();
                this.outStream.println("\t" + string2 + "\t" + string3);
            }
        } else {
            this.outStream.println(CommandParser.getMessage("Usage: {0} [flags]", new String[]{this.commandName}));
            this.outStream.println("\n" + CommandParser.getMessage("Flags:"));
            int n = 0;
            while (n < this.commandOptions.size()) {
                CommandOption commandOption = (CommandOption)this.commandOptions.elementAt(n);
                commandOption.printUsageVerbose(this.outStream, this.combineFlags);
                ++n;
            }
        }
    }

    public boolean promptUser() {
        int n = 0;
        while (n < this.commandOptions.size()) {
            CommandOption commandOption = (CommandOption)this.commandOptions.elementAt(n);
            if (!(commandOption.wasSet() || commandOption.hasDefault() || commandOption.promptUser(this.inStream, this.outStream))) {
                return false;
            }
            ++n;
        }
        return true;
    }

    public void setCombineFlags(boolean bl) {
        this.combineFlags = bl;
    }

    class ArgHandler {
        protected String[] args = null;
        protected int pos = 0;
        protected int flagoffset = 0;
        protected int argsfound = 0;
        protected boolean stuck = false;
        protected Vector usedArgs = null;
        protected Vector unusedArgs = null;
        protected boolean combine = true;

        public ArgHandler(String[] stringArray, boolean bl) {
            this.args = stringArray;
            this.usedArgs = new Vector();
            this.unusedArgs = new Vector();
            this.combine = bl;
        }

        public String getArgument() {
            if (this.pos + this.flagoffset >= this.args.length || this.pos < 0) {
                return null;
            }
            String string = this.args[this.pos + this.flagoffset];
            if (string.startsWith("-")) {
                return null;
            }
            ++this.argsfound;
            if (this.flagoffset == 0) {
                this.argsfound = 0;
                ++this.pos;
            }
            return string;
        }

        public String getFlag() {
            if (this.pos >= this.args.length || this.pos < 0) {
                return null;
            }
            String string = this.args[this.pos];
            if (this.flagoffset > 0 && this.flagoffset >= string.length() - 1) {
                this.pos += this.argsfound + 1;
                this.argsfound = 0;
                this.flagoffset = 0;
                if (this.pos >= this.args.length) {
                    return null;
                }
                string = this.args[this.pos];
            }
            if (string.startsWith("--")) {
                ++this.pos;
                this.flagoffset = 0;
                return string.substring(2, string.length());
            }
            if (string.startsWith("-") && !this.combine) {
                ++this.pos;
                this.flagoffset = 0;
                return string.substring(1, string.length());
            }
            if (string.startsWith("-") && this.combine) {
                ++this.flagoffset;
                return string.substring(this.flagoffset, this.flagoffset + 1);
            }
            ++this.pos;
            this.flagoffset = 0;
            if (CommandParser.this.subCommands.containsKey(string)) {
                CommandParser.this.subCommand = string;
                while (this.pos < this.args.length) {
                    CommandParser.this.subCommandArgs.addElement(this.args[this.pos++]);
                }
                return null;
            }
            this.unusedArgs.addElement(string);
            return null;
        }

        public Vector getUnusedArgs() {
            Vector vector = new Vector();
            vector.addAll(this.unusedArgs);
            this.unusedArgs.clear();
            return vector;
        }

        public Vector getUsedArgs() {
            return this.usedArgs;
        }

        public boolean hasMoreOptions() {
            return this.pos < this.args.length;
        }
    }
}

