/*
 * Decompiled with CFR 0.152.
 */
package com.sun.management.viper.console.gui.lf;

import com.sun.management.viper.console.gui.lf.VInfoComp;
import com.sun.management.viper.console.gui.lf.VInfoPane;
import com.sun.management.viper.util.Debug;
import com.sun.management.viper.util.ResourceManager;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Font;
import javax.swing.Icon;
import javax.swing.JPanel;
import javax.swing.JTabbedPane;
import javax.swing.border.EmptyBorder;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;

public class VInfoContainer
extends JPanel {
    protected VInfoComp currComp = null;
    protected JTabbedPane tabPane = null;
    protected int layer = 0;
    protected VInfoPane vInfoPane = null;

    public VInfoContainer(String string, Icon icon, Component component, int n, VInfoPane vInfoPane) {
        this.layer = n;
        this.vInfoPane = vInfoPane;
        this.setBorder(new EmptyBorder(0, 0, 0, 0));
        this.setLayout(new BorderLayout());
        this.currComp = new VInfoComp(string, icon, component, 0, this);
        this.add((Component)this.currComp, "Center");
        this.validate();
        this.repaint();
    }

    public void addInfoPanel(String string, Icon icon, Component component) {
        if (component == null || string == null) {
            return;
        }
        if (this.tabPane != null) {
            int n = this.tabPane.getTabCount();
            this.tabPane.addTab(string, icon, new VInfoComp(string, icon, component, n, this));
            this.tabPane.setBackgroundAt(n, Color.gray);
            this.validate();
            this.repaint();
            return;
        }
        this.remove(this.currComp);
        this.tabPane = new JTabbedPane(){

            public Component findComponentAt(int n, int n2) {
                if (!this.contains(n, n2)) {
                    return null;
                }
                int n3 = this.getComponentCount();
                int n4 = 0;
                while (n4 < n3) {
                    Component component = this.getComponentAt(n4);
                    if (component != null && component instanceof Container) {
                        if (component.isVisible()) {
                            Container container = (Container)component;
                            component = container.findComponentAt(n - component.getX(), n2 - component.getY());
                        } else {
                            component = component.getComponentAt(n - component.getX(), n2 - component.getY());
                        }
                        if (component != null && component.isVisible()) {
                            return component;
                        }
                    }
                    ++n4;
                }
                return this;
            }
        };
        this.tabPane.setFont(ResourceManager.menuFont);
        this.tabPane.setOpaque(true);
        this.tabPane.setBackground(ResourceManager.sunBlue);
        this.tabPane.setTabPlacement(3);
        this.tabPane.setBorder(new EmptyBorder(0, 0, 0, 0));
        this.tabPane.addTab(this.currComp.getTitle(), this.currComp.getIcon(), this.currComp);
        this.tabPane.addTab(string, icon, new VInfoComp(string, icon, component, 1, this));
        this.tabPane.setBackgroundAt(0, Color.gray);
        this.tabPane.setBackgroundAt(1, Color.gray);
        this.tabPane.setForeground(ResourceManager.menuColor);
        this.tabPane.addChangeListener(new ChangeListener(){

            public void stateChanged(ChangeEvent changeEvent) {
                VInfoContainer.this.invalidate();
                Component component = VInfoContainer.this.tabPane.getSelectedComponent();
                if (component != null) {
                    component.invalidate();
                    component.doLayout();
                    component.validate();
                    component.repaint();
                }
                VInfoContainer.this.doLayout();
                VInfoContainer.this.validate();
                VInfoContainer.this.repaint();
            }
        });
        this.add((Component)this.tabPane, "Center");
        this.validate();
        this.repaint();
    }

    public int getInfoPanelCount() {
        int n = 1;
        if (this.tabPane != null) {
            n = this.tabPane.getTabCount();
        }
        return n;
    }

    public Dimension getMinimumSize() {
        return new Dimension(0, 32);
    }

    public void removeInfoPanel(int n) {
        if (n < 0 || n >= this.getInfoPanelCount()) {
            return;
        }
        try {
            if (this.tabPane != null) {
                if (this.tabPane.getTabCount() == 2) {
                    this.currComp = (VInfoComp)this.tabPane.getComponentAt(0);
                    this.remove(this.tabPane);
                    this.add((Component)this.currComp, "Center");
                    this.setBorder(new EmptyBorder(0, 0, 0, 0));
                    this.tabPane = null;
                    this.validate();
                    this.repaint();
                } else {
                    this.tabPane.removeTabAt(n);
                }
            } else {
                this.vInfoPane.removeContentPane(this.layer);
            }
        }
        catch (Throwable throwable) {
            Debug.trace("VInfoContainer", Debug.WARNING, "Problem removing component", throwable);
        }
    }

    public void removeInfoPanel(Component component) {
        if (component == null) {
            return;
        }
        try {
            if (this.tabPane != null) {
                int n = 0;
                while (n < this.tabPane.getTabCount()) {
                    Component component2 = this.tabPane.getComponentAt(n);
                    VInfoComp vInfoComp = (VInfoComp)component2;
                    if (vInfoComp.getComponent() == component) {
                        this.tabPane.removeTabAt(n);
                        break;
                    }
                    ++n;
                }
                if (this.tabPane.getTabCount() == 1) {
                    this.currComp = (VInfoComp)this.tabPane.getComponentAt(0);
                    this.remove(this.tabPane);
                    this.add((Component)this.currComp, "Center");
                    this.setBorder(new EmptyBorder(0, 0, 0, 0));
                    this.tabPane = null;
                    this.validate();
                    this.repaint();
                }
            } else if (this.currComp.getComponent() == component) {
                this.vInfoPane.removeContentPane(this.layer);
            }
        }
        catch (Throwable throwable) {
            Debug.trace("VInfoContainer", Debug.WARNING, "Problem removing component", throwable);
        }
    }

    public void setFont(Font font) {
        if (font == null || this.tabPane == null) {
            return;
        }
        this.tabPane.setFont(font);
        this.tabPane.validate();
        this.tabPane.repaint();
    }

    public void setForeground(Color color) {
        if (color == null || this.tabPane == null) {
            return;
        }
        int n = 0;
        while (n < this.tabPane.getTabCount()) {
            this.tabPane.setForegroundAt(n, color);
            ++n;
        }
        this.tabPane.validate();
        this.tabPane.repaint();
    }

    public void setLayer(int n) {
        this.layer = n;
    }
}

