/*
 * Decompiled with CFR 0.152.
 */
package com.sun.management.viper.console.gui.lf;

import com.sun.management.viper.console.VConsoleActionListener;
import com.sun.management.viper.console.VConsoleEvent;
import com.sun.management.viper.console.VConsoleProperties;
import com.sun.management.viper.console.VScopeNode;
import com.sun.management.viper.util.ResourceManager;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Font;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.Vector;
import javax.swing.JPanel;
import javax.swing.JProgressBar;
import javax.swing.JTextField;

public class VInfoBar
extends JPanel
implements PropertyChangeListener,
VConsoleActionListener {
    protected JTextField label = null;
    protected Component comp = null;
    protected Vector listeners = null;
    protected VConsoleProperties properties = null;
    protected VScopeNode selNode = null;

    public VInfoBar() {
        this.setLayout(new BorderLayout());
        this.label = new JTextField();
        this.comp = this.label;
        this.label.setEditable(false);
        this.add((Component)this.label, "Center");
        this.label.setFont(ResourceManager.bodyFont);
        this.label.setForeground(ResourceManager.bodyColor);
    }

    public void addConsoleActionListener(VConsoleActionListener vConsoleActionListener) {
        if (this.listeners == null) {
            this.listeners = new Vector();
        }
        if (vConsoleActionListener == null) {
            return;
        }
        this.listeners.addElement(vConsoleActionListener);
    }

    public void consoleAction(VConsoleEvent vConsoleEvent) {
        Object object;
        String string = vConsoleEvent.getID();
        if (string.equals("vconsole.updateselinfo")) {
            Object object2 = vConsoleEvent.getPayload();
            if (object2 instanceof String) {
                this.setText((String)object2);
            } else if (object2 instanceof Component) {
                this.setComponent((Component)object2);
            }
        } else if (string.equals("vconsole.scopeselected")) {
            Object object3 = vConsoleEvent.getPayload();
            if (object3 != null && object3 instanceof VScopeNode) {
                this.selNode = (VScopeNode)object3;
            }
            this.reflectScopeChange(vConsoleEvent.getPayload());
        } else if (string.equals("vconsole.updatescope") && (object = vConsoleEvent.getPayload()) != null && object instanceof VScopeNode && (VScopeNode)object == this.selNode) {
            this.reflectScopeChange(vConsoleEvent.getPayload());
        }
    }

    protected void notifyListeners(VConsoleEvent vConsoleEvent) {
        if (this.listeners == null || vConsoleEvent == null) {
            return;
        }
        int n = 0;
        while (n < this.listeners.size()) {
            Object e = this.listeners.elementAt(n);
            ((VConsoleActionListener)e).consoleAction(vConsoleEvent);
            ++n;
        }
    }

    public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
        if (propertyChangeEvent == null) {
            return;
        }
        String string = propertyChangeEvent.getPropertyName();
        Object object = propertyChangeEvent.getNewValue();
        try {
            if (string.equals("vconsole.bodyfont")) {
                this.label.setFont((Font)object);
                this.validate();
                this.repaint();
            } else if (string.equals("vconsole.bodycolor")) {
                this.label.setForeground((Color)object);
                this.validate();
                this.repaint();
            }
        }
        catch (Throwable throwable) {}
    }

    protected void reflectScopeChange(Object object) {
        try {
            VScopeNode vScopeNode = (VScopeNode)object;
            int n = vScopeNode.getChildCount();
            if (vScopeNode.getInternalRoot() != null) {
                n += vScopeNode.getInternalRoot().getChildCount();
            }
            this.setText(String.valueOf(n) + " " + ResourceManager.getString("Item(s)"));
        }
        catch (Exception exception) {
            this.setText(" ");
        }
    }

    protected void setComponent(Component component) {
        this.remove(this.comp);
        this.add(component, "Center");
        this.comp = component;
        this.validate();
        this.repaint();
    }

    protected void setProgress(JProgressBar jProgressBar) {
        this.setComponent(jProgressBar);
    }

    public void setProperties(VConsoleProperties vConsoleProperties) {
        if (vConsoleProperties == null) {
            return;
        }
        this.properties = vConsoleProperties;
        vConsoleProperties.addPropertyChangeListener(this);
    }

    protected void setText(String string) {
        this.label.setText(string);
        this.setComponent(this.label);
    }
}

