/*
 * Decompiled with CFR 0.152.
 */
package com.sun.management.viper.console.gui.help;

import com.sun.management.viper.console.VConsoleActionListener;
import com.sun.management.viper.console.VConsoleEvent;
import com.sun.management.viper.console.VConsoleProperties;
import com.sun.management.viper.console.gui.VContainer;
import com.sun.management.viper.console.gui.VDialog;
import com.sun.management.viper.util.Debug;
import com.sun.management.viper.util.ResourceManager;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dialog;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.Point;
import java.awt.Toolkit;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.net.URL;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Vector;
import javax.help.DefaultHelpModel;
import javax.help.HelpSet;
import javax.help.JHelp;
import javax.help.JHelpIndexNavigator;
import javax.help.JHelpNavigator;
import javax.help.JHelpSearchNavigator;
import javax.help.JHelpTOCNavigator;
import javax.help.Map;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JInternalFrame;
import javax.swing.JPanel;

public class VHelpViewer
extends JPanel
implements PropertyChangeListener,
VConsoleActionListener {
    protected static Dimension preferredSize = new Dimension(650, 450);
    protected static String DEFAULT_HELPSET = "SMC.hs";
    protected JHelp helpView = null;
    protected HelpSet defaultHelpSet = null;
    protected VContainer parentContainer = null;
    protected Component container = null;
    protected VConsoleProperties properties = null;
    protected String helpSetName = DEFAULT_HELPSET;
    protected String title = ResourceManager.getString("Help");
    protected Hashtable addedSets = null;
    protected Vector listeners = null;
    protected JHelpNavigator treeTab = null;
    protected JHelpNavigator indexTab = null;
    protected JHelpNavigator searchTab = null;

    public VHelpViewer() {
        this(DEFAULT_HELPSET);
    }

    public VHelpViewer(String string) {
        if (string != null) {
            this.helpSetName = string;
        }
        this.initializeHelpSet();
        this.validate();
        this.repaint();
    }

    public void addConsoleActionListener(VConsoleActionListener vConsoleActionListener) {
        if (this.listeners == null) {
            this.listeners = new Vector();
        }
        this.listeners.addElement(vConsoleActionListener);
    }

    public void closeBox() {
        if (this.container != null) {
            this.container.setVisible(false);
        }
    }

    public void consoleAction(VConsoleEvent vConsoleEvent) {
        block17: {
            Object object;
            String string;
            block18: {
                block16: {
                    if (vConsoleEvent == null || vConsoleEvent.getID() == null) {
                        return;
                    }
                    string = vConsoleEvent.getID();
                    if (!string.equals("vconsole.addhelpset")) break block16;
                    Object object2 = vConsoleEvent.getPayload();
                    if (object2 == null || !(object2 instanceof HelpSet)) break block17;
                    HelpSet helpSet = (HelpSet)object2;
                    if (this.addedSets == null) {
                        this.addedSets = new Hashtable();
                    }
                    try {
                        String string2 = helpSet.getHelpSetURL().toString();
                        String string3 = string2.substring(string2.lastIndexOf(47) + 1);
                        int n = string3.lastIndexOf(".hs");
                        if (n > 0) {
                            string3 = string3.substring(0, n);
                        }
                        if (this.addedSets.containsKey(string3)) {
                            return;
                        }
                        this.defaultHelpSet.add(helpSet);
                        this.addedSets.put(string3, helpSet);
                    }
                    catch (Exception exception) {
                        Debug.trace("HelpViewer", Debug.WARNING, "Problem adding HelpSet", exception);
                    }
                    break block17;
                }
                if (!string.equals("vconsole.removehelpset")) break block18;
                Object object3 = vConsoleEvent.getPayload();
                if (object3 == null || !(object3 instanceof HelpSet)) {
                    return;
                }
                HelpSet helpSet = (HelpSet)object3;
                try {
                    String string4 = helpSet.getHelpSetURL().toString();
                    String string5 = string4.substring(string4.lastIndexOf(47) + 1);
                    int n = string5.lastIndexOf(".hs");
                    if (n > 0) {
                        string5 = string5.substring(0, n);
                    }
                    this.addedSets.remove(string5);
                    this.defaultHelpSet.remove(helpSet);
                }
                catch (Exception exception) {
                    Debug.trace("HelpViewer", Debug.WARNING, "Problem removing HelpSet", exception);
                }
                break block17;
            }
            if (!string.equals("vconsole.hyperlinkevent")) break block17;
            Object object4 = vConsoleEvent.getPayload();
            if (object4 == null || !(object4 instanceof String)) {
                return;
            }
            String string6 = (String)object4;
            if (string6.startsWith("http:")) {
                System.err.println("HTTP hyperlinks no longer supported");
                return;
            }
            String string7 = string6;
            HelpSet helpSet = this.defaultHelpSet;
            int n = string6.lastIndexOf(47);
            if (n > 0) {
                string7 = string6.substring(n + 1);
                object = string6.substring(0, n);
                if ((n = ((String)object).lastIndexOf(".hs")) > 0) {
                    object = ((String)object).substring(0, n);
                }
                helpSet = (HelpSet)this.addedSets.get(object);
            }
            try {
                object = Map.ID.create((String)string7, (HelpSet)helpSet);
                DefaultHelpModel defaultHelpModel = (DefaultHelpModel)this.helpView.getModel();
                defaultHelpModel.setCurrentID((Map.ID)object);
            }
            catch (Throwable throwable) {
                Debug.trace("HelpViewer", Debug.WARNING, "Problem linking totarget", throwable);
            }
        }
    }

    public Component getContainer() {
        return this.container;
    }

    public Dimension getPreferredSize() {
        return preferredSize;
    }

    public void index() {
        if (this.indexTab != null && this.helpView != null) {
            this.helpView.setCurrentNavigator(this.indexTab);
        }
    }

    protected void initializeHelpSet() {
        try {
            URL uRL = HelpSet.findHelpSet(null, (String)this.helpSetName);
            this.defaultHelpSet = new HelpSet(null, uRL);
            this.initializeModelAndView();
        }
        catch (Exception exception) {
            Debug.trace("HelpViewer", Debug.ERROR, "Could not load helpset", exception);
        }
    }

    protected void initializeModelAndView() {
        try {
            this.helpView = new JHelp(this.defaultHelpSet);
            this.setLayout(new BorderLayout());
            this.add((Component)this.helpView, "Center");
            this.validate();
            this.repaint();
            Enumeration enumeration = this.helpView.getHelpNavigators();
            while (enumeration.hasMoreElements()) {
                Object e = enumeration.nextElement();
                if (e instanceof JHelpTOCNavigator && this.treeTab == null) {
                    this.treeTab = (JHelpNavigator)e;
                    continue;
                }
                if (e instanceof JHelpIndexNavigator && this.indexTab == null) {
                    this.indexTab = (JHelpNavigator)e;
                    continue;
                }
                if (!(e instanceof JHelpSearchNavigator) || this.searchTab != null) continue;
                this.searchTab = (JHelpNavigator)e;
            }
        }
        catch (Exception exception) {
            Debug.trace("HelpViewer", Debug.ERROR, "Error initializing model", exception);
        }
    }

    public static void main(String[] stringArray) {
        ResourceManager.seed(true);
        VConsoleProperties.newInstance();
        VHelpViewer vHelpViewer = null;
        vHelpViewer = stringArray.length == 1 ? new VHelpViewer(stringArray[0]) : new VHelpViewer();
        JFrame jFrame = new JFrame();
        VDialog vDialog = new VDialog(jFrame, "Viper Help Viewer", true);
        vDialog.setComponent(vHelpViewer);
        vDialog.showCenter(null);
        System.exit(0);
    }

    protected void notifyListeners(VConsoleEvent vConsoleEvent) {
        if (this.listeners == null) {
            return;
        }
        int n = 0;
        while (n < this.listeners.size()) {
            Object e = this.listeners.elementAt(n);
            ((VConsoleActionListener)e).consoleAction(vConsoleEvent);
            ++n;
        }
    }

    public void overview() {
    }

    public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
    }

    public void search() {
        if (this.searchTab != null && this.helpView != null) {
            this.helpView.setCurrentNavigator(this.searchTab);
        }
    }

    public void setContainer(Component component) {
        Cloneable cloneable;
        Object object;
        if (component != null && component instanceof VContainer) {
            object = (VContainer)((Object)component);
            cloneable = new AbstractAction(){

                public void actionPerformed(ActionEvent actionEvent) {
                    VHelpViewer.this.closeBox();
                }
            };
            object.setDefaultAction((Action)((Object)cloneable));
            object.setCancelAction((Action)((Object)cloneable));
            object.setComponent(this);
            this.parentContainer = object;
        }
        if (component instanceof JInternalFrame) {
            object = (JInternalFrame)component;
            if (this.title != null) {
                ((JInternalFrame)object).setTitle(this.title);
            } else {
                ((JInternalFrame)object).setTitle(" ");
            }
            ((JInternalFrame)object).setDefaultCloseOperation(2);
            cloneable = this.getPreferredSize();
            ((Component)object).setSize(new Dimension(((Dimension)cloneable).width + 4, ((Dimension)cloneable).height + 40));
            ((JInternalFrame)object).getContentPane().setLayout(new BorderLayout());
            ((JInternalFrame)object).getContentPane().add((Component)this, "Center");
        } else if (component instanceof JFrame) {
            object = (JFrame)component;
            if (this.title != null) {
                ((Frame)object).setTitle(this.title);
            } else {
                ((Frame)object).setTitle(" ");
            }
            cloneable = this.getPreferredSize();
            ((Component)object).setSize(new Dimension(((Dimension)cloneable).width + 4, ((Dimension)cloneable).height + 40));
            ((JFrame)object).getContentPane().setLayout(new BorderLayout());
            ((JFrame)object).getContentPane().add((Component)this, "Center");
        } else if (component instanceof JDialog) {
            object = (JDialog)component;
            if (this.title != null) {
                ((Dialog)object).setTitle(this.title);
            } else {
                ((Dialog)object).setTitle(" ");
            }
            cloneable = this.getPreferredSize();
            ((Component)object).setSize(new Dimension(((Dimension)cloneable).width + 4, ((Dimension)cloneable).height + 40));
            ((JDialog)object).getContentPane().setLayout(new BorderLayout());
            ((JDialog)object).getContentPane().add((Component)this, "Center");
        }
        this.container = component;
    }

    public void setLocation(int n, int n2) {
        if (this.container != null) {
            this.container.setLocation(n, n2);
        }
    }

    public void setProperties(VConsoleProperties vConsoleProperties) {
        this.properties = vConsoleProperties;
    }

    public void setVisible(boolean bl) {
        if (this.container != null) {
            this.container.setVisible(bl);
        }
    }

    public void showCenter(Component component) {
        try {
            if (this.container != null) {
                Dimension dimension = null;
                Point point = null;
                if (component != null) {
                    dimension = component.getSize();
                    point = component.getLocation();
                } else {
                    dimension = Toolkit.getDefaultToolkit().getScreenSize();
                    point = new Point(0, 0);
                }
                Dimension dimension2 = this.getPreferredSize();
                int n = point.x + dimension.width / 2 - dimension2.width / 2;
                int n2 = point.y + dimension.height / 2 - dimension2.height / 2;
                if (!this.container.isShowing()) {
                    this.container.setLocation(n, n2);
                    this.container.setVisible(true);
                } else if (this.container instanceof Window) {
                    ((Window)this.container).toFront();
                }
            }
        }
        catch (Throwable throwable) {
            throwable.printStackTrace();
        }
    }

    public void toc() {
        if (this.treeTab != null && this.helpView != null) {
            this.helpView.setCurrentNavigator(this.treeTab);
        }
    }
}

