/*
 * Decompiled with CFR 0.152.
 */
package com.sun.management.viper.console.gui.deck;

import com.sun.management.viper.console.VConsoleProperties;
import com.sun.management.viper.console.gui.VOptionPane;
import com.sun.management.viper.console.gui.deck.VCard;
import com.sun.management.viper.console.gui.deck.VDeck;
import com.sun.management.viper.console.gui.deck.VDeckManager;
import com.sun.management.viper.console.gui.deck.VDeckProperties;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Container;
import java.beans.PropertyChangeEvent;
import java.net.URL;
import javax.swing.JComponent;

public abstract class VBaseDeck
extends VOptionPane
implements VDeck {
    protected VDeckProperties deckProperties = null;
    protected VDeckManager manager = this.getNewManager();

    public VBaseDeck() {
        this((String)null);
    }

    public VBaseDeck(String string) {
        super(string, null);
    }

    public void addCard(String string, VCard vCard) {
        this.manager.addCard(string, vCard);
        if (vCard != null) {
            vCard.setDeck(this);
        }
    }

    public VDeckProperties getDeckProperties() {
        return this.deckProperties;
    }

    public Object getDeckProperty(String string) {
        return this.deckProperties.getProperty(string);
    }

    public VDeckManager getManager() {
        return this.manager;
    }

    protected abstract VDeckManager getNewManager();

    protected abstract VDeckProperties getNewProperties();

    public Object getProperty(String string) {
        return this.deckProperties.getProperty(string);
    }

    public void init() {
        this.manager.init();
    }

    public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
        try {
            String string = propertyChangeEvent.getPropertyName();
            if (!string.equals("vwp.helpinfo")) {
                return;
            }
            Object object = propertyChangeEvent.getNewValue();
            if (object instanceof String) {
                super.setHelpHTML((String)object);
            } else if (object instanceof URL) {
                super.setHelpHTML((URL)object);
            } else if (object instanceof Component) {
                JComponent jComponent = super.getHelpPane();
                jComponent.removeAll();
                jComponent.setLayout(new BorderLayout());
                jComponent.add((Component)object, "Center");
                jComponent.validate();
                jComponent.repaint();
            }
        }
        catch (Exception exception) {}
    }

    public void removeCard(String string) {
        this.manager.removeCard(string);
    }

    public void reset() {
        this.deckProperties = this.getNewProperties();
        this.deckProperties.addPropertyChangeListener(this);
        this.manager.setProperties(this.deckProperties);
        this.manager.setConsoleProperties(this.properties);
        this.manager.reset();
        this.updateCard(this.manager.getCurrentCard());
        this.validate();
        this.repaint();
    }

    public Object setDeckProperty(String string, Object object) {
        return this.deckProperties.setProperty(string, object);
    }

    public void setProperties(VConsoleProperties vConsoleProperties) {
        super.setProperties(vConsoleProperties);
        this.manager.setConsoleProperties(vConsoleProperties);
    }

    public Object setProperty(String string, Object object) {
        return this.deckProperties.setProperty(string, object);
    }

    public void start() {
        this.updateCard(this.manager.getCurrentCard());
    }

    protected void updateCard(VCard vCard) {
        if (vCard == null) {
            return;
        }
        this.updateCardHelp(vCard);
        this.updateCardContent(vCard);
        super.setContentTitle(vCard.getTitle());
        vCard.start();
    }

    protected void updateCardContent(VCard vCard) {
        JComponent jComponent = super.getContentPane();
        jComponent.removeAll();
        jComponent.setLayout(new BorderLayout());
        jComponent.add((Component)vCard.getContentPane(), "Center");
        jComponent.validate();
        jComponent.repaint();
        jComponent.requestFocus();
    }

    protected void updateCardHelp(VCard vCard) {
        Container container = vCard.getInfoPane();
        if (container != null) {
            super.getHelpPane().removeAll();
            super.getHelpPane().setLayout(new BorderLayout());
            super.getHelpPane().add((Component)container, "Center");
        } else if (vCard.getHelpHTML() != null) {
            super.setHelpHTML(vCard.getHelpHTML());
        } else if (vCard.getHelpURL() != null) {
            super.setHelpHTML(vCard.getHelpURL());
        }
        super.getHelpPane().validate();
        super.getHelpPane().repaint();
    }
}

