/*
 * Decompiled with CFR 0.152.
 */
package com.sun.management.viper.console.gui;

import com.sun.management.viper.console.VConsoleEvent;
import com.sun.management.viper.console.VConsoleTableModel;
import com.sun.management.viper.util.ConsoleUtility;
import com.sun.management.viper.util.ResourceManager;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Insets;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JTable;
import javax.swing.border.BevelBorder;
import javax.swing.border.Border;
import javax.swing.border.CompoundBorder;
import javax.swing.border.EmptyBorder;
import javax.swing.table.JTableHeader;
import javax.swing.table.TableCellRenderer;
import javax.swing.table.TableModel;

public class VStyledTableHeaderRenderer
extends JButton
implements TableCellRenderer {
    protected int sorted = -1;
    protected boolean ascending = true;
    protected int tempSort = -1;
    protected ImageIcon upIcon = null;
    protected ImageIcon dnIcon = null;
    protected Border pressedBorder = null;
    protected Border stdBorder = null;
    protected JTableHeader tableHeader = null;
    protected int pressed = -1;
    protected boolean isResizing = false;

    public VStyledTableHeaderRenderer() {
        EmptyBorder emptyBorder = new EmptyBorder(0, 2, 0, 7);
        this.stdBorder = new CompoundBorder(new BevelBorder(0), emptyBorder);
        this.pressedBorder = new CompoundBorder(new BevelBorder(1), emptyBorder);
        this.setBorder(this.stdBorder);
        this.setOpaque(true);
        this.setMargin(new Insets(0, 2, 0, 7));
        this.setHorizontalTextPosition(2);
        this.setHorizontalAlignment(2);
        this.setFont(ResourceManager.labelFont);
        this.upIcon = ConsoleUtility.loadImageIcon("lf/images/SortCol_Up.gif", this.getClass());
        this.dnIcon = ConsoleUtility.loadImageIcon("lf/images/SortCol_Dn.gif", this.getClass());
    }

    public void clearPressed() {
        this.notifyOfSort();
        this.pressed = -1;
    }

    public boolean getAscending() {
        return this.ascending;
    }

    public Dimension getPreferredSize() {
        return new Dimension(super.getMinimumSize().width, this.getFont().getSize() * 2);
    }

    public int getSorted() {
        return this.sorted;
    }

    public Component getTableCellRendererComponent(JTable jTable, Object object, boolean bl, boolean bl2, int n, int n2) {
        if (object == null) {
            this.setText("");
            this.setIcon(null);
            this.setToolTipText(null);
            return this;
        }
        this.setText(object.toString());
        if (this.sorted == n2) {
            if (this.ascending) {
                this.setIcon(this.dnIcon);
            } else {
                this.setIcon(this.upIcon);
            }
        } else {
            this.setIcon(null);
        }
        if (this.pressed == n2) {
            this.model.setArmed(true);
            this.model.setPressed(true);
            this.setBorder(this.pressedBorder);
        } else {
            this.model.setArmed(false);
            this.model.setPressed(false);
            this.setBorder(this.stdBorder);
        }
        TableModel tableModel = jTable.getModel();
        int n3 = -1;
        if (tableModel instanceof VConsoleTableModel) {
            VConsoleTableModel vConsoleTableModel = (VConsoleTableModel)tableModel;
            int n4 = vConsoleTableModel.getColumnWidth(n2);
            n3 = n4 > 20000 ? 1 : (n4 > 10000 ? 0 : -1);
        }
        if (n3 == 0) {
            this.setHorizontalAlignment(0);
        } else if (n3 == 1) {
            this.setHorizontalAlignment(4);
        } else {
            this.setHorizontalAlignment(2);
        }
        return this;
    }

    public JTableHeader getTableHeader() {
        return this.tableHeader;
    }

    protected void notifyListeners(VConsoleEvent vConsoleEvent) {
        if (vConsoleEvent == null) {
            return;
        }
        try {
            JTable jTable = this.tableHeader.getTable();
            TableModel tableModel = jTable.getModel();
            if (tableModel instanceof VConsoleTableModel) {
                VConsoleTableModel vConsoleTableModel = (VConsoleTableModel)tableModel;
                vConsoleTableModel.correlateViewAction(vConsoleEvent);
            }
        }
        catch (Throwable throwable) {}
    }

    protected void notifyOfSort() {
        int n = this.tempSort;
        VConsoleEvent vConsoleEvent = null;
        if (n == -1) {
            vConsoleEvent = new VConsoleEvent(this, "vconsole.sortup", null);
        } else {
            Integer[] integerArray = new Integer[]{new Integer(n)};
            vConsoleEvent = new VConsoleEvent(this, "vconsole.sortup", integerArray);
            if (!this.ascending) {
                vConsoleEvent.setID("vconsole.sortdown");
            }
        }
        this.notifyListeners(vConsoleEvent);
    }

    public void setAscending(boolean bl) {
        this.ascending = bl;
    }

    public void setPressed(int n, boolean bl) {
        this.pressed = n;
        this.tempSort = n;
        if (this.sorted == n) {
            if (bl) {
                this.sorted = -1;
                this.tempSort = -1;
                return;
            }
            this.ascending ^= true;
        } else {
            if (bl) {
                this.pressed = -1;
                this.tempSort = -1;
                return;
            }
            this.ascending = true;
        }
    }

    public void setSorted(int n) {
        this.sorted = n;
    }

    public void setSorted(int n, boolean bl) {
        this.sorted = n;
        this.ascending = bl;
        this.tableHeader.validate();
        this.tableHeader.repaint();
    }

    public void setTableHeader(JTableHeader jTableHeader) {
        if (jTableHeader != null) {
            jTableHeader.addMouseListener(new headerListener());
        }
        this.tableHeader = jTableHeader;
    }

    class headerListener
    extends MouseAdapter {
        headerListener() {
        }

        public void mousePressed(MouseEvent mouseEvent) {
            JTableHeader jTableHeader = VStyledTableHeaderRenderer.this.getTableHeader();
            if (jTableHeader.getResizingColumn() != null) {
                VStyledTableHeaderRenderer.this.isResizing = true;
                return;
            }
            JTable jTable = jTableHeader.getTable();
            int n = jTable.columnAtPoint(mouseEvent.getPoint());
            VStyledTableHeaderRenderer.this.setPressed(n, mouseEvent.isShiftDown());
            jTableHeader.repaint();
        }

        public void mouseReleased(MouseEvent mouseEvent) {
            if (VStyledTableHeaderRenderer.this.isResizing) {
                VStyledTableHeaderRenderer.this.isResizing = false;
                return;
            }
            VStyledTableHeaderRenderer.this.clearPressed();
        }
    }
}

