/*
 * Decompiled with CFR 0.152.
 */
package com.sun.management.viper.console.gui;

import com.sun.management.viper.util.ConsoleUtility;
import java.awt.Color;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Frame;
import java.awt.Graphics;
import java.awt.Image;
import java.awt.Toolkit;
import java.awt.Window;
import java.util.Vector;
import javax.swing.ImageIcon;

public class VSplashScreen
extends Window
implements Runnable {
    protected Image splashImage = null;
    protected String text = null;
    protected Font textFont = null;
    protected Font messageFont = null;
    protected String splashImageFile = "images/splash.gif";
    protected int boxWidth = 5;
    protected int messageIndex = 0;
    protected String messageText = null;
    protected Thread runner = null;
    private boolean isNeeded = false;
    protected static Vector messageQueue = null;

    public VSplashScreen(Frame frame, String string) {
        super(frame);
        this.text = string;
        this.loadDefaultImage();
    }

    public VSplashScreen(Window window, String string) {
        super(window);
        this.text = string;
        this.loadDefaultImage();
    }

    public VSplashScreen(String string) {
        super(new Frame());
        this.text = string;
        this.loadDefaultImage();
    }

    public void dispose() {
        this.isNeeded = false;
        super.dispose();
    }

    public String getText() {
        return this.text;
    }

    public Font getTextFont() {
        return this.textFont;
    }

    protected void loadDefaultImage() {
        ((Component)this).setCursor(Cursor.getPredefinedCursor(3));
        messageQueue = new Vector();
        Class<?> clazz = this.getClass();
        ImageIcon imageIcon = ConsoleUtility.loadImageIcon(this.splashImageFile, clazz);
        this.setImage(imageIcon);
    }

    public static void main(String[] stringArray) {
        VSplashScreen vSplashScreen = new VSplashScreen("Solaris Management Console");
        vSplashScreen.show();
        VSplashScreen.setMessageText("Opening Console...");
    }

    public void paint(Graphics graphics) {
        super.paint(graphics);
        try {
            int n;
            graphics.drawImage(this.splashImage, 2, 2, this);
            if (this.textFont == null) {
                this.textFont = new Font("SansSerif", 0, 25);
            }
            if (this.text != null) {
                graphics.setColor(Color.white);
                n = this.textFont.canDisplayUpTo(this.text);
                if (n < 0 || n > this.text.length()) {
                    graphics.setFont(this.textFont);
                }
                graphics.drawString(this.text, 10, 100 + this.textFont.getSize() / 2);
            }
            if (this.messageFont == null) {
                this.messageFont = this.textFont.deriveFont(0, 14.0f);
            }
            if (this.messageText != null) {
                graphics.setColor(Color.white);
                n = this.messageFont.canDisplayUpTo(this.messageText);
                if (n < 0 || n > this.messageText.length()) {
                    graphics.setFont(this.messageFont);
                }
                graphics.drawString(this.messageText, 16, 140);
            }
        }
        catch (Exception exception) {}
    }

    public void run() {
        while (this.isNeeded) {
            try {
                this.messageText = null;
                try {
                    this.messageText = (String)messageQueue.elementAt(this.messageIndex);
                    ++this.messageIndex;
                }
                catch (Throwable throwable) {}
                if (this.messageText != null) {
                    this.paint(this.getGraphics());
                }
                try {
                    Thread.currentThread();
                    Thread.sleep(500L);
                }
                catch (InterruptedException interruptedException) {}
            }
            catch (Exception exception) {}
        }
    }

    public void setImage(ImageIcon imageIcon) {
        ((Component)this).setSize(new Dimension(imageIcon.getIconWidth() + 4, imageIcon.getIconHeight() + 4));
        Dimension dimension = Toolkit.getDefaultToolkit().getScreenSize();
        ((Component)this).setLocation(dimension.width / 2 - this.getSize().width / 2, dimension.height / 2 - this.getSize().height / 2);
        this.splashImage = imageIcon.getImage();
        ((Component)this).setBackground(Color.black);
    }

    public static void setMessageText(String string) {
        messageQueue.addElement(string);
    }

    public void setText(String string) {
        this.text = string;
    }

    public void setTextFont(Font font) {
        this.textFont = font;
    }

    public void show() {
        this.isNeeded = true;
        this.runner = new Thread(this);
        super.show();
        this.runner.start();
    }
}

