/*
 * Decompiled with CFR 0.152.
 */
package com.sun.management.viper.console.gui;

import com.sun.management.viper.console.gui.VContainer;
import com.sun.management.viper.console.gui.VFrame;
import com.sun.management.viper.util.ConsoleUtility;
import com.sun.management.viper.util.ResourceManager;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.FlowLayout;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.AbstractAction;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.border.EmptyBorder;

public class VAboutBox
extends JPanel {
    protected ImageIcon boxHeader = null;
    protected JLabel hdrLabel = null;
    protected ImageIcon boxLogo = null;
    protected String title = null;
    protected Font titleFont = null;
    protected String description = null;
    protected Font descFont = null;
    protected JTextArea descArea = null;
    protected JButton cancelB = null;
    protected VContainer container = null;

    public VAboutBox() {
        Class<?> clazz = this.getClass();
        this.boxHeader = ConsoleUtility.loadImageIcon("images/about_hdr.gif", clazz);
        this.boxLogo = ConsoleUtility.loadImageIcon("images/about_logo.gif", clazz);
        this.titleFont = new Font("SansSerif", 0, 20);
        this.descFont = ResourceManager.bodyFont;
        this.setLayout(new BorderLayout());
        this.hdrLabel = new JLabel(this.boxHeader);
        this.add((Component)this.hdrLabel, "North");
        this.descArea = new JTextArea();
        this.descArea.setEditable(false);
        this.descArea.setOpaque(false);
        this.descArea.setLineWrap(true);
        this.descArea.setWrapStyleWord(true);
        this.descArea.setFont(this.descFont);
        JPanel jPanel = new JPanel();
        jPanel.setBorder(new EmptyBorder(10, 10, 10, 10));
        jPanel.setLayout(new BorderLayout());
        jPanel.add((Component)new JScrollPane(this.descArea), "Center");
        this.add((Component)jPanel, "Center");
        JPanel jPanel2 = new JPanel();
        jPanel2.setBorder(new EmptyBorder(0, 0, 10, 10));
        jPanel2.setLayout(new FlowLayout(2));
        this.cancelB = new JButton(ResourceManager.getString("CLOSE_BUTTON"));
        this.cancelB.setMargin(new Insets(0, 6, 2, 6));
        this.cancelB.setMnemonic(ResourceManager.getString("CLOSE_BUTTON_mnemonic").charAt(0));
        this.cancelB.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                VAboutBox.this.closeBox();
            }
        });
        jPanel2.add(this.cancelB);
        JPanel jPanel3 = new JPanel(new BorderLayout());
        jPanel3.add((Component)new JLabel(this.boxLogo), "West");
        JPanel jPanel4 = new JPanel(new BorderLayout());
        jPanel4.add((Component)jPanel3, "North");
        jPanel4.add((Component)jPanel2, "South");
        this.add((Component)jPanel4, "South");
    }

    public void closeBox() {
        if (this.container != null) {
            this.container.close();
        }
    }

    public VContainer getContainer() {
        return this.container;
    }

    public String getDescription() {
        return this.description;
    }

    public String getTitle() {
        return this.title;
    }

    public Font getTitleFont() {
        return this.titleFont;
    }

    public static void main(String[] stringArray) {
        VFrame vFrame = new VFrame();
        VAboutBox vAboutBox = new VAboutBox();
        vAboutBox.setTitle("Solaris Management Console 2.0");
        vAboutBox.setDescription("Copyright 2000 Sun Microsystems.");
        vAboutBox.setContainer(vFrame);
        vFrame.setTitle("Solaris Management Console 2.0");
        vFrame.getContentPane().setLayout(new BorderLayout());
        vFrame.getContentPane().add((Component)vAboutBox, "Center");
        vFrame.pack();
        vFrame.show();
    }

    public void paint(Graphics graphics) {
        this.descArea.setFont(ResourceManager.bodyFont);
        this.descArea.setForeground(ResourceManager.bodyColor);
        super.paint(graphics);
        if (this.title != null && this.title.length() > 0) {
            graphics.setColor(Color.white);
            int n = this.titleFont.canDisplayUpTo(this.title);
            if (n < 0 || n > this.title.length()) {
                graphics.setFont(this.titleFont);
            }
            graphics.drawString(this.title, 6, 55);
        }
    }

    public void setContainer(VContainer vContainer) {
        AbstractAction abstractAction = new AbstractAction(){

            public void actionPerformed(ActionEvent actionEvent) {
                VAboutBox.this.closeBox();
            }
        };
        vContainer.setDefaultAction(abstractAction);
        vContainer.setCancelAction(abstractAction);
        this.container = vContainer;
    }

    public void setDescription(String string) {
        this.description = string;
        this.descArea.setText(string);
    }

    public void setHeaderImage(ImageIcon imageIcon) {
        if (imageIcon != null) {
            this.boxHeader = imageIcon;
            this.hdrLabel.setIcon(this.boxHeader);
        }
    }

    public void setTitle(String string) {
        this.title = string;
    }

    public void setTitleFont(Font font) {
        if (font != null) {
            this.titleFont = font;
        }
    }
}

