/*
 * Decompiled with CFR 0.152.
 */
package com.sun.management.viper.console;

import com.sun.management.viper.console.VConsoleEvent;
import com.sun.management.viper.console.VConsoleProperties;
import com.sun.management.viper.console.VConsoleTableModel;
import com.sun.management.viper.console.VScopeNode;
import com.sun.management.viper.util.Debug;
import com.sun.management.viper.util.ResourceManager;
import java.text.Collator;
import java.util.Comparator;
import java.util.Date;
import java.util.Hashtable;
import javax.swing.event.TableModelEvent;

public class VConsoleModel
extends VConsoleTableModel {
    protected VScopeNode sortedNode = null;
    protected boolean sortEnabled = true;
    protected boolean canUseSuper = true;
    protected boolean ascending = true;
    protected int[] sortColumns = null;
    protected int[] map = null;
    protected Hashtable sortStore = new Hashtable();
    protected Hashtable dirStore = new Hashtable();
    protected Collator collator = null;

    public VConsoleModel(VScopeNode vScopeNode) {
        super(vScopeNode);
    }

    public void clearSort() {
        try {
            if (this.sortStore.containsKey(this.selectedNode)) {
                this.sortStore.remove(this.selectedNode);
                this.dirStore.remove(this.selectedNode);
            }
            this.initializeMap(this.map.length);
            this.canUseSuper = true;
            this.properties.setProperty("vconsole.sortedcolumn", "null");
        }
        catch (Throwable throwable) {}
    }

    protected int compare(int n, int n2) {
        int n3 = 0;
        while (n3 < this.sortColumns.length) {
            int n4 = this.compareIndexesByColumn(n, n2, this.sortColumns[n3]);
            if (n4 != 0) {
                return this.ascending ? n4 : -n4;
            }
            ++n3;
        }
        return 0;
    }

    public int compareIndexesByColumn(int n, int n2, int n3) {
        try {
            int n4;
            int n5;
            Object object = null;
            Object object2 = null;
            if (this.listMode || this.detailsMode) {
                object = super.getValueAt(n, n3);
                object2 = super.getValueAt(n2, n3);
            } else {
                int n6 = super.getColumnCount();
                n5 = n / n6;
                n4 = n % n6;
                object = super.getValueAt(n5, n4);
                n5 = n2 / n6;
                n4 = n2 % n6;
                object2 = super.getValueAt(n5, n4);
            }
            if (object == null && object2 == null) {
                return 0;
            }
            if (object == null) {
                return -1;
            }
            if (object2 == null) {
                return 1;
            }
            if (object instanceof Comparator) {
                Comparator comparator = (Comparator)object;
                Comparator comparator2 = (Comparator)object2;
                n4 = comparator.compare(object, object2);
                if (n4 < 0) {
                    return -1;
                }
                if (n4 > 0) {
                    return 1;
                }
                return 0;
            }
            if (object instanceof Number) {
                Number number;
                double d;
                Number number2 = (Number)object;
                double d2 = number2.doubleValue();
                if (d2 < (d = (number = (Number)object2).doubleValue())) {
                    return -1;
                }
                if (d2 > d) {
                    return 1;
                }
                return 0;
            }
            if (object instanceof Date) {
                Date date;
                long l;
                Date date2 = (Date)object;
                long l2 = date2.getTime();
                if (l2 < (l = (date = (Date)object2).getTime())) {
                    return -1;
                }
                if (l2 > l) {
                    return 1;
                }
                return 0;
            }
            if (object instanceof Boolean) {
                Boolean bl;
                int n7;
                Boolean bl2 = (Boolean)object;
                n5 = bl2.booleanValue() ? 1 : 0;
                if (n5 == (n7 = (bl = (Boolean)object2).booleanValue())) {
                    return 0;
                }
                if (n5 != 0) {
                    return 1;
                }
                return -1;
            }
            String string = object.toString();
            if (object instanceof String) {
                string = (String)object;
            }
            String string2 = object2.toString();
            if (object2 instanceof String) {
                string2 = (String)object2;
            }
            n4 = 0;
            n4 = this.collator != null ? this.collator.compare(string, string2) : string.compareTo(string2);
            if (n4 < 0) {
                return -1;
            }
            if (n4 > 0) {
                return 1;
            }
            return 0;
        }
        catch (Throwable throwable) {
            return 0;
        }
    }

    public void consoleAction(VConsoleEvent vConsoleEvent) {
        if (vConsoleEvent == null) {
            return;
        }
        String string = vConsoleEvent.getID();
        if (string == null) {
            return;
        }
        try {
            if (string.equals("vconsole.sortup") || string.equals("vconsole.sortdown")) {
                if (!this.sortEnabled) {
                    return;
                }
                this.ascending = string.equals("vconsole.sortup");
                Object object = vConsoleEvent.getPayload();
                Integer[] integerArray = null;
                if (object instanceof Integer[]) {
                    integerArray = (Integer[])object;
                }
                this.syncSortColumns(integerArray);
                if (integerArray == null) {
                    this.clearSort();
                } else {
                    this.sortTable();
                }
                this.suppressTableRebuild = true;
                super.notifyTableListeners(new TableModelEvent(this, -1));
                return;
            }
            if (string.equals("vconsole.filter") || string.equals("vconsole.updatescope")) {
                this.sortedNode = null;
            }
        }
        catch (Throwable throwable) {}
        super.consoleAction(vConsoleEvent);
    }

    public int getIndexForSortedIndex(int n) {
        try {
            int n2 = 0;
            while (n2 < this.map.length) {
                if (this.map[n2] == n) {
                    return n2;
                }
                ++n2;
            }
            return -1;
        }
        catch (Throwable throwable) {
            Debug.trace("Console Model", Debug.WARNING, "Problem retrieving original index", throwable);
            return -1;
        }
    }

    public boolean getSortEnabled() {
        return this.sortEnabled;
    }

    public int getSortedColumnIndex() {
        if (!this.sortEnabled) {
            return -1;
        }
        return this.sortColumns[this.sortColumns.length - 1];
    }

    public int[] getSortedColumns() {
        if (!this.sortEnabled) {
            return null;
        }
        return this.sortColumns;
    }

    public int getSortedIndexForIndex(int n) {
        try {
            return this.map[n];
        }
        catch (Throwable throwable) {
            Debug.trace("Console Model", Debug.WARNING, "Problem retrieving sorted index", throwable);
            return -1;
        }
    }

    public Object getValueAt(int n, int n2) {
        if (!this.sortEnabled || this.canUseSuper) {
            return super.getValueAt(n, n2);
        }
        try {
            int n3 = n;
            int n4 = super.getColumnCount();
            if (!this.detailsMode && !this.listMode) {
                n3 = n * n4 + n2;
            }
            if (n3 >= this.map.length) {
                return null;
            }
            n3 = this.map[n3];
            if (this.listMode || this.detailsMode) {
                return super.getValueAt(n3, n2);
            }
            n = n3 / n4;
            n2 = n3 % n4;
            return super.getValueAt(n, n2);
        }
        catch (Throwable throwable) {
            Debug.trace("Console Model", Debug.WARNING, "Problem retrieving model value", throwable);
            return null;
        }
    }

    protected void handleTableChange() {
        this.manageSort(this.getTrueChildCount(this.selectedNode));
        this.sortedNode = this.selectedNode;
    }

    protected void initializeMap(int n) {
        this.map = new int[n];
        int n2 = 0;
        while (n2 < n) {
            this.map[n2] = n2;
            ++n2;
        }
        this.canUseSuper = true;
    }

    public boolean isAscending() {
        return this.ascending;
    }

    protected void manageSort(int n) {
        if (n < 0) {
            n = 0;
        }
        this.initializeMap(n);
        if (this.needToSort()) {
            this.sortTable();
        }
    }

    protected boolean needToSort() {
        try {
            if (!this.sortStore.containsKey(this.selectedNode)) {
                return false;
            }
            Integer[] integerArray = (Integer[])this.sortStore.get(this.selectedNode);
            this.syncSortColumns(integerArray);
            Boolean bl = (Boolean)this.dirStore.get(this.selectedNode);
            this.ascending = bl;
            return true;
        }
        catch (Throwable throwable) {
            return false;
        }
    }

    protected void notifyTableListeners(TableModelEvent tableModelEvent) {
        this.handleTableChange();
        super.notifyTableListeners(tableModelEvent);
    }

    protected void printMap() {
        try {
            int n = 0;
            while (n < this.map.length) {
                System.err.println(this.map[n]);
                ++n;
            }
        }
        catch (Throwable throwable) {}
    }

    public void setProperties(VConsoleProperties vConsoleProperties) {
        try {
            this.collator = Collator.getInstance(ResourceManager.currentLocale);
        }
        catch (Throwable throwable) {
            this.collator = Collator.getInstance();
        }
        super.setProperties(vConsoleProperties);
    }

    public void setSortEnabled(boolean bl) {
        this.sortEnabled = bl;
    }

    protected void shuttlesort(int[] nArray, int[] nArray2, int n, int n2) {
        try {
            if (n2 - n < 2) {
                return;
            }
            int n3 = (n + n2) / 2;
            this.shuttlesort(nArray2, nArray, n, n3);
            this.shuttlesort(nArray2, nArray, n3, n2);
            int n4 = n;
            int n5 = n3;
            if (n2 - n >= 4 && this.compare(nArray[n3 - 1], nArray[n3]) <= 0) {
                int n6 = n;
                while (n6 < n2) {
                    nArray2[n6] = nArray[n6];
                    ++n6;
                }
                return;
            }
            int n7 = n;
            while (n7 < n2) {
                nArray2[n7] = n5 >= n2 || n4 < n3 && this.compare(nArray[n4], nArray[n5]) <= 0 ? nArray[n4++] : nArray[n5++];
                ++n7;
            }
        }
        catch (Exception exception) {
            Debug.trace("Console Model", Debug.WARNING, "Problem in shuttlesort", exception);
        }
    }

    public void sort(int n, boolean bl) {
        try {
            this.sortColumns = new int[1];
            this.sortColumns[0] = n;
            this.ascending = bl;
            this.sortTable();
        }
        catch (Throwable throwable) {}
    }

    public void sort(int[] nArray, boolean bl) {
        try {
            this.sortColumns = (int[])nArray.clone();
            this.ascending = bl;
            this.sortTable();
        }
        catch (Throwable throwable) {}
    }

    protected void sortTable() {
        this.shuttlesort((int[])this.map.clone(), this.map, 0, this.map.length);
        this.canUseSuper = false;
        Integer[] integerArray = new Integer[this.sortColumns.length];
        int n = 0;
        while (n < integerArray.length) {
            integerArray[n] = new Integer(this.sortColumns[n]);
            ++n;
        }
        this.sortStore.put(this.selectedNode, integerArray);
        this.dirStore.put(this.selectedNode, new Boolean(this.ascending));
        if (this.properties != null) {
            int n2 = this.sortColumns[this.sortColumns.length - 1];
            String string = null;
            string = this.ascending ? "+" + n2 : "-" + n2;
            this.properties.setProperty("vconsole.sortedcolumn", string);
        }
    }

    protected void syncSortColumns(Integer[] integerArray) {
        if (integerArray == null) {
            return;
        }
        try {
            this.sortColumns = new int[integerArray.length];
            int n = 0;
            while (n < integerArray.length) {
                this.sortColumns[n] = integerArray[n];
                ++n;
            }
        }
        catch (Throwable throwable) {}
    }
}

