/*
 * Decompiled with CFR 0.152.
 */
package com.sun.management.viper;

import java.text.MessageFormat;
import java.util.Date;
import java.util.Locale;
import java.util.NoSuchElementException;
import java.util.ResourceBundle;
import java.util.StringTokenizer;
import java.util.Vector;

public class VException
extends Exception {
    public static final String DEFAULT_BUNDLE = "com.sun.management.viper.resources.ExceptionResources";
    protected String bundleName = null;
    protected ClassLoader resourceClassLoader = null;
    protected Vector subargs = null;
    protected Exception subexcept = null;

    public VException(String string) {
        super(string);
    }

    public VException(String string, Exception exception) {
        super(string);
        this.subexcept = exception;
    }

    public VException(String string, String[] stringArray) {
        super(string);
        if (stringArray != null) {
            int n = 0;
            while (n < stringArray.length) {
                this.addArg(stringArray[n]);
                ++n;
            }
        }
    }

    public VException(String string, String[] stringArray, Exception exception) {
        super(string);
        if (stringArray != null) {
            int n = 0;
            while (n < stringArray.length) {
                this.addArg(stringArray[n]);
                ++n;
            }
        }
        this.subexcept = exception;
    }

    public void addArg(Integer n) {
        this.addNextArg(n);
    }

    public void addArg(Long l) {
        this.addNextArg(l);
    }

    public void addArg(Object object) {
        this.addNextArg(object);
    }

    public void addArg(String string) {
        this.addNextArg(string);
    }

    public void addArg(Date date) {
        this.addNextArg(date);
    }

    protected void addNextArg(Object object) {
        if (this.subargs == null) {
            this.subargs = new Vector();
        }
        if (this.subargs.size() < 10) {
            this.subargs.addElement(object);
        }
    }

    public String formatForLogging() {
        String string = "";
        string = this.getBundleName();
        string = String.valueOf(string) + "&!$";
        string = String.valueOf(string) + super.getMessage();
        if (this.subargs != null) {
            int n = 0;
            while (n < this.subargs.size()) {
                string = String.valueOf(string) + "&!$";
                Object e = this.subargs.elementAt(n);
                string = String.valueOf(string) + e.toString();
                ++n;
            }
        }
        return string;
    }

    protected String getBundleName() {
        if (this.bundleName == null) {
            return DEFAULT_BUNDLE;
        }
        return this.bundleName;
    }

    public Exception getEmbeddedException() {
        return this.subexcept;
    }

    public String getLocalizedMessage() {
        Locale locale = Locale.getDefault();
        return this.getLocalizedMessage(locale);
    }

    public String getLocalizedMessage(Locale locale) {
        String string = super.getMessage();
        int n = 0;
        if (this.subargs != null) {
            n = this.subargs.size();
        }
        Object[] objectArray = new Object[n];
        int n2 = 0;
        while (n2 < n) {
            objectArray[n2] = this.subargs.elementAt(n2);
            ++n2;
        }
        try {
            string = MessageFormat.format(this.getPattern(string, locale), objectArray);
        }
        catch (Exception exception) {}
        return string;
    }

    public String getMessage() {
        Locale locale = new Locale("", "");
        return this.getLocalizedMessage(locale);
    }

    protected String getPattern(String string, Locale locale) {
        ResourceBundle resourceBundle = null;
        String string2 = null;
        if (locale == null) {
            locale = Locale.getDefault();
        }
        String string3 = this.getBundleName();
        try {
            resourceBundle = this.getResourceClassLoader() == null ? ResourceBundle.getBundle(string3, locale) : ResourceBundle.getBundle(string3, locale, this.getResourceClassLoader());
            string2 = resourceBundle.getString(string);
        }
        catch (Exception exception) {
            string2 = string;
        }
        return string2;
    }

    protected ClassLoader getResourceClassLoader() {
        return this.resourceClassLoader;
    }

    public boolean isEmbeddedException() {
        return this.subexcept != null;
    }

    public static VException parseLogStr(String string) {
        StringTokenizer stringTokenizer = null;
        if (string != null) {
            stringTokenizer = new StringTokenizer(string, "&!$", false);
        }
        if (stringTokenizer != null) {
            String string2;
            String string3;
            try {
                string3 = stringTokenizer.nextToken();
                string2 = stringTokenizer.nextToken();
            }
            catch (NoSuchElementException noSuchElementException) {
                return null;
            }
            VException vException = new VException(string2);
            vException.setBundleName(string3);
            while (stringTokenizer.hasMoreTokens()) {
                try {
                    vException.addArg(stringTokenizer.nextToken());
                }
                catch (NoSuchElementException noSuchElementException) {
                    return vException;
                }
            }
            return vException;
        }
        return null;
    }

    public void printStackTrace() {
        super.printStackTrace();
        if (this.subexcept != null) {
            this.subexcept.printStackTrace();
        }
    }

    public void setBundleName(String string) {
        this.bundleName = string;
    }

    public void setResourceClassLoader(ClassLoader classLoader) {
        this.resourceClassLoader = classLoader;
    }

    public String toString() {
        String string = this.getClass().getName();
        String string2 = this.getLocalizedMessage();
        if (string2 != null) {
            string = string.concat(": ");
            string = string.concat(string2);
        }
        return string;
    }
}

