/*
 * Decompiled with CFR 0.152.
 */
package com.sun.wbem.solarisprovider.common;

import com.sun.wbem.cim.CIMDateTime;
import com.sun.wbem.cim.CIMProperty;
import com.sun.wbem.query.AttributeExp;
import com.sun.wbem.query.BinaryRelQueryExp;
import com.sun.wbem.query.DateTimeExp;
import com.sun.wbem.query.NumericValue;
import com.sun.wbem.query.StringValueExp;
import com.sun.wbem.query.ValueExp;
import com.sun.wbem.solarisprovider.common.ProviderException;
import com.sun.wbem.solarisprovider.common.ProviderFilter;
import com.sun.wbem.solarisprovider.common.ProviderFilterException;
import com.sun.wbem.utility.directorytable.DirectoryFilter;
import com.sun.wbem.utility.directorytable.DirectoryTable;
import com.sun.wbem.utility.directorytable.TableDefinitions;
import java.util.List;

public abstract class ProviderDirectoryFilter {
    private static final int MAX_ELEMENTS = 2;
    private ProviderFilter filter;
    private TableDefinitions tdef;
    private String tableName;
    private String sortName;
    private int sortCol;
    private boolean sortAsc;
    private int numElements;

    public ProviderDirectoryFilter(ProviderFilter providerFilter, String string) throws ProviderException {
        this.filter = providerFilter;
        this.tableName = string;
        this.sortName = null;
        this.sortCol = -1;
        this.sortAsc = false;
        this.numElements = 0;
        this.verifyFilter(providerFilter);
    }

    public DirectoryFilter getDirectoryFilter(DirectoryTable directoryTable) throws ProviderException {
        TableDefinitions tableDefinitions = null;
        try {
            tableDefinitions = directoryTable.getCurrentTableDefinitions();
            tableDefinitions.loadTableDefinitions(this.tableName);
        }
        catch (Exception exception) {
            throw new ProviderFilterException("EXCOM_DFTNF", this.tableName);
        }
        DirectoryFilter directoryFilter = new DirectoryFilter(this.numElements);
        int n = -1;
        int n2 = 1;
        int n3 = -1;
        int n4 = -1;
        String string = null;
        AttributeExp attributeExp = null;
        ValueExp valueExp = null;
        BinaryRelQueryExp binaryRelQueryExp = null;
        List list = this.filter.getCanonicalWhere();
        if (list != null && list.size() > 0) {
            int n5 = 0;
            while (n5 < list.size()) {
                List list2 = (List)list.get(n5);
                int n6 = 0;
                while (n6 < list2.size()) {
                    try {
                        binaryRelQueryExp = (BinaryRelQueryExp)list2.get(n6);
                        attributeExp = (AttributeExp)binaryRelQueryExp.getLeftValue();
                        n = binaryRelQueryExp.getOperator();
                        valueExp = binaryRelQueryExp.getRightValue();
                        String string2 = this.mapPropertyToColumnName(attributeExp.getAttributeName());
                        if (string2 == null) {
                            throw new NullPointerException();
                        }
                        n4 = tableDefinitions.getColumnNumber(string2);
                    }
                    catch (Exception exception) {
                        throw new ProviderFilterException("EXCOM_DFBRE");
                    }
                    n3 = this.mapOperator(n);
                    string = this.mapExpValue(valueExp);
                    if (n == 6) {
                        n3 = this.mapLikeOperator(string);
                    }
                    if (n == 6 || n == 7) {
                        string = this.mapLikeValue(string);
                    }
                    try {
                        directoryFilter.add(n4, n2, n3, string);
                    }
                    catch (Exception exception) {
                        throw new ProviderFilterException("EXCOM_DFCAE");
                    }
                    n2 = 2;
                    ++n6;
                }
                n2 = 3;
                ++n5;
            }
        }
        return directoryFilter;
    }

    public ProviderFilter getProviderFilter() {
        return this.filter;
    }

    public String getSortColumnName() {
        return this.sortName;
    }

    public String getTableName() {
        return this.tableName;
    }

    public boolean isSortAscending() {
        return this.sortAsc;
    }

    private String mapExpValue(ValueExp valueExp) {
        String string = null;
        if (valueExp instanceof StringValueExp) {
            string = ((StringValueExp)valueExp).getValue();
        } else if (valueExp instanceof NumericValue) {
            string = ((NumericValue)valueExp).toString();
        } else if (valueExp instanceof DateTimeExp) {
            CIMDateTime cIMDateTime = ((DateTimeExp)valueExp).getValue();
            string = cIMDateTime.toString();
        }
        return string;
    }

    private int mapLikeOperator(String string) {
        int n = -1;
        if (string != null & string.length() > 0) {
            int n2 = string.length();
            n = string.charAt(0) == '%' ? (n2 > 1 && string.charAt(n2 - 1) == '%' ? 1 : 4) : (n2 > 1 && string.charAt(n2 - 1) == '%' ? 3 : 5);
        }
        return n;
    }

    private String mapLikeValue(String string) {
        String string2 = string;
        int n = string2.length();
        if (string2.length() > 0) {
            if (string2.charAt(0) == '%') {
                string2 = string2.substring(1);
                --n;
            }
            if (n > 0 && string2.charAt(n - 1) == '%') {
                string2 = string2.substring(0, n - 1);
            }
        }
        return string2;
    }

    private int mapOperator(int n) {
        int n2;
        switch (n) {
            case 0: {
                n2 = 8;
                break;
            }
            case 1: {
                n2 = 7;
                break;
            }
            case 2: {
                n2 = -1;
                break;
            }
            case 3: {
                n2 = -1;
                break;
            }
            case 4: {
                n2 = 5;
                break;
            }
            case 5: {
                n2 = 6;
                break;
            }
            case 6: {
                n2 = 1;
                break;
            }
            case 7: {
                n2 = 2;
                break;
            }
            default: {
                n2 = -1;
            }
        }
        return n2;
    }

    public abstract String mapPropertyToColumnName(String var1);

    private void verifyFilter(ProviderFilter providerFilter) throws ProviderException {
        int n = 0;
        int n2 = -1;
        int n3 = -1;
        String string = null;
        AttributeExp attributeExp = null;
        ValueExp valueExp = null;
        BinaryRelQueryExp binaryRelQueryExp = null;
        List list = providerFilter.getCanonicalWhere();
        if (list != null && list.size() > 0) {
            int n4 = 0;
            while (n4 < list.size()) {
                List list2 = (List)list.get(n4);
                int n5 = 0;
                while (n5 < list2.size()) {
                    try {
                        binaryRelQueryExp = (BinaryRelQueryExp)list2.get(n5);
                        attributeExp = (AttributeExp)binaryRelQueryExp.getLeftValue();
                        n2 = binaryRelQueryExp.getOperator();
                        valueExp = binaryRelQueryExp.getRightValue();
                        String string2 = this.mapPropertyToColumnName(attributeExp.getAttributeName());
                        if (string2 == null) {
                            throw new NullPointerException();
                        }
                    }
                    catch (Exception exception) {
                        throw new ProviderFilterException("EXCOM_DFBRE");
                    }
                    n3 = this.mapOperator(n2);
                    if (n3 == -1) {
                        throw new ProviderFilterException("EXCOM_DFBOP");
                    }
                    string = this.mapExpValue(valueExp);
                    if (string == null) {
                        throw new ProviderFilterException("EXCOM_DFBEV");
                    }
                    ++n;
                    ++n5;
                }
                ++n4;
            }
        }
        if (n > 2) {
            throw new ProviderFilterException("EXCOM_DFTME", new Integer(2));
        }
        this.numElements = n;
        String string3 = null;
        CIMProperty cIMProperty = providerFilter.getSortProperty();
        if (cIMProperty != null && (string3 = this.mapPropertyToColumnName(cIMProperty.getName())) == null) {
            throw new ProviderFilterException("EXCOM_DFBSP", cIMProperty.getName());
        }
        this.sortName = string3;
        this.sortAsc = providerFilter.isSortAscending();
    }
}

