/*
 * Decompiled with CFR 0.152.
 */
package com.sun.admin.pm.server;

import com.sun.admin.pm.server.Debug;
import com.sun.admin.pm.server.SysCommand;
import com.sun.admin.pm.server.pmCmdFailedException;
import com.sun.admin.pm.server.pmHostNotPingableException;
import com.sun.admin.pm.server.pmInternalErrorException;
import com.sun.admin.pm.server.pmNSNotConfiguredException;

public class Host {
    public static synchronized String getDomainName() throws Exception {
        Debug.message("SVR: Host.getDomainName()");
        String string = "/usr/bin/domainname";
        SysCommand sysCommand = new SysCommand();
        sysCommand.exec(string);
        if (sysCommand.getExitValue() != 0) {
            String string2 = sysCommand.getError();
            sysCommand = null;
            throw new pmCmdFailedException(string2);
        }
        String string3 = sysCommand.getOutput();
        sysCommand = null;
        if (string3 == null) {
            return new String("");
        }
        return new String(string3);
    }

    public static synchronized String getLocalHostName() throws Exception {
        Debug.message("SVR: Host.getLocalHostName()");
        String string = "/usr/bin/hostname";
        SysCommand sysCommand = new SysCommand();
        sysCommand.exec(string);
        if (sysCommand.getExitValue() != 0) {
            String string2 = sysCommand.getError();
            sysCommand = null;
            throw new pmCmdFailedException(string2);
        }
        String string3 = sysCommand.getOutput();
        sysCommand = null;
        if (string3 == null) {
            return new String("");
        }
        return new String(string3);
    }

    public static synchronized String getNisHost(String string) throws Exception {
        Debug.message("SVR: Host.getNisHost() " + string);
        SysCommand sysCommand = null;
        String string2 = null;
        int n = 0;
        string2 = string.equals("master") ? "/usr/bin/ypwhich -m printers.conf.byname" : "/usr/bin/ypwhich";
        sysCommand = new SysCommand();
        sysCommand.exec(string2);
        n = sysCommand.getExitValue();
        if (n != 0 && string.equals("master")) {
            Debug.message("SVR: printers.conf NIS host not found.");
            Debug.message("SVR: Looking for NIS passwd host.");
            string2 = "/usr/bin/ypwhich -m passwd";
            sysCommand = new SysCommand();
            sysCommand.exec(string2);
            n = sysCommand.getExitValue();
        }
        if (n != 0) {
            Debug.error("SVR: NIS server could not be found");
            String string3 = sysCommand.getError();
            sysCommand = null;
            throw new pmNSNotConfiguredException(string3);
        }
        String string4 = sysCommand.getOutput();
        sysCommand = null;
        if (string4 == null) {
            throw new pmCmdFailedException(sysCommand.getError());
        }
        string4 = string4.trim();
        return new String(string4);
    }

    public static synchronized String getNisMaster() throws Exception {
        return Host.getNisHost("master");
    }

    public static synchronized void isNSConfigured(String string) throws Exception {
        Debug.message("SVR: Host.isNSConfigured() " + string);
        String string2 = null;
        String string3 = null;
        SysCommand sysCommand = null;
        if (string.equals("system")) {
            return;
        }
        if (string.equals("nis")) {
            string2 = "/usr/bin/ypwhich";
            sysCommand = new SysCommand();
            sysCommand.exec(string2);
            int n = sysCommand.getExitValue();
            string3 = sysCommand.getError();
            sysCommand = null;
            if (n != 0) {
                throw new pmNSNotConfiguredException(string3);
            }
            string2 = "/usr/bin/ypcat cred";
            sysCommand = new SysCommand();
            sysCommand.exec(string2);
            n = sysCommand.getExitValue();
            sysCommand = null;
            if (n == 0) {
                Debug.warning("SVR: Discovered NIS+ server in yp compat mode.");
                Debug.warning("SVR: Unable to update this configuration.");
                throw new pmNSNotConfiguredException();
            }
        } else if (string.equals("xfn")) {
            String string4 = null;
            try {
                string4 = Host.getDomainName();
            }
            catch (Exception exception) {
                throw new pmNSNotConfiguredException(exception.getMessage());
            }
            string2 = "/usr/bin/niscat -o fns.ctx_dir." + string4;
            sysCommand = new SysCommand();
            sysCommand.exec(string2);
            if (sysCommand.getExitValue() != 0) {
                string3 = sysCommand.getError();
                sysCommand = null;
                throw new pmNSNotConfiguredException(string3);
            }
            sysCommand = null;
        } else if (string.equals("nisplus")) {
            string2 = "/usr/bin/grep printers: /etc/nsswitch.conf";
            sysCommand = new SysCommand();
            sysCommand.exec(string2);
            if (sysCommand.getExitValue() != 0) {
                sysCommand = null;
                Debug.message("SVR: nisplus is not supported for this system");
                throw new pmNSNotConfiguredException();
            }
            string2 = "/usr/bin/nisls";
            sysCommand = new SysCommand();
            sysCommand.exec(string2);
            if (sysCommand.getExitValue() != 0) {
                string3 = sysCommand.getError();
                sysCommand = null;
                throw new pmNSNotConfiguredException(string3);
            }
            sysCommand = null;
        } else {
            if (string.equals("ldap")) {
                throw new pmNSNotConfiguredException("ldap not supported");
            }
            throw new pmInternalErrorException("Unkown name service " + string);
        }
    }

    public static void main(String[] stringArray) {
        try {
            System.out.println(Host.getLocalHostName());
            System.out.println(Host.getDomainName());
            System.out.println(Host.getNisHost("master"));
        }
        catch (Exception exception) {
            System.out.println(exception);
        }
        System.exit(0);
    }

    public static synchronized void pingHost(String string) throws Exception {
        Debug.message("SVR: Host.pingHost()");
        SysCommand sysCommand = new SysCommand();
        sysCommand.exec("/usr/sbin/ping " + string);
        int n = sysCommand.getExitValue();
        sysCommand = null;
        if (n != 0) {
            String string2 = sysCommand.getError();
            throw new pmHostNotPingableException(string2);
        }
    }
}

