/*
 * tunable variables
 *
 * first, those that are configurable in conf/c.c
 */
#define DNBUF    40		/* size of buffer cache */
#define DNFLOCKS 200            /* number of file locks per system */
#define DTIMEZONE (8*60)	/* Minutes westward from Greenwich */
#define	DDSTFLAG 1		/* Daylight Saving Time applies in this locality */

/*
 * now the rest
 */
#define NCOREL (1024/4)         /* number of pages in largest machine */
#define	NINODE	100		/* number of in core inodes */
#define	NFILE	100		/* number of in core file structures */
#define NMOUNT  8		/* number of mountable file systems */
#define MAXMEM  64              /* max core per process - 64 2K pages */
#define MAXUPRC 15              /* max processes per user */
#define SSIZE   1024            /* initial stack size (bytes) */
#define SINCR   1024            /* increment of stack (bytes) */
#define	NOFILE	20		/* max open files per process */
#define	CANBSIZ	256		/* max size of typewriter line */
#define SMAPSIZ (NPROC/2)	/* size of swap allocation area */
#define	NCALL	25		/* max simultaneous time callouts */
#define NPROC   60              /* max number of processes */
#define NTEXT   40              /* max number of pure texts */
#define NCLIST  100		/* max total clist size */
#define HZ      20              /* Ticks/second of the clock */
#define	MSGBUFS	128		/* Characters saved from error messages */
#define	NCARGS	5120		/* # characters in exec arglist */

/*
 * priorities
 * probably should not be
 * altered too much
 */

#define	PSWP	0
#define	PINOD	10
#define	PRIBIO	20
#define	PZERO	25
#define	NZERO	20
#define	PPIPE	26
#define	PWAIT	30
#define	PSLEP	40
#define	PUSER	50

/*
 * signals
 * dont change
 */

#define	NSIG	17
/*
 * No more than 16 signals (1-16) because they are
 * stored in bits in a word.
 */
#define	SIGHUP	1	/* hangup */
#define	SIGINT	2	/* interrupt (rubout) */
#define	SIGQUIT	3	/* quit (FS) */
#define	SIGINS	4	/* illegal instruction */
#define	SIGTRC	5	/* trace or breakpoint */
#define	SIGIOT	6	/* iot */
#define	SIGEMT	7	/* emt */
#define	SIGFPT	8	/* floating exception */
#define	SIGKIL	9	/* kill, uncatchable termination */
#define	SIGBUS	10	/* bus error */
#define	SIGSEG	11	/* segmentation violation */
#define	SIGSYS	12	/* bad system call */
#define	SIGPIPE	13	/* end of pipe */
#define	SIGCLK	14	/* alarm clock */
#define	SIGTRM	15	/* Catchable termination */
#define  SIGFN   16      /* function key */

/*
 * fundamental constants of the implementation--
 * cannot be changed easily
 */

#define	NBPW	sizeof(int)	/* number of bytes in an integer */
#define	BSIZE	512		/* size of secondary block (bytes) */
/* BSLOP can be 0 unless you have a TIU/Spider */
#define BSLOP   4               /* In case some device needs bigger buffers */
#define	NINDIR	(BSIZE/sizeof(daddr_t))
#define	BMASK	0777		/* BSIZE-1 */
#define	BSHIFT	9		/* LOG2(BSIZE) */
#define	NMASK	0177		/* NINDIR-1 */
#define	NSHIFT	7		/* LOG2(NINDIR) */
#define USIZE   1               /* size of use block is 1 page */
#define UBASE   0xf000          /* abs. addr of user block is top page  */
#define	NULL	0
#define	CMASK	0		/* default mask for file creation */
#define	NODEV	(dev_t)(-1)
#define	ROOTINO	((ino_t)2)	/* i number of all roots */
#define	SUPERB	((daddr_t)1)	/* block number of the super block */
#define	DIRSIZ	14		/* max characters per directory */
#define	NICINOD	100		/* number of superblock inodes */
#define	NICFREE	50		/* number of superblock free blocks */
/* #define INFSIZE 138             /* size of per-proc info for users */
#define CBSIZE  30               /* number of chars in a clist block */
#define CROUND  31              /* clist rounding: sizeof(int *) + CBSIZE - 1*/

/*
 * Some macros for units conversion
 */

/* ****** There are 16 pages in a segment */

#define NPAGEPS 16
#define NSEG 0                  /* max seg / user (see user.h) */

/* pages to disk blocks (4k pages and 1/2k blocks) */
#define ptod(x) ((x)*8)

/* inumber to disk address */
#define itod(x) (daddr_t)((((unsigned)(x)+15)>>3))

/* inumber to disk offset */
#define itoo(x) (int)(((x)+15)&07)

/* pages to bytes (4k pages) */
#define ptob(x) ((x)<<12)

/* bytes to pages (4k pages) */
#define btop(x) ( ((unsigned) (x) + 4095) >> 12)

/* bytes to page number (4k pages) */
#define btopn(x) ( ((unsigned) (x) ) >> 12)

/* long bytes (32 bit) to pages (int)*/
#define atop(x) ((int)( ((long) (x + 4095) ) >> 12 ))

/* address (long (32 bit)) to page (int)*/
#define atopn(x) ((int)( ((long) (x) ) >> 12 ))

/* address (long (32 bit)) to offset (int) get bits 12- 0 */
#define atoo(x) ((int)( (x) & 0x0FFF ))

/* long address to short address (get low 16 bits of long address */
#define atos(x) ((int)( (x) & 0x0000FFFF))

/* long address to short address (get low 16 bits of long address */
#define atoh(x) ((int)( (x) >> 16))

/* page register to long address */
#define ptol(x) ( (long)((int)(x) & 0x0FFF) << 12 )

/* major part of a device */
#define major(x)        (int)(((unsigned)(x)>>8))

/* minor part of a device */
#define minor(x)        (int)((x)&0377)

/* make a device number */
#define	makedev(x,y)	(dev_t)((x)<<8 | (y))

typedef	struct { int r[1]; } *	physadr;
typedef struct { unsigned short off;
		 unsigned short seg; } *  segadr;
typedef	long		daddr_t;
typedef char *		caddr_t;
typedef	unsigned int	ino_t;
typedef	long		time_t;
typedef int             label_t[5];     /* return, sp, si, di, bp */
typedef	int		dev_t;
typedef	long		off_t;

/*
 * Machine-dependent bits and macros
 */
#define	SPL0MASK	0x00
#define USERMODE(ps)	((ps)&PS_USER)
#define BASEPRI(ps)	(((ps)&PS_PRIMASK)!=(SPL0MASK<<8))

/*
 * 8086 simulated "state" definitions.
 */
#define	PS_USER		0x01		/* "user" mode */
#define	PS_PRIMASK	0xFF00		/* current spl priority (PIC mask) */
