/*                                                           */
/*       Copyright 1983 Technical Analysis Corporation       */
/*                                                           */


#include <stdio.h>
#include "comm.h"

extern char data[], cmsg[];

commio(mode)
char mode;
{
   if (master)
      return(masterio(mode));
   else
      return(slaveio(mode));
} /* end-commio */

masterio(mode)
char mode;
{
   display("MASTER operation not implemented");
   abend(97);
   return(mode);
} /* end-masterio */

slaveio(mode)
char mode;
{
   char csum[5], msum[133], nmsg[133], lmsg[133];
   int s, error;
   copy(nmsg, "0000");
   append(nmsg, mode);
   append(nmsg, '0');
   concat(nmsg, data);
   do {
      error = 0;
      recv(cmsg, 132);
      if (strcmp(cmsg, "BYE") == 0)
	 return(QUIT);
      if (length(cmsg) < 6) {
	 bads++;
	 error = 1;
	 continue;
      }
      itohex(csum, cksum(cmsg), 4);
      copy(msum, cmsg);
      msum[4] = NUL;

#ifdef DEBUG  			             /* conditional debug code */
      copy(msum, csum);
#endif                                       /* end-condition */

      if (strcmp(csum, msum) != 0) {
	 if (seq >= 0) {
	    naks++;
	    setmsg(cmsg, NAK, seq, "");
	    send(cmsg);
	 }
	 error = 1;
	 continue;
      }
      mode = cmsg[4];
      s = cmsg[5] & 7;
      if (mode == SYNC) {
	 seq = s;
	 return(mode);
      }
      if (seq < 0)
	 seq = (s - 1) & 7;
      if (s == seq) {
	 tos++;
	 send(lmsg);
	 error = 1;
	 continue;
      }
      if (s != ((seq + 1) & 7)) {
	 setmsg(cmsg, SYNC, s, "");
	 send(cmsg);
	 error = 1;
	 continue;
      }
   } while (error);
   seq = s;
   switch (mode) {

      case DATA:
      case CONTROL:
	 copy(data, &cmsg[6]);
      
      case POLL:
	 if (nmsg[4] == DATA || nmsg[4] == CONTROL) {
	    copy(cmsg, nmsg);
	    cmsg[5] = seq + '0';
	 } else {
	    cmsg[4] = ACK;
	    cmsg[5] = seq + '0';
	    cmsg[6] = NUL;
	 }
	 setcksum(cmsg);
	 copy(lmsg, cmsg);
	 send(cmsg);
	 return(mode);
      
      default:
	 copy(cmsg, "unexpected mode received: ");
	 append(cmsg, mode);
	 log(cmsg);
	 abend(96);
	 return(QUIT);
   } /* end-switch */
} /* end-slaveio */

setmsg(str, mode, seqnum, data)
char str[], mode, seqnum, data[];
{
   copy(str, "0000");
   append(str, mode);
   append(str, seqnum + '0');
   concat(str, data);
   setcksum(str);
} /* end-setmsg */

cksum(str)
char str[];
{
   int i, l, sum = 0;
   l = length(str);
   for (i = 4; i < l; i++)
      sum += str[i];
   return(sum);
} /* end-cksum */

setcksum(str)
char str[];
{
   int i;
   char h[5];
   itohex(h, cksum(str), 4);
   for (i = 0; i < 4; i++)
      str[i] = h[i];
   return;
} /* end-setcksum */

send(msg)
char msg[];
{
   int count;

#ifdef DEBUG  			             /* conditional debug code */
   putchar('\024');
#endif                                       /* end-condition */

   count = length(msg);
   msg[count] = RET;
   write(commout, msg, count+1);

#ifdef DEBUG  			             /* conditional debug code */
   putchar('\025');
#endif                                       /* end-condition */

} /* end-send */

recv(msg, lim)
char *msg;
int lim;
{
   int i;
   char c;

#ifdef DEBUG  			             /* conditional debug code */
   putchar('>');
   putchar(' ');
#endif                                       /* end-condition */

   i = read(commin, msg, lim);
   if (i != -1) {
      c = msg[i-1];
      msg[i-1] = NUL;
   } else {
      c = EOF;
      msg[0] = NUL;
   }
   return(c);
} /* end-recv */
