/*                                                           */
/*       Copyright 1983 Technical Analysis Corporation       */
/*                                                           */


#include <stdio.h>
#include "comm.h"


/* global data items */
int master, seq;
int nrtys = 3, timeout = 100;
int tos = 0, cksums = 0, seqs = 0, naks = 0, bads = 0;
int wc = -1, rc = -1, cc = -1, lc = -1;
FILE *wp, *rp, *cp, *lp, *fopen();
int commin, commout;
int lbye = 0, col = 0, buflen = 0;
char c, mode, data[133], cmsg[133], cmnd[133], rcmnd[133];
char buf[512],arg1[133], arg2[133], cmode;
char cs[128];
char sp1[] = {'\n', '\f', '\r', '\n', '\t', '^', '\0'};
char sp2[] = { 'L',  'F',  'L',  'N',  'T', '^', '\0'};


main()
{
   setup();
   initcomm();
   comm();
   logstats();
   waitbye();
   resetcomm();
   display("Communications complete - system restored");
} /* end-main */

setup()
{
   char ans[6], filname[14];
   printf("(M)aster or (S)lave: ");
   getline(stdin, ans, 6);
   if (ans[0] == 'S' || ans[0] == 's') {
      master = 0; seq = -1;
   } else {
      master = 1; seq = 0; nrtys = 100;
      printf("MASTER mode not implemented, using SLAVE mode\n");
      master = 0; seq = -1; nrtys = 3;
   }
   printf("Log file name: ");
   getline(stdin, filname, 14);
   if (length(filname))
      if ((lp = fopen(filname, "w")) != NULL)
	 lc = 0;
      else
	 printf("***   Can't open log file   ***\n");
   printf("Command file name: ");
   getline(stdin, filname, 14);
   if (length(filname))
      if ((cp = fopen(filname, "r")) != NULL)
	cc = 1; 
      else
	 printf("***   Can't open command file   ***\n");

} /* end-setup */

logstats()
{
   char stats[133];
   sprintf(stats,"timeouts = %d, cksums = %d, ", tos, cksums);
   sprintf(&stats[length(stats)], "seqs = %d, naks = %d, ", seqs, naks);
   sprintf(&stats[length(stats)], "bads = %d", bads);
   if (lc >= 0)
      log(stats);
   else
      display(stats);
} /* end-logstats */

waitbye()
{
   char ans[4];
   do {
      display("transfer complete, enter BYE to terminate");
      getline(stdin, ans, 4);
   } while (strcmp(ans, "BYE") != 0 && strcmp(ans, "bye") != 0);
} /* end-waitbye */

initcomm()
{
   commin = fileno(stdin);
   commout = fileno(stdout);

/* insert some sort of comm-port initialization here */

} /* end-initcomm */

resetcomm()
{

/* insert some sort of comm-port reset here */

} /* end-resetcomm */

display(txt)
char *txt;
{

   while (*txt != NUL)
      putchar(*txt++);
   putchar(EOL);

} /* end-display */

log(msg)
char *msg;
{
   char c;
   if (lc != -1) {
      while (c = *msg++)
	 putc(c, lp);
      putc(EOL, lp);
   }

} /* end-log */

getline(fp, line, lim)
FILE *fp;
char *line;
int lim;
{
   int c, i;
   i = 0;
   while (--lim > 0 && (c = getc(fp)) != EOF && c != EOL)
      line[i++] = c;
   line[i] = NUL;
   while (c != EOF && c != EOL)
      c = getc(fp);
   return(c);
} /* end-getline */

pos(str, c)
char str[], c;
{
   int i;
   char t;
   i = 0;
   while ((t = str[i++]))
      if (t == c)
	 return(i-1);
   return(-1);
} /* end-pos */

copy(dest, src)
char *dest, *src;
{
   while (*dest++ = *src++)
      ;
} /* end-copy */

concat(dest, src)
char dest[], src[];
{
   int p1, p2;
   p1 = p2 = 0;
   while (dest[p1] != NUL)
      p1++;
   while (dest[p1++] = src[p2++])
      ;
} /* end-concat */

append(str, c)
char str[], c;
{
   int slen;
   slen = length(str);
   str[slen] = c;
   str[slen + 1] = NUL;
} /* end-append */

length(str)
char *str;
{
   char *tmp = str;
   while (*tmp)
      tmp++;
   return(tmp - str);
} /* end-length */

hex(x)
int x;
{
   return( ((x&15) <= 9) ? ((x & 15) + '0') : (((x & 15) - 10) + 'A') );
} /* end-hex */

itohex(outstr, inpval, prec)
char outstr[];
int inpval, prec;
{
   int i;
   outstr[prec] = NUL;
   for (i = prec - 1; i >= 0; inpval >>= 4, i--)
      outstr[i] = hex(inpval);
} /* end-itohex */

hextoi(inpstr)
char *inpstr;
{
   int outval;
   for (outval = 0; *inpstr != '\0'; inpstr++)
      outval = outval * 16 + (*inpstr - (*inpstr <= '9' ? '0' : 'A' - 10));
   return(outval);
} /* end-hextoi */

abend(exitcode)
int exitcode;
{
   resetcomm();
   printf("\n\nAbnormal termination: %d\n\n", exitcode);
   exit(exitcode);
   return;
} /* end-abend */

escape()
{
   resetcomm();
   printf("\n\nProcess interrupted\n\n");
   exit(0);
   return;
} /* end-escape */

comm()
{
   char temp[133];
   cs[0] = NUL;
   for (c = ' '; c <= '~'; c++)
      if (c != '^')
	 append(cs, c);
   rcmnd[0] = NUL;
   mode = POLL;
   while (mode != QUIT) {
      mode = commio(mode);
      switch (mode) {

	 case QUIT:
	    continue;

	 case QUESTION_MARK:
	    mode = QUIT;
	    commio(mode);
	    continue;

	 case SYNC:
	    if (rc >= 0)
	       rclose();
	    if (wc >= 0)
	       wclose();
	    log("R: sync");
	    if (master)
	       mode = POLL;
	    continue;

	 case DATA:
	    if (wc >= 0) {
	       putdata();
	       mode = POLL;
	    } else {
	       mode = CONTROL;
	       copy(data, "ER File not opened");
	    }
	    continue;

	 case POLL:
	 case ACK:
	 case NAK:
	    moredata();
	    continue;

	 case CONTROL:
	    copy(temp, "R: ");
	    concat(temp, data);
	    log(temp);
	    copy(cmnd, data);
	    contproc(cmnd[0]); 
	    continue;

	 default:
	    copy(temp, "Invalid mode: ");
	    append(temp, mode);
	    log(temp);
	    abend(95);
      } /* end-switch */
   } /* end-while */
} /* end-comm */

getargs()
{
   int p;
   arg2[0] = NUL;
   p = 2;
   p = extract(arg1, cmnd, p);
   if (p > 0)
      p = extract(arg2, cmnd, p);
   return;
} /* end-getargs */

extract(outstr, instr, start)
char outstr[], instr[];
int start;
{
   int p; 
   p = start + 1;
   while (instr[p] == ' ')
      p++;
   while (instr[p] != ' ' && instr[p] != ',' && instr[p] != NUL)
      *outstr++ = instr[p++];
   *outstr = NUL;
   return(instr[p] ? p : 0);
} /* end-extract */

moredata()
{
   char temp[133];
   if (rc >= 0)
      if (getdata(data, PSIZE, cmode) != EOF)
	 mode = DATA;
      else {
	 if (rc >= 0)
	    rclose();
	 mode = CONTROL;
	 copy(data, "WE");
      }
   else {
      if (length(rcmnd) == 0) {
	 if (cc >= 0)
	    readcc(cmnd);
	 if (cc < 0) {
	    if (lbye)
	       mode = POLL;
	    else {
	       lbye = 1;
	       mode = CONTROL;
	       copy(data, "BYE");
	    }
	    cmnd[0] = NUL;
	    return;
	 }
      } else {
	 copy(cmnd, rcmnd);
	 rcmnd[0] = NUL;
      }
      copy(temp, "C: ");
      concat(temp, cmnd);
      log(temp);
      if (length(cmnd))
	 cmndproc(cmnd[0]); 
   }
   return;
} /* end-moredata */

contproc(code)
char code;
{
   char temp[133];
   switch (code) {
   
      case LOG:
	 mode = POLL;
	 return;

      case ERROR:
	 if (wc >= 0)
	    wc = -1;
	 mode = POLL;
	 return;
      
      case BYE:
	 if (lbye == 0) {
	    mode = POLL;
	    return;
	 }
	 if (master) {
	    mode = QUIT;
	    return;
	 }
	 lbye = 1;
	 mode = CONTROL;
	 copy(data, "BYE");
	 return;
	 
      case READ:
	 getargs();
	 rcmnd[0] = WRITE;
	 rcmnd[1] = cmnd[1];
	 rcmnd[2] = ' ';
	 rcmnd[3] = NUL;
	 concat(rcmnd, arg2);
	 concat(rcmnd, " ");
	 concat(rcmnd, arg1);
	 lbye = 0;
	 moredata();
	 return;
      
      case WRITE:
	 if (wc >= 0) {
	    putbuf();
	    wclose();
	 }
	 if (cmnd[1] == ERROR) {
	    mode = POLL;
	    return;
	 }
	 getargs();
	 if  ((wp = fopen(arg2, "w")) == NULL) {
	    copy(temp, "E: ");
	    concat(temp, data);
	    log(temp);
	    mode = CONTROL;
	    copy(data, "ER Unable to open file for writing");
	    return;
	 }
	 wc = 2;
	 cmode = (cmnd[1] == TEXT) ? TEXT : BINARY;
	 initbuf();
	 mode = POLL;
	 return;
      
      default:
	 copy(temp, "Invalid control code: ");
	 append(temp, code);
	 log(temp);
	 abend(98);
   } /* end-switch */
} /* end-contproc */

initbuf()
{
   buflen = 0;
   return;
} /* end-initbuf */

cmndproc(command)
char command;
{
   char temp[133];
   switch (command) {

      case COMMENT:
	 mode = POLL;
	 return;

      case WRITE:
	 getargs();
	 if (rc >= 0)
	    rclose();
	 if ((rp = fopen(arg1, "r")) == NULL) {
	    copy(temp, "E: ");
	    concat(temp, data);
	    log(temp);
	    mode = CONTROL;
	    copy(data, "ER Unable to open file for reading");
	    return;
	 }
	 rc = 3;
	 cmode = (cmnd[1] == TEXT) ? TEXT : BINARY;
         initbuf();
	 col = 0;

      case READ:
      case LOG:
	 mode = CONTROL;
	 copy(data, cmnd);
	 return;

      default:
	 copy(temp, "Invalid command: ");
	 append(temp, command);
	 log(temp);
	 abend(99);
   } /* end-switch */
} /* end-cmndproc */

putbuf()
{
   int p;
   for (p = 0; p < buflen; p++)
      putc(buf[p], wp);
   buflen = 0;
   return;
} /* end-putbuf */

readcc(line)
char line[];
{
   char c;
   while ((c = getline(cp, line, 132)) == EOL && length(line) == 0)
      ;
   if ((int) c == EOF) {
      fclose(cp);
      cc = -1;
   }
   return;
} /* end-readcc */

rclose()
{
   fclose(rp);
   rc = -1;
   return;
} /* end-rclose */

wclose()
{
   fclose(wp);
   wc = -1;
   return;
} /* end-wclose */

putdata()
{
   int i;
   char h[3];
   col = 0;
   while ((c = cget()) != NUL) {
      if (buflen >= 512)
	 putbuf();
      if (c != '^') {
	 addbuf(c);
	 continue;
      }
LAB1: if ((c = cget()) == NUL)
	 return;
      if (c != 'H') {
	 if (c == 'A')
	    continue;
	 if ((i = pos(sp2, c)) >= 0)
	    addbuf(sp1[i]);
	 if (i == 0 || i == 1)
	    putbuf();
	 continue;
      }
      while ((c = cget()) != NUL) {
	 if (c == '^')
	    goto LAB1;
	 h[0] = c;
	 h[1] = cget();
	 h[2] = NUL;
	 addbuf(hextoi(h));
	 if (buflen >= 512)
	    putbuf();
      }
   }
   return;
} /* end-putdata */

addbuf(c)
char c;
{
   buf[buflen++] = c;
   return;
} /* end-addbuf */

cget()
{
   return( (col < length(data)) ? data[col++] : NUL);
} /* end-cget */

getdata(buffer, lim, tmode)
char buffer[], tmode;
int lim;
{
   int i;
   char h[3];
   if (tmode == TEXT)
      buffer[0] = NUL;
   else
      copy(buffer, "^H");
   while (length(buffer) <= lim && (int) (c = getch()) != EOF)
      if (tmode != TEXT) {
	 itohex(h, (int) c, 2);
	 concat(buffer, h);
      } else
	 if (pos(cs, c) >= 0)
	    append(buffer, c);
	 else
	    if ((i = pos(sp1, c)) >= 0) {
	       append(buffer, '^');
	       append(buffer, sp2[i]);
	    } else {
	       itohex(h, (int) c, 2);
	       concat(buffer, "^H");
	       concat(buffer, h);
	       concat(buffer, "^A");
	    }
   if ((int) c == EOF)
      if ((tmode == TEXT && length(buffer) > 0) || 
	  (tmode != TEXT && length(buffer) > 2))
	    c = EOL;
   return(c);
} /* end-getdata */

getch()
{
   char c;
   if (cmode == TEXT) {
      while ((c = getc(rp)) == NUL)
	 ;
   } else
      c = getc(rp);
   return(c);
} /* end-getch */

commio(mode)
char mode;
{
   if (master)
      return(masterio(mode));
   else
      return(slaveio(mode));
} /* end-commio */

masterio(mode)
char mode;
{
   display("MASTER operation not implemented");
   abend(97);
   return(mode);
} /* end-masterio */

slaveio(mode)
char mode;
{
   char csum[5], msum[133], nmsg[133], lmsg[133];
   int s, error;
   copy(nmsg, "0000");
   append(nmsg, mode);
   append(nmsg, '0');
   concat(nmsg, data);
   do {
      error = 0;
      recv(cmsg, 132);
      if (strcmp(cmsg, "BYE") == 0)
	 return(QUIT);
      if (length(cmsg) < 6) {
	 bads++;
	 error = 1;
	 continue;
      }
      itohex(csum, cksum(cmsg), 4);
      copy(msum, cmsg);
      msum[4] = NUL;
      if (strcmp(csum, msum) != 0) {
	 if (seq >= 0) {
	    naks++;
	    setmsg(cmsg, NAK, seq, "");
	    send(cmsg);
	 }
	 error = 1;
	 continue;
      }
      mode = cmsg[4];
      s = cmsg[5] & 7;
      if (mode == SYNC) {
	 seq = s;
	 return(mode);
      }
      if (seq < 0)
	 seq = (s - 1) & 7;
      if (s == seq) {
	 tos++;
	 send(lmsg);
	 error = 1;
	 continue;
      }
      if (s != ((seq + 1) & 7)) {
	 setmsg(cmsg, SYNC, s, "");
	 send(cmsg);
	 error = 1;
	 continue;
      }
   } while (error);
   seq = s;
   switch (mode) {

      case DATA:
      case CONTROL:
	 copy(data, &cmsg[6]);
      
      case POLL:
	 if (nmsg[4] == DATA || nmsg[4] == CONTROL) {
	    copy(cmsg, nmsg);
	    cmsg[5] = seq + '0';
	 } else {
	    cmsg[4] = ACK;
	    cmsg[5] = seq + '0';
	    cmsg[6] = NUL;
	 }
	 setcksum(cmsg);
	 copy(lmsg, cmsg);
	 send(cmsg);
	 return(mode);
      
      default:
	 copy(cmsg, "unexpected mode received: ");
	 append(cmsg, mode);
	 log(cmsg);
	 abend(96);
	 return(QUIT);
   } /* end-switch */
} /* end-slaveio */

setmsg(str, mode, seqnum, data)
char str[], mode, seqnum, data[];
{
   copy(str, "0000");
   append(str, mode);
   append(str, seqnum + '0');
   concat(str, data);
   setcksum(str);
} /* end-setmsg */

cksum(str)
char str[];
{
   int i, l, sum = 0;
   l = length(str);
   for (i = 4; i < l; i++)
      sum += str[i];
   return(sum);
} /* end-cksum */

setcksum(str)
char str[];
{
   int i;
   char h[5];
   itohex(h, cksum(str), 4);
   for (i = 0; i < 4; i++)
      str[i] = h[i];
   return;
} /* end-setcksum */

send(msg)
char msg[];
{
   int count;

   count = length(msg);
   msg[count] = RET;
   write(commout, msg, count+1);

} /* end-send */

recv(msg, lim)
char *msg;
int lim;
{
   int i;
   char c;

   i = read(commin, msg, lim);
   if (i != -1) {
      c = msg[i-1];
      msg[i-1] = NUL;
   } else {
      c = EOF;
      msg[0] = NUL;
   }
   return(c);
} /* end-recv */
