/* 
	Dump pcode histogram file
*/

#include "/bb/include/ptype.h"

#define DEBDEF 1

#include "/bb/run/src/dasm.c"

main (argc,argv)
int argc;
char *argv[];
{
	int	i,j,fd;
	long	phtab[1024];
	char	buf[PATHSIZE],*cptr;
	unsigned *uptr,chk;

	if (argc != 2) {
		printf("Usage: %s file.st\n",argv[0]);
		exit(-1);
	}

	if ((fd = open(argv[1],0)) < 0) {
		printf("Can't open %s\n",argv[1]);
		exit(-1);
	}

	if (read(fd,(char *)&phtab,sizeof(phtab)) < 0) {
		printf("Can't read pcode histogram file\n");
		exit(-1);
	}

	swab((char *)&phtab,(char *)&phtab,sizeof(phtab));

	for (i=0; i<1024; ++i) {
		if (phtab[i] != 0L) {
			if (i>0 && i<4)
				cptr = "L/I";
			else {
				if (i>=128 && i<256)
					j = (int)(char)i;
				else
					j = i;
				cptr = dasm(j);
			}
			printf("%5d %-8s %10D\n",j,cptr,phtab[i]);
		}
	}
	exit(0);
}
