/************************************************************************
*
*
*	Name:  pmach.c
*
*	Description:  Main line of p-machine. This part reads in the
*			p-code, sets up the stack and registers, 
*			initializes the UST and captures all signals.
*			Then it executes the p-code.
*
*	History:
*	Date		By	Comments
*
*	03/01/83	mas
*	04/18/83	mas	changed to initialize tracefd to stderr
*	04/21/83	mas	added revision display
*	04/24/83	mas	fixed bug in CMPA - first comparision on
*						curlth was to (SP.S-1) should be (SP.S+1)
*	04/25/83	mas	added  reset of iofl.ioeof to INEND
*	05/05/83	mas	fixed bug in SBDA where subcript of zero
*						caused error when max length is equal to
*						the current length in the string descriptor
*	05/06/83	mas	reset input maximum on end of input statement
*	05/09/83	mas	moved ONGO + ONGS to here and STOP to pmach2.c
*	05/09/83	mas	added call to phinc()
*	05/10/83	mas	added label to timed inputs to find next
*						statement when it times out
*	05/17/83	mas	cancelled all alarms if they are not used
*	05/19/83	mas	removed need for label in input statements
*						by using the ineof flag
*	05/19/83	mas	fixed bug in sub string calculate where an 
*						error occurred when then byte past the end
*						of the string was accessed
*	06/02/83	mas	cleanup - fixed lint complaints and reduced
*						duplicated code
*	06/02/83	mas	fixed bug where compiler is incrementing
*						iof.inustring and not checking for overflow
*						(which is iof.ineof) and thereby causing 
*						every fourth input statement (or INCR) to not
*						do a newline. iof.inustring can never be 
*						greater than 2 (hopefully) so the bug will
*						stay in ina() (see invar.c) and inustring will
*						be cleared every INEND
*	06/08/83	mas	changed INSET and INEND to set iofl.inline to
*						FALSE. This flag is used to limit input using
*						to only one call to inputln()
*	07/12/83	mas	changed timed input to check for time limit
*						under a second and set it up to 1 sec
*	07/28/83	mas	fixed overflow problem in CMPL/CMPJ
*	08/01/83	waf	Fix for revised xltbchan() function, which traps BEIFN
*						(illegal file/chan number) errors.
*						Also use new xlt2bchan() function where possible to trap
*						BEFNO (file not open) errors.
*
*
*
*  This document contains confidential/proprietary information.
*
*  Copyright 1983 by Technical Analysis Corporation.
*
*************************************************************************
* BB/Xenix Runtime Module */




/*  Notes -

** Note **
  This module MUST be compiled using the optimize (-O) switch.
  If it is compiled without the optimization, the large number of cases
  in the switch statement causes an assembler error (because the number
  of labels created for fwd reference, when all put together at the
  end of the switch statement, creates a line too long).

*/


#include "/bb/include/ptype.h"
#include "/bb/include/pextern.h"
#include "/bb/include/pfunc.h"
#include "/bb/include/bberms.h"
#include "/bb/include/opcodes.h"

#include "/bb/include/pcondcomp.h"

extern	long	lseek();
extern	int	errno;

#ifdef DEBDEF
extern unsigned DEB;
#endif

main (argc,argv)
int	argc;
char	*argv[];
{

	register POINTER PC;
	register POINTER SP;

	ARRDES	*arptr;
	int	i,j,tempj,tempj1,tempj2,k[20];
	unsigned utemp,x;
	long	*pl,templ,templ1,templ2;
	char	*cptr,tempbuf[32];

#ifdef PHIST
	write(1,"bbh 1.0\n",8);
#endif

	pinit(argc,argv);	/* initialize p-machine */

	/* init registers and set starting PC */
	if (pcheader.stksiz == 0 || contsw == FALSE) {
		SP.B = begstk; 		/* SP to start of evaluation stack */
		SP.B = framinit(SP);	/* sets FP, GFP, BFP and global frame */
		PC.B = begmem;		/* PC to start of p-code */
	} else {
		SP.B = pcheader.sp.B;
		PC.B = pcheader.pc.B;
	}

	/* ERROR during p-code execution returns here */
	if ((i = setjmp(errenv)) != 0) {
		errz(i,PC,SP); /* go get user error routine */
		PC.B = TPC;		/* reset PC */
		SP.B = TSP;		/* reset stack on error */
	}

#ifdef PHIST
	phinit();		/* init pcode table */
#endif

top:	/* Main p-code loop */

#ifdef DEBDEF
if (DEB == TRUE)
	dumpregs(PC,SP);
#endif

#ifdef PHIST
	phinc(*PC.B,0);		/* inc this p-code slot */
#endif

	switch (*PC.B++) {
		case NOP:
		case RDEND:
		case WREND:
			break;
		case 1:	/* P-code leadin code 1 */
			pmach1(PC,SP);	/* do 01 codes */
			PC.B = TPC;
			SP.B = TSP;
			break;
		case 2:	/* P-code leadin code 2 */
			pmach2(PC,SP);	/*  do 02 codes */
			PC.B = TPC;
			SP.B = TSP;
			break;
		case 3:	/* P-code leadin code 3  - STMA's */
			pmach3(PC,SP);	/*  do 03 codes */
			PC.B = TPC;
			SP.B = TSP;
			break;
		case CLRSTK:
			for (i = (int)*PC.J++; i > 0; --i) 
				*SP.J++ = 0;
			break;
		case DFLTBL:
			GFP->LTP = (struct lnrec *)(PC.B + *PC.J);
			PC.J++;
			break;
		case BREAK:
			ust.stxfl.debug = TRUE;
		case STMTX:
			pclast = PC.B - 1;	/* point to STMTX */
			if (ust.stmtx.sxflag != 0) {
				dostmt(PC,SP);
				PC.B = TPC;
				SP.B = TSP;
			}
			break;
		case LD0L:
			*SP.L++ = 0;
			break;
		case LD0J:
			*SP.J++ = 0;
			break;
		case LD1L:
			*SP.L++ = 1;
			break;
		case LD1J:
			*SP.J++ = 1;
			break;
		case LDBJ:
			*SP.J++ = (int)*PC.B++;
			break;
		case LDBL:
			*SP.L++ = (long)*PC.B++;
			break;
		case LDCJ:
			*SP.J++ = *PC.J++;
			break;
		case LDCL:
			*SP.L++ = *PC.L++;
			break;
		case LDDL:
			SP.N->ntype = typeL;
			SP.N++->ndata.l = (long *)(((char *)GFP) + *PC.J++);
			break;
		case LDVL:
			*SP.L++ = *(long *)(((char *)GFP) + *PC.J++);
			break;
		case LDAV:
			*SP.PJ++ = (int *)(((char *)GFP) + *PC.J++);
			break;
		case LDIL:
			*SP.L = *(*--SP.PL);
			SP.L++;
			break;
		case LDIDL:
			--SP.N;
			*SP.L = *SP.N->ndata.l;
			SP.L++;
			break;
		case SBAL:
		case SBDL:
		case SBVL:
			x = *(PC.B - 1);
			arptr = (ARRDES *)(((char *)GFP) + *PC.J++);
			for (i = 0; i < arptr->numdim; ++i)
				k[arptr->numdim-(i+1)] = *--SP.J;
			utemp = subcalc(arptr,k);
			switch (x) {
				case SBAL:
					*SP.PL++ = (long *)
					      ((char *)(arptr->adata.l)+utemp);
					break;
				case SBDL:
					SP.N->ndata.l=(long *)
					      (((char *)arptr->adata.l)+utemp);
					SP.N->ntype = typeL;
					SP.N++;
					break;
				case SBVL:
					*SP.L++ = *(long *)
					      (((char *)arptr->adata.l)+utemp);
					break;
			}
			break;
		case STIL:
			--SP.L;
			*(*(SP.PL-1)) = *SP.L;
			--SP.PL;
			break;
		case STIDL:
			--SP.L;
			*((SP.N-1)->ndata.l) = *SP.L;
			--SP.N;
			break;
		case LDA:
		case LDD:
		case LDV:
		case SBD:
		case SBA:
		case SBV:
			utemp = *(PC.B-1);	/* save pcode */
			i = *PC.B++ & 0x00ff;	/* FP link */
			if (utemp == (unsigned)LDA) /* LDA doesn't have type */
				j = -1;		/* invlaid type */
			else
				j = *PC.B++;	/* var type */
			tempj = *PC.J++; 	/* offset from FP */
			cptr = FP.B;		/* get FP */
			/* resolve FP link */
			for (;i > 0 && cptr > (char *)BFP; --i)
				cptr = *(BPTR *)cptr;
			/* compute address of var */
			cptr += tempj;
			switch (utemp) {
				case LDD:
					if(j == typeA)
						*SP.S++ = *(STRDES *)cptr;
					else
						*SP.N++ = *(NUMDES *)cptr;
					break;
				case LDV:
					if(j == typeA)
						panic();
					if (j == typeJ)
						*SP.J++ = *(int *)cptr;
					else
						*SP.L++ = *(long *)cptr;
					break;
				case LDA:
					*SP.PB++ = cptr;
					break;
				default:
					bberr(BEOPT);
			}
			break;
		case ADDJ:
			--SP.J;
#ifdef OVERFLOW
			i = *SP.J;
			j = *(SP.J-1);
#endif
			*(SP.J-1) += *SP.J;
#ifdef OVERFLOW
			if (i < 0 && j < 0 && *(SP.J-1) > 0)
				bberr(BEARI);
			if (i > 0 && j > 0 && *(SP.J-1) < 0)
				bberr(BEARI);
#endif
			break;
		case ADDL:
			--SP.L;
#ifdef OVERFLOW
			templ1 = *SP.L;
			templ2 = *(SP.L-1);
#endif
			*(SP.L-1) += *SP.L;
#ifdef OVERFLOW
			if (templ1 < 0 && templ2 < 0 && *(SP.L-1) > 0)
				bberr(BEARI);
			if (templ1 > 0 && templ2 > 0 && *(SP.L-1) < 0)
				bberr(BEARI);
#endif
			break;
		case SUBJ:
			--SP.J;
#ifdef OVERFLOW
			i = *SP.J;
			j = *(SP.J-1);
#endif
			*(SP.J-1) -= *SP.J;
#ifdef OVERFLOW
			if (i > 0 && j < 0 && *(SP.J-1) > 0)
				bberr(BEARI);
			if (i < 0 && j > 0 && *(SP.J-1) < 0)
				bberr(BEARI);
#endif
			break;
		case SUBL:
			--SP.L;
#ifdef OVERFLOW
			templ1 = *SP.L;
			templ2 = *(SP.L-1);
#endif
			*(SP.L-1) -= *SP.L;
#ifdef OVERFLOW
			if (templ1 > 0 && templ2 < 0 && *(SP.L-1) > 0)
				bberr(BEARI);
			if (templ1 < 0 && templ2 > 0 && *(SP.L-1) < 0)
				bberr(BEARI);
#endif
			break;
		case MULJ:
			--SP.J;
#ifdef OVERFLOW
			tempj = *(SP.J-1);
#endif
			*(SP.J-1) *= *SP.J;
#ifdef OVERFLOW
			if (*SP.J == 0 || *SP.J == 1)
				break;
			if (*(SP.J-1) / *SP.J != tempj)
				bberr(BEARI);
#endif
			break;
		case MULL:
			--SP.L;
#ifdef OVERFLOW
			templ = *(SP.L-1);
#endif
			*(SP.L-1) *= *SP.L;
#ifdef OVERFLOW
			if (*SP.L == 0 || *SP.L == 1)
				break;
			if (*(SP.L-1) / *SP.L != templ)
				bberr(BEARI);
#endif
			break;
		case DIVJ:
			--SP.J;
			if (*SP.J == 0)
				bberr(BEARI);	/* divide by zero error */
			*(SP.J-1) /= *SP.J;
			break;
		case DIVL:
			--SP.L;
			if (*SP.L == 0L)
				bberr(BEARI);	/* divide by zero error */
			*(SP.L-1) /= *SP.L;
			break;
		case NEGJ:
			*(SP.J-1) = -*(SP.J-1);
			break;
		case NEGL:
			*(SP.L-1) = -*(SP.L-1);
			break;
		case FXJL:
			*SP.L = *--SP.J;
			SP.L++;
			break;
		case FXLJ:
			tempj = *--SP.L & 0xffff;
			if ((*SP.L>0 && *SP.J != 0) || (*SP.L<0 && *SP.J != -1))
				bberr(BEARI);
			*SP.J++ = tempj;
			break;
		case CVLJ:
			templ = *--SP.L;
			*SP.L = *--SP.J;
			SP.L++;
			*SP.L = templ;
			SP.L++;
			break;
		case DPRL:
			templ1 = *--SP.L; /* get value */
			pl = *--SP.PL;    /* get top address */
			*SP.L++ = templ1; /* push value */
			*SP.PL++ = pl;    /* push address */
			*SP.L++ = templ1; /* push value */
			break;
		case FORL:
			++PC.J;	/* skip label of stmt after NEXT */
			i=forl(*--SP.PL,*--SP.L,*--SP.L,*--SP.L,PC.B);
			/*     ctlvar   init    limit   step    loop */
			if (i == FALSE) {
				--PC.J;	      /* point to label */
				PC.B += *PC.J; /* go to line after NEXT */
			}
			break;
		case NXTL:
			PC.B = nextl(PC,*--SP.PL);	/* do next */
			/*		ctlvar */
			break;
		case JMPT:
			if (*--SP.J == TRUE)
				PC.B += *PC.J;	/* do jump */
			else
				++PC.J;		/* skip offset */
			break;
		case JMPF:
			if (*--SP.J == FALSE)
				PC.B += *PC.J;	/* do jump */
			else
				++PC.J;		/* skip offset */
			break;
		case MAKDL:
			cptr = PC.B;		/* get PC */
			cptr += *PC.J++;	/* add in label offset */
			SP.S->curlth = SP.S->maxlth = (int)*cptr++;
			(SP.S++)->data = cptr;
			break;
		case RFORM:
		case DATA:
		case JMP:
			PC.B += *PC.J;
			break;
		case DEFFN:
			++PC.B;
			GFP->FUNC[*(PC.B-1)].B = (char *)(PC.J + 1);
			PC.B += *PC.J;
			break;
		case CALLFN:
			if (GFP->FUNC[*PC.B].B == (char *)0)
				bberr(BEUDF);
		case CALLFS:
			x = *(PC.B-1);
			*SP.PB++ = PC.B +
			     ((x==(unsigned)CALLFS)?sizeof(int):sizeof(char));
			*SP.PB++ = FP.B;
			if (SP.B + 500 >= endmem)
				bberr((x==(unsigned)CALLFS)?BEDTM:BEFUN);
			FP.B = (char *)(SP.PB-2);
			if (x == (unsigned)CALLFS)
				PC.B += *PC.J;
			else
				PC.B = GFP->FUNC[*PC.B].B;
			break;
		case RETFN:
			FP.B = *--SP.PB;	/* restore FP */
			cptr = *--SP.PB;	/* get return address */

		/* 	tempj = *PC.J++;	get no of bytes to free */
		/*	for(i=0; i<tempj; ++i)
				--SP.B;		pop stack */

			SP.B -= *PC.J++;
			PC.B = cptr;		/* return */
			break;
		case FCALL:
		case FRET:
			break;
		case GOSUB:
			PC.B = gosub(PC,0);	/* do gosub */
			break;
		case ONGO:
		case ONGS:
			x = *(PC.B-1);		/* save pcode */
			i = *--SP.J;		/* get number off stack */
			j = (*PC.B++) & 0x00ff;	/* get number of labels */
			if (i > j || i <= 0) {	/* if number > no of labels */
				PC.PB += j; 	/* skip labels */
				break;
			}
			for (--i; i > 0; --i,--j)  /* find correct label*/
				++PC.J;
			if (x == (unsigned)ONGO)
				PC.B += *PC.J;		/* jump to it */
			else
				PC.B = gosub(PC,j);	/* do gosub */
			break;
		case RETSUB:
			pl = ((struct GFRAMEA *)GFP)->GSADES.adata.l;
			if ((char *)(GFP->GSP) == (char *)pl)
				bberr(BERNG);  /* no return address */
			PC.B = *--GFP->GSP;	/* pop return address */
			break;
		case CMPJ:
			SP.J -= 2;
			if (*SP.J == *(SP.J+1))
				*SP.J++ = 0;
			else {
				if (*SP.J > *(SP.J+1))
					*SP.J++ = 1;
				else
					*SP.J++ = -1;
			}
			break;
		case CMPL:
			SP.L -= 2;
			if (*SP.L == *(SP.L+1))
				*SP.J++ = 0;
			else {
				if (*SP.L > *(SP.L+1))
					*SP.J++ = 1;
				else
					*SP.J++ = -1;
			}
			break;
		case LEZJ:
			--SP.J;
			*SP.J = (*SP.J <= 0)?TRUE:FALSE;
			++SP.J;
			break;
		case LTZJ:
			--SP.J;
			*SP.J = (*SP.J < 0)?TRUE:FALSE;
			++SP.J;
			break;
		case EQZJ:
			--SP.J;
			*SP.J = (*SP.J == 0)?TRUE:FALSE;
			++SP.J;
			break;
		case NEZJ:
			--SP.J;
			*SP.J = (*SP.J != 0)?TRUE:FALSE;
			++SP.J;
			break;
		case GTZJ:
			--SP.J;
			*SP.J = (*SP.J > 0)?TRUE:FALSE;
			++SP.J;
			break;
		case GEZJ:
			--SP.J;
			*SP.J = (*SP.J >= 0)?TRUE:FALSE;
			++SP.J;
			break;
		case LDDA:
			*SP.S = *(STRPTR)(((char *)GFP) + *PC.J++);
			if (SP.S->data == (char *)0)
				bberr(BEUDS);
			SP.S++;
			break;
		case LDCA:
			SP.S->curlth = SP.S->maxlth = (int)*PC.B++;
			(SP.S++)->data = PC.B;
			PC.B += (int)*(PC.B-1);
			break;
		case SBDA:
			tempj2 = *--SP.J;
			tempj1 = *--SP.J;
			*SP.S = *(STRPTR)(((char *)GFP) + *PC.J++);
			if (SP.S->data == (char *)0)
				bberr(BEUDS);
			if (tempj1 == 0) {
				tempj1 = (SP.S->curlth)+1;
				if (tempj1 > SP.S->maxlth) {
					SP.S->curlth=SP.S->maxlth=0;
					SP.S->data += tempj1-1;
					++SP.S;
					break;
				}
			}
			if (tempj1 > (SP.S->curlth)+1)
				bberr(BESUB);
			if (tempj2 > SP.S->maxlth)
				bberr(BESUB);
			SP.S->data += tempj1-1;
			if (tempj2 == 0) {
				SP.S->curlth = (SP.S->curlth - tempj1)+1;
				SP.S->maxlth = (SP.S->maxlth - tempj1)+1;
				++SP.S;
				break;
			}
			if (tempj1 > tempj2) {
				SP.S->curlth = SP.S->maxlth=0;
				++SP.S;
				break;
			}
			i = (tempj2 < SP.S->maxlth) ? tempj2 : SP.S->maxlth;
			j = (tempj2 < SP.S->curlth) ? tempj2 : SP.S->curlth;
			SP.S->maxlth = (i - tempj1)+1;
			SP.S->curlth = (j - tempj1)+1;
			++SP.S;
			break;
		case MOVS:
			--SP.S;
			movdd(SP.S,SP.S-1);
			break;
		case UPCL:
			updcl(--SP.S);
			break;
		case CMPA:
			SP.S -= 2;
			if (SP.S->curlth < (SP.S+1)->curlth)
				i = SP.S->curlth;
			else
				i = (SP.S+1)->curlth;
			tempj = bstrncmp(SP.S->data,(SP.S+1)->data,i);
			if (tempj == 0)
				tempj = SP.S->curlth - (SP.S+1)->curlth;
			if (tempj > 0)
				*SP.J++ = 1;
			else if (tempj < 0)
				*SP.J++ = -1;
			else
				*SP.J++ = 0;
			break;
		case PAKSET:
			SP.B = pakset(SP);
			break;
		case PAKA:
			--SP.S;
			cptr = SP.B - sizeof(PAKDES);
			paka(*SP.S,(PAKDES *)cptr);
			break;
		case PAKJ:
			*SP.L++ = *--SP.J;
		case PAKL:
			--SP.L;
			pakl(*SP.L, (PAKDES *)(SP.B - sizeof(PAKDES)));
			break;
		case PAKD:
			--SP.PL;	/* point to element addr */
			--SP.PA;	/* point to array pointer */
			cptr = SP.B - sizeof(PAKDES);
			pakd(*SP.PA,*((LPTR *)(SP.PA+1)),(PAKDES *)cptr);
			break;
		case PAKEND:
			SP.B = pakend(SP);
			break;
		case UPKSET:
			SP.B = upkset(SP);
			break;
		case UPKA:
			--SP.S;
			cptr = SP.B - sizeof(PAKDES);
			upka(*SP.S,(PAKDES *)cptr);
			break;
		case UPKL:
			--SP.PL;
			upkl(*SP.PL, (PAKDES *)(SP.B - sizeof(PAKDES)));
			break;
		case UPKD:
			--SP.PL;	/* point to element addr */
			--SP.PA;	/* point to array pointer */
			cptr = SP.B - sizeof(PAKDES);
			upkd(*SP.PA,*((LPTR *)(SP.PA+1)),(PAKDES *)cptr);
			break;
		case PRUSET:
			SP.B = pruset(SP);
			break;
		case PRUJ:
			templ = (long)*--SP.J;
			goto PRUL1;
		case PRUL:
			templ = *--SP.L;
		PRUL1:
			prul(templ,(PRUDES *)(SP.B-sizeof(PRUDES)));
			break;
		case PRUA:
			cptr = SP.B - sizeof(STRDES) - sizeof(PRUDES);
			prua(*--SP.S,(PRUDES *)cptr);
			break;
		case PRUEND:
			SP.B = pruend(SP);
			break;
		case PRSET:
			iostat.iocount = 0;
			iost.status = 0;
			tempj = xlt2bchan(*--SP.J,&iostat.ofd);
			if (tempj == 0)
				bberr(BEWRM);
			if (tempj == 16)
				iostat.ofd = 1;	/* print to stdout */
			break;
		case PRJ:
			*SP.L++ = *--SP.J;
		case PRL:
			cbdl(tempbuf,*--SP.L,2); /* convert w/spaces around it*/
			tempj = strlen(tempbuf);
			iocpy(tempbuf,(unsigned)tempj);
			break;
		case PRA:
			--SP.S;
			iocpy(SP.S->data,SP.S->curlth);
			break;
		case PRCOM:
			prcom();
			break;
		case PRTAB:
			prtab(*--SP.J);
			break;
		case PRCTL:
			prctl(*--SP.J,*--SP.J);
			break;
		case PRCR:
			iocpy("\n",1);
			goto PREND1;
		case PREND:
			if (iostat.ofd != 1)	/* print to file add null */
				iocpy("\0",1);
		PREND1:
			termout();
			termflush();		/* flush to output file */
			iostat.ifd = 0;		/* reset to standard input */
			iostat.ofd = 1;		/* reset to standard output */
			break;
		case TIUSET:
			iofl.inusing = TRUE;	/* set input using flag */
			iofl.inustring = 0;	/* clear input using string */
			goto TISET1;
		case TISET:
			iofl.inusing = FALSE;
		TISET1:
			tempj = *--SP.J;	/* get channel number */
			alarmreq = *--SP.J;	/* get time */
			*SP.J++ = tempj;	/* replace channel number */
			alarmreq += 9;
			alarmreq /= 10;		/* round up to next second */
			if (alarmreq < 1)
				alarmreq = 1;	/* set alarm at least 1 sec */
			if (setjmp(alarmenv) == 0)
				valalarm = TRUE; /*long jump here on alarm */
			else {
				/* comes here on alarm during input */
				valalarm = FALSE;	/* no more longjumps */
				valikey = FALSE;	/* no more longjumps */
				timeleft = 0;		/* no time left */
				SP.B = GFP->BSP.B;	/* reset SP */
				iofl.ineof = TRUE;  /*set eof to skip rest*/
				break;
			}
			tempj = alarm(alarmreq);	/* set alarm */
			/* do regular input set */
			goto INSET1;
		case INUSET:
			iofl.inusing = TRUE;	/* set input using flag */
			iofl.inustring = 0;	/* clear input using string */
			goto INSET1;
		case INSET:
			iofl.inusing = FALSE;
		INSET1:
			iofl.inline = FALSE;
			iofl.moredata = FALSE;
			iofl.prtprm = FALSE;
			iostat.iopos = 0;
			iostat.iocount = 0;
			tempj = xlt2bchan(*--SP.J,&iostat.ifd);
			if (tempj == 1)
				bberr(BEWRM);
			if (tempj == 16)
				iostat.ifd = 0;	/* input from stdin */
			if (setjmp(ikeyenv) == 0)
				valikey = TRUE;	/* long jump to here on ikey */
			else {
				/* comes here on ikey during input */
				valikey = FALSE;	/* no more longjumps */
				valalarm = FALSE;	/* no more longjumps */
				alarm(0);		/* cancel alarm */
				SP.B = GFP->BSP.B;	/* reset SP */
				ikeyz(PC,SP);		/* check for user */
				PC.B = TPC;
				SP.B = TSP;
				break;
			}
			termflush();
			break;
		case INL:
			inl(*--SP.PL);
			break;
		case INA:
			ina(*--SP.S);
			break;
		case INPRM:
			--SP.S;
			if(iostat.ifd == 0 && iofl.ineof == FALSE)
				inprm(SP.S->data,SP.S->curlth);
			break;
		case INCTL:
			SP.J -= 2;
			if(iostat.ifd == 0 && iofl.ineof == FALSE)
				inctl(*SP.J,*(SP.J+1));
			break;
		case INCR:
			if (iofl.prtprm == FALSE)
				iostat.iocount = 0;
			if(iostat.ifd == 0 && iofl.ineof == FALSE) {
				iocpy("\n",1);
				iofl.prtprm = TRUE;
			}
		case INEND:
			valikey = FALSE;	/* no longjumps anymore */
			if (valalarm == TRUE) {
				valalarm = FALSE;
				timeleft = alarm(0) * 10;
			}
			if (iofl.prtprm == TRUE && iostat.ifd == 0) {
				termout();
				termflush();
			}
			iofl.prtprm = FALSE;
			iofl.ineof = FALSE;
			iofl.inline = FALSE;
			iofl.inustring = 0;	/* clear it */
			iostat.iopos = iostat.iocount = 0;
			iostat.ifd = 0;		/* reset to standard input */
			iostat.ofd = 1;		/* reset to standard output */
			ust.inputmax = crtctrl[ust.termtype]->cinptmx;
			if (iofl.moredata == TRUE) {
				iofl.moredata = FALSE;
				bberr(BEIIN);
			}
			break;
		case RDSET:
			rdset(*--SP.J);		/* set up for read */
			break;
		case RDL:
			rdl(*--SP.PL); /* read long, pass pointer to var */
			break;
		case RDJ:
			rdj(*--SP.PJ); /* read int, pass pointer to variable */
			break;
		case RDLJ:
			rdlj(*--SP.PL); /* read int, pass pointer to variable */
			break;
		case RDA:
			rda(*--SP.S); /* read string, pass STRDES of var */
			break;
		case WRSET:
			wrset(*--SP.J);		/* set up for write */
			break;
		case WRL:
			wrl(*--SP.L);		/* write long value */
			break;
		case WRJ:
			wrj(*--SP.J);	/* write low order of long */
			break;
		case WRLJ:
			wrlj(*--SP.L);	/* write low order of long */
			break;
		case WRA:
			wra(*--SP.S);	/* write string */
			break;
#include "/bb/include/px.x"
		default:
			panic();
	}
#ifdef DEBDEF
if (DEB == TRUE)
	dumpstk(SP);
#endif

	goto top;
}
