#include "msdos.h"
#include "errno.h"
int errno;
#define NFILES 8
struct CCB {
   char *ptr;		/* pointer to next char position in buf */
   int rcnt;		/* number of bytes left to read in this block */
   int wcnt;		/* number of bytes left to write in this block */
   unsigned flags;
#define READ  0000001
#define WRITE 0000002
#define DIRTY 0000004
#define ATEOF 0000010
#define CONS  0100000
   long blknum;		/* current block in buf */
   long filelen;	/* current length of file */
   struct FCB fcb;	/* the FCB of this file */
   char buf[512];	/* a buffer for the current block */
};
struct CCB _msdioc[NFILES];

long _getlong(u)
struct MSDLONG *u;
{
   union {long v; struct MSCLONG d} w;
   w.d.hc = u->h; w.d.lc = u->l;
   return w.v;
}

_putlong(u,v)
struct MSDLONG *u;
struct MSCLONG v;
{
   u->h = v.hc; u->l = v.lc;
}

struct CCB *getchan(chan)
int chan;
{
   struct CCB *c;
   if (chan >= NFILES || chan < 0) {
      errno = EBADF;
      return 0;
   }
   c = &_msdioc[chan];
   if (c->flags == 0) {
      errno = EBADF;
      return 0;
   }
   return c;
}

int _open(name,mode,flag)
char *name;
int mode;
int flag;
{
   int chan;
   struct CCB *c;
   struct FCB fcb;
   struct REGS regs;

   if (_fparse(name,&fcb,1) != 0) {
      errno = ENOENT;
      return -1;
   }
   for (chan=0, c=_msdioc; c->flags != 0; chan++, c++)
      if (chan >= NFILES) {
	 errno = ENFILE;
	 return -1;
      }
   if (strncmp(fcb.filename,"CON        ",11) == 0) {
      c->flags = ((mode+1) & (READ|WRITE)) | CONS;
   } else {
      if (flag != 1) regs.ah = 0x0F /* open */;
      else regs.ah = 0x16 /* create */;
      regs.dx = &fcb;
      indir(&regs);
      if (regs.al != 0) {
	 errno = ENOENT;
	 return -1;
      }
      fcb.recsize = 512;
      c->filelen = _getlong(&fcb.filesize);
      c->flags = (mode+1) & (READ|WRITE) /* set READ/WRITE clear others*/;
   }
   c->fcb = fcb;
   c->rcnt = 0;
   c->wcnt = 0;
   c->blknum = -1;
   return chan;
}

int open(name,mode)
char *name;
int mode;
{
   return _open(name,mode,0);
}

int creat(name,mode)
char *name;
int mode;
{
   return _open(name,1,1);
}

int close(chan)
int chan;
{
   struct CCB *c;
   struct REGS regs;

   if ((c = getchan(chan)) == 0) return -1;
   if ((c->flags & CONS) == 0) {
      _msdfls(c);
      _putlong(&(c->fcb.filesize),c->filelen);
      regs.ah = 0x10 /* close */;
      regs.dx = &(c->fcb);
      indir(&regs);
      if (regs.al != 0) {
	 c->flags = 0;
	 errno = EIO;
	 return -1;
      } 
   }
   c->flags = 0;
   return 0;
}

_msdcl()
{
   int chan;
   for (chan=0; chan < NFILES; chan++)
      close(chan);
}

int read(chan,buffer,nbytes)
int chan;
char *buffer;
int nbytes;
{
   int count=0, cons;
   struct CCB *c;

   if ((c = getchan(chan)) == 0) return -1;
   if ((c->flags & READ) == 0) {
      errno = EBADF;
      return -1;
   }
   if (cons = ((c->flags & CONS) != 0) && c->rcnt == 0) {
      _rdl(c);
   }
   while (nbytes-- > 0) {
      if (!cons && (c->rcnt <= 0)) 
	 if (_nxtblk(c) != 0) return -1;
      if (c->rcnt <= 0) break;
      *buffer++ = *(c->ptr++);
      c->rcnt--;
      c->wcnt--;
      count++;
   };
   return count;
}

int write(chan,buffer,nbytes)
int chan;
char *buffer;
int nbytes;
{
   int count=0;
   long l;
   struct CCB *c;

   if ((c = getchan(chan)) == 0) return -1;
   if ((c->flags & WRITE) == 0) {
      errno = EBADF;
      return -1;
   }
   if ((c->flags & CONS) == 0) {
      while (nbytes-- > 0) {
	 if (c->wcnt <= 0) 
	    if (_nxtblk(c) != 0) return -1;
	 *(c->ptr++) = *buffer++;
	 c->wcnt--;
	 c->rcnt--;
	 count++;
	 c->flags |= DIRTY;
      };
      if ((l = ((c->blknum)*512 + 512 - (c->wcnt))) > c->filelen)
	 c->filelen = l;
   } else {
      while (nbytes-- > 0) {
	 _wrc(*buffer++);
	 count++;
      }
   }
   return count;
}

long lseek(chan,offset,whence)
int chan;
long offset;
int whence;
{
   long nbl; int nby;
   struct CCB *c;

   if ((c = getchan(chan)) == 0) return -1;
   if ((c->flags & CONS) != 0) return 0;
   switch (whence) {
   case 1:
      offset += (c->blknum) * 512 + 512 - c->wcnt;
      break;
   case 2:
      offset += c->filelen;
      break;
   }
   nbl = offset>>9; nby = offset&0777;
   if (nbl != c->blknum) {
      _msdfls(c);
      c->blknum = nbl;
      _msdfil(c);
   } else {
      nby -= 512 - c->wcnt;
   }
   c->ptr += nby;
   c->wcnt -= nby;
   c->rcnt -= nby;
   return offset;
}

_nxtblk(c)
struct CCB *c;
{
   _msdfls(c);
   c->blknum++;
   _msdfil(c);
}

_msdfil(c)
struct CCB *c;
{
   char *p;
   int i;

   c->ptr = c->buf;
   switch (i = _blkio(0,c,c->blknum,c->ptr,1)) {
   case -1:
      errno = EIO;
      c->rcnt = 0;
      c->wcnt = 0;
      return -1;
   case 512:
      break;
   case 0:
      for (i=512, p=c->buf; i > 0; i--)
	 *p++ = 0;
   default:
      break;
   }
   c->rcnt = i;
   c->wcnt = 512;
   return 0;
}

_msdfls(c)
struct CCB *c;
{
   if ((c->flags & DIRTY) != 0) {
      if (_blkio(1,c,c->blknum,c->buf,1) < 0) return -1;
      c->flags &= ~DIRTY;
   }
   c->wcnt = 0;
   c->rcnt = 0;
}

int _blkio(mode,ccb,start,buffer,count)
int mode;
struct CCB *ccb;
long start;
char *buffer;
int count;
{
   char *p;
   int i, n=0;
   long eblock, ecount;
   struct REGS regs;

   if (count == 0) return 0;
   eblock = (_getlong(&(ccb->fcb.filesize))+511) >> 9;
   if (mode != 1 && start >= eblock) return 0;
   _putlong(&(ccb->fcb.recnum),start);
   regs.ah = 0x1A /* set transfer address*/;
   regs.dx = buffer;
   indir(&regs);
   if (mode == 1) {
      n = start - eblock;
      regs.ah = 0x28 /* random block write */;
   } else
      regs.ah = 0x27 /* random block read */;
   regs.cx = count;
   regs.dx = &(ccb->fcb);
   indir(&regs);
   switch (regs.al) {
   case 1:
   case 3:
      count = regs.cx * 512;
      break;
   case 0:
      count *= 512;
      break;
   default:
      return -1;
   }
/* zero fill any never been written blocks */
   if (n > 0) {
      for (p=ccb->buf, i=512; i > 0; i--)
	 *p++ = 0;
      regs.ah = 0x22 /* random write */;
      while (n-- > 0) {
	 _putlong(&(ccb->fcb.recnum),eblock++);
	 indir(&regs);
	 if (regs.al != 0) return -1;
      }
   }
   if (mode != 1 && count > (ecount = ccb->filelen - (start*512)))
      return (int) ecount;
   else 
      return count;
}

_rdl(c)
struct CCB *c;
{
   int i;
   struct REGS regs;

   c->buf[0] = 509;
   regs.ah = 0x0A /* buffered keyboard input */;
   regs.dx = c->buf;
   indir(&regs);
   c->ptr = c->buf+2;
   c->buf[(i = c->buf[1]) + 2] = '\n';
   if (*(c->ptr) == 0x1A) c->rcnt = 0;
   else c->rcnt = i+1;
   c->wcnt = 0;
   _wrc('\n');
}

_wrc(c)
char c;
{
   struct REGS regs;
   if (c == '\n') _wrc('\r');
   regs.ah = 0x02 /* display output*/;
   regs.dl = c;
   indir(&regs);
}

ioctl(chan,request,argp)
int chan;
int request;
char *argp;
{
   struct CCB *c;
   if ((c = getchan(chan)) == 0) return -1;
   switch (request>>8) {
   case 't':
      if ((c->flags & CONS) != 0) return 0;
      else return -1;
   case 'f':
      if ((c->flags & CONS) == 0) return 0;
      else return -1;
   default:
      return -1;
   }
   return -1;
}

