/*************************************************************************
*
*
*	Name:  winio.c
*
*	Description:  Window i/o function.
*
*
*	History:
*	Date		By		Comments
*
*	03/16/84	waf
*
*
*
*  This document contains confidential/proprietary information.
*
*  Copyright (c) 1983, 1984 by Digital Communication Assoc..
*
*************************************************************************
*  SForm routines module.  */




/*  Notes -

	To Do -
	**>> Return all codes not recognized.

*/

#include	"/sform/src/sfint.h"


static	struct SF_FIELD *fld_desc ;	/* ptr to fld desc */
static	unsigned flags ;			/* bit flags */




sfwinio ( window, fld_num, mode )

struct SF_WINDOW *window ;	/* window structure */
int		*fld_num ;			/* entry - starting field number
							   return - ending field number */
int		mode ;				/* SF_DISPLAY / SF_INPUT / SF_EDIT */

/*
  Synopsis -
	Perform window i/o, starting with field '*fld_num' and continueing
	until all fields have been processed or one of certain completion codes
	is returned.

  Description -
	This function will perform i/o on multiple fields within a given
	window. It is presumed that sfopen() has already been run (at some
	time) for this window.

	The modes are -
		SF_DISPLAY	- Display all fields in window & return.
		SF_INPUT	- Input fields without displaying current values.
		SF_EDIT		- Display current value of field, then input new value.
					  (The value is unchanged if no new value is input).
		SF_LABELS	- Display all the string literal ('label') fields only.
	In DISPLAY mode, all fields are displayed.
	In INPUT and EDIT modes, all fields are displayed (if EDIT), and all data
	(e.g. non-label) fields are input. Trying to input into a protected field
	(SF_PROTFLD flag set) returns a SF_EDPROT error. All SF_LABFLD fields are
	skipped.
	In LABELS mode, only label fields are displayed.

  Return -
	return val	= Completion code -
				SF_FINISH	= User is done.
				SF_ABORT	= User aborted.
				SF_<NXT,PRV>WIN = Goto next/prev window.
				SF_<NXT,PRV>xxx = Ended due to other fn key.
	*fld_num	= Field # of last field edited.

  Notes -
  *> At this time, label fields are only displayed when mode = LABELS.
  > The sfopen() fn will be automatically invoked if this window is not
  already 'open'.
  > Note that 'sffldio()' can be invoked directly by the user for specific
  fields.
*/

{
	register int fld ;		/* current field number */
	register int fc, lfc ;	/* completion/motion codes */
	int		labelsflg ;
	int		flg ;


	/* Save the 'current' window ptr
		   and get the highest fld # in this window */
	gethifld(window) ;

	/* Initialize */
	fld = *fld_num ;		/* starting field # */
	fc = lfc = SF_NXTFLD ;	/* initial motion is fwd fld */
	sf_fldmod = 0 ;			/* 'field(s) modified' flag */

	/* Chk for SF_LABELS mode.
	   If so, set flag and change mode to SF_DISPLAY
	   (so that labels will be displayed) */
	labelsflg = 0 ;
	if ( mode == SF_LABELS ) {
		labelsflg = -1 ;
		mode = SF_DISPLAY ;
	}


	/* Process fields */
	while ( fld >= 0 && fld <= sf_hifld ) {		/* while fld# is in range */

		/* If SF_LABELS mode, process only label fields.
		   If not, process only data fields */
		getfd(window, fld) ;		/* get fld_desc & flags */
		fc = flags & SF_LABFLD ;	/* set if fld is a label fld */
		flg = 0 ;
		if ( labelsflg ) {
			/* SF_LABELS mode */
			if ( fc == 0 )
				flg-- ;			/* skip data fields */
		}
		else {
			if ( fc )
				flg-- ;			/* skip label flds */
		}
		if ( flg ) {
			/* skip this fld */
			fld++ ;			/* inc to nxt fld */
			continue ;		/*   and loop */
		}


		/* do field i/o */
		fc = sffldio(window, fld, mode) ;


		/* Chk completion code */
		/* Chk for keyboard fn key  								<<< PATCH */
		if ( fc >= SF_F1 && fc <= SF_SF11 )
			goto xit ;		/* return undefined fn keys to user */
		switch ( fc ) {
			case SF_ERROR :
				/* error during field entry */
				return(fc) ;
			case SF_EDPROT :
				/* tried to update protected field.
								   Ignore it & keep going */
				fc = lfc ;		/* use prev motion */
				goto selnxt ;

				/* <<<PATCH>>> */
			case SF_ABORT :
			case SF_FINISH :
			case SF_NXTWIN :
			case SF_PRVWIN :
			case SF_RSTWIN :
				/* return these codes to user */
				goto xit ;
		}


selnxt:
		/* select next field */

		if ( mode == SF_DISPLAY )
			fld++ ;		/* display next field */
		else {

			/* use 'fc' code to select next field */
			switch ( fc ) {

				case SF_NXTFLD :	/* next field */
					fld++ ;
					break ;

				case SF_PRVFLD :	/* prev field */
					/* backup to 1st non-label field */
					while ( --fld >= 0 ) {
						getfd(window, fld) ;
						if ( (fld_desc->sf_iodata->sf_flags & SF_LABFLD) == 0 ){
							fc = SF_NXTFLD ;	/* continue fwd */
							break ;
						}
					}
					break ;

				case SF_NXTGRP :	/* next group */
					/* get 1st fld in next group */
					fld = sfnxtgrp(window, fld) ;
					/* adjust the 'motion' flag */
					fc = SF_NXTFLD ;	/* use fwd fld motion */
					break ;

				case SF_PRVGRP :	/* prev group */
					/* get 1st fld in last group */
					fld = sfprvgrp(window, fld) ;
					/* adjust the 'motion' flag */
					fc = SF_NXTFLD ;	/* use fwd fld motion */
					break ;

				default :
					/* Some other code (i.e. SF_CUNP from input).
					   Use lfc to remember motion & continue. */
					fc = lfc ;
					goto selnxt ;	/* select next fld */
			}
		}

		/* save the current completion code.
				   In case of error, it will be needed to remember which
				   direction we were going. */
		lfc = fc ;

	}	/* end while */


xit:
	/* field out of range */
	*fld_num = fld ;		/* return last field */

	return(fc) ;			/* return last ret code */
}



static	getfd ( window, fld )

struct SF_WINDOW *window ;
int		fld ;

/* Set up global vars 'fld_desc' and 'flags' for field # 'fld' in 'window'.
*/

{


	fld_desc = &((*window->sf_fldlist)[fld]) ;	/* fld desc ptr */
	flags = fld_desc->sf_iodata->sf_flags ;	/* bit flags */
}



static	gethifld ( winptr )

struct SF_WINDOW	*winptr ;

/* If this is not the 'current' window, get the highest legal fld
   number for this window, and make this window the 'current' window.
   Also chks sfinitflg flag & runs sfinit() is necessary.
*/

{
	extern	int	sfinitflg ;


	/* Chk sfinitflg */
	if ( sfinitflg == 0 )
		sfinit() ;

	if ( sf_curwin != winptr ) {

		/* Get highest field # in this window.
				   This code assumes that the fld list is terminated by a 'null'
				   field desc, which is flagged by a field width of '-1' */
		sf_hifld = 0 ;
		while ( (*winptr->sf_fldlist)[sf_hifld].sf_width != -1 )
			sf_hifld++ ;
		sf_hifld-- ;		/* fld # of last field */

		sf_curwin = winptr ;		/* make this win the current window */
	}

}

sffldio ( window, fld, mode )

struct SF_WINDOW *window ;
int		fld ;
int		mode ;

/*
  Synopsis -
	Perform i/o on a given field.

  Description -
	This fn is invoked by winio() for each field (see winio()).
	This fn can also be invoked directly by the user in order to do
	i/o on a particular field.

  Return -
	return val	= Completion code or Fn Key code (see winio()).

  Notes -
  > There may be some redundancy between winio() and fldio(), since
  fldio() can be invoked either by winio() or directly by the user.
  > The sfopen() fn will be automatically invoked if this window is not
  already 'open'.
  > The var 'sf_fldmod' is set if fld is mod'ed by user.
  If the fld was cleared, sf_fldmod is set to -fld#, if the fld was changed,
  sf_fldmod is set to fld#.
*/

{
	register int	fc ;			/* return code */
	int		(*fldfn)() ;			/* field i/o fn addr */
	extern	int		sfclrfld ;		/* set if fld is cleared */


	/* Save current window ptr 
		   & get highest fld # if new window */
	gethifld(window) ;

	/* Chk input fld # against highest legal field # */
	if ( fld < 0 || fld > sf_hifld )
		return(SF_ERROR) ;		/* bad fld # */

	/* Save current field # & reset field char cnt.
		   This info will be used to derive cursor pos. */
	sf_curfld = fld ;
	sf_nchars = 0 ;

	/* Get fld desc ptr */
	getfd(window, fld) ;

	/* Get fldio fn */
	fldfn = fld_desc->sf_iodata->sf_fldfn ;		/* fld io fn addr */
	/** Note - assumes fn addr is at same offset in ALL field desc's */

	/* Invoke the fld io fn for current fld */
	fc = (*fldfn)(fld_desc, mode, fld_desc->sf_bindata) ;

	/* Chk for modified fld */
	if ( sf_nchars || sfclrfld ) {
		/* fld was mod'ed (either changed or cleared) */
		if ( (sf_nchars == 0) && sfclrfld )
			sf_fldmod = -fld ;		/* flag that fld was cleared */
		else
			sf_fldmod = fld ;		/* flag that fld was changed */
	}

	/* If an error was reported during input, clear the error msg */
	if ( sf_errflg ) {
		/* sfclrerm() ;		<<<PATCH */
		sf_errflg = 0 ;
	}

	return(fc) ;
}
