/*************************************************************************
*
*
*	Name:  enmio.c
*
*	Description:  Enumerator field i/o.
*
*					sfenmio()	- Enumerator i/o.
*					sfenmdisp()	- Display enum fld.
*					sfenminp()	- Input enum fld.
*
*
*	History:
*	Date		By		Comments
*
*	03/28/84	waf
*
*
*
*  This document contains confidential/proprietary information.
*
*  Copyright (c) 1983, 1984 by Digital Communication Assoc..
*
*************************************************************************
*  SForm routines module.  */




/*  Notes -

	  Note that enumerator data is of type 'integer'.

	  The enumerator strings supplied to these fn's are assumed to have
	the same syntax as in the 'c' language, including initializers.

	  At present, the code for scanning the enumerator string is rather
	simple minded -
	  Enumerators may consist of only letters and numbers.
	  The only legal seperators are ',', '=', and ' '.
	  Embedded spaces are allowed.

*/

#include	"/sform/src/sfint.h"
#include	<ctype.h>


#define		ENMSTR		16		/* Max # chars in an enumerator */
#define		ENMMAX		16		/* Max # of enumerators allowed */
#define		ENMBYTE	sizeof(int)	/* # bytes in enumerator type */


/* Enumeration global data */
static	struct	{		/* Enumerator values */
	int		value ;				/* (int) value of enumerator */
	char	name[ENMSTR+1] ;	/* enumerator name */
} 
enmary[ENMMAX] ;
static	int		eaend ;		/* ix of (last entry +1) in enmary */
static	char	*esptr ;	/* enum string ptr */

sfenmio ( fld_desc, mode, data_ptr )

struct SF_FIELD *fld_desc ;
int		mode ;
int		*data_ptr ;

/*
  Synopsis -
	Enumerator field i/o.

  Description -
	This fn uses the 'genio()' fn to perform i/o. See genio.c for a
	description of operation and return values
	Before calling genio(), the 'enmary' is created by parsing the
	enumerator list. After parsing, enmary contains the enumerator names
	and thier associated values.

  Return -
	return val	= See genio.c.

  Notes -
*/

{
	int		eval ;		/* enum value */
	int		eaix ;		/* enum ary index */
	int		sgn ;
	int	sfenmdisp(), sfenminp() ;
	int		i ;
	int		fc ;		/* completion code */
	char	c ;
	struct SF_EFDATA *iodata ;
	char	*nptr ;
	char	*skipsp() ;



	/** Build the enumerator array **/
	iodata = (struct SF_EFDATA *)fld_desc->sf_iodata ;
	esptr = iodata->sf_enmstr ;	/* ptr to enum string */
	eaix = 0 ;		/* enum ary index */
	eval = 0 ;		/* default enum values start at zero */
	skipsp() ;
	c = *esptr++ ;
	while ( c != '\0' ) {

		if ( eaix > ENMMAX )
			sfpanic("enmio: Too many enumerators.") ;
		nptr = enmary[eaix].name ;		/* ptr to name */

		/* get next enum */
		i = 0 ;
		while ( isalnum(c) ) {
			if ( i > ENMSTR )
				sfpanic("enmio: Enumerator too big.") ;
			nptr[i++] = c ;
			c = *esptr++ ;
		}
		if ( i == 0 )
			parserr() ;
		nptr[i] = '\0' ;

		/* chk for initialization */
		esptr-- ;		/* back up to last char */
		skipsp() ;		/* skip spaces after name */
		c = *esptr++ ;
		if ( c == '=' ) {
			/* get value */
			skipsp() ;		/* skip spaces after '=' */
			c = *esptr++ ;
			eval = 0 ;
			sgn = 0 ;
			if ( c == '-' ) {
				sgn = -1 ;
				c = *esptr++ ;
			}
			while ( isdigit(c) ) {
				eval = eval * 10 + (int)(c - '0') ;
				/* Note - no overflow chk */
				c = *esptr++ ;
			}
			if ( sgn )
				eval = -eval ;
		}

		/* enter val in enum ary */
		enmary[eaix].value = eval ;
		eaix++ ;		/* inc ary index */

		/* inc enum default value */
		eval++ ;

		/* chk for ',' */
		esptr-- ;
		skipsp() ;
		c = *esptr++ ;
		if ( c != 0 ) {
			if ( c != ',' )
				parserr() ;
			skipsp() ;
			c = *esptr++ ;
		}
	}


	/* Save the ix of the end of the ary entries */
	eaend = eaix ;


	/* Do the i/o */
	fc = sfgenio(fld_desc, mode, data_ptr, ENMBYTE, sfenminp, sfenmdisp) ;
	return(fc) ;
}




static	char	*skipsp ()

/* 'esptr' points to next char.
   Skip any spaces, and return with global esptr updated. 
*/

{


	while ( isspace(*esptr) )
		esptr++ ;
}



static	parserr ()

/* Parsing error */

{


	sfpanic("enmio: Enumerator list parse error.") ;
}

sfenmdisp ( fld_desc, data_ptr )

struct SF_FIELD *fld_desc ;
int		*data_ptr ;

/*
  Synopsis -
	Display an enumeration field.

  Description -
	The value at data_ptr is used to find the enumerator name in the 
	enumerator array built by enmio().
	Then, the enumeration name is displayed, using the string display fn.

  Return -
	return val	= See strdisp.c.
*/

{
	register int	fc ;
	register char	*cp ;
	char	*enmname() ;


	/* Find the enum name */
	cp = enmname(*data_ptr) ;

	/* Show the enumerator */
	fc = sfflddisp(fld_desc, cp, 's') ;

	return(fc) ;
}



static	char	*enmname ( val )

int		val ;

/* Given a value, find the enumerator with that value. */
{
	register char	*cp ;
	register int	i ;


	cp = "?" ;		/* display this if not found */
	for ( i=0 ; i < eaend ; i++ )
		if ( val == enmary[i].value ) {
			cp = enmary[i].name ;	/* ptr to name */
			break ;
		}
	return(cp) ;
}

sfenminp ( fld_desc, data_ptr )

struct SF_FIELD *fld_desc ;
int		*data_ptr ;

/*
  Synopsis -
	Input an enumeration field.

  Description -
	The user can 'input' data by either selecting a current field value
	or entering in an (exact) enumerator string.
	The enumerator strings can be displayed using the <PRV/NXT>ENM fn
	key. An enumerator string is selected with the SELENM fn key.

  Return -
	return val	= See strinp.c.

  Notes -

  To Do -
  *> Allow enumerator name to be input.
*/

{
	int		fc ;	/* completion code */
	int		eaix ;	/* enum array index */
	int		cval ;	/* current enum value */
	int		i ;


	/* Initialize the current enum value.
		   Note - intial value may be an illegal value. */
	cval = *data_ptr ;

	/* Get eaix for current enum value.
		   Use '0' if current value is not legal. */
	for ( eaix = eaend - 1 ; eaix > 0 ; eaix-- ) {
		if ( enmary[eaix].value == *data_ptr ) {
			/* found it */
			break ;
		}
	}


again:
	/* Get input */
	fc = sfstrinp(fld_desc, (char *)data_ptr) ;

	/* Chk return code */
	if ( fc < 0 || fc == SF_ABORT )
		return(fc) ;
	if ( fc == SF_CLRFLD ) {
		/* clear field (to '0') */
		*data_ptr = 0 ;
		return(fc) ;
	}
	if ( sf_nchars != 0 ) {
		/* He entered input.
				   Chk for legal enumerator name. */
		for ( i = 0 ; i <= eaend ; i++ ) {
			if ( i == eaend ) {
				/* bad enum name */
				sferrmsg("Invalid value.") ;
				return(SF_ERROR) ;
			}
			if ( strcmp(enmary[i].name, data_ptr) == 0 ) {
				/* found it */
				cval = enmary[i].value ;	/* enum value */
				break ;		/* return value & fc */
			}
		}
	}

	if ( fc != SF_NXTENM && fc != SF_PRVENM ) {
		/* Update the data_ptr & return the completion code */
		*data_ptr = cval ;	/* return current enum value */
		sf_nchars = 1 ;		/* so genio() will think data was entered */
		return(fc) ;
	}

	/* Process enum selection fn */
	switch ( fc ) {

		case SF_NXTENM :	/* Show next enumerator */
			eaix++ ;	/* inc enum ary index */
			if ( eaix == eaend )
				eaix = 0 ;	/* wrap */
			break ;

		case SF_PRVENM :	/* Show prev enumerator */
			eaix-- ;	/* dec enum ary index */
			if ( eaix < 0 )
				eaix = eaend - 1 ;	/* wrap */
			break ;
	}

	/* Show next/prev enumerator */
	cval = enmary[eaix].value ;	/* update current enum value */
	/* sfposcur(row, col) ;		/* re-position cursor */
	fc = sfflddisp(fld_desc, enmary[eaix].name, 's') ;	/* show name */

	/* Loop */
	goto again ;

}
