/*************************************************************************
*
*
*	Name:  sfinit.c
*
*	Description:  Functions to 'open' and 'close' windows.
*					sfinit()	- Initialize for sform i/o.
*					sfclrwin()	- Clear (or paint) a window.
*					sfterm()	- Exit from sform (resets i/o).
*
*
*	History:
*	Date		By		Comments
*
*	03/16/84	waf
*	06/08/84	waf		**  Rev. 2.0  **
*
*
*
*  Copyright (c) 1983, 1984 by Digital Communication Assoc..
*  This document contains confidential/proprietary information.
*
*************************************************************************
*  SForm routines module.  */




/*  Notes -

	  NOTE that the sfexit() call is the only call that the USER MUST
	INVOKE. All of the others in this module will be invoked automatically
	by the sform code.
	  Note that, in some environments, if sfexit() is not called,
	the display and/or input characteristics may be fubar'ed.

	Altos notes -
	  Note that, in between the sfinit() and the sfexit() calls, THE USER
	SHOULD NOT ATTEMPT ANY I/O TO THE TERMINAL.
*/

#include	"/sform/src/sfint.h"

int		sfinitflg = 0 ;		/* If set, init code has been run	*/



sfinit ()

/*
  Synopsis -
	Initialize for sform i/o.

  Description -
	The terminal characteristics are commandeered.
	The default input attribute offset value is set.
	The default HELP fn ptr is set.
	The default cursor types are set.

  Return -
	return val	= 	SF_OK		if no errors.
					SF_ERROR	if errors.

  Notes -
*/

{
	extern	sfsuecod() ;
	extern	sf_nrmcur, sf_inscur ;


	/* Init term handler / characteristics */
	stinit() ;

	/* Set default input attribute offset value.
	   This value is used to highlight input fields. */
	sf_inatros = SF_ATINPOS ;

	/* Set default user help & error fn ptrs */
	sf_usrhelp = sfnotimp ;			/* 'Not implemented' */
	sf_usrerr = sfsuecod ;			/* show error message */

	/* Set default cursor types */
	sf_nrmcur = SF_CURT1 ;
	sf_inscur = SF_CURT2 ;

	/* Flag that this code was run */
	sfinitflg = -1 ;

	return(SF_OK) ;
}

sfclrwin ( window )

struct SF_WINDOW *window ;

/*
  Synopsis -
	Clear a window.
	The window area is 'painted'.
	If this is the first window to be opened, sfinit() is invoked.

  Description -
	If this is the first window to be opened, this fn does any intialization
	necessary when entering the SForm routines. Terminal characteristics are
	'commandeered' after this call & until sfclose() is invoked. Much of this
	will be system dependent.
	The window area is 'painted' by showing spaces with the window display
	attribute set.

  Return -
	return val -	<undefined>

  Notes -
*/

{


	/* Chk for first window.
	   If so, run initialization code. */
	if ( sfinitflg == 0 ) {
		sfinit() ;
	}

	/* Paint the window */
	winpaint(window, window->sf_wdatr) ;

	return(SF_OK) ;
}

sfterm ()

/*
  Synopsis -
	Exit the sform routines.
	Terminal control is returned to the user.

  Description -
	This fn MUST be invoked by the user pgm. The consequences of not
	doing this difer according to the system.

  Return -
	return val	= <undefined>

  Notes -
*/

{


	/* Position the cursor to the error row */
	stscp(SF_ERRROW, 0) ;

	/* set display attr's to 'normal' */
	stsatr(SF_NORM) ;

	/* Reset terminal characteristics */
	stterm() ;

	/* Reset flags */
	sfinitflg = 0 ;				/* flag 'Init code not run' */

	return ;					/* no defined return value */
}

static	winpaint ( win, datr )

struct SF_WINDOW	*win;
unsigned			datr ;

/*
  Synopsis -
	Paint the window, using the datr param for display attributes.

  Description -
	The stclw() fn is used to clear/paint the window.

  Return -
	return val	= <undefined>

  Notes -
*/

{

	stclw(win->sf_urow, win->sf_lrow, win->sf_lcol, win->sf_rcol, datr) ;

	return ;				/* undefined return value */
}
